<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<!--#include file="inc/Blowfish.asp"-->
<%
	If Not IsCustomer() Then
		Redirect(GetPageLink("Account/Login"))
	End If

	Dim iOrderID : iOrderID = Request("OrderID")
	If Not ValidateInteger(iOrderID) Then
		Call SetAlertMessage("error", "Invalid Order ID.")
		Redirect("Account/Orders")
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	sQuery = "SELECT o.*" &_
			 "	   , (CASE WHEN OrderTaxExemption = 0 THEN o.OrderTaxAmount ELSE 0 END) AS OrderTaxAmount" &_
			 "	   , os.OrderStatusName" &_
			 "	   , os.OrderStatusColor" &_
			 "	   , osr.OrderStatusReasonID" &_
			 "	   , osr.OrderStatusReasonName" &_
			 "	   , (CAST(o.OrderCreateDate AS DATE)) AS _OrderCreateDate" &_
			 "	   , pt.PaymentTypeName" &_
			 "	   , pt.PaymentTypeCategory" &_
			 "	   , c.OrderDeliveryCarrierName" &_
			 "	FROM utb_Orders o" &_
			 "		 INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
			 "		 LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
			 "		 LEFT JOIN utb_OrderStatusReasons osr ON osr.OrderStatusReasonID = o.OrderStatusReasonID" &_
			 "		 LEFT JOIN utb_OrderDeliveryCarriers c ON c.OrderDeliveryCarrierID = o.OrderDeliveryCarrierID" &_
			 " WHERE o.CustomerID = " & GetCustomerID() &_
			 "	 AND o.OrderID = '" & Quote(iOrderID) & "'"

	Dim oOrder
	Set oOrder = oConn.Execute(sQuery)
	If oOrder.Eof Then
		Call SetAlertMessage("error", "Order #" & iOrderID & " not found")
		Redirect("Account/Orders")
	End If
	Dim iCounter : iCounter = 0

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderFrontend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopFrontend.asp"-->
        <div class="breadcrumbs">
			<span class="home">Home:</span>
			<span itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
				<a href="<%= GetPageLink("Account") %>" itemprop="url"><span itemprop="title">Account</span></a>
				<span itemprop="child" itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
					<a href="<%= GetPageLink("Account/Orders") %>" itemprop="url"><span itemprop="title">My Orders</span></a>
					<span itemprop="child" itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
						<a href="<%= GetPageLink("Account/Order/Details") & "?OrderID=" & oOrder("OrderID") %>" itemprop="url"><span itemprop="title">Order #<%= oOrder("OrderID") %></span></a>
					</span>
				</span>
			</span>
		</div>
		<!--#include file="inc/AccountLinks.asp"-->
        <div class="block-clear details-wrap">
			<div class="wpage-title"><h1>Order #<%= oOrder("OrderID") %></h1></div>
			<div class="wpage-content">
				<table cellpadding="3" cellspacing="1" border="0" style="background: #bebebe">
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<th colspan="2">Order Information</th>
					</tr>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td style="width: 100px">Order ID:</td>
						<td><%= oOrder("OrderID") %></td>
					</tr>
					<% iCounter = iCounter + 1 %>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td>Date Created:</td>
						<td><%= oOrder("OrderCreateDate") %></td>
					</tr>
					<% iCounter = iCounter + 1 %>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td>Status:</td>
						<td><%= oOrder("OrderStatusName") %></td>
					</tr>
				<% If Not IsNull(oOrder("OrderMerchantShippedDate")) Then %>
					<% iCounter = iCounter + 1 %>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td>Date Shipped:</td>
						<td><%= oOrder("OrderMerchantShippedDate") %></td>
					</tr>
				<% End If %>
				<% If Not IsNull(oOrder("OrderDeliveryCarrierName")) Then %>
					<% iCounter = iCounter + 1 %>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td>Tracking Carrier:</td>
						<td><%= oOrder("OrderDeliveryCarrierName") %></td>
					</tr>
				<% End If %>
				<% If Not IsNull(oOrder("OrderDeliveryTracking")) Then %>
					<% iCounter = iCounter + 1 %>
					<tr style="background: <%= IIF(iCounter Mod 2 = 0, "#fff", C_SITE_COLOR2) %>">
						<td>Tracking Number:</td>
						<td><%= oOrder("OrderDeliveryTracking") %></td>
					</tr>
				<% End If %>
				</table>
				<br />
				<br />

				<table cellpadding="3" cellspacing="1" border="0" style="background: #bebebe">
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<th style="width: 100px">&nbsp;</th>
						<th>Billing Information</th>
						<th>Shipping Information</th>
					</tr>
					<tr style="background: #fff">
						<td>Name:</td>
						<td><%= oOrder("OrderBillingFirstName") & " " & oOrder("OrderBillingLastName") %></td>
						<td><%= oOrder("OrderShippingFirstName") & " " & oOrder("OrderShippingLastName") %></td>
					</tr>
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<td>Company:</td>
						<td><%= oOrder("OrderBillingCompanyName") %></td>
						<td><%= oOrder("OrderShippingCompanyName") %></td>
					</tr>
					<tr style="background: #fff">
						<td>Address 1:</td>
						<td><%= oOrder("OrderBillingAddress1") %></td>
						<td><%= oOrder("OrderShippingAddress1") %></td>
					</tr>
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<td>Address 2:</td>
						<td><%= oOrder("OrderBillingAddress2") %></td>
						<td><%= oOrder("OrderShippingAddress2") %></td>
					</tr>
					<tr style="background: #fff">
						<td>City, St. Zip:</td>
						<td><%= oOrder("OrderBillingCity") %>,
							<%= oOrder("OrderBillingState") %>&nbsp;<%= oOrder("OrderBillingZip") %>,
							<%= oOrder("OrderBillingCountry") %></td>
						<td><%= oOrder("OrderShippingCity") %>,
							<%= oOrder("OrderShippingState") %>&nbsp;<%= oOrder("OrderShippingZip") %>,
							<%= oOrder("OrderShippingCountry") %></td>
					</tr>
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<td>Home Phone:</td>
						<td><%= oOrder("OrderBillingHomePhone") %></td>
						<td><%= oOrder("OrderShippingHomePhone") %></td>
					</tr>
					<tr style="background: #fff">
						<td>Alt Phone:</td>
						<td><%= oOrder("OrderBillingAltPhone") %></td>
						<td><%= oOrder("OrderShippingAltPhone") %></td>
					</tr>
				</table>
				<br />
				<br />

				<table cellpadding="3" cellspacing="1" border="0" style="background: #bebebe">
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<th colspan="2">Payment Type: <%= oOrder("PaymentTypeName") %></th>
					</tr>
			<%
			Select Case oOrder("PaymentTypeCategory")
				Case "1"
					%>
					<tr style="background: #fff">
						<td style="width: 100px">Card Type:</td>
						<td><%= oOrder("PaymentTypeName") %></td>
					</tr>
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<td>Card Number:</td>
						<td><%
							Dim sCCNumber : sCCNumber = Decode(oOrder("OrderAccountNumber1"))
							Response.Write PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X")
							%></td>
					</tr>
					<tr style="background: #fff">
						<td>CVV/CVV2:</td>
						<td><%= oOrder("OrderAccountNumber2") %></td>
					</tr>
					<%
				Case Else
					%>
					<tr style="background: #fff">
						<td colspan="2">Coming soon..</td>
					</tr><%
			End Select
			%>
				</table>
				<br />
				<br />

				<table cellpadding="3" cellspacing="1" border="0" style="background: #bebebe">
					<tr style="background: <%= C_SITE_COLOR2 %>">
						<th colspan="6">Order Details &amp; Totals</th>
					</tr>
					<tr style="background: #fff">
						<th>Sku</th>
						<th>Item</th>
						<th>Price</th>
						<th>Stock</th>
						<th>Quantity</th>
						<th>Total</th>
					</tr>
					<% Dim i : i = 0
					Dim fSubTotal : fSubTotal = 0

					Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = " & iOrderID)
					While Not oQuery.Eof %>
						<tr style="background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
							<td><%= oQuery("ProductSKU") %></td>
							<td style="text-align: left"><%= oQuery("ProductName") %> &nbsp; <span style="color: #999999"><%= oQuery("OrderDetailType") %></span></td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></td>
							<td><%= oQuery("ProductStatusName") %></td>
							<td style="text-align: right"><%= oQuery("OrderDetailProductQuantity") %></td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Total"), 2) %></td>
						</tr>
						<% i = i + 1
						fSubTotal = fSubTotal + CCur(oQuery("Total"))
						oQuery.MoveNext
					Wend

					Dim fShipping : fShipping = CCur(IIF(IsNull(oOrder("OrderDeliveryPrice")), 0, oOrder("OrderDeliveryPrice")))
					Dim fPromo : fPromo = CCur(IIF(IsNull(oOrder("OrderPromoAmount")), 0, oOrder("OrderPromoAmount")))
					Dim fTax : fTax = CCur(IIF(IsNull(oOrder("OrderTaxAmount")), 0, oOrder("OrderTaxAmount")))
					Dim fGrandTotal : fGrandTotal = fSubTotal + fShipping + fPromo + fTax
					%>
					<tr style="font-weight: bold; background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
						<td style="text-align: right" colspan="5">Sub Total:</td>
						<td style="text-align: right"><%= CurrencyFormat(fSubTotal, 2) %></td>
					</tr>
					<% i = i + 1 %>
					<tr style="font-weight: bold; background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
						<td style="text-align: right" colspan="5">
							<% If Not IsNull(oOrder("OrderDeliveryCost")) Then %>
							<span style="font-weight: normal">Shipping Cost: <%= CurrencyFormat(oOrder("OrderDeliveryCost"), 2) %></span>
							&nbsp;&nbsp;&nbsp;
							<% End If %>
							Shipping (<%= oOrder("OrderDeliveryMethod") %>):
						</td>
						<td style="text-align: right"><%= CurrencyFormat(fShipping, 2) %></td>
					</tr>
					<% i = i + 1 %>
					<tr style="font-weight: bold; background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
						<td style="text-align: right" colspan="5">Promo (<%= oOrder("OrderPromoCode") %>):</td>
						<td style="text-align: right"><%= CurrencyFormat(fPromo, 2) %></td>
					</tr>
					<% i = i + 1 %>
					<tr style="font-weight: bold; background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
						<td style="text-align: right" colspan="5">Tax<%= IIF(oOrder("OrderTaxExemption") = "1", " (Exemption)", "") %>:</td>
						<td style="text-align: right"><%= CurrencyFormat(fTax, 2) %></td>
					</tr>
					<% i = i + 1 %>
					<tr style="font-weight: bold; background: <%= IIF(i Mod 2 = 0, C_SITE_COLOR2, "#fff") %>">
						<td style="text-align: right; color: red" colspan="5">Grand Total:</td>
						<td style="text-align: right; color: red"><%= CurrencyFormat(fGrandTotal, 2) %></td>
					</tr>
				</table>
				<%
					oOrder.Close
					Set oOrder = Nothing
				%>
			</div>
		</div>
		<!--#include file="inc/BottomFrontend.asp"-->
	</body>
</html>
