<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<!--#include file="inc/Blowfish.asp"-->
<%
	If IsCustomer() Then
		Redirect(GetPageLink("Account"))
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iCustomerID
	Dim CustomerFirstName : CustomerFirstName				= GetFormValue("CustomerFirstName", 255)
	Dim CustomerLastName : CustomerLastName					= GetFormValue("CustomerLastName", 255)
	Dim CustomerEmail : CustomerEmail						= GetFormValue("CustomerEmail", 255)
	Dim CustomerCompany : CustomerCompany					= GetFormValue("CustomerCompany", 255)
	Dim CustomerWebsite : CustomerWebsite					= GetFormValue("CustomerWebsite", 255)
	Dim CustomerProfName : CustomerProfName					= GetFormValue("CustomerProfName", 255)
	Dim CustomerProfType : CustomerProfType					= GetFormValue("CustomerProfType", 255)
	Dim CustomerProfLicense : CustomerProfLicense			= GetFormValue("CustomerProfLicense", 255)
	Dim CustomerDEANumber : CustomerDEANumber				= GetFormValue("CustomerDEANumber", 255)
	Dim CustomerPassword : CustomerPassword					= GetFormValue("CustomerPassword", 255)
	Dim CustomerConfirmPassword : CustomerConfirmPassword	= GetFormValue("CustomerConfirmPassword", 255)

	If Request("Submit") <> "" Then
		If CustomerFirstName = "" Then
			AddError("Field <strong>First Name</strong> is required.")
		End If
		If CustomerLastName = "" Then
			AddError("Field <strong>Last Name</strong> is required.")
		End If
		If CustomerEmail = "" Then
			AddError("Field <strong>Email Address</strong> is required.")
		ElseIf Not ValidateEmail(CustomerEmail) Then
			AddError("Field <strong>Email Address</strong> is invalid.")
		ElseIf GetValueFromTable(oConn, "CustomerID", "utb_Customers", "WHERE CustomerEmail = '" & Quote(CustomerEmail) & "'") <> "" Then
			AddError("Customer with Email <strong>" & CustomerEmail & "</strong> already exist in database.")
		End If
		If CustomerProfName = "" Then
			AddError("Field <strong>Medical Professional Name</strong> is required.")
		End If
		If CustomerProfLicense = "" Then
			AddError("Field <strong>Medical Professional License Number</strong> is required.")
		End If
		If CustomerPassword = "" Then
			AddError("Field <strong>Password</strong> is required.")
		ElseIf Len(CustomerPassword) < C_PASSWORD_LENGTH Then
			AddError("Field <strong>Password</strong> is invalid. Please enter " & C_PASSWORD_LENGTH & " or more characters")
		End If
		If CustomerConfirmPassword = "" Then
			AddError("Field <strong>Confirm Password</strong> is required.")
		End If
		If (CustomerPassword <> "" Or CustomerConfirmPassword <> "") And (CustomerPassword <> CustomerConfirmPassword) Then
			AddError("Fields <strong>Password</strong> and <strong>Confirm Password</strong> do not match.")
		End If

		If Not IsError() Then
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "INSERT INTO utb_Customers(" &_
					 "	CustomerTypeID" &_
					 ", CustomerEmail" &_
					 ", CustomerPassword" &_
					 ", CustomerBillingFirstName" &_
					 ", CustomerBillingLastName" &_
					 ", CustomerBillingCompanyName" &_
					 ", CustomerBillingCountry" &_
					 ", CustomerBillingAddress1" &_
					 ", CustomerBillingCity" &_
					 ", CustomerBillingState" &_
					 ", CustomerBillingZip" &_
					 ", CustomerBillingHomePhone" &_
					 ", CustomerShippingFirstName" &_
					 ", CustomerShippingLastName" &_
					 ", CustomerShippingCountry" &_
					 ", CustomerShippingAddress1" &_
					 ", CustomerShippingCity" &_
					 ", CustomerShippingState" &_
					 ", CustomerShippingZip" &_
					 ", CustomerShippingHomePhone" &_
					 ", CustomerProfName" &_
					 ", CustomerProfType" &_
					 ", CustomerProfLicense" &_
					 ", CustomerDEANumber" &_
					 ", CustomerWebsite" &_
					 ") " & _
					 "VALUES(" &_
					 "	1" &_
					 ", '" & Quote(CustomerEmail) & "'" &_
					 ", '" & Quote(Encode(CustomerPassword)) & "'" &_
					 ", '" & Quote(CustomerFirstName) & "'" &_
					 ", '" & Quote(CustomerLastName) & "'" &_
					 ",  " & IIF(CustomerCompany <> "", "'" & Quote(CustomerCompany) & "'", "NULL") &_
					 ", 'US'" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", 'US'" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", ''" &_
					 ", '" & Quote(CustomerProfName) & "'" &_
					 ",  " & IIF(CustomerProfType <> "", "'" & Quote(CustomerProfType) & "'", "NULL") &_
					 ", '" & Quote(CustomerProfLicense) & "'" &_
					 ",  " & IIF(CustomerDEANumber <> "", "'" & Quote(CustomerDEANumber) & "'", "NULL") &_
					 ",  " & IIF(CustomerWebsite <> "", "'" & Quote(CustomerWebsite) & "'", "NULL") &_
					 ")"
			oConn.Execute(sQuery)
			iCustomerID = GetLastID(oConn)

			If Err.Number = 0 Then
				Dim sEmailSubject, sEmailBody
				Call GetEmailTemplate(2)
				sEmailBody = Replace(sEmailBody, "$FirstName$", CustomerFirstName)
				sEmailBody = Replace(sEmailBody, "$LastName$", CustomerLastName)
				sEmailBody = Replace(sEmailBody, "$Email$", CustomerEmail)
				sEmailBody = Replace(sEmailBody, "$Password$", CustomerPassword)

				Call SendEmail(CustomerEmail, GetSetting(oConn, "CompanyEmailForSite"), sEmailSubject, sEmailBody)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Session("CustomerID") = iCustomerID
					Session("CustomerIsGuest") = False
					Call SetAlertMessage("success", "Your account has been created.")
					Redirect(IIF(Request("Referer") <> "", Base64Decode(Request("Referer")), GetPageLink("Account")))
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
		End If
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderFrontend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopFrontend.asp"-->
        <div class="breadcrumbs">
			<span class="home">Home:</span>
			<span itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
				<a href="<%= GetPageLink("Account") %>" itemprop="url"><span itemprop="title">Account</span></a>
				<span itemprop="child" itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
					<a href="<%= GetPageLink("Account/Registration") %>" itemprop="url"><span itemprop="title">Registration</span></a>
				</span>
			</span>
		</div>
        <div class="block-clear details-wrap">
			<div class="wpage-title"><h1>Customer Registration</h1></div>
			<div class="wpage-content">
				<!--#include file="inc/Alert.asp"-->
				<form action="<%= GetPageLink("Account/Registration") %>" method="post" class="default register">
					<table cellpadding="5" cellspacing="0" border="0">
						<tr>
							<td>
								<label for="CustomerFirstName">First Name</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerFirstName" id="CustomerFirstName" value="<%= CustomerFirstName %>" maxlength="255" required="true" autofocus="true"/>
							</td>
							<td style="width: 20px">&nbsp;</td>
							<td>
								<label for="CustomerLastName">Last Name</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerLastName" id="CustomerLastName" value="<%= CustomerLastName %>" maxlength="255" required="true"/>
							</td>
						</tr>
						<tr>
							<td>
								<label for="CustomerEmail">Email Address</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="email" name="CustomerEmail" id="CustomerEmail" value="<%= CustomerEmail %>" maxlength="255" required="true"/>
							</td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td>
								<label for="CustomerCompany">Company Name</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""><strong>NOT</strong> required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerCompany" id="CustomerCompany" value="<%= CustomerCompany %>" maxlength="255"/>
							</td>
							<td></td>
							<td>
								<label for="CustomerWebsite">Website</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""><strong>NOT</strong> required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="url" name="CustomerWebsite" id="CustomerWebsite" value="<%= CustomerWebsite %>" maxlength="255"/>
							</td>
						</tr>
						<tr>
							<td>
								<label for="CustomerProfName">Medical Professional Name</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerProfName" id="CustomerProfName" value="<%= CustomerProfName %>" maxlength="255" required="true"/>
							</td>
							<td></td>
							<td>
								<label for="CustomerProfType">Type of Medical Professional</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""><strong>NOT</strong> required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerProfType" id="CustomerProfType" value="<%= CustomerProfType %>" maxlength="255"/>
							</td>
						</tr>
						<tr>
							<td>
								<label for="CustomerProfLicense">Medical Professional License Number</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerProfLicense" id="CustomerProfLicense" value="<%= CustomerProfLicense %>" maxlength="255" required="true"/>
							</td>
							<td></td>
							<td>
								<label for="CustomerDEANumber">DEA Number</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""><strong>NOT</strong> required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="text" name="CustomerDEANumber" id="CustomerDEANumber" value="<%= CustomerDEANumber %>" maxlength="255"/>
							</td>
						</tr>
						<tr>
							<td>
								<label for="CustomerPassword">Password</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="password" name="CustomerPassword" id="CustomerPassword" value="<%= CustomerPassword %>" maxlength="255" required="true" autocomplete="off"/>
							</td>
							<td></td>
							<td>
								<label for="CustomerConfirmPassword">Confirm Password</label>
								<div><img src="<%= GetMediaUrl("images/default/required.gif") %>" alt="">required <img src="<%= GetMediaUrl("images/default/required.gif") %>" alt=""></div>
								<input type="password" name="CustomerConfirmPassword" id="CustomerConfirmPassword" value="<%= CustomerConfirmPassword %>" maxlength="255" required="true" autocomplete="off"/>
							</td>
						</tr>
						<tr>
							<td colspan="3"><input type="submit" name="Submit" value="Submit"/></td>
						</tr>
					</table>
				</form>
			</div>
		</div>
		<!--#include file="inc/BottomFrontend.asp"-->
	</body>
</html>
