<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<!--#include file="inc/Blowfish.asp"-->
<%
	Dim sAction : sAction = Request("Action")
	Dim ShippingCountry : ShippingCountry = IIF(Request("ShippingCountry") <> "", Request("ShippingCountry"), C_DEFAULT_COUNTRY_CODE)
	Dim ShippingState : ShippingState = Request("ShippingState")
	Dim ShippingMethodID : ShippingMethodID = Request("ShippingMethodID")
	Dim PromoCode : PromoCode = Request("PromoCode")

	Dim sContinueLink : sContinueLink = GetLink("")
	'If Request.ServerVariables("HTTP_REFERER") <> "" And Request.ServerVariables("HTTP_REFERER") <> "a" Then
	'	sContinueLink = StripTags(Request.ServerVariables("HTTP_REFERER"))
	'End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iBasketCustomerID : iBasketCustomerID = GetBasketCustomerID()

	Select Case sAction
		Case "Update"
			Dim iProductCount
			Dim ProductID : ProductID = Split(Request("_ProductID"), ", ")
			Dim ProductSKU : ProductSKU = Split(Request("_ProductSKU"), ", ")
			Dim BasketQuantity : BasketQuantity = Split(Request("_BasketQuantity"), ", ")

			Dim sXML
			For iProductCount = 0 To UBound(ProductID)
				Dim ID, SKU, Quantity
				ID = Trim(ProductID(iProductCount))
				SKU = Trim(ProductSKU(iProductCount))
				Quantity = Trim(BasketQuantity(iProductCount))

				If Not ValidateInteger(Quantity) Then
					AddError("Field <strong>Quantity</strong> for item '" & SKU & "' is invalid.")
				End If

				If Not IsError() Then
					sXML = sXML & "<i p=""" & ID & """ q=""" & Quantity &  """/>"
				End If
			Next

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "EXEC usp_BasketUpd" &_
						 "	   @BasketCustomerID = " & iBasketCustomerID &_
						 "	 , @XML = '" & Quote("<r>" & sXML & "</r>") & "'"
				Set oQuery = oConn.Execute(sQuery)
				If CInt(oQuery("OverLimit")) > 0 Then
					AddError("You have exceeded the max order quantity, your qty has been adjusting accordingly to the inventory available.")
				End If

				If Err.Number = 0 Then
					oConn.CommitTrans
					If Not IsError() Then
						Call SetAlertMessage("success", "Basket has been updated.")
					End If
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Remove"
			Dim iBasketID : iBasketID = Request("BasketID")

			If Not ValidateInteger(iBasketID) Then
				Redirect(GetPageLink("Basket"))
			End If

			oConn.BeginTrans
			On Error Resume Next

			oConn.Execute("EXEC usp_BasketDel @BasketCustomerID = '" & Quote(iBasketCustomerID) & "', @BasketID = '" & Quote(iBasketID) & "'")

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Product has been removed.")
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
	End Select

	Dim fSubTotal : fSubTotal = 0
	Dim fShipping : fShipping = 0
	Dim fShippingDiscount : fShippingDiscount = 0
	Dim iShippingDiscountMethodID : iShippingDiscountMethodID = 0
	Dim fPromoDiscount : fPromoDiscount = 0
	Dim fTaxRate : fTaxRate = 0
	Dim fTax : fTax = 0
	Dim bShippingEnable : bShippingEnable = False

	If PromoCode <> "" Then
		sQuery = "EXEC usp_PromoCodeDiscountCalculate" &_
				 "	   @PromoCodeName = '" & PromoCode & "'" &_
				 "	 , @BasketCustomerID = '" & Quote(iBasketCustomerID) & "'" &_
				 IIF(ShippingCountry <> "", "	 , @CountryCode = '" & Quote(ShippingCountry) & "'", "") &_
				 IIF(ShippingState <> "", "	 , @StateID = '" & Quote(ShippingState) & "'", "")

		Dim oPromoCode
		Set oPromoCode = oConn.Execute(sQuery)

		If Not oPromoCode.Eof Then
			If oPromoCode("DisplayMessage") <> "" Then
				AddError(oPromoCode("DisplayMessage"))
			Else
				fPromoDiscount = CCur(oPromoCode("OrderDiscount"))
				fShippingDiscount = CCur(oPromoCode("ShippingDiscount"))
				iShippingDiscountMethodID = oPromoCode("ShippingMethodID")
			End If
		End If
	End If

	If ShippingCountry <> "" Then
		Dim bCountryWithStates : bCountryWithStates = (GetValueFromTable(oConn, "COUNT(*)", "utb_States", "WHERE CountryCode = '" & Quote(ShippingCountry) & "'") > 0)

		If Not bCountryWithStates Or (bCountryWithStates And ValidateInteger(ShippingState)) Then
			bShippingEnable = True
		End If

		If ShippingState <> "" Then
			Dim oStateTax
			sQuery = " SELECT se.CompanyTaxRate " &_
					 "   FROM utb_Settings se " &_
					 "		INNER JOIN utb_States st ON st.StateCode = se.CompanyTaxState " &_
					 "  WHERE st.StateID = '" & Quote(ShippingState) & "' " &_
					 "	AND st.CountryCode = '" & Quote(C_DEFAULT_COUNTRY_CODE) & "' "
			Set oStateTax = oConn.Execute(sQuery)

			If Not oStateTax.Eof Then
				fTaxRate = CCur(oStateTax("CompanyTaxRate"))
			End If

			oStateTax.Close
			Set oStateTax = Nothing
		End If
	End If

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderFrontend.asp"-->
	</head>
	<body>
		<% If sAction = "Checkout" Then %>
			<form action="<%= GetLink("Checkout.asp") %>" method="post" id="checkout-form">
				<input type="hidden" name="CustomerID" value="<%= Encode(GetCustomerID()) %>"/>
				<input type="hidden" name="BasketCustomerID" value="<%= iBasketCustomerID %>"/>
				<input type="hidden" name="PromoCode" value="<%= PromoCode %>"/>
				<input type="hidden" name="RefID" value="<%= Encode(Request.Cookies("RefID")) %>"/>
				<input type="hidden" name="HttpReferer" value="<%= Encode(Request.Cookies("HttpReferer")) %>"/>
			</form>
			<script type="text/javascript">$('#checkout-form').submit()</script>
		<% Else %>
			<!--#include file="inc/TopFrontend.asp"-->
			<div class="breadcrumbs">
				<span class="home">Home:</span>
				<span itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
					<a href="<%= GetPageLink("Basket") %>" itemprop="url"><span itemprop="title">Basket</span></a>
				</span>
			</div>
			<div class="block-clear details-wrap">
				<div class="wpage-title"><h1>Basket</h1></div>
				<div class="wpage-content">
					<strong>Your Basket ID:</strong> <%= iBasketCustomerID %>
					<br/><br/>
					<!--#include file="inc/Alert.asp"-->
					<%
					Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = " & iBasketCustomerID)
					If Not oQuery.Eof Then
						%>
						<form action="<%= GetPageLink("Basket") %>" method="post" class="default" id="BasketForm">
							<input type="hidden" id="Action" name="Action" value="<%= sAction %>"/>
							<input type="hidden" id="BasketID" name="BasketID" value="<%= iBasketID %>"/>
							<table width="100%" cellpadding="0" cellspacing="1" border="0" style="background: <%= C_SITE_COLOR1 %>" class="basket-grid">
								<tr style="text-align: center; background: <%= C_SITE_COLOR2 %>">
									<th width="70">Quantity</th>
									<th>Item Description</th>
									<th width="70">Price</th>
									<th width="70">Total</th>
								</tr>
							<%
							Dim iDisplayType, sName, sSKU, sStatus, sPrice, sQty, sLink
							Dim iProductCounter : iProductCounter = 0
							Dim iKitCounter : iKitCounter = 0
							Dim iGiftCounter : iGiftCounter = 0

							While Not oQuery.Eof
								iDisplayType = CInt(oQuery("DisplayType"))
								If iDisplayType = 0 Or iDisplayType = 1 Then
									If iProductCounter > 0 Then
										%>
													<% If iKitCounter > 0 Or iGiftCounter > 0 Then %>
														</ul>
													</div>
													<% End If %>
													<div style="padding: 10px 0 0 5px">
														<strong>SKU:</strong> <%= sSKU %><br/>
														<strong>Availability:</strong> <%= sStatus %>
													</div>
												</td>
											</tr>
										</table>
									</td>
									<td align="right"><%= CurrencyFormat(sPrice, 2) %></td>
									<td align="right"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
								</tr>
										<%
									End If

									sName	= oQuery("ProductName")
									sSKU	= oQuery("ProductSKU")
									sStatus	= oQuery("ProductStatusName")
									sPrice	= oQuery("ProductPrice")
									sQty	= oQuery("BasketQuantity")
									'sLink	= BuildFriendlyDetailURL(oQuery("ProductName"), oQuery("ProductID"))
                                    sLink	= "/Product/" & Text2Url(oQuery("ProductName")) & ".htm"                                    
									%>
								<tr valign="top" style="background: #fff">
									<td align="center">
										<input type="hidden" name="_ProductID" value="<%= oQuery("ProductID") %>"/>
										<input type="hidden" name="_ProductSKU" value="<%= oQuery("ProductSKU") %>"/>
										<input type="text" name="_BasketQuantity" value="<%= oQuery("BasketQuantity") %>" maxlength="3" style="width: 40px; text-align: center"/>
										<br/>
										<input type="button" value="Remove" onclick="return makeAction('Remove', <%= oQuery("BasketID") %>)" style="margin-top: 5px; padding: 1px 2px; font-size: 10px"/>
									</td>
									<td>
										<table width="100%" cellpadding="0" cellspacing="0" border="0">
											<tr valign="top">
												<td width="90">
													<a href="<%= sLink %>"><img src="<%= GetProductImageSrc(oQuery("ProductImage"), "mini") %>"
															width="<%= C_PRODUCT_IMAGE_MINI_WIDTH %>" height="<%= C_PRODUCT_IMAGE_MINI_HEIGHT %>"
															alt="<%= oQuery("ProductName") %>"/></a>
												</td>
												<td>
													<a href="<%= sLink %>"><strong><%= oQuery("ProductName") %></strong></a>
									<%
								ElseIf iDisplayType = 2 Then
									%>
									<% If iKitCounter = 0 Then %>
													<div style="padding: 10px 0 0 5px">
														<strong>Kit Items:</strong>
														<ul class="kit-items">
									<% End If %>
															<li><%= oQuery("ProductName") %></li>
									<%
								ElseIf iDisplayType = 3 Then
									%>
									<% If iGiftCounter = 0 Then %>
													<% If iKitCounter > 0 Then %>
														</ul>
													</div>
													<% End If %>
													<div style="padding: 10px 0 0 5px">
														<strong>Free Items:</strong>
														<ul class="gift-items">
									<% End If %>
															<li><%= oQuery("ProductName") %></li>
									<%
								End If

								Select Case iDisplayType
									Case 0
										iProductCounter = iProductCounter + 1
										iKitCounter = 0
										iGiftCounter = 0
									Case 1
										iProductCounter = iProductCounter + 1
										iKitCounter = 0
										iGiftCounter = 0
									Case 2
										iKitCounter = iKitCounter + 1
									Case 3
										iGiftCounter = iGiftCounter + 1
								End Select

								fSubTotal = fSubTotal + CCur(oQuery("ProductPrice")) * CCur(oQuery("BasketQuantity"))
								oQuery.MoveNext
							Wend
							fTax = (fSubTotal - fPromoDiscount) / 100 * fTaxRate
							%>
													<% If iKitCounter > 0 Or iGiftCounter > 0 Then %>
														</ul>
													</div>
													<% End If %>
													<div style="padding: 10px 0 0 5px">
														<strong>SKU:</strong> <%= sSKU %><br/>
														<strong>Availability:</strong> <%= sStatus %>
													</div>
												</td>
											</tr>
										</table>
									</td>
									<td align="right"><%= CurrencyFormat(sPrice, 2) %></td>
									<td align="right"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
								</tr>
							</table>

							<br />
							<table width="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td align="center" width="72">
										<input type="button" value="Update" onclick="return makeAction('Update', 0)"/>
									</td>
									<td align="right" nowrap="nowrap">
										<table cellpadding="0" cellspacing="0" border="0">
											<tr>
												<td align="right" style="padding-top: 5px; padding-right: 0">
													<strong>Sub Total:</strong>
													&nbsp;&nbsp;&nbsp;
													<%= CurrencyFormat(fSubTotal, 2) %>
												</td>
											</tr>
											<tr>
												<td align="right" style="padding-top: 5px; padding-right: 0">
													<strong>Shipping:</strong>
													&nbsp;&nbsp;&nbsp;
													<%
														If bShippingEnable Then
															Dim oShippingMethod
															Set oShippingMethod = oConn.Execute("EXEC usp_ShippingRatesGet @BasketCustomerID = '" & Quote(iBasketCustomerID) & "', @CountryCode = '" & Quote(ShippingCountry) & "', @StateID = '" & Quote(ShippingState) & "'")

															If Not oShippingMethod.Eof Then
																ShippingMethodID = IIF(ShippingMethodID <> "", ShippingMethodID, oShippingMethod("ShippingMethodID"))
													%>
															<select id="ShippingMethodID" name="ShippingMethodID" onchange="makeAction('Recalc', 0)" style="width: auto">
														<%
																While Not oShippingMethod.Eof
																	Dim fValue : fValue = CCur(oShippingMethod("ShippingTotal"))
																	If CStr(oShippingMethod("ShippingMethodID")) = CStr(iShippingDiscountMethodID) Then
																		fValue = fValue - fShippingDiscount
																	End If
														%>
																<option value="<%= oShippingMethod("ShippingMethodID") %>" <%= IIF(CStr(oShippingMethod("ShippingMethodID")) = CStr(ShippingMethodID), "selected='selected'", "") %>> <%= oShippingMethod("ShippingMethodName") %> - <%= IIF(fValue = 0, "free", CurrencyFormat(fValue, 2)) %></option>
														<%
																	If CStr(oShippingMethod("ShippingMethodID")) = CStr(ShippingMethodID) Then
																		fShipping = fValue
																	End if
																	oShippingMethod.MoveNext
																Wend
														%>
															</select>
													<%
															End If

															oShippingMethod.Close
															Set oShippingMethod = Nothing
														Else
													%>
													<%= CurrencyFormat(0, 2) %>
													<%
														End If
													%>
												</td>
											</tr>
											<tr>
												<td align="right" style="padding-top: 5px; padding-right: 0">
													<table cellpadding="0" cellspacing="0" border="0">
														<tr style="vertical-align: middle">
															<td style="padding: 0"><strong>Promo Code:&nbsp;&nbsp;&nbsp;</strong></td>
															<td style="padding: 0"><input type="text" name="PromoCode" value="<%= PromoCode %>" style="width: 80px" maxlength="8"/></td>
															<td style="padding: 0">&nbsp;&nbsp;<input type="button" value="Apply" id="Apply" onclick="makeAction('Recalc', 0)" style="padding: 1px 2px"/></td>
															<td style="padding: 0; text-align: right">&nbsp;&nbsp;&nbsp;<%= CurrencyFormat(0 - fPromoDiscount, 2) %></td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td align="right" style="padding-top: 5px; padding-right: 0">
													<strong>Tax:</strong>
													&nbsp;&nbsp;&nbsp;
													<%= CurrencyFormat(fTax, 2) %>
												</td>
											</tr>
											<tr>
												<td align="right" style="padding-top: 5px; padding-right: 0">
													<strong>Grand Total:</strong>
													&nbsp;&nbsp;&nbsp;
													<%= CurrencyFormat(fSubTotal + fShipping - fPromoDiscount + fTax, 2) %>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>

							<table cellpadding="0" cellspacing="10" border="0">
								<tr>
									<td valign="middle">
										<label for="ShippingCountry">Shipping Country:</label>
										<select id="ShippingCountry" name="ShippingCountry" onchange="getStates()" style="width: auto; margin-top: 0px">
											<option value="">Select One</option>
										<%
											Dim oShippingCountry
											Set oShippingCountry = oConn.Execute("SELECT * FROM utb_Countries WHERE CountryIsActiveShipping = 1 ORDER BY CountrySortOrder, CountryName")

											While Not oShippingCountry.Eof
										%>
											<option value="<%= oShippingCountry("CountryCode") %>" <%= IIF(CStr(oShippingCountry("CountryCode")) = CStr(ShippingCountry), "selected='selected'", "") %>> <%= oShippingCountry("CountryName") %></option>
										<%
												oShippingCountry.MoveNext
											Wend

											oShippingCountry.Close
											Set oShippingCountry = Nothing
										%>
										</select>
									</td>
									<td valign="middle"><div id="ShippingStateLayer"></div></td>
									<td valign="middle">
										<input type="button" value="Calculate Shipping" onclick="makeAction('Recalc', 0)"/>
									</td>
								</tr>
							</table>
						</form>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td style="padding-top: 5px"><input type="button" value="Continue Shopping" onclick="document.location.href='<%= sContinueLink %>'"/></td>
								<td align="right" style="padding-top:5px">
									<form action="<%= GetLink("Checkout.asp") %>" method="post" id="checkout-form">
										<input type="hidden" name="CustomerID" value="<%= Encode(GetCustomerID()) %>"/>
										<input type="hidden" name="BasketCustomerID" value="<%= iBasketCustomerID %>"/>
										<input type="hidden" name="PromoCode" value="<%= PromoCode %>"/>
										<input type="hidden" name="RefID" value="<%= Encode(Request.Cookies("RefID")) %>"/>
										<input type="hidden" name="HttpReferer" value="<%= Encode(Request.Cookies("HttpReferer")) %>"/>
										<input type="submit" name="submit" value="Checkout"/>
									</form>
								</td>
							</tr>
						</table>
						<br/>
						<div style="clear: both"></div>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td><%= GetInfoSection(2) %></td>
							</tr>
						</table>
					<% Else %>
						<div style="text-align: center; padding: 50px 0">
							Your shopping cart is empty.
							<br/><br/>
							<a href="<%= GetLink("") %>">Continue shopping</a>
						</div>
					<% End If %>
					<%
						oQuery.Close
						Set oQuery = Nothing
					%>
				</div>
			</div>
			<!--#include file="inc/BottomFrontend.asp"-->
			<script type="text/javascript">
			//<![CDATA[
			$(function(){
				getStates();
			});

			function getStates() {
				$.ajax({url: 'ajax/GetStates.asp', type: 'POST', dataType: 'json', async: true,
					data: {CountryID: $('#ShippingCountry').val(), IsCode: 0},
					success: function(response) {
						if (response.length > 0) {
							var html = '';
							html += '<label for="ShippingState">State:</label> ';
							html += '<select id="ShippingState" name="ShippingState" onchange="changeState();" style="width: auto; margin-top: 0px">';
							html += '<option value="">Select One</option>';
							$.each(response, function(i, v) {
								html += '<option value="' + v.StateCode + '" ' + (v.StateCode == '<%= ShippingState %>' ? 'selected="selected"' : '') + '>' + v.StateName + '</option>';
							});
							html += '</select>';

							$('#ShippingStateLayer').html(html);
							changeState();
						}
						else {
							$('#ShippingStateLayer').html('');
							$('#GetMethods').attr('disabled', ($('#ShippingCountry').val() ? '' : 'disabled'));
						}
					}
				});
			}

			function changeState() {
				$('#GetMethods').attr('disabled', ($('#ShippingState').val() ? '' : 'disabled'));
			}

			function makeAction(name, id) {
				$('#Action').val(name);
				$('#BasketID').val(id);
				$('#BasketForm').submit();

				return false;
			}
			//]]>
			</script>
		<% End If %>
	</body>
</html>
