<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<!--#include file="inc/Blowfish.asp"-->
<!--#include file="inc/CheckoutValidation.asp"-->
<%
	If CustomerID = "" Then
		Redirect(GetPageLink("Basket"))
	End If

	Dim oConn, sQuery, oQuery, sWhere
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sParam
	Dim iProductsCount
	sWhere = "WHERE b.BasketCustomerID = '" & Quote(GetBasketCustomerID()) & "' AND p.ProductStatusID > 1"
	iProductsCount = GetValueFromTable(oConn, "COUNT(*)", "utb_Basket b INNER JOIN utb_Products p ON p.ProductID = b.ProductID", sWhere)
	If iProductsCount = 0 Then
		Redirect(GetPageLink("Basket"))
	End If

	Dim CustomerIsTaxable
	CustomerIsTaxable = GetValueFromTable(oConn, "CustomerIsTaxable", "utb_Customers", "WHERE CustomerID = '" & Quote(Decode(CustomerID)) & "'")
	If IsNull(CustomerIsTaxable) Then
		CustomerIsTaxable = 0
	End If
	CustomerIsTaxable = CInt(CustomerIsTaxable)

	Dim CustomerShippingStateID
	sWhere = "WHERE CountryCode = '" & Quote(CustomerShippingCountry) & "' AND StateCode = '" & Quote(CustomerShippingState) & "'"
	CustomerShippingStateID = GetValueFromTable(oConn, "StateID", "utb_States", sWhere)

	Dim fPromoDiscount : fPromoDiscount = 0
	Dim fShippingDiscount : fShippingDiscount = 0
	Dim iShippingDiscountMethodID : iShippingDiscountMethodID = 0
	If PromoCode <> "" Then
		sQuery = "EXEC usp_PromoCodeDiscountCalculate" &_
				 "	@PromoCodeName = '" & PromoCode & "'" &_
				 ", @BasketCustomerID = '" & Quote(GetBasketCustomerID()) & "'" &_
				 ", @CountryCode = '" & Quote(CustomerShippingCountry) & "'" &_
				 ", @StateID = '" & Quote(CustomerShippingStateID) & "'"

		Dim oPromoCode
		Set oPromoCode = oConn.Execute(sQuery)
		If Not oPromoCode.Eof Then
			If oPromoCode("DisplayMessage") <> "" Then
				AddError(oPromoCode("DisplayMessage"))
			Else
				fPromoDiscount = CCur(oPromoCode("OrderDiscount"))
				fShippingDiscount = CCur(oPromoCode("ShippingDiscount"))
				iShippingDiscountMethodID = oPromoCode("ShippingMethodID")
			End If
		End If
	End If

	Dim fTax : fTax = 0
	Dim fTaxRate : fTaxRate = 0
	Dim fSubTotal : fSubTotal = 0
	If CustomerShippingStateID <> "" And CustomerIsTaxable = 0 Then
		sQuery = "SELECT se.CompanyTaxRate" &_
				 "	FROM utb_Settings se" &_
				 "		 INNER JOIN utb_States st ON st.StateCode = se.CompanyTaxState" &_
				 " WHERE st.StateID = '" & Quote(CustomerShippingStateID) & "'" &_
				 "	 AND st.CountryCode = '" & Quote(C_DEFAULT_COUNTRY_CODE) & "'"

		Dim oStateTax
		Set oStateTax = oConn.Execute(sQuery)
		If Not oStateTax.Eof Then
			fTaxRate = CCur(oStateTax("CompanyTaxRate"))
		End If
		oStateTax.Close
		Set oStateTax = Nothing
	End If

	Dim fShipping : fShipping = 0
	Dim sShippingName : sShippingName = ""
	Dim oShippingMethod
	sQuery = "EXEC usp_ShippingRateGet" &_
			 "	@BasketCustomerID 	= '" & Quote(GetBasketCustomerID()) & "'" &_
			 ", @CountryCode 		= '" & Quote(CustomerShippingCountry) & "'" &_
			 ", @StateID 			= '" & Quote(CustomerShippingStateID) & "'" &_
			 ", @ShippingMethodID 	= '" & ShippingMethodID & "'"
	Set oShippingMethod = oConn.Execute(sQuery)
	If Not oShippingMethod.Eof Then
		fShipping = CCur(oShippingMethod("ShippingTotal")) - IIF(CStr(oShippingMethod("ShippingMethodID")) = CStr(iShippingDiscountMethodID), fShippingDiscount, 0)
		sShippingName = oShippingMethod("ShippingMethodName")
	End If
	oShippingMethod.Close
	Set oShippingMethod = Nothing

	Dim Direction : Direction = Request("Direction")
	If Direction = "Next" Then
		Call CommonValidation(3)

		If Not IsError() Then
			On Error Resume Next

			Dim HttpReferer : HttpReferer = Decode(Request("HttpReferer"))
			If Err.Number <> 0 Then
				HttpReferer = ""
				Err.Clear
			End If

			Dim RefID : RefID = Decode(Request("RefID"))
			If Err.Number <> 0 Then
				RefID = ""
				Err.Clear
			End If

			oConn.BeginTrans

			Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = '" & Quote(GetBasketCustomerID()) & "'")
			While Not oQuery.Eof
				fSubTotal = fSubTotal + CCur(oQuery("ProductPrice")) * CCur(oQuery("BasketQuantity"))
				oQuery.MoveNext
			Wend
			fTax = (fSubTotal - fPromoDiscount) / 100 * fTaxRate
			oQuery.Close
			Set oQuery = Nothing

			Dim iCustID : iCustID = IIF(Decode(CustomerID) = 0, "NULL", "'" & Quote(Decode(CustomerID)) & "'")
			sQuery = "EXEC usp_OrderAdd" &_
					 "	@CustomerID 				=  " & iCustID &_
					 ",	@OrderEmail					= '" & Quote(CustomerEmail) & "'" &_
					 ",	@BasketCustomerID			= '" & Quote(GetBasketCustomerID()) & "'" &_
					 ", @ItemsXML					= NULL" &_

					 ", @OrderBillingFirstName		= '" & Quote(CustomerBillingFirstName) & "'" &_
					 ", @OrderBillingLastName		= '" & Quote(CustomerBillingLastName) & "'" &_
					 ", @OrderBillingCompanyName 	= '" & Quote(CustomerBillingCompanyName) & "'" &_
					 ", @OrderBillingCountry		= '" & Quote(CustomerBillingCountry) & "'" &_
					 ", @OrderBillingAddress1		= '" & Quote(CustomerBillingAddress1) & "'" &_
					 ", @OrderBillingAddress2		= '" & Quote(CustomerBillingAddress2) & "'" &_
					 ", @OrderBillingCity			= '" & Quote(CustomerBillingCity) & "'" &_
					 ", @OrderBillingState			= '" & Quote(CustomerBillingState) & "'" &_
					 ", @OrderBillingZip			= '" & Quote(CustomerBillingZip) & "'" &_
					 ", @OrderBillingHomePhone		= '" & Quote(CustomerBillingHomePhone) & "'" &_
					 ", @OrderBillingAltPhone		= '" & Quote(CustomerBillingAltPhone) & "'" &_

					 ", @OrderShippingFirstName		= '" & Quote(CustomerShippingFirstName) & "'" &_
					 ", @OrderShippingLastName		= '" & Quote(CustomerShippingLastName) & "'" &_
					 ", @OrderShippingCompanyName	= '" & Quote(CustomerShippingCompanyName) & "'" &_
					 ", @OrderShippingCountry		= '" & Quote(CustomerShippingCountry) & "'" &_
					 ", @OrderShippingAddress1		= '" & Quote(CustomerShippingAddress1) & "'" &_
					 ", @OrderShippingAddress2		= '" & Quote(CustomerShippingAddress2) & "'" &_
					 ", @OrderShippingCity			= '" & Quote(CustomerShippingCity) & "'" &_
					 ", @OrderShippingState			= '" & Quote(CustomerShippingState) & "'" &_
					 ", @OrderShippingZip			= '" & Quote(CustomerShippingZip) & "'" &_
					 ", @OrderShippingHomePhone		= '" & Quote(CustomerShippingHomePhone) & "'" &_
					 ", @OrderShippingAltPhone		= '" & Quote(CustomerShippingAltPhone) & "'" &_

					 ", @PaymentTypeID 				= '" & Quote(PaymentTypeID) & "'" &_
					 ", @OrderAccountName			= '" & Quote(CreditCardName) & "'" &_
					 ", @OrderAccountNumber1		= '" & Quote(Encode(CreditCardNumber)) & "'" &_
					 ", @OrderAccountNumber2		= '" & Quote(CreditCardCVV) & "'" &_
					 ", @OrderAccountNumber3		= NULL" &_
					 ", @OrderAccountNumber4		= NULL" &_
					 ", @OrderCardExpMonth			= '" & Quote(CreditCardExpMonth) & "'" &_
					 ", @OrderCardExpYear			= '" & Quote(CreditCardExpYear) & "'" &_
					 ", @OrderCard4Digits			= '" & Quote(Right(CreditCardNumber, 4)) & "'" &_

					 ", @OrderDeliveryMethod		= '" & Quote(sShippingName) & "'" &_
					 ", @OrderDeliveryPrice			= '" & Quote(DecimalPatch(fShipping)) & "'" &_
					 ", @OrderPromoCode				= '" & Quote(PromoCode) & "'" &_
					 ", @OrderPromoAmount			= '-" & Quote(DecimalPatch(fPromoDiscount)) & "'" &_
					 ", @OrderTaxAmount				= '" & Quote(DecimalPatch(fTax)) & "'" &_
					 ", @OrderTaxExemption			= '" & Quote(CustomerIsTaxable) & "'" &_
					 ", @OrderCustomerNotes			= '" & Quote(CustomerNotes) & "'" &_
					 ", @OrderReferral 				= '" & Quote(HTMLEncode(HttpReferer)) & "'" &_
					 ", @OrderReferralCode 			= '" & Quote(HTMLEncode(RefID)) & "'" &_
					 ", @OrderIP 					= '" & Quote(Request.ServerVariables("REMOTE_ADDR")) & "'" &_
					 ", @OrderMerchantAltID			= NULL" &_
					 ", @HearFromID					= NULL" &_
					 ", @OrderCreateUser			= NULL" &_
					 ", @OrderProfName				= '" & Quote(CustomerProfName) & "'" &_
					 ", @OrderProfType				= '" & Quote(CustomerProfType) & "'" &_
					 ", @OrderProfLicense			= '" & Quote(CustomerProfLicense) & "'" &_
					 ", @OrderIssuingAuthority		= '" & Quote(CustomerIssuingAuthority) & "'" &_
					 ", @OrderDEANumber				= '" & Quote(CustomerDEANumber) & "'" &_
					 ", @OrderWebsite				= '" & Quote(CustomerWebsite) & "'"

			Dim iOrderID
			Set oQuery = oConn.Execute(sQuery)
			iOrderID = CLng(oQuery("OrderId"))
			oQuery.Close
			Set oQuery = Nothing

			If Err.Number = 0 Then
				oConn.CommitTrans

				Call setOrderFirstOrderedItems(iOrderID)

				If Request("ReceiveOffers") = "1" Then
					oConn.Execute("DELETE FROM utb_Newsletters WHERE NewsletterTypeID = 1 AND NewsletterEmail = '" & Quote(CustomerEmail) & "'")
					oConn.Execute("INSERT INTO utb_Newsletters(NewsletterTypeID, NewsletterEmail) VALUES(1, '" & Quote(CustomerEmail) & "')")
				End If

				Dim arOrderSt : arOrderSt = GetOrderStatusMessage(iOrderID)
				Call SendEmail(CustomerEmail, GetSetting(oConn, "CompanyEmailForOrder"), arOrderSt(0), arOrderSt(1))

				Redirect(GetLink("CheckoutStep4.asp?thankyou=" & Encode(CustomerEmail & "---" & iOrderID)))
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
		End If
	End If

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderFrontend.asp"-->
	</head>
	<body>
		<% If Direction = "Prev" Then %>
		<form action="<%= GetLink("CheckoutStep2.asp") %>" method="post" id="CheckoutStep">
		<input type="hidden" name="RefID" value="<%= GetFormValue("RefID", 1000) %>"/>
		<input type="hidden" name="HttpReferer" value="<%= GetFormValue("HttpReferer", 1000) %>"/>
		<% For Each sParam In Request.Form %>
			<% If LCase(sParam) <> "direction" And LCase(sParam) <> "refid" And LCase(sParam) <> "httpreferer" Then %>
				<input type="hidden" name="<%= sParam %>" value="<%= HTMLEncode(Request.Form(sParam)) %>"/>
			<% End If %>
		<% Next %>
		</form><script type="text/javascript">$('#CheckoutStep').submit()</script>
		<% End If %>

		<!--#include file="inc/TopFrontend.asp"-->
		<div class="breadcrumbs">
			<span class="home">Home:</span>
			<span itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
				<a href="<%= GetLink("Checkout.asp") %>" itemprop="url"><span itemprop="title">Checkout</span></a>
			</span>
		</div>
		<div class="block-clear details-wrap">
			<div class="wpage-title"><h1>Preview</h1></div>
			<div class="wpage-content">
				<!--#include file="inc/Alert.asp"-->
				<form action="<%= GetLink("CheckoutStep3.asp") %>" method="post" class="default" id="CheckoutStep3">
					<input type="hidden" id="Direction" name="Direction" value=""/>
					<input type="hidden" name="RefID" value="<%= GetFormValue("RefID", 1000) %>"/>
					<input type="hidden" name="HttpReferer" value="<%= GetFormValue("HttpReferer", 1000) %>"/>
					<% For Each sParam In Request.Form %>
						<% If LCase(sParam) <> "direction" And LCase(sParam) <> "refid" And LCase(sParam) <> "httpreferer" Then %>
							<input type="hidden" name="<%= sParam %>" value="<%= HTMLEncode(Request.Form(sParam)) %>"/>
						<% End If %>
					<% Next %>

					<table cellpadding="0" cellspacing="0">
						<tr valign="top">
							<td>
								<div style="padding: 0 0 10px 6px"><strong>Billing Information</strong></div>
								<table cellpadding="5" cellspacing="0" border="0">
									<tr><td>&nbsp;<%= CustomerBillingFirstName & " " & CustomerBillingLastName %></td></tr>
									<% If CustomerBillingCompanyName <> "" Or CustomerShippingCompanyName <> "" Then %>
									<tr><td>&nbsp;<%= CustomerBillingCompanyName %></td></tr>
									<% End If %>
									<tr><td>&nbsp;<%= CustomerBillingAddress1 %></td></tr>
									<tr><td>&nbsp;<%= CustomerBillingAddress2 %></td></tr>
									<tr><td>&nbsp;<%= CustomerBillingCity %>,&nbsp;<%= CustomerBillingState %>&nbsp;<%= CustomerBillingZip %></td></tr>
									<tr><td>&nbsp;<%= CustomerBillingCountry %></td></tr>
									<tr><td>&nbsp;<%= CustomerBillingHomePhone %></td></tr>
									<% If CustomerBillingAltPhone <> "" Or CustomerShippingAltPhone <> "" Then %>
									<tr><td>&nbsp;<%= CustomerBillingAltPhone %></td></tr>
									<% End If %>
								</table>
							</td>
							<td width="100">&nbsp;</td>
							<td>
								<div style="padding: 0 0 10px 6px"><strong>Delivery Information</strong></div>
								<table cellpadding="5" cellspacing="0" border="0">
									<tr><td>&nbsp;<%= CustomerShippingFirstName & " " & CustomerShippingLastName %></td></tr>
									<% If CustomerBillingCompanyName <> "" Or CustomerShippingCompanyName <> "" Then %>
									<tr><td>&nbsp;<%= CustomerShippingCompanyName %></td></tr>
									<% End If %>
									<tr><td>&nbsp;<%= CustomerShippingAddress1 %></td></tr>
									<tr><td>&nbsp;<%= CustomerShippingAddress2 %></td></tr>
									<tr><td>&nbsp;<%= CustomerShippingCity %>,&nbsp;<%= CustomerShippingState %>&nbsp;<%= CustomerShippingZip %></td></tr>
									<tr><td>&nbsp;<%= CustomerShippingCountry %></td></tr>
									<tr><td>&nbsp;<%= CustomerShippingHomePhone %></td></tr>
									<% If CustomerBillingAltPhone <> "" Or CustomerShippingAltPhone <> "" Then %>
									<tr><td>&nbsp;<%= CustomerShippingAltPhone %></td></tr>
									<% End If %>
								</table>
							</td>
							<td width="100">&nbsp;</td>
							<td>
								<div style="padding: 0 0 10px 6px"><strong>Payment Information</strong></div>
							<% If (GetIndex(PaymentTypeID, Split("1,2,3,4", ",")) <> -1) Then %>
								<table cellpadding="5" cellspacing="0" border="0">
									<tr><td>&nbsp;<strong>Credit Card - <%= GetValueFromTable(oConn, "PaymentTypeName", "utb_PaymentTypes", "WHERE PaymentTypeID = '" & Quote(PaymentTypeID) & "'") %></strong></td></tr>
									<tr><td>&nbsp;<%= CreditCardName %></td></tr>
									<tr><td>&nbsp;<%= PrependChar(Right(CreditCardNumber, 4), Len(CreditCardNumber), "X") %></td></tr>
									<tr><td>&nbsp;exp:&nbsp;<%= PrependChar(CreditCardExpMonth, 2, "0") %>/<%= CreditCardExpYear %></td></tr>
									<tr><td>&nbsp;</td></tr>
									<tr><td>&nbsp;</td></tr>
								</table>
							<% ElseIf (GetIndex(PaymentTypeID, Split("9", ",")) <> -1) Then %>
								<table cellpadding="5" cellspacing="0" border="0">
									<tr><td>&nbsp;<strong>Money Order</strong></td></tr>
									<tr><td>&nbsp;<%= MoneyOrderNote %></td></tr>
								</table>
							<% ElseIf (GetIndex(PaymentTypeID, Split("11", ",")) <> -1) Then %>
								<table cellpadding="5" cellspacing="0" border="0">
									<tr><td>&nbsp;<strong>Payment by Check</strong></td></tr>
									<tr><td>&nbsp;Account Type - <%= CheckAccountType %></td></tr>
									<tr><td>&nbsp;Check Number - <%= CheckNumber %></td></tr>
									<tr><td>&nbsp;Routing Number - <%= CheckRoutingNumber %></td></tr>
									<tr><td>&nbsp;Bank Account Number - <%= CheckBankAccountNumber %></td></tr>
								</table>
							<% End If %>
							</td>
						</tr>
					</table>
					<br/>

					<strong>Items Ordered</strong>
					<table width="100%" cellpadding="3" cellspacing="1" border="0" style="background: #bebebe">
						<tr style="text-align: center; background: #d8d8d8">
							<th>Item</th>
							<th width="60">Price</th>
							<th width="70">Quantity</th>
							<th width="60">Total</th>
						</tr>
					<%
					Dim oBasket
					Set oBasket = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = '" & Quote(GetBasketCustomerID()) & "'")

					Dim iDisplayType, sName, sSKU, sStatus, sPrice, sQty, sLink
					Dim iProductCounter : iProductCounter = 0
					Dim iKitCounter : iKitCounter = 0
					Dim iGiftCounter : iGiftCounter = 0

					While Not oBasket.Eof
						iDisplayType = CInt(oBasket("DisplayType"))
						If iDisplayType = 0 Or iDisplayType = 1 Then
							If iProductCounter > 0 Then
								%>
											<% If iKitCounter > 0 Or iGiftCounter > 0 Then %>
												</ul>
											</div>
											<% End If %>
											<div style="padding: 10px 0 0 5px">
												<strong>SKU:</strong> <%= sSKU %><br/>
												<strong>Availability:</strong> <%= sStatus %>
											</div>
										</td>
									</tr>
								</table>
							</td>
							<td align="right"><%= CurrencyFormat(sPrice, 2) %></td>
							<td align="center"><%= sQty %></td>
							<td align="right"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
						</tr>
								<%
							End If

							sName	= oBasket("ProductName")
							sSKU	= oBasket("ProductSKU")
							sStatus	= oBasket("ProductStatusName")
							sPrice	= oBasket("ProductPrice")
							sQty	= oBasket("BasketQuantity")
							sLink	= BuildFriendlyDetailURL(oBasket("ProductName"), oBasket("ProductID"))
							%>
						<tr valign="top" style="background: #fff">
							<td align="left">
								<table width="100%" cellpadding="0" cellspacing="0" border="0">
									<tr valign="top">
										<td width="100">
											<a href="<%= sLink %>" target="_blank"><img src="<%= GetProductImageSrc(oBasket("ProductImage"), "mini") %>"
													width="<%= C_PRODUCT_IMAGE_MINI_WIDTH %>" height="<%= C_PRODUCT_IMAGE_MINI_HEIGHT %>"
													alt="<%= oBasket("ProductName") %>"/></a>
										</td>
										<td>
											<a href="<%= sLink %>" target="_blank"><strong><%= oBasket("ProductName") %></strong></a>
							<%
						ElseIf iDisplayType = 2 Then
							%>
							<% If iKitCounter = 0 Then %>
											<div style="padding: 10px 0 0 5px">
												<strong>Kit Items:</strong>
												<ul class="kit-items">
							<% End If %>
													<li><%= oBasket("ProductName") %></li>
							<%
						ElseIf iDisplayType = 3 Then
							%>
							<% If iGiftCounter = 0 Then %>
								<% If iKitCounter <> 0 Then %>
								</ul>
								</div>
								<% End If %>
											<div style="padding: 10px 0 0 5px">
												<strong>Free Items:</strong>
												<ul class="gift-items">
							<% End If %>
													<li><%= oBasket("ProductName") %></li>
							<%
						End If

						Select Case iDisplayType
							Case 0
								iProductCounter = iProductCounter + 1
								iKitCounter = 0
								iGiftCounter = 0
							Case 1
								iProductCounter = iProductCounter + 1
								iKitCounter = 0
								iGiftCounter = 0
							Case 2
								iKitCounter = iKitCounter + 1
							Case 3
								iGiftCounter = iGiftCounter + 1
						End Select

						fSubTotal = fSubTotal + CCur(oBasket("ProductPrice")) * CCur(oBasket("BasketQuantity"))
						oBasket.MoveNext
					Wend
					fTax = (fSubTotal - fPromoDiscount) / 100 * fTaxRate

					oBasket.Close
					Set oBasket = Nothing
					%>
											<% If iKitCounter > 0 Or iGiftCounter > 0 Then %>
												</ul>
											</div>
											<% End If %>
											<div style="padding: 10px 0 0 5px">
												<strong>SKU:</strong> <%= sSKU %><br/>
												<strong>Availability:</strong> <%= sStatus %>
											</div>
										</td>
									</tr>
								</table>
							</td>
							<td align="right"><%= CurrencyFormat(sPrice, 2) %></td>
							<td align="center"><%= sQty %></td>
							<td align="right"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
						</tr>
					</table>

					<div align="right">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td align="right" style="padding-top: 5px">
									<strong>Sub Total:</strong>
									&nbsp;&nbsp;&nbsp;
									<%= CurrencyFormat(fSubTotal, 2) %>
								</td>
							</tr>
							<tr>
								<td align="right" style="padding-top: 5px">
									<strong>Shipping (<%= sShippingName %>):</strong>
									&nbsp;&nbsp;&nbsp;
									<%= CurrencyFormat(fShipping, 2) %>
								</td>
							</tr>
							<tr>
								<td align="right" style="padding-top: 5px">
									<strong>Promo Code (<%= PromoCode %>):</strong>
									&nbsp;&nbsp;&nbsp;
									<%= CurrencyFormat(0 - fPromoDiscount, 2) %>
								</td>
							</tr>
							<tr>
								<td align="right" style="padding-top: 5px">
									<strong>Tax:</strong>
									&nbsp;&nbsp;&nbsp;
									<%= CurrencyFormat(fTax, 2) %>
								</td>
							</tr>
							<tr>
								<td align="right" style="padding-top: 5px">
									<strong>Grand Total:</strong>
									&nbsp;&nbsp;&nbsp;
									<%= CurrencyFormat(fSubTotal + fShipping - fPromoDiscount + fTax, 2) %>
								</td>
							</tr>
						</table>
					</div>
					<br/>
					<br/>

					<div style="padding-left: 4px">
						<input type="button" value="Back" onclick="makeAction('Prev')"/>
						&nbsp;&nbsp;&nbsp;
						<input type="button" value="Place Order" onclick="makeAction('Next')"/>
					</div>
				</form>
			</div>
		</div>
		<!--#include file="inc/BottomFrontend.asp"-->
		<script type="text/javascript">
		function makeAction(direction) {
			$('#Direction').val(direction);
			$('#CheckoutStep3').submit();
		}
		</script>
	</body>
</html>
