<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iProductID, oProduct
	Dim iCategoryID, iCategoryParentID, sCategoryName, sCategoryPath

	sQuery = "SELECT p.*" &_
			 "	   , ps.ProductStatusName" &_
			 "	   , c.CategoryID" &_
			 "	   , c.ParentID AS CategoryParentID" &_
			 "	   , c.CategoryName" &_
			 "	   , c.CategoryLink" &_
			 "	   , c.CategoryPath" &_
			 "	   , m.ManufacturerName" &_
			 "	   , (SELECT ISNULL(MIN(ShippingFirstItemPrice), 0) FROM utb_Shippings WHERE ShippingIsAvailable = 1 AND ShippingLevelID = sl.ShippingLevelID) AS ShippingFirstItemPrice " &_
			 "	FROM utb_Products AS p" &_
			 "		 INNER JOIN utb_ProductStatuses		AS ps	ON ps.ProductStatusID = p.ProductStatusID" &_
			 "		 INNER JOIN utb_ShippingLevels		AS sl	ON sl.ShippingLevelID = p.ShippingLevelID" &_
			 "		 INNER JOIN utb_ProductCategories	AS pcat	ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1" &_
			 "		 INNER JOIN utb_Categories			AS c	ON c.CategoryID = pcat.CategoryID" &_
			 "		 INNER JOIN utb_Manufacturers		AS m	ON m.ManufacturerID = p.ManufacturerID" &_
			 " WHERE p.ProductStatusID > 0" &_
			 "	 AND p.ProductLink = '" & Quote(Request("Link")) & "'"

	Set oProduct = oConn.Execute(sQuery)
	If Not oProduct.Eof Then
		iProductID = oProduct("ProductID")
		iCategoryID = oProduct("CategoryID")
		sCategoryName = oProduct("CategoryName")
		sCategoryPath = oProduct("CategoryPath")
		iCategoryParentID = oProduct("CategoryParentID")

		If oProduct("ProductMetaTitle") <> "" Then
			sPageTitle = oProduct("ProductMetaTitle")
		End If
		If oProduct("ProductMetaKey") <> "" Then
			sPageKeywords = oProduct("ProductMetaKey")
		End If
		If oProduct("ProductMetaDescription") <> "" Then
			sPageDescription = oProduct("ProductMetaDescription")
		End If
	Else
		Redirect(GetLink(""))
	End If

	Dim sImgLargePath, sImgSmallExtraPath, sImgLargeExtraPath
	sImgLargePath		= C_PRODUCT_IMAGE_LARGE_PATH & "/"
	sImgSmallExtraPath	= C_PRODUCT_EXTRA_IMAGE_SMALL_PATH & "/"
	sImgLargeExtraPath	= C_PRODUCT_EXTRA_IMAGE_LARGE_PATH & "/"

	Dim sImgSmall
	sImgSmall = GetProductImage(oProduct("ProductName"), oProduct("ProductImage"), "medium")

	Dim sPrintLink
	sPrintLink = "Print.asp?Link=" & Text2Url(oProduct("ProductName"))

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<meta name="robots" content="noindex,follow">
		<!--#include file="inc/HeaderFrontend.asp"-->
		<style type="text/css">@media print{.print {display: none}}</style>
	</head>
	<body>
		<div class="wrapper" style="width: 773px">
			<div class="page-header" style="padding-bottom: 1em">
				<div class="search-n-call" style="padding-top: 62px">
					<div class="call">Call us: <strong><%= C_DOMAIN_PHONE %></strong></div>
				</div>

				<h1 id="logo"><strong>GibsonMedicalOutlet.com</strong><a href="<%= GetLink("") %>" title="over 3000 satisfied professionals" class="logo"><img src="<%= GetMediaUrl("images/logo.png") %>" alt="<%= C_DEFAULT_TITLE %>"/></a></h1>
				<div class="cleaner"></div>
			</div>

			<div class="block-clear details-wrap">
				<h1><%= HTMLEncode(oProduct("ProductName")) %></h1>
				<div class="detail-image-wrap">
					<% If Not IsNull(oProduct("ProductImage")) And oProduct("ProductImage") <> "" Then %>
					<a class="detail-image"><%= sImgSmall %></a>
					<% End If %>
					<%
					If Not IsNull(oProduct("ProductOrigin")) Then
						%>
						<div style="padding-top: 10px">The origin of this product is Europe <img src="<%= GetMediaUrl("images/origin/" & oProduct("ProductOrigin") & ".png") %>" alt="Europe" align="absmiddle"/></div>
						<%
					End If
					%>
				</div>
				<div class="description">
					<p><%= HTMLEncode(oProduct("ProductPunchLine")) %></p>
					<table class="options">
						<tr><td>Sku:</td><td class="value"><%= oProduct("ProductSKU") %></td></tr>
						<%
						Dim iCounter, arInfoNV
						For iCounter = 1 To 5
							If Not IsNull(oProduct("ProductInfoNameValue" & iCounter)) Then
								arInfoNV = Split(oProduct("ProductInfoNameValue" & iCounter), "|")
								%>
								<tr><td><%= HTMLEncode(arInfoNV(0)) %>:</td><td class="value"><%= HTMLEncode(arInfoNV(1)) %></td></tr>
								<%
							End If
						Next
						%>
						<tr><td>Manufacturer:</td><td class="value"><%= oProduct("ManufacturerName") %></td></tr>
					</table>
					<% If oProduct("ProductStatusID") > 1 Then %>
					<table class="options">
						<tr><td>Available:</td><td>Usually Ships in 1 to 2 Business Days</td></tr>
					</table>
					<% End If %>

					<%
					iCounter = 0
					Set oQuery = oConn.Execute("SELECT * FROM utb_ProductPrices WHERE ProductID = " & iProductID & " ORDER BY ProductPriceID")
					If Not oQuery.Eof Then
						%>
						<table class="prices">
							<tr><th>Quantity</th><th>Price</th></tr>
							<%
							While Not oQuery.Eof
								%>
								<tr<%= InvertColor(iCounter, " class='alt'", "") %>>
									<td><%= oQuery("ProductPriceQtyFrom") & IIF(IsNull(oQuery("ProductPriceQtyTo")), " and more", " - " & oQuery("ProductPriceQtyTo")) %> unit(s)</td>
									<td><strong class="price"><%= DecimalFormat(oQuery("ProductPriceAmount"), 2) %> USD</strong></td>
								</tr>
								<%
								oQuery.MoveNext
							Wend
							%>
						</table>
						<%
					End If
					oQuery.Close
					Set oQuery = Nothing
					%>
				</div>
				<div class="cleaner"></div>
			</div>

			<% If (Not IsNull(oProduct("ProductDescription")) And oProduct("ProductDescription") <> "") Then %>
			<div class="article">
				<h1>Product Description</h1>
				<%= oProduct("ProductDescription") %>
			</div>
			<% End If %>

			<% If (Not IsNull(oProduct("ProductSpecification")) And oProduct("ProductSpecification") <> "") Then %>
			<div class="article">
				<h1>Product Specification</h1>
				<%= oProduct("ProductSpecification") %>
			</div>
			<% End If %>
			<div class="copyright">Copyring &copy; <%= Year(Date) %> GibsonMedicalOutlet.com All Rights reserved. Trademarks listed on our pages belong to their designated owner(s).</div>
		</div>
		<br/>
		<br/>
		<div align="center" class="print"><input type="button" style="padding: 1px 5px" value="Print" onclick="return printPage()"/></div>
		<br/>
		<br/>
		<script type="text/javascript">
		function printPage(){
			window.print();
			return false;
		}
		</script>
	</body>
</html>
<%
	oProduct.Close
	Set oProduct = Nothing
%>