﻿<!--#include file="inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsFrontend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iProductID, oProduct
	Dim iCategoryID, iCategoryParentID, sCategoryName, sCategoryPath

	sQuery = "SELECT p.*" &_
			 "	   , ps.ProductStatusName" &_
			 "	   , c.CategoryID" &_
			 "	   , c.ParentID AS CategoryParentID" &_
			 "	   , c.CategoryName" &_
			 "	   , c.CategoryLink" &_
			 "	   , c.CategoryPath" &_
			 "	   , m.ManufacturerName" &_
			 "	   , (SELECT ISNULL(MIN(ShippingFirstItemPrice), 0) FROM utb_Shippings WHERE ShippingIsAvailable = 1 AND ShippingLevelID = sl.ShippingLevelID) AS ShippingFirstItemPrice " &_
			 "	FROM utb_Products AS p" &_
			 "		 INNER JOIN utb_ProductStatuses		AS ps	ON ps.ProductStatusID = p.ProductStatusID" &_
			 "		 INNER JOIN utb_ShippingLevels		AS sl	ON sl.ShippingLevelID = p.ShippingLevelID" &_
			 "		 INNER JOIN utb_ProductCategories	AS pcat	ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1" &_
			 "		 INNER JOIN utb_Categories			AS c	ON c.CategoryID = pcat.CategoryID" &_
			 "		 INNER JOIN utb_Manufacturers		AS m	ON m.ManufacturerID = p.ManufacturerID" &_
			 " WHERE p.ProductStatusID > 0" &_
			 "	 AND p.ProductLink = '" & Quote(Request("Link")) & "'"

	Set oProduct = oConn.Execute(sQuery)
	If Not oProduct.Eof Then
		iProductID = oProduct("ProductID")
		iCategoryID = oProduct("CategoryID")
		sCategoryName = oProduct("CategoryName")
		sCategoryPath = oProduct("CategoryPath")
		iCategoryParentID = oProduct("CategoryParentID")

		If oProduct("ProductMetaTitle") <> "" Then
			sPageTitle = oProduct("ProductMetaTitle")
		End If
		If oProduct("ProductMetaKey") <> "" Then
			sPageKeywords = oProduct("ProductMetaKey")
		End If
		If oProduct("ProductMetaDescription") <> "" Then
			sPageDescription = oProduct("ProductMetaDescription")
		End If
	Else
		Redirect(GetLink(""))
	End If

	Dim sImgLargePath, sImgSmallExtraPath, sImgLargeExtraPath
	sImgLargePath		= C_PRODUCT_IMAGE_LARGE_PATH & "/"
	sImgSmallExtraPath	= C_PRODUCT_EXTRA_IMAGE_SMALL_PATH & "/"
	sImgLargeExtraPath	= C_PRODUCT_EXTRA_IMAGE_LARGE_PATH & "/"

	Dim sImgSmall
	sImgSmall = GetProductImage(oProduct("ProductName"), oProduct("ProductImage"), "medium")

	Dim sPrintLink
	sPrintLink = "Print.asp?Link=" & Text2Url(oProduct("ProductName"))

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderFrontend.asp"-->
		<link rel="stylesheet" type="text/css" href="<%= GetMediaUrl("css/default/jquery.bubble.css") %>"/>
		<link rel="stylesheet" type="text/css" href="<%= GetMediaUrl("css/default/highslide.css") %>"/>
		<script type="text/javascript" src="<%= GetMediaUrl("js/default/highslide.js") %>"></script>
		<script type="text/javascript">
		hs.useBox = true;
		hs.width = <%= C_PRODUCT_IMAGE_LARGE_WIDTH %>;
		hs.height = <%= C_PRODUCT_IMAGE_LARGE_HEIGHT %>;
		hs.graphicsDir = '<%= GetMediaUrl("images/default/highslide/") %>';
		hs.align = 'center';
		hs.transitions = ['expand', 'crossfade'];
		hs.outlineType = 'rounded-white';
		hs.fadeInOut = true;
		hs.showCredits = false;
		hs.allowMultipleInstances = false;
		hs.numberPosition = 'caption';
		hs.addSlideshow({
			interval: 5000,
			repeat: false,
			useControls: true,
			fixedControls: 'fit',
			overlayOptions: {
				opacity: 0.75,
				position: 'bottom center',
				hideOnMouseOut: true
			}
		});
		</script>
	</head>
	<body>
		<!--#include file="inc/TopFrontend.asp"-->
		<!--#include file="inc/BreadCrumbs.asp"-->
		<div class="block-clear details-wrap">
        	<h2><%= HTMLEncode(oProduct("ProductName")) %></h2>
            <div class="detail-image-wrap">
				<% If Not IsNull(oProduct("ProductImage")) And oProduct("ProductImage") <> "" Then %>
            	<a class="detail-image" title="Click to enlarge" href="<%= sImgLargePath & oProduct("ProductImage") %>" onclick="return hs.expand(this)"><%= sImgSmall %></a>
            	<a class="enlarge" href="#enlarge" onclick="$('.detail-image').trigger('click'); return false">Enlarge</a>
				<% Else %>
				<a class="detail-image" onclick="return false"><%= sImgSmall %></a>
				<% End If %>
				<%
				Dim iCounter
				Set oQuery = oConn.Execute("SELECT ProductImageName FROM utb_ProductImages WHERE ProductID = " & iProductID & " ORDER BY ProductImageSortOrder")
				If Not oQuery.Eof Then
					%><ul class="thumbs"><%
					While Not oQuery.Eof
						%>
						<li<%= IIF(iCounter > 3, " style='display: none'", "") %>><a href="<%= sImgLargeExtraPath & oQuery("ProductImageName") %>" class="thumb" onclick="return hs.expand(this)"><img src="<%= sImgSmallExtraPath & oQuery("ProductImageName") %>" alt="" /></a></li>
						<%
						iCounter = iCounter + 1
						oQuery.MoveNext
					Wend
					%></ul><%
				End If
				oQuery.Close
				Set oQuery = Nothing
				%>
				<%
				If Not IsNull(oProduct("ProductOrigin")) Then
					%>
					<div style="padding-top: 10px">The origin of this product is Europe <img src="<%= GetMediaUrl("images/origin/" & oProduct("ProductOrigin") & ".png") %>" alt="Europe" align="absmiddle"/></div>
					<%
				End If
				%>
            </div>
            <div class="description">
            	<p><%= HTMLEncode(oProduct("ProductPunchLine")) %></p>
                <table class="options">
		<%
			'<tr><td>Sku:</td><td class="value"><%= oProduct("ProductSKU") %></td></tr>
					<%
					Dim arInfoNV
					For iCounter = 1 To 5
						If Not IsNull(oProduct("ProductInfoNameValue" & iCounter)) Then
							arInfoNV = Split(oProduct("ProductInfoNameValue" & iCounter), "|")
							%>
							<tr><td><%= HTMLEncode(arInfoNV(0)) %>:</td><td class="value"><%= HTMLEncode(arInfoNV(1)) %></td></tr>
							<%
						End If
					Next
					%>
                	<tr><td>Manufacturer:</td><td class="value"><%= oProduct("ManufacturerName") %></td></tr>
                </table>
				<% If oProduct("ProductStatusID") = 2 Then %>
                <table class="options">
                	<tr><td>Available:</td><td>Usually Ships in 1 to 2 Business Days</td></tr>
                </table>
				<% End If %>

				<%
				iCounter = 0
				Set oQuery = oConn.Execute("SELECT * FROM utb_ProductPrices WHERE ProductID = " & iProductID & " ORDER BY ProductPriceID")
				If Not oQuery.Eof Then
					%>
					<table class="prices">
						<tr><th>Quantity</th><th>Price</th></tr>
						<%
						While Not oQuery.Eof
							%>
							<tr<%= InvertColor(iCounter, " class='alt'", "") %>>
								<td><%= oQuery("ProductPriceQtyFrom") & IIF(IsNull(oQuery("ProductPriceQtyTo")), " and more", " - " & oQuery("ProductPriceQtyTo")) %> packs(s)</td>
								<td><strong class="price"><%= DecimalFormat(oQuery("ProductPriceAmount"), 2) %> USD</strong></td>
							</tr>
							<%
							oQuery.MoveNext
						Wend
						%>
					</table>
					<%
				End If
				oQuery.Close
				Set oQuery = Nothing

				Dim sBuyNowImage, sBuyNowText
				Select Case CInt(oProduct("ProductStatusID"))
					Case 3
						sBuyNowImage = "preorder.png"
						sBuyNowText = "Preorder"
					Case 4
						sBuyNowImage = "backorder.png"
						sBuyNowText = "Backorder"
					Case Else
						sBuyNowImage = "add2cart.png"
						sBuyNowText = "Add to cart"
				End Select
				%>
                <table class="buy-section">
                	<tr>
						<% If CInt(oProduct("ProductStatusID")) = 1 Then %>
						<td style="width: 56px">&nbsp;</td>
						<td><img src="<%= GetMediaUrl("images/buttons/notinstock.png") %>" alt="Not In Stock"/></td>
						<% Else %>
                    	<td><input type="text" name="Qty" id="Qty" class="quantity-field" value="1" maxlength="3"/></td>
                    	<td><a href="#" title="Add <%= HTMLEncode(oProduct("ProductName")) %> to cart" class="add2cart" id="p-<%= iProductID %>"><img src="<%= GetMediaUrl("images/buttons/" & sBuyNowImage) %>" alt="<%= sBuyNowText %>"/></a></td>
						<% End If %>
						<% If CInt(oProduct("ShippingFirstItemPrice")) = 0 Then %>
                    	<td style="padding-right: 0">
							<img src="<%= GetMediaUrl("images/banners/free-shipping.png") %>" alt="" class="free-shipping"/>
							<script type="text/javascript">//<![CDATA[
							$(function(){
								$('.free-shipping').CreateBubblePopup({
									themePath: '<%= GetMediaUrl("images/default/jquery-bubble/") %>',
									innerHtml: '<%= Replace(Replace(GetInfoSection(4), VbNewLine, ""), "'", "\'") %>',
									position: 'left',
									align: 'middle',
									width: '300px',
									innerHtmlStyle: {'text-align': 'left'}
								});
							});
							//]]></script>
						</td>
						<% End If %>
                    </tr>
                </table>
				<%
				%>
                <ul class="aux-links">
                	<li><a href="#" class="add2wish" id="w-<%= iProductID %>"><img src="<%= GetMediaUrl("images/icons/wish.png") %>" alt=""/> Add to wishlist</a></li>
                	<li><a href="#" id="ask-a-ques"><img src="<%= GetMediaUrl("images/icons/ask.png") %>" alt=""/> Ask question</a></li>
                	<li><a href="#" id="email-to-f"><img src="<%= GetMediaUrl("images/icons/email.png") %>" alt=""/> E-mail to a friend</a></li>
                	<li><a href="<%= sPrintLink %>"><img src="<%= GetMediaUrl("images/icons/print.png") %>" alt=""/> Print</a></li>
                </ul>
                <div class="bookmarks">
					<table>
						<tr>
							<td><div class="fb-like" data-send="false" data-layout="button_count" data-width="100" data-show-faces="false"></div></td>
							<td><a href="https://twitter.com/share" class="twitter-share-button">Tweet</a></td>
						</tr>
					</table>
                	<!--<img src="<%= GetMediaUrl("images/bookmarks.png") %>" alt="" />-->
                </div>
            </div>
            <div class="cleaner"></div>
		</div>

		<% If (Not IsNull(oProduct("ProductDescription")) And oProduct("ProductDescription") <> "") Then %>
		<div class="article">
            <h2>Product Description</h2>
            <%= oProduct("ProductDescription") %>
        </div>
		<% End If %>

		<% If (Not IsNull(oProduct("ProductSpecification")) And oProduct("ProductSpecification") <> "") Then %>
    	<div class="article">
            <h2>Product Specifications</h2>
            <%= oProduct("ProductSpecification") %>
        </div>
		<% End If %>

		<%
		Dim sProductUrl, sProductImg
		sQuery = "SELECT TOP 3 p.ProductID" &_
				 "	   , p.ProductName" &_
				 "	   , p.ProductImage" &_
				 "	   , p.ProductPrice" &_
				 "	   , p.ProductMSRP" &_
				 "	   , p.ProductStatusID" &_
				 "	   , ps.ProductStatusName" &_
				 "	FROM utb_Products AS p" &_
				 "		 INNER JOIN utb_ProductCategories AS pc ON pc.ProductID = p.ProductID AND pc.ProductCategoryIsMain = 1" &_
				 "		 INNER JOIN utb_ProductStatuses AS ps ON ps.ProductStatusID = p.ProductStatusID" &_
				 " WHERE p.ProductStatusID > 0" &_
				 "	 AND p.ProductID <> " & iProductID &_
				 "	 AND pc.CategoryID = " & iCategoryID

		Set oQuery = oConn.Execute(sQuery)
		If Not oQuery.Eof Then
			%>
			<div class="products">
				<h2>Related Products</h2>
				<ul class="items-list">
				<%
				While Not oQuery.Eof
					'sProductUrl = BuildFriendlyDetailURL(oQuery("ProductName"), oQuery("ProductID"))
                    sProductUrl = "/Product/" & Text2Url(oQuery("ProductName")) & ".htm"
					sProductImg = GetProductImage(oQuery("ProductName"), oQuery("ProductImage"), "small")
					%>
					<li>
						<a href="<%= sProductUrl %>" class="item-img"><%= sProductImg %></a>
						<h3 class="item-name"><a href="<%= sProductUrl %>"><%= HTMLEncode(oQuery("ProductName")) %></a></h3>
						<div class="item-retail">
						<% If CCur(oQuery("ProductMSRP")) > 0 Then %>
						Retail price: <span><%= CurrencyFormat(oQuery("ProductMSRP"), 2) %></span>
						<% Else %>
						&nbsp;
						<% End If %>
						</div>
						<div class="item-price">Our Price: <strong class="price"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></strong></div>
						<a class="item-btn-more" href="<%= sProductUrl %>">More info</a>
					</li>
					<%
					oQuery.MoveNext
				Wend
				%>
				</ul>
			</div>
			<%
		End If
		oQuery.Close
		Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomFrontend.asp"-->
		<!--#include file="inc/ProductWindows.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		var pid = <%= iProductID %>,
			cid = <%= GetCustomerID() %>;
		//]]>
		</script>
		<script type="text/javascript" src="<%= GetMediaUrl("js/default/jquery.fav.js") %>"></script>
		<script type="text/javascript" src="<%= GetMediaUrl("js/default/jquery.bubble.js") %>"></script>
		<script type="text/javascript" src="<%= GetMediaUrl("js/default/product.js") %>"></script>
		<div id="fb-root"></div>
		<script>(function(d,s,id){var js, fjs = d.getElementsByTagName(s)[0];if (d.getElementById(id)) return;js = d.createElement(s); js.id = id;js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";fjs.parentNode.insertBefore(js, fjs);}(document, 'script', 'facebook-jssdk'));</script>
		<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>
	</body>
</html>
<%
	oProduct.Close
	Set oProduct = Nothing
%>