﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/CommonsFrontend.asp"-->
<!--#include file="../inc/JSON.asp"-->
<%
	Dim oJSONOut
	Set oJSONOut = jsObject()

	Dim oConn, sQuery, oQuery, oWQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iProductID : iProductID = IIF(ValidateInteger(Request("ProductID")), Request("ProductID"), 0)
	Dim iQuantity : iQuantity = IIF(ValidateInteger(Request("Qty")), Request("Qty"), 1)
	Dim sProductName, sProductSKU, fProductPrice, sProductLink, sProductImage

	sQuery = "SELECT p.ProductName" &_
			 "	   , p.ProductSKU" &_
			 "	   , ISNULL(pp.ProductPriceAmount, p.ProductPrice) AS ProductPrice" &_
			 "	   , p.ProductImage" &_
			 "	FROM utb_Products AS p" &_
			 "		 LEFT JOIN utb_ProductPrices AS pp ON pp.ProductID = p.ProductID AND pp.ProductPriceQtyFrom <= " & iQuantity & " AND ISNULL(pp.ProductPriceQtyTo, 999999) >= " & iQuantity &_
			 " WHERE p.ProductID = " & iProductID &_
			 "	 AND p.ProductStatusID > 1"

	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		sProductName	= oQuery("ProductName")
		sProductSKU		= oQuery("ProductSKU")
		fProductPrice	= oQuery("ProductPrice")
		sProductLink	= BuildFriendlyDetailURL(sProductName, iProductID)
		sProductImage	= GetProductImageSrc(oQuery("ProductImage"), "mini")
	End If
	oQuery.Close
	Set oQuery = Nothing

	If sProductLink = "" Then
		oJSONOut("success") = False
		oJSONOut("message") = "Product not found"
		oJSONOut.Flush
		Response.End
	End If

	oConn.BeginTrans
	On Error Resume Next

	sQuery = " EXEC usp_BasketAdd" &_
			 "		@BasketCustomerID = " & GetBasketCustomerID() &_
			 "	  , @BasketQuantity = " & iQuantity &_
			 "	  , @ProductID = " & iProductID
	oConn.Execute(sQuery)

	If Err.Number <> 0 Then
		oConn.RollbackTrans

		oJSONOut("success") = False
		oJSONOut("message") = "An error occurred, please try again later"
		oJSONOut.Flush
		Response.End
	End If

	oConn.CommitTrans

	Dim iBasketItemsCount, fBasketTotalPrice
	Call GetBasketTotals()
	oJSONOut("success") = True
	oJSONOut("count") = iBasketItemsCount
	oJSONOut("amount") = CurrencyFormat(fBasketTotalPrice, 2)

	Set oJSONOut("product")	= jsObject()
	oJSONOut("product")("link")		= sProductLink
	oJSONOut("product")("imgsrc")	= sProductImage
	oJSONOut("product")("imgsrcwidth")	= C_PRODUCT_IMAGE_MINI_WIDTH
	oJSONOut("product")("imgsrcheight")	= C_PRODUCT_IMAGE_MINI_HEIGHT
	oJSONOut("product")("name")		= sProductName
	oJSONOut("product")("sku")		= sProductSKU
	oJSONOut("product")("price")	= CurrencyFormat(fProductPrice, 2)

	oJSONOut.Flush
%>