﻿/*
Copyright (c) 2003-2012, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.editorConfig = function( config )
{
	// Define changes to default configuration here. For example:
	// config.language = 'fr';
	// config.uiColor = '#AADC6E';

	config.removePlugins = 'elementspath';
	config.language = 'en';
	config.resize_enabled = false;
	config.toolbarCanCollapse = false;
	config.contentsCss = '../css/style.css';
	config.toolbar = 'MyToolbar';
	config.toolbar_MyToolbar = [
		{ name: 'document', items : [ 'Source','-','PasteFromWord','PasteText','Paste','-','Undo','Redo'] },
		{ name: 'links', items : [ 'Link','Unlink','Anchor', 'Image','Flash','Table','HorizontalRule','SpecialChar','PageBreak', 'ShowBlocks', 'Maximize'] },
		'/',
		{ name: 'styles1', items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript', '-', 'TextColor','BGColor', '-', 'NumberedList','BulletedList','-','Outdent','Indent','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','-','BidiLtr','BidiRtl'] },
		{ name: 'styles2', items : ['Styles','Format','Font','FontSize' ] }
	];
};


/* http://docs.cksource.com/CKEditor_3.x/Howto/FCKeditor_HTML_Output */
CKEDITOR.on( 'instanceReady', function( ev )
{
	var writer = ev.editor.dataProcessor.writer; 
	// The character sequence to use for every indentation step.
	writer.indentationChars = '    ';
 
	var dtd = CKEDITOR.dtd;
	// Elements taken as an example are: block-level elements (div or p), list items (li, dd), and table elements (td, tbody).
	for ( var e in CKEDITOR.tools.extend( {}, dtd.$block, dtd.$listItem, dtd.$tableContent ) )
	{
		ev.editor.dataProcessor.writer.setRules( e, {
			// Indicates that an element creates indentation on line breaks that it contains.
			indent : false,
			// Inserts a line break before a tag.
			breakBeforeOpen : true,
			// Inserts a line break after a tag.
			breakAfterOpen : false,
			// Inserts a line break before the closing tag.
			breakBeforeClose : false,
			// Inserts a line break after the closing tag.
			breakAfterClose : true
		});
	}
 
	for ( var e in CKEDITOR.tools.extend( {}, dtd.$list, dtd.$listItem, dtd.$tableContent ) )
	{
		ev.editor.dataProcessor.writer.setRules( e, {			
			indent : true,
		});
	}
 
	// You can also apply the rules to a single element.
	ev.editor.dataProcessor.writer.setRules( 'table',
	{ 		
		indent : true
	});	
 
	ev.editor.dataProcessor.writer.setRules( 'form',
	{ 		
		indent : true
	});		
});
