<%

' Conversion of Visual Basic code to VBScript code 
' First published on <www.di-mgt.com.au/crypto.html> 2 February 2002

' basByteUtils: Misc byte utilities

'************************* COPYRIGHT NOTICE*************************
' This code was originally written in Visual Basic by David Ireland
' and is copyright (c) 2000-2 D.I. Management Services Pty Limited,
' all rights reserved.

' You are free to use this code as part of your own applications
' provided you keep this copyright notice intact and acknowledge
' its authorship with the words:

'   "Contains cryptography software by David Ireland of
'   DI Management Services Pty Ltd <www.di-mgt.com.au>."

' This code may only be used as part of an application. It may
' not be reproduced or distributed separately by any means without
' the express written permission of the author.

' David Ireland and DI Management Services Pty Limited make no
' representations concerning either the merchantability of this
' software or the suitability of this software for any particular
' purpose. It is provided "as is" without express or implied
' warranty of any kind.

' Please forward comments or bug reports to <code@di-mgt.com.au>.
' The latest version of this source code can be downloaded from
' www.di-mgt.com.au/crypto.html.
'****************** END OF COPYRIGHT NOTICE*************************


Public Function bu_HexStr2Bytes(str, aBytes())
' Converts string <str> with hex values into array of bytes
' Returns # of bytes converted
' Assumes array is large enough
' E.g. "fedcba98" will be converted into (&HFE, &HDC, &HBA, &H98)

    Dim i, nBytes
    nBytes = Len(str) \ 2
    For i = 0 To nBytes - 1
        aBytes(i) = CByte("&H" & Mid(str, i * 2 + 1, 2))
    Next

    bu_HexStr2Bytes = nBytes

End Function

Public Function bu_Bytes2HexStr(aBytes(), nBytes)
' Returns hex string from array of bytes
' E.g. {&HFE, &HDC, &HBA, &H98} will return "fedcba98"
    Dim strTemp

    strTemp = bu_Bytes2String(aBytes, nBytes)
    bu_Bytes2HexStr = bu_Str2Hex(strTemp)
End Function


Public Function bu_String2Bytes(str, aBytes())
' Converts string <str> directly into array of bytes
' String may contain any characters between &H00 and &HFF
' Returns # of bytes converted
' Assumes array is large enough
' E.g. "abc" will be converted to (&H61, &H62, &H63) i.e. (97, 98, 99)

    Dim i, nBytes
    nBytes = Len(str)
    For i = 0 To nBytes - 1
        aBytes(i) = Asc(Mid(str, i + 1, 1))
    Next

    bu_String2Bytes = nBytes

End Function

Public Function bu_Bytes2String(aBytes(), nBytes)
' Converts array of bytes, nBytes long, into a string
' E.g. (&H61, &H62, &H63) will be converted to "abc"

    Dim i, str
    For i = 0 To nBytes - 1
        str = str & Chr(aBytes(i))
    Next

    bu_Bytes2String = str

End Function

Public Function bu_Str2Hex(str)
' Converts string <str> of chars to string in hex byte format
' E.g. "abc" will be converted to "616263"
    sHex = ""

    n = Len(str)
    For i = 1 To n
        byt = CByte(Asc(Mid(str, i, 1)))
        If Len(Hex(byt)) = 1 Then
            sHex = sHex & "0" & Hex(byt)
        Else
            sHex = sHex & Hex(byt)
        End If
    Next
    bu_Str2Hex = sHex

End Function


%>