<%
	Dim CustomerID : CustomerID			= GetFormValue("CustomerID", 255)
	Dim CustomerEmail : CustomerEmail	= GetFormValue("CustomerEmail", 255)
	Dim CustomerNotes : CustomerNotes	= GetFormValue("CustomerNotes", 500)
	Dim PromoCode : PromoCode			= GetFormValue("PromoCode", 8)

	Dim CustomerProfName : CustomerProfName						= GetFormValue("CustomerProfName", 255)
	Dim CustomerProfType : CustomerProfType						= GetFormValue("CustomerProfType", 255)
	Dim CustomerDEANumber : CustomerDEANumber					= GetFormValue("CustomerDEANumber", 255)
	Dim CustomerProfLicense : CustomerProfLicense				= GetFormValue("CustomerProfLicense", 255)
	Dim CustomerIssuingAuthority : CustomerIssuingAuthority		= GetFormValue("CustomerIssuingAuthority", 255)
	Dim CustomerWebsite : CustomerWebsite						= GetFormValue("CustomerWebsite", 255)

	Dim CustomerBillingFirstName : CustomerBillingFirstName		= GetFormValue("CustomerBillingFirstName", 255)
	Dim CustomerBillingLastName : CustomerBillingLastName		= GetFormValue("CustomerBillingLastName", 255)
	Dim CustomerBillingCompanyName : CustomerBillingCompanyName	= GetFormValue("CustomerBillingCompanyName", 255)
	Dim CustomerBillingCountry : CustomerBillingCountry			= GetFormValue("CustomerBillingCountry", 2)
	Dim CustomerBillingAddress1 : CustomerBillingAddress1		= GetFormValue("CustomerBillingAddress1", 255)
	Dim CustomerBillingAddress2 : CustomerBillingAddress2		= GetFormValue("CustomerBillingAddress2", 100)
	Dim CustomerBillingCity : CustomerBillingCity				= GetFormValue("CustomerBillingCity", 100)
	Dim CustomerBillingState : CustomerBillingState				= GetFormValue("CustomerBillingState", 50)
	Dim CustomerBillingZip : CustomerBillingZip					= GetFormValue("CustomerBillingZip", 50)
	Dim CustomerBillingHomePhone : CustomerBillingHomePhone		= GetFormValue("CustomerBillingHomePhone", 20)
	Dim CustomerBillingAltPhone : CustomerBillingAltPhone		= GetFormValue("CustomerBillingAltPhone", 20)

	Dim CustomerShippingFirstName : CustomerShippingFirstName		= GetFormValue("CustomerShippingFirstName", 255)
	Dim CustomerShippingLastName : CustomerShippingLastName			= GetFormValue("CustomerShippingLastName", 255)
	Dim CustomerShippingCompanyName : CustomerShippingCompanyName	= GetFormValue("CustomerShippingCompanyName", 255)
	Dim CustomerShippingCountry : CustomerShippingCountry			= GetFormValue("CustomerShippingCountry", 2)
	Dim CustomerShippingAddress1 : CustomerShippingAddress1			= GetFormValue("CustomerShippingAddress1", 255)
	Dim CustomerShippingAddress2 : CustomerShippingAddress2			= GetFormValue("CustomerShippingAddress2", 100)
	Dim CustomerShippingCity : CustomerShippingCity					= GetFormValue("CustomerShippingCity", 100)
	Dim CustomerShippingState : CustomerShippingState				= GetFormValue("CustomerShippingState", 50)
	Dim CustomerShippingZip : CustomerShippingZip					= GetFormValue("CustomerShippingZip", 50)
	Dim CustomerShippingHomePhone : CustomerShippingHomePhone		= GetFormValue("CustomerShippingHomePhone", 20)
	Dim CustomerShippingAltPhone : CustomerShippingAltPhone			= GetFormValue("CustomerShippingAltPhone", 20)

	Dim PaymentTypeID : PaymentTypeID					= GetFormValue("PaymentTypeID", 10)
	Dim CreditCardNumber : CreditCardNumber				= GetFormValue("CreditCardNumber", 255)
	Dim CreditCardName : CreditCardName					= GetFormValue("CreditCardName", 255)
	Dim CreditCardExpMonth : CreditCardExpMonth			= GetFormValue("CreditCardExpMonth", 2)
	Dim CreditCardExpYear : CreditCardExpYear			= GetFormValue("CreditCardExpYear", 4)
	Dim CreditCardCVV : CreditCardCVV					= GetFormValue("CreditCardCVV", 4)
	Dim CheckAccountType : CheckAccountType				= GetFormValue("CheckAccountType", 255)
	Dim CheckNumber : CheckNumber						= GetFormValue("CheckNumber", 255)
	Dim CheckRoutingNumber : CheckRoutingNumber			= GetFormValue("CheckRoutingNumber", 255)
	Dim CheckBankAccountNumber : CheckBankAccountNumber	= GetFormValue("CheckBankAccountNumber", 255)
	Dim MoneyOrderNote : MoneyOrderNote					= GetFormValue("MoneyOrderNote", 255)
	Dim ShippingMethodID : ShippingMethodID				= GetFormValue("ShippingMethodID", 10)

	Sub CommonValidation(iStep)
		If iStep = 1 Or iStep = 3 Then
			If CustomerEmail = "" Then
				AddError("Field <strong>Email Address</strong> is required.")
			ElseIf Not ValidateEmail(CustomerEmail) Then
				AddError("Field <strong>Email Address</strong> is invalid.")
			ElseIf CLng(Decode(CustomerID)) > 0 Then
				If GetValueFromTable(oConn, "CustomerID", "utb_Customers", "WHERE CustomerEmail = '" & Quote(CustomerEmail) & "' AND CustomerID <> '" & Decode(CustomerID) & "'") <> "" Then
					AddError("Customer with email <strong>" & CustomerEmail & "</strong> already exist in database.")
				End If
			End If

			If CustomerProfName = "" Then
				AddError("Field <strong>Medical Professional Name</strong> is required.")
			End If
			If CustomerProfLicense = "" Then
				AddError("Field <strong>Medical Professional License Number</strong> is required.")
			End If
			If CustomerIssuingAuthority = "" Then
				AddError("Field <strong>Medical License Issuing Authority</strong> is required.")
			End If

			If CustomerBillingFirstName = "" Then
				AddError("Field <strong>Billing First Name</strong> is required.")
			End If
			If CustomerBillingLastName = "" Then
				AddError("Field <strong>Billing Last Name</strong> is required.")
			End If
			If CustomerBillingCountry = "" Then
				AddError("Field <strong>Billing Country</strong> is required.")
			End If
			If CustomerBillingAddress1 = "" Then
				AddError("Field <strong>Billing Address 1</strong> is required.")
			End If
			If CustomerBillingCity = "" Then
				AddError("Field <strong>Billing City</strong> is required.")
			End If
			If CustomerBillingState = "" Then
				AddError("Field <strong>Billing State</strong> is required.")
			End If
			If CustomerBillingZip = "" Then
				AddError("Field <strong>Billing Zip</strong> is required.")
			End If
			If CustomerBillingHomePhone = "" Then
				AddError("Field <strong>Billing Home Phone</strong> is required.")
			End If

			If CustomerShippingFirstName = "" Then
				AddError("Field <strong>Delivery First Name</strong> is required.")
			End If
			If CustomerShippingLastName = "" Then
				AddError("Field <strong>Delivery Last Name</strong> is required.")
			End If
			If CustomerShippingCountry = "" Then
				AddError("Field <strong>Delivery Country</strong> is required.")
			End If
			If CustomerShippingAddress1 = "" Then
				AddError("Field <strong>Delivery Address 1</strong> is required.")
			End If
			If CustomerShippingCity = "" Then
				AddError("Field <strong>Delivery City</strong> is required.")
			End If
			If CustomerShippingState = "" Then
				AddError("Field <strong>Delivery State</strong> is required.")
			End If
			If CustomerShippingZip = "" Then
				AddError("Field <strong>Delivery Zip</strong> is required.")
			End If
			If CustomerShippingHomePhone = "" Then
				AddError("Field <strong>Delivery Home Phone</strong> is required.")
			End If
		End If

		If iStep = 2 Or iStep = 3 Then
			If PaymentTypeID = "" Then
				AddError("Field <strong>Payment Type</strong> is required.")
			End If

			If (GetIndex(PaymentTypeID, Split("1,2,3,4", ",")) <> -1) Then
				If CreditCardNumber = "" Then
					AddError("Field <strong>Card Number</strong> is required.")
				ElseIf Not ValidateCardNumber(CreditCardNumber) Then
					AddError("Field <strong>Card Number</strong> is invalid.")
				Else
					Dim sCardT
					Select Case PaymentTypeID
						Case "1"
							sCardT = "visa"
						Case "2"
							sCardT = "mastercard"
						Case "3"
							sCardT = "discover"
						Case "4"
							sCardT = "americanexpress"
					End Select
					If Not IsCreditCard(sCardT, CreditCardNumber) Then
						AddError("<strong>" & CreditCardNumber & "</strong> is invalid Card Number.")
					End If
				End If
				If CreditCardName = "" Then
					AddError("Field <strong>Name on Card</strong> is required.")
				End If
				If CreditCardExpMonth = "" Then
					AddError("Field <strong>Expiration Date (Month)</strong> is required.")
				ElseIf CLng(CreditCardExpYear) = CLng(Year(Date)) And CLng(CreditCardExpMonth) < CLng(Month(Date)) Then
					AddError("Field <strong>Expiration Date</strong> is invalid.")
				End If
				If CreditCardExpYear = "" Then
					AddError("Field <strong>Expiration Date (Year)</strong> is required.")
				End If
				If CreditCardCVV = "" Then
					AddError("Field <strong>CVV/CVV2</strong> is required.")
				End If
			ElseIf (GetIndex(PaymentTypeID, Split("9", ",")) <> -1) Then
				If MoneyOrderNote = "" Then
					AddError("Field <strong>Payment info for check</strong> is required.")
				End If
			ElseIf (GetIndex(PaymentTypeID, Split("11", ",")) <> -1) Then
				If CheckAccountType = "" Then
					AddError("Field <strong>Account Type</strong> is required.")
				End If
				If CheckNumber = "" Then
					AddError("Field <strong>Check Number</strong> is required.")
				End If
				If CheckRoutingNumber = "" Then
					AddError("Field <strong>Routing Number</strong> is required.")
				End If
				If CheckBankAccountNumber = "" Then
					AddError("Field <strong>Bank Account Number</strong> is required.")
				End If
			End If

			If ShippingMethodID = "" Then
				AddError("Field <strong>Shipping Method</strong> is required.")
			End If
		End If
	End Sub
%>