<%
	Dim sNewLocation
	If Request.ServerVariables("HTTP_HOST") <> C_DOMAIN_NAME_SECURE Then
		If Request.ServerVariables("HTTPS") = "off" Then
			sNewLocation = C_DOMAIN_PATH & Replace(GetURLWithout("none"), "&amp;", "&")
		Else
			sNewLocation = C_DOMAIN_PATH_SECURE & Replace(GetURLWithout("none"), "&amp;", "&")
		End If
		Response.Status = "301 Moved Permanently"
		Response.AddHeader "Location", Replace(sNewLocation, "Default.asp", "")
		Response.End
	End If

	Function GetMediaUrl(sUrl)
		GetMediaUrl = Replace("/" & sUrl, "//", "/")
	End Function

    Sub GetInfoPage(iID)
        Dim oQuery
        Set oQuery = oConn.Execute("SELECT * FROM utb_InfoPages WHERE InfoPageID = '" & Quote(iID) & "'")
        If Not oQuery.Eof Then
			If Not IsNull(oQuery("InfoPageMetaTitle")) And oQuery("InfoPageMetaTitle") <> "" Then
				sPageTitle = HTMLEncode(oQuery("InfoPageMetaTitle"))
			End If

			If Not IsNull(oQuery("InfoPageMetaKey")) And oQuery("InfoPageMetaKey") <> "" Then
				sPageKeywords = HTMLEncode(oQuery("InfoPageMetaKey"))
			End If

			If Not IsNull(oQuery("InfoPageMetaDescription")) And oQuery("InfoPageMetaDescription") <> "" Then
				sPageDescription = HTMLEncode(oQuery("InfoPageMetaDescription"))
			End If

            sInfoPageTitle = HTMLEncode(oQuery("InfoPageTitle"))
            sInfoPageContent = oQuery("InfoPageContent")
        Else
            'sInfoPageTitle = "Page not found"
            'sInfoPageContent = "<p>The page you requested was not found.</p><p>You may have clicked an expired link or mistyped the address. Some web addresses are case sensitive.</p>"
			sInfoPageTitle = ""
			sInfoPageContent = ""
        End If
        oQuery.Close
        Set oQuery = Nothing
    End Sub

    Function GetInfoSection(iID)
        GetInfoSection = GetValueFromTable(oConn, "InfoSectionContent", "utb_InfoSections", "WHERE InfoSectionIsActive = 1 AND InfoSectionID = '" & Quote(iID) & "'")
    End Function

    Sub GetBasketTotals()
		iBasketItemsCount = 0
		fBasketTotalPrice = 0
        Dim oQuery
        Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = " & GetBasketCustomerID())
		If Not oQuery.Eof Then
			While Not oQuery.Eof
				iBasketItemsCount = iBasketItemsCount + oQuery("BasketQuantity")
				fBasketTotalPrice = fBasketTotalPrice + CCur(oQuery("ProductPrice")) * CCur(oQuery("BasketQuantity"))
				oQuery.MoveNext
			Wend
		End If
        oQuery.Close
        Set oQuery = Nothing
    End Sub

    Function GetBasketCustomerID()
		If Request("BasketCustomerID") <> "" And ValidateInteger(Request("BasketCustomerID")) Then
			GetBasketCustomerID = Request("BasketCustomerID")
		ElseIf Request.Cookies("BasketCustomerID") <> "" And ValidateInteger(Request.Cookies("BasketCustomerID")) Then
			GetBasketCustomerID = Request.Cookies("BasketCustomerID")
		Else
			GetBasketCustomerID = 0
		End If
    End Function

    Function GetCustomerID()
		Dim iCustomerID : iCustomerID = 0
		If Session("CustomerID") <> "" Then
			iCustomerID = CInt(Session("CustomerID"))
		ElseIf Request("CustomerID") <> "" Then
			iCustomerID = Decode(Request("CustomerID"))
			If ValidateInteger(iCustomerID) Then
				iCustomerID = CInt(iCustomerID)
			Else
				iCustomerID = 0
			End If
		End If
		GetCustomerID = iCustomerID
    End Function

    Function IsCustomer()
        IsCustomer = (GetCustomerID() > 0)
    End Function

	Function SetLastCategoryID(CategoryID)
		Session("CategoryID") = CategoryID
	End Function

	Function GetLastCategoryID(ProductID)
		If Session("CategoryID") = "" Then
			GetLastCategoryID = 0
		Else
			Dim CategoryID : CategoryID = Session("CategoryID")
			If GetValueFromTable(oConn, "COUNT(*)", "utb_ProductCategories", "WHERE CategoryID = '" & Quote(CategoryID) & "' AND ProductID = '" & Quote(ProductID) & "'") > 0 Then
				GetLastCategoryID = CategoryID
			Else
				GetLastCategoryID = 0
			End If
		End If
	End Function

	Public Function GetRootCategoryID(CategoryID)
		Dim iCategoryID : iCategoryID = 0
		Dim sCategoryPath

        Set oQuery = oConn.Execute("SELECT CategoryID, CategoryPath FROM utb_Categories WHERE CategoryID = '" & Quote(CategoryID) & "'")
		If Not oQuery.Eof Then
			iCategoryID = oQuery("CategoryID")
			sCategoryPath = oQuery("CategoryPath")
		End If
        oQuery.Close
        Set oQuery = Nothing

		If iCategoryID > 0 Then
			If Not IsNull(sCategoryPath) Then
				Set oQuery = oConn.Execute("SELECT CategoryID FROM utb_Categories WHERE CategoryID IN(" & Quote(sCategoryPath) & ") AND ParentID = 1")
				If Not oQuery.Eof Then
					iCategoryID = oQuery("CategoryID")
				End If
				oQuery.Close
				Set oQuery = Nothing
			End If
		End If
		GetRootCategoryID = iCategoryID
	End function

	Public Function ReferralTrack()
		Dim ref : ref = GetFormValue("RefID", 50)
		If ref <> "" Then
			oConn.Execute("EXEC usp_ReferralTrack @Referral = '" & Quote(ref) & "'")
		End If
		ReferralTrack = ""
	End Function

	Public Function SetRecentProduct(ID)
		Dim sRecent
		Dim arRecent : arRecent = Array(ID)
		Dim arOldRecent : arOldRecent = Split(Session("RecentProducts"), ",")

		For Each sRecent In arOldRecent
			If CLng(sRecent) <> CLng(ID) Then
				If Ubound(arRecent) >= 2 Then
					Exit For
				End If
				ReDim Preserve arRecent(Ubound(arRecent) + 1)
				arRecent(Ubound(arRecent)) = sRecent
			End If
		Next

		Session("RecentProducts") = Join(arRecent, ",")

		SetRecentProduct = True
	End Function

	Public Function GetRecentProducts()
		GetRecentProducts = Session("RecentProducts")
	End Function

	Function GetQStrWithout(sParam)
		Dim arParam, arParams, sItem
		arParam = Split(sParam, ",")
		arParams = Array()

		For Each sItem In Request.QueryString
			If GetIndex(sItem, arParam) = -1 Then
				ReDim Preserve arParams(Ubound(arParams) + 1)
				arParams(Ubound(arParams)) = sItem & "=" & Request.QueryString(sItem)
			End If
		Next

		GetQStrWithout = Join(arParams, "&amp;")
	End Function

	Function GetURLWithoutRewrite(sParam)
		Dim sQueryStr, sOut, arXOrig
		sQueryStr = GetQStrWithout(sParam)

		If Request.ServerVariables("HTTP_X_ORIGINAL_URL") <> "" Then
			arXOrig = Split(Request.ServerVariables("HTTP_X_ORIGINAL_URL"), "?")
			sOut = arXOrig(0)
		Else
			sOut = Request.ServerVariables("URL")
		End If

		GetURLWithoutRewrite = sOut & "?" & sQueryStr & IIF(sQueryStr <> "", "&amp;", "")
	End Function

%>