<%@ Language=VBScript %>
<% Option Explicit %>
<% Response.Buffer = False %>
<!--#include file="Settings.asp"-->
<%
	Dim arError : arError = Array()
	Dim sPageTitle : sPageTitle = C_DEFAULT_TITLE
	Dim sPageDescription : sPageDescription = C_DEFAULT_DESCRIPTION
	Dim sPageKeywords : sPageKeywords = C_DEFAULT_KEYWORDS
	Dim sInfoPageContent, sInfoPageTitle
	Dim sScriptName : sScriptName = GetFileName()

	Dim arMonth(12)
	arMonth(1)	= "January"
	arMonth(2)	= "February"
	arMonth(3)	= "March"
	arMonth(4)	= "April"
	arMonth(5)	= "May"
	arMonth(6)	= "June"
	arMonth(7)	= "July"
	arMonth(8)	= "August"
	arMonth(9)	= "September"
	arMonth(10)	= "October"
	arMonth(11)	= "November"
	arMonth(12)	= "December"

	Sub AddError(sError)
		ReDim Preserve arError(UBound(arError) + 1)
		arError(UBound(arError)) = sError
	End Sub

	Function IsError()
		IsError = (UBound(arError) > -1)
	End Function

	Function IIF(bEval, sTrue, sFalse)
		If bEval Then
			IIF = sTrue
		Else
			IIF = sFalse
		End If
	End Function

	Function Quote(ByVal sValue)
		If Not IsNull(sValue) Then
			sValue = Replace(sValue, "'", "''")
		End If
		Quote = sValue
	End Function

	Function HTMLEncode(ByVal sValue)
		If Not IsNull(sValue) Then
			sValue = Server.HTMLEncode(sValue)
		End If
		HTMLEncode = sValue
	End Function

	Function URLDecode(str)
		If Not IsNull(str) Then
			Dim sT, sR, i
			str = Replace(str, "+", " ")
			For i = 1 To Len(str)
				sT = Mid(str, i, 1)
				If sT = "%" Then
					If i+2 < Len(str) Then
						sR = sR & _
							Chr(CLng("&H" & Mid(str, i+1, 2)))
						i = i+2
					End If
				Else
					sR = sR & sT
				End If
			Next
			URLDecode = sR
		Else
			URLDecode = ""
		End If
	End Function

	Function URLEncode(str)
		URLEncode = Server.URLEncode(str)
	End Function

	Function GetIndex(sElement, arArray)
		Dim i

		For i = 0 To UBound(arArray)
			If CStr(sElement) = CStr(arArray(i)) Then
				GetIndex = i
				Exit Function
			End If
		Next

		GetIndex = -1
	End Function

	Function ReverseArray(arArray)
		Dim i, j, arResult

		ReDim arResult(UBound(arArray, 2), UBound(arArray, 1))
		For i = 0 To UBound(arArray, 1)
			For j = 0 To UBound(arArray, 2)
				arResult(j, i) = arArray(i, j)
			Next
		Next

		ReverseArray = arResult
	End Function

	Function GetFileName()
		Dim sPath, arPath

		sPath = Request.ServerVariables("SCRIPT_NAME")
		arPath = Split(sPath, "/")

		GetFileName = arPath(UBound(arPath, 1))
	End Function

	Function GetURLWithout(sParam)
		Dim sItem, sDelimiter, sQueryString, arParam

		sDelimiter = ""
		sQueryString = ""
		arParam = Split(sParam, ",")
		For Each sItem In Request.QueryString
			If GetIndex(sItem, arParam) = -1 Then
				sQueryString = sQueryString & sDelimiter & sItem & "=" & Request.QueryString(sItem)
				sDelimiter = "&amp;"
			End If
		Next

		GetURLWithout = Request.ServerVariables("URL") & IIF(sQueryString <> "", "?" & sQueryString, "")
	End Function

	Function GetURLForOrder(sTitle, sField, sOrderQuery, sOrder, sArrow)
		GetURLForOrder = "<a href='" & sOrderQuery & IIF(sOrderQuery = Request.ServerVariables("URL"), "?", "&amp;") & _
						 "Order=" & sField & "&amp;Arrow=" & IIF(sArrow = "1" And sField = sOrder, "2", "1") & "'>" & _
						 sTitle & _
						 "</a>" & _
						 IIF(sField = sOrder, "&nbsp;<img src='images/arrow-" & IIF(sArrow = "1", "asc", "desc") & ".png' style='vertical-align: top' alt='' />", "")
	End Function

	Function GetURLForPage(sTitle, sPage, sPageQuery)
		GetURLForPage = "<a href='" & sPageQuery & IIF(sPageQuery = Request.ServerVariables("URL"), "?", "&amp;") & _
						"Page=" & sPage & "'>" & _
						sTitle & _
						"</a>"
	End Function

	Function ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
		Dim oRegEx
		Set oRegEx = New RegExp
		oRegEx.Global = True
		oRegEx.IgnoreCase = True
		oRegEx.Pattern = "ORDER BY.*"

		Dim oMatch, arMatches, sOrderBy
		Set arMatches = oRegEx.Execute(sQuery)
		For Each oMatch In arMatches
			sOrderBy = oMatch.Value
		Next

		sQuery = Replace(sQuery, sOrderBy, "")
		sQuery = Mid(Trim(sQuery), 8)

		Dim ssQuery
		ssQuery = "SELECT *" &_
				  "	 FROM (SELECT ROW_NUMBER() OVER(" & sOrderBy & ") AS RowNumber" &_
				  "				, RowTotal = COUNT(*) OVER()" &_
				  "				, " & sQuery &_
				  "		  ) AS RowsData" &_
				  "	WHERE RowNumber >= " & iRecordFrom &_
				  "	  AND RowNumber < " & (iRecordFrom + C_PAGE_SIZE)

		Dim oQuery
		Set oQuery = oConn.Execute(ssQuery)
		If Not oQuery.Eof Then
			iRecordCount = oQuery("RowTotal")
		Else
			iRecordCount = 0
		End If

		Set ExecuteWithPager = oQuery
	End Function

	Function GetLastID(oConn)
		Dim oQuery
		Set oQuery = oConn.Execute(" SELECT @@IDENTITY AS ID ")
		GetLastID = oQuery("ID")
		oQuery.Close
		Set oQuery = Nothing
	End Function

	Function GetValueFromTable(oConn, sField, sTable, sWhere)
		Dim oQuery
		Set oQuery = oConn.Execute("SELECT " & sField & " FROM " & sTable & " " & sWhere)
		If Not oQuery.Eof Then
			GetValueFromTable = oQuery(0)
		End If
		oQuery.Close
		Set oQuery = Nothing
	End Function

	Function GetSetting(oConn, sField)
		GetSetting = GetValueFromTable(oConn, sField, "utb_Settings", "")
	End Function

	Sub Redirect(sURL)
		Response.Redirect(sURL)
		Response.End
	End Sub

	Sub SetAlertMessage(sType, sMessage)
		Session("AlertType") = sType
		Session("AlertMessage") = sMessage
	End Sub

	Sub ClearAlertMessage()
		Session.Contents.Remove("AlertType")
		Session.Contents.Remove("AlertMessage")
	End Sub

	Function GetMessage(sType, sMessage)
		If IsArray(sMessage) Then
			sMessage = Join(sMessage, "<br />")
		End If

		sType = IIF(sType = "", "error", sType)

		Dim sTitle
		Select Case sType
			Case "notice" sTitle = "Notice or Alert Message"
			Case "success" sTitle = "Success Message"
			Case "info" sTitle = "Informative Message"
			Case "error" sTitle = "Error Message"
		End Select

		GetMessage = "<div class='alert " & sType & "' onclick='$(this).slideUp();'><h3>" & sTitle & "</h3>" & sMessage & "</div>"
	End Function

	Function RegExpValidator(sValue, sPattent)
		Dim oRegExp
		Set oRegExp = New RegExp

		With oRegExp
			.Pattern = sPattent
			.IgnoreCase = False
		End With

		RegExpValidator = oRegExp.Test(sValue)
		Set oRegExp = Nothing
	End Function

	Function ValidateInteger(sValue)
		ValidateInteger = RegExpValidator(sValue, "^\d+$")
	End Function

	Function ValidateDate(sValue)
		ValidateDate = RegExpValidator(sValue, "^\d{1,2}\/\d{1,2}\/\d{4}$")
	End Function

	Function ValidateDecimal(sValue)
		sValue = Replace(sValue, "$", "a")
		ValidateDecimal = IsNumeric(sValue)
	End Function

	Function ValidateEmail(sValue)
		ValidateEmail = RegExpValidator(sValue, "^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$")
	End Function

	Function ValidateIP(sValue)
		ValidateIP = RegExpValidator(sValue, "^(([01]?\d\d?|2[0-4]\d|25[0-5])\.){3}([01]?\d\d?|25[0-5]|2[0-4]\d)$")
	End Function

	Function ValidateCode(sValue)
		ValidateCode = RegExpValidator(sValue, "^[a-zA-Z]{2}$")
	End Function

	Function ValidateColor(sValue)
		ValidateColor = RegExpValidator(sValue, "^[a-fA-F0-9]{6}$")
	End Function

	Function ValidatePromoCode(sValue)
		ValidatePromoCode = RegExpValidator(sValue, "^[a-zA-Z0-9]{8}$")
	End Function

	Function ValidateCardNumber(sValue)
		ValidateCardNumber = RegExpValidator(sValue, "^((67\d{2})|(4\d{3})|(5[1-5]\d{2})|(6011))-?\s?\d{4}-?\s?\d{4}-?\s?\d{4}|3[4,7]\d{13}$")
	End Function

	Function DecimalPatch(sValue)
		DecimalPatch = Replace(sValue, ",", ".")
	End Function

	Function DecimalFormat(sValue, iPrecision)
		If sValue <> "" Then
			DecimalFormat = FormatNumber(sValue, iPrecision, -2, -2, 0)
		End If
	End Function

	Function CurrencyFormat(sValue, iPrecision)
		If sValue <> "" Then
			CurrencyFormat = FormatCurrency(sValue, iPrecision, -2, -2, -2)
		End If
	End Function

	Function ReplaceEx(ByVal sValue, sFind, sReplace)
		While InStr(sValue, sFind) > 0
			sValue = Replace(sValue, sFind, sReplace)
		Wend

		ReplaceEx = sValue
	End Function

	Function Ceil(fValue)
		Ceil = Round(fValue + 0.49)
	End Function

	Function Floor(fValue)
		Floor = Round(fValue - 0.49)
	End Function

	Function RandomKey(iLength)
		Dim i, sResult
		Dim sPattern : sPattern = "1234567890abcdefghijklmnopqrstuvwxyz"
		Dim iMin : iMin = 1
		Dim iMax : iMax = Len(sPattern)

		Randomize
		For i = 1 To iLength
			sResult = sResult & Mid(sPattern, Int((iMax - iMin + 1) * Rnd + iMin), 1)
		Next

		RandomKey = sResult
	End Function

	Function StripTags(HTMLstring)
		Dim RegularExpressionObject

		If IsNull(HTMLstring) Then
			StripTags = ""
		Else
			Set RegularExpressionObject = New RegExp
			With RegularExpressionObject
				.Pattern = "<[^>]+>"
				.IgnoreCase = True
				.Global = True
			End With
			StripTags = RegularExpressionObject.Replace(HTMLstring, "")
			Set RegularExpressionObject = nothing
		End If
	End Function

	Sub SendEmail(sTo, sFrom, sSubject, sContent)
		Dim sch : sch = "http://schemas.microsoft.com/cdo/configuration/"

		Dim cdoConfig
		Set cdoConfig = Server.CreateObject("CDO.Configuration")
		cdoConfig.Fields(sch & "sendusing") = 2
		cdoConfig.Fields(sch & "smtpserver") = C_SMTP_HOST
		cdoConfig.Fields(sch & "smtpserverport") = C_SMTP_PORT
		If C_SMTP_PASS <> "" Then
			'cdoConfig.Fields(sch & "sendusername") = ""
			cdoConfig.Fields(sch & "sendpassword") = C_SMTP_PASS
		End If
		cdoConfig.Fields.Update

		'Dim sMsg : sMsg = "" &_
		'	"<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Transitional//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"">" &_
		'	"<html xmlns=""http://www.w3.org/1999/xhtml"">" &_
		'	"	<head>" &_
		'	"		<meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"" />" &_
		'	"		<title></title>" &_
		'	"		<style type=""text/css"">td {font-size: 11px; font-family: Verdana,Helvetica,Arial}</style>" &_
		'	"	</head>" &_
		'	"	<body>" &_
		'	"		" & sContent &_
		'	"	</body>" &_
		'	"</html>"

		Dim sMsg : sMsg = "" &_
			"<style type=""text/css"">td {font-size: 11px; font-family: Verdana,Helvetica,Arial}</style>" &_
			sContent

		Dim cdoMessage
		Set cdoMessage = Server.CreateObject("CDO.Message")
		Set cdoMessage.Configuration = cdoConfig
		cdoMessage.From = sFrom
		cdoMessage.To = sTo
		cdoMessage.Subject = sSubject
		cdoMessage.HTMLBody = sMsg

		cdoMessage.Send

		Set cdoMessage = Nothing
		Set cdoConfig = Nothing
	End Sub

	Sub GetEmailTemplate(iID)
		Dim oQuery
		Set oQuery = oConn.Execute("SELECT EmailTemplateSubject, EmailTemplateBody FROM utb_EmailTemplates WHERE EmailTemplateID = " & iID)
		If Not oQuery.Eof Then
			sEmailSubject = oQuery("EmailTemplateSubject")
			sEmailBody = oQuery("EmailTemplateBody")
		End If
		oQuery.Close
		Set oQuery = Nothing

		sEmailSubject = Replace(sEmailSubject, "$CompanyName$", GetSetting(oConn, "CompanyName"))
	End Sub

	Function GetPrintTemplate(iID)
		Dim oQuery
		Set oQuery = oConn.Execute("SELECT PrintTemplateBody FROM utb_PrintTemplates WHERE PrintTemplateID = " & iID)
		If Not oQuery.Eof Then
			GetPrintTemplate = oQuery("PrintTemplateBody")
		End If
		oQuery.Close
		Set oQuery = Nothing
	End Function

	Function GetFormValue(sName, iLength)
		GetFormValue = Left(HTMLEncode(Trim(Request(sName))), iLength)
	End Function

	Function QueryToJSON(dbc, sql)
		Dim rs, jsa, col
		Set rs = dbc.Execute(sql)
		Set jsa = jsArray()
		While Not (rs.EOF Or rs.BOF)
				Set jsa(Null) = jsObject()
				For Each col In rs.Fields
					jsa(Null)(col.Name) = col.Value
				Next
		rs.MoveNext
		Wend
		Set QueryToJSON = jsa
	End Function

	Function Base64Decode(sStringToDecode)
		Const CharList = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
		Dim iDataLength, sOutputString, iGroupInitialCharacter
		sStringToDecode = Replace(Replace(Replace(sStringToDecode, vbCrLf, ""), vbTab, ""), " ", "")
		iDataLength = Len(sStringToDecode)
		If iDataLength Mod 4 <> 0 Then
			Base64Decode = "Bad string passed to Base64Decode() function."
			Exit Function
		End If
		For iGroupInitialCharacter = 1 To iDataLength Step 4
			Dim iDataByteCount, iCharacterCounter, sCharacter, iData, iGroup, sPreliminaryOutString
			iDataByteCount = 3
			iGroup = 0
			For iCharacterCounter = 0 To 3
				sCharacter = Mid(sStringToDecode, iGroupInitialCharacter + iCharacterCounter, 1)
				If sCharacter = "=" Then
					iDataByteCount = iDataByteCount - 1
					iData = 0
				Else
					iData = InStr(1, CharList, sCharacter, 0) - 1
					If iData = -1 Then
						Base64Decode = "Bad string passed to Base64Decode() function."
						Exit Function
					End If
				End If
				iGroup = 64 * iGroup + iData
			Next
			iGroup = Hex(iGroup)
			iGroup = String(6 - Len(iGroup), "0") & iGroup
			sPreliminaryOutString = Chr(CByte("&H" & Mid(iGroup, 1, 2))) & Chr(CByte("&H" & Mid(iGroup, 3, 2))) & Chr(CByte("&H" & Mid(iGroup, 5, 2)))
			sOutputString = sOutputString & Left(sPreliminaryOutString, iDataByteCount)
		Next
		Base64Decode = sOutputString
	End Function

	Function Base64Encode(inData)
		Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
		Dim cOut, sOut, I

		For I = 1 To Len(inData) Step 3
			Dim nGroup, pOut, sGroup

			nGroup = &H10000 * Asc(Mid(inData, I, 1)) + &H100 * SafeASC(Mid(inData, I + 1, 1)) + SafeASC(Mid(inData, I + 2, 1))
			nGroup = Oct(nGroup)
			nGroup = String(8 - Len(nGroup), "0") & nGroup

			pOut = 	Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _
					Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _
					Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _
					Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)

			sOut = sOut + pOut
		Next
		Select Case Len(inData) Mod 3
			Case 1: sOut = Left(sOut, Len(sOut) - 2) + "=="
			Case 2: sOut = Left(sOut, Len(sOut) - 1) + "="
		End Select

		Base64Encode = sOut
	End Function

	Function SafeASC(OneChar)
		If OneChar = "" Then SafeASC = 0 Else SafeASC = Asc(OneChar)
	End Function

	Function Append0(iValue, iLength)
		Append0 = PrependChar(iValue, iLength, "0")
	End Function

	Function PrependChar(iValue, iLength, sChar)
		If IsNull(iValue) Then
			PrependChar = ""
			Exit Function
		End If

		Dim i, sValue
		sValue = CStr(iValue)
		For i = Len(sValue) To iLength - 1
			sValue = sChar + sValue
		Next
		PrependChar = sValue
	End Function

	Function BuildFriendlyDetailURL(sProductName, iProductID)
		BuildFriendlyDetailURL = GetProductUrl(sProductName, iProductID)
	End Function

	Function BuildFriendlyDetailPrintURL(sProductName, iProductID)
		BuildFriendlyDetailPrintURL = GetLink("ProductPrint.asp?Link=" & Text2Url(sProductName, iProductID))
	End Function

	Public Function GetProductUrl(Name, ID)
		GetProductUrl = GetLink("Product.asp?Link=" & Text2Url(Name))
	End Function

	Function AmpSign(sValue)
		If IsNull(sValue) Or sValue = "" Then
			AmpSign = sValue
		Else
			AmpSign = Replace(Replace(sValue, "&amp;", "&"), "&", "&amp;")
		End If
	End Function

	Function WordWrap(str,width,breakString)
		Dim words, parola
		Dim out, temp
		Dim i,k
		out = ""
		words = Split(str," ")
		For i = 0 To UBound(words)
			If Len(words(i)) >= width Then
				temp = ""
				parola = words(i)
				For k = 1 To Len(parola)
					temp = Left(parola,k)
					If len(temp)>=width Then
						out = out & temp & breakString
						parola = Right(parola,Len(parola) - width)
						k = 1
						temp = ""
					End if
				Next
				out = out & temp & breakString
			Else
				out = out & words(i) & breakString
			End If
		Next
		WordWrap = Trim(out)
	End Function

	Function GetLink(ByVal sUrl)
		sUrl = Replace("/" & sUrl, "//", "/")
		Dim IsNeedSSL : IsNeedSSL = (InStr(sUrl, "Checkout") > 0 Or InStr(sUrl, "Account") > 0 Or InStr(sUrl, "Order_Status.asp") > 0)

		If AreWeSecure() And Not IsNeedSSL Then
			GetLink = C_DOMAIN_PATH & sUrl
		ElseIf Not AreWeSecure() And IsNeedSSL Then
			GetLink = C_DOMAIN_PATH_SECURE & sUrl
		Else
			GetLink = sUrl
		End If
	End Function

	Function GetProductImage(sProductName, sProductImage, sType)
		' @TODO: Add checking for file exists

		Dim iImgWidth, iImgHeight
		Select Case LCase(sType)
			Case "mini"
				iImgWidth = C_PRODUCT_IMAGE_MINI_WIDTH
				iImgHeight = C_PRODUCT_IMAGE_MINI_HEIGHT

			Case "small"
				iImgWidth = C_PRODUCT_IMAGE_SMALL_WIDTH
				iImgHeight = C_PRODUCT_IMAGE_SMALL_HEIGHT

			Case "medium"
				iImgWidth = C_PRODUCT_IMAGE_MEDIUM_WIDTH
				iImgHeight = C_PRODUCT_IMAGE_MEDIUM_HEIGHT

			Case "large"
				iImgWidth = C_PRODUCT_IMAGE_LARGE_WIDTH
				iImgHeight = C_PRODUCT_IMAGE_LARGE_HEIGHT
		End Select

		'If IsNull(sProductImage) Or sProductImage = "" Then
			'GetProductImage = "<div style='width: " & iImgWidth & "px; height: " & iImgHeight & "px; text-align: center' align='center'>Image Coming soon</div>"
		'	GetProductImage = ""
		'Else
			GetProductImage = "<img " &_
				"src=""" & GetProductImageSrc(sProductImage, sType) & """ " &_
				"width=""" & iImgWidth & """ " &_
				"height=""" & iImgHeight & """ " &_
				"alt=""" & HTMLEncode(sProductName) & """ " &_
			"/>"
		'End If
		
	End Function

	Function GetProductImageSrc(sProductImage, sType)
		GetProductImageSrc = GetProductImageSrc__(sProductImage, sType, True)
	End Function

	Public Function AreWeSecure()
		AreWeSecure = (Request.ServerVariables("SERVER_PORT") = "443")
	End Function

	Function GetProductImageSrc__(sProductImage, sType, isCheckSecure)
		Dim sSrc

		If IsNull(sProductImage) Or sProductImage = "" Then
			Select Case LCase(sType)
				Case "mini"
					sSrc = C_NO_IMAGE_MINI
				Case "small"
					sSrc = C_NO_IMAGE_SMALL
				Case "medium"
					sSrc = C_NO_IMAGE_MEDIUM
				Case "large"
					sSrc = C_NO_IMAGE_LARGE
			End Select
		Else
			Select Case LCase(sType)
				Case "mini"
					sSrc = C_PRODUCT_IMAGE_MINI_PATH & "/" & sProductImage
				Case "small"
					sSrc = C_PRODUCT_IMAGE_SMALL_PATH & "/" & sProductImage
				Case "medium"
					sSrc = C_PRODUCT_IMAGE_MEDIUM_PATH & "/" & sProductImage
				Case "large"
					sSrc = C_PRODUCT_IMAGE_LARGE_PATH & "/" & sProductImage
			End Select
		End If

		If AreWeSecure() And isCheckSecure Then
			'sSrc = C_DOMAIN_PATH_SECURE & sSrc
			sSrc = "" & sSrc
		Else
			'sSrc = C_DOMAIN_PATH & sSrc
			sSrc = "" & sSrc
		End If
		GetProductImageSrc__ = Replace(sSrc, "../", "/")
	End Function

	Function IsNullOrEmpty(sValue)
		If IsNull(sValue) Or sValue = "" Then
			IsNullOrEmpty = True
		Else
			IsNullOrEmpty = False
		End If
	End Function

	Public Function GetOrderStatusMessage(OrderID)
		Dim oOrder, arRes(1)
		arRes(0) = ""
		arRes(1) = ""

		sQuery = " SELECT o.*" &_
				 "		, ISNULL(os.OrderStatusEmailSubject, '') AS OrderStatusEmailSubject" &_
				 "		, os.OrderStatusEmailBody" &_
				 "		, pt.PaymentTypeName" &_
				 "		, c.OrderDeliveryCarrierName" &_
				 "	 FROM utb_Orders AS o" &_
				 "		  INNER JOIN utb_OrderStatuses AS os ON os.OrderStatusID = o.OrderStatusID" &_
				 "		   LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
				 "		   LEFT JOIN utb_OrderDeliveryCarriers c ON c.OrderDeliveryCarrierID = o.OrderDeliveryCarrierID" &_
				 "	WHERE o.OrderID = '" & Quote(OrderID) & "'"

		Set oOrder = oConn.Execute(sQuery)
		If Not oOrder.Eof Then
			Dim OrderAccountNumber1 : OrderAccountNumber1 = IIF(IsNull(oOrder("OrderAccountNumber1")), "", oOrder("OrderAccountNumber1"))

			Dim sCCNumber : sCCNumber = ""
			If Len(OrderAccountNumber1) > 0 Then
				sCCNumber = Decode(OrderAccountNumber1)
			End If

			Dim fSubTotal, fSubTotalCost, fShipping, fShippingCost, fInsurance, fPromo, sPromoCode, fTax

			fSubTotal = CCur(oOrder("OrderTotalAmount"))
			fSubTotalCost = CCur(oOrder("OrderCostAmount"))
			fShipping = CCur(oOrder("OrderDeliveryPrice"))
			fShippingCost = CCur(oOrder("OrderDeliveryCost"))
			fInsurance = CCur(oOrder("OrderHandlingInsurance"))
			fPromo = CCur(oOrder("OrderPromoAmount"))
			sPromoCode = IIF(IsNull(oOrder("OrderPromoCode")), "", oOrder("OrderPromoCode"))
			fTax = CCur(oOrder("OrderTaxAmount"))

			Dim sOrderSegment : sOrderSegment = "" &_
				"<table width=""100%"" cellpadding=""5"" cellspacing=""1"" border=""0"" bgcolor=""#dedede"" style=""border: 1px solid #999"">" &_
					"<tr align=""center"">" &_
						"<td><strong>Qty.</strong></td>" &_
						"<td><strong>Sku</strong></td>" &_
						"<td align=""left""><strong>Description</strong></td>" &_
						"<td><strong>Price</strong></td>" &_
						"<td><strong>Total</strong></td>" &_
					"</tr>"

			Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = '" & Quote(OrderID) & "'")
			While Not oQuery.Eof
				sOrderSegment = sOrderSegment &_
					"<tr valign=""top"" bgcolor=""#ffffff"">" &_
						"<td align=""center"">" & oQuery("OrderDetailProductQuantity") & "</td>" &_
						"<td>" & oQuery("ProductSKU") & "</td>" &_
						"<td>" & oQuery("ProductName") & "</td>" &_
						"<td align=""right"">" & CurrencyFormat(oQuery("ProductPrice"), 2) & "</td>" &_
						"<td align=""right"">" & CurrencyFormat(oQuery("Total"), 2) & "</td>" &_
					"</tr>"
				oQuery.MoveNext
			Wend
			oQuery.Close
			Set oQuery = Nothing

			Dim fTotalOrder, fTotalCost, fPNL, fGrandTotal

			fTotalOrder = fSubTotal + fShipping + fPromo + fInsurance
			fTotalCost	= fSubTotalCost + fShippingCost
			fPNL = fTotalOrder - fTotalCost
			fGrandTotal = fSubTotal + fShipping + fPromo + fInsurance + fTax

			sOrderSegment = sOrderSegment &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4"">Sub Total:</td>" &_
						"<td>" & CurrencyFormat(fSubTotal, 2) & "</td>" &_
					"</tr>" &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4"">Promo" & IIF(sPromoCode <> "", " (" & sPromoCode & ")", "") & ":</td>" &_
						"<td>" & CurrencyFormat(fPromo, 2) & "</td>" &_
					"</tr>" &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4"">Shipping:</td>" &_
						"<td>" & CurrencyFormat(fShipping, 2) & "</td>" &_
					"</tr>"

			If fInsurance > 0 Then
				sOrderSegment = sOrderSegment &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4"">Handling and Insurance:</td>" &_
						"<td>" & CurrencyFormat(fInsurance, 2) & "</td>" &_
					"</tr>"
			End If

			sOrderSegment = sOrderSegment &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4"">Tax:</td>" &_
						"<td>" & CurrencyFormat(fTax, 2) & "</td>" &_
					"</tr>" &_
					"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
						"<td colspan=""4""><strong>Grand Total:</strong></td>" &_
						"<td><strong>" & CurrencyFormat(fGrandTotal, 2) & "</strong></td>" &_
					"</tr>" &_
				"</table>"

			Dim sContent : sContent = oOrder("OrderStatusEmailBody")
			sContent = Replace(sContent, "$CompanyName$",	GetSetting(oConn, "CompanyName"))
			sContent = Replace(sContent, "$CompanyEmail$",	GetSetting(oConn, "CompanyEmailForOrder"))
			sContent = Replace(sContent, "$OrderNumber$",	OrderID)
			sContent = Replace(sContent, "$OrderDate$",		oOrder("OrderCreateDate"))
			sContent = Replace(sContent, "$CustomerEmail$",	oOrder("OrderEmail"))

			sContent = Replace(sContent, "$CFirstName$",	IIF(IsNull(oOrder("OrderBillingFirstName")), "", oOrder("OrderBillingFirstName")))
			sContent = Replace(sContent, "$CLastName$",		IIF(IsNull(oOrder("OrderBillingLastName")), "", oOrder("OrderBillingLastName")))
			sContent = Replace(sContent, "$CCompanyName$",	IIF(IsNull(oOrder("OrderBillingCompanyName")), "", oOrder("OrderBillingCompanyName")))
			sContent = Replace(sContent, "$CAddress$",		IIF(IsNull(oOrder("OrderBillingAddress1")), "", oOrder("OrderBillingAddress1")))
			sContent = Replace(sContent, "$CApt$",			IIF(IsNull(oOrder("OrderBillingCountry")), "", oOrder("OrderBillingCountry")))
			sContent = Replace(sContent, "$CCity$",			IIF(IsNull(oOrder("OrderBillingCity")), "", oOrder("OrderBillingCity")))
			sContent = Replace(sContent, "$CState$",		IIF(IsNull(oOrder("OrderBillingState")), "", oOrder("OrderBillingState")))
			sContent = Replace(sContent, "$CZip$",			IIF(IsNull(oOrder("OrderBillingZip")), "", oOrder("OrderBillingZip")))
			sContent = Replace(sContent, "$CHomePhone$",	IIF(IsNull(oOrder("OrderBillingHomePhone")), "", oOrder("OrderBillingHomePhone")))
			sContent = Replace(sContent, "$CWorkPhone$",	IIF(IsNull(oOrder("OrderBillingAltPhone")), "", oOrder("OrderBillingAltPhone")))

			sContent = Replace(sContent, "$DFirstName$",	IIF(IsNull(oOrder("OrderShippingFirstName")), "", oOrder("OrderShippingFirstName")))
			sContent = Replace(sContent, "$DLastName$",		IIF(IsNull(oOrder("OrderShippingLastName")), "", oOrder("OrderShippingLastName")))
			sContent = Replace(sContent, "$DCompanyName$",	IIF(IsNull(oOrder("OrderShippingCompanyName")), "", oOrder("OrderShippingCompanyName")))
			sContent = Replace(sContent, "$DAddress$",		IIF(IsNull(oOrder("OrderShippingAddress1")), "", oOrder("OrderShippingAddress1")))
			sContent = Replace(sContent, "$DApt$",			IIF(IsNull(oOrder("OrderShippingCountry")), "", oOrder("OrderShippingCountry")))
			sContent = Replace(sContent, "$DCity$",			IIF(IsNull(oOrder("OrderShippingCity")), "", oOrder("OrderShippingCity")))
			sContent = Replace(sContent, "$DState$",		IIF(IsNull(oOrder("OrderShippingState")), "", oOrder("OrderShippingState")))
			sContent = Replace(sContent, "$DZip$",			IIF(IsNull(oOrder("OrderShippingZip")), "", oOrder("OrderShippingZip")))
			sContent = Replace(sContent, "$DHomePhone$",	IIF(IsNull(oOrder("OrderShippingHomePhone")), "", oOrder("OrderShippingHomePhone")))
			sContent = Replace(sContent, "$DWorkPhone$",	IIF(IsNull(oOrder("OrderShippingAltPhone")), "", oOrder("OrderShippingAltPhone")))

			sContent = Replace(sContent, "$Shipping$",		IIF(IsNull(oOrder("OrderDeliveryMethod")), "", oOrder("OrderDeliveryMethod")))
			sContent = Replace(sContent, "$PaymentType$",	IIF(IsNull(oOrder("PaymentTypeName")), "", oOrder("PaymentTypeName")))
			sContent = Replace(sContent, "$CreditCard$",	PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X"))
			sContent = Replace(sContent, "$TrackingNumber$",IIF(IsNull(oOrder("OrderDeliveryTracking")), "", oOrder("OrderDeliveryTracking")))
			sContent = Replace(sContent, "$ShippingCompany$",IIF(IsNull(oOrder("OrderDeliveryCarrierName")), "", oOrder("OrderDeliveryCarrierName")))

			sContent = Replace(sContent, "$OrderSegment$",	sOrderSegment)
			sContent = Replace(sContent, "$CurrentYear$",	Year(Date))

			arRes(0) = oOrder("OrderStatusEmailSubject")
			arRes(1) = sContent
		End If
		oOrder.Close
		Set oOrder = Nothing

		GetOrderStatusMessage = arRes
	End function

	Public Function InvertColor(i, color1, color2)
		InvertColor = IIF(i Mod 2 = 0, color1, color2)
		i = i + 1
	End function

	Public Function HideCC(ccNumber)
		HideCC = PrependChar(Right(ccNumber, 4), Len(ccNumber), "X")
	End function

	Public Function setOrderFirstOrderedItems(iOrderID)
		Dim sItems

		Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = " & iOrderID)
		If Not oQuery.Eof Then
			sItems = sItems &_
				"<table class=""items-grid"">" &_
					"<tr>" &_
						"<th class=""h-sku"">Sku</th>" &_
						"<th class=""h-item"">Item</th>" &_
						"<th class=""h-price"">Price</th>" &_
						"<th class=""h-cost"">Cost</th>" &_
						"<th class=""h-stock"">Stock</th>" &_
						"<th class=""h-qty"">Qty</th>" &_
						"<th class=""h-total"">Total</th>" &_
					"</tr>"

			While Not oQuery.Eof
				sItems = sItems &_
					"<tr>" &_
						"<td class=""b-sku"">" & oQuery("ProductSKU") & "</td>" &_
						"<td class=""b-item"">" & oQuery("ProductName") & " &nbsp; <span>" & oQuery("OrderDetailType") & "</span></td>" &_
						"<td class=""b-price"">" & CurrencyFormat(oQuery("ProductPrice"), 2) & "</td>" &_
						"<td class=""b-cost"">" & CurrencyFormat(oQuery("ProductCost"), 2) & "</td>" &_
						"<td class=""b-stock"">" & oQuery("ProductStatusName") & "</td>" &_
						"<td class=""b-qty"">" & oQuery("OrderDetailProductQuantity") & "</td>" &_
						"<td class=""b-total"">" & CurrencyFormat(oQuery("Total"), 2) & "</td>" &_
					"</tr>"
				oQuery.MoveNext
			Wend

			sItems = sItems &_
				"</table>"
		End If
		oQuery.Close
		Set oQuery = Nothing

		sQuery = "SELECT OrderTotalAmount" &_
				 "	   , OrderDeliveryCost" &_
				 "	   , OrderDeliveryMethod" &_
				 "	   , OrderDeliveryPrice" &_
				 "	   , OrderHandlingInsurance" &_
				 "	   , ISNULL(OrderPromoCode, '') AS OrderPromoCode" &_
				 "	   , OrderPromoAmount" &_
				 "	   , OrderTaxExemption" &_
				 "	   , OrderTaxAmount" &_
				 "	   , (OrderTotalAmount + OrderDeliveryPrice + OrderPromoAmount + OrderHandlingInsurance) AS TotalOrder" &_
				 "	   , (OrderCostAmount + OrderDeliveryCost) AS TotalCost" &_
				 "	   , (OrderTotalAmount + OrderDeliveryPrice + OrderPromoAmount + OrderHandlingInsurance + OrderTaxAmount) AS GrandTotal" &_
				 "	FROM utb_Orders" &_
				 " WHERE OrderID = " & iOrderID
		Set oQuery = oConn.Execute(sQuery)
		If Not oQuery.Eof Then
			sItems = sItems &_
				"<table class=""items-grid"">" &_
					"<tr class=""i-subtotal"">" &_
						"<td class=""f-label"">Sub Total:</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("OrderTotalAmount"), 2) & "</td>" &_
					"</tr>" &_
					"<tr class=""i-shipping"">" &_
						"<td class=""f-label"">" &_
							IIF(CCur(oQuery("OrderDeliveryCost")) > 0, "<span>Shipping Cost: " & CurrencyFormat(oQuery("OrderDeliveryCost"), 2) & "</span> &nbsp;&nbsp;&nbsp; ", "") &_
							"Shipping (" & oQuery("OrderDeliveryMethod") & "):" &_
						"</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("OrderDeliveryPrice"), 2) & "</td>" &_
					"</tr>" &_
					"<tr class=""i-insurance"">" &_
						"<td class=""f-label"">Handling and Insurance:</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("OrderHandlingInsurance"), 2) & "</td>" &_
					"</tr>" &_
					"<tr class=""i-promo"">" &_
						"<td class=""f-label"">Promo" & IIF(oQuery("OrderPromoCode") <> "", " (" & oQuery("OrderPromoCode") & ")", "") & ":</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("OrderPromoAmount"), 2) & "</td>" &_
					"</tr>" &_
					"<tr class=""i-tax"">" &_
						"<td class=""f-label"">Tax" & IIF(oQuery("OrderTaxExemption") = "1", " (Exemption)", "") & ":</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("OrderTaxAmount"), 2) & "</td>" &_
					"</tr>" &_
					"<tr class=""i-total"">" &_
						"<td class=""f-label"">" &_
							"<div style=""float: left"">" &_
								"<span>Total Order:</span> " & CurrencyFormat(oQuery("TotalOrder"), 2) &_
								" &nbsp;&nbsp;&nbsp; " &_
								"<span>Total Cost:</span> " & CurrencyFormat(oQuery("TotalCost"), 2) &_
								" &nbsp;&nbsp;&nbsp; " &_
								"<span>PNL:</span> " & CurrencyFormat(CCur(oQuery("TotalOrder")) - CCur(oQuery("TotalCost")), 2) &_
							"</div>" &_
							"Grand Total:<div style=""clear: both""></div>" &_
						"</td>" &_
						"<td class=""f-value"">" & CurrencyFormat(oQuery("GrandTotal"), 2) & "</td>" &_
					"</tr>" &_
				"</table>"
		End If
		oQuery.Close
		Set oQuery = Nothing

		oConn.Execute("UPDATE utb_Orders SET OrderFirstOrderedItems = '" & Quote(sItems) & "' WHERE OrderID = " & iOrderID)

		setOrderFirstOrderedItems = True
	End Function

	Public Function IsCreditCard(ByRef asCardType, ByRef anCardNumber)
		' Performs a Mod 10 check to make sure the credit card number
		' appears valid
		' Developers may use the following numbers as dummy data:
		' Visa:					430-00000-00000
		' American Express:		372-00000-00000
		' Mastercard:			521-00000-00000
		' Discover:				620-00000-00000

		Dim lsNumber		' Credit card number stripped of all spaces, dashes, etc.
		Dim lsChar			' an individual character
		Dim lnTotal			' Sum of all calculations
		Dim lnDigit			' A digit found within a credit card number
		Dim lnPosition		' identifies a character position in a string
		Dim lnSum			' Sum of calculations for a specific set
		Dim lnMultiplier

		' Default result is false
		IsCreditCard = False

		' ====
		' Strip all characters that are not numbers.
		' ====

		' Loop through each character inthe card number submited
		For lnPosition = 1 To Len(anCardNumber)
			' Grab the current character
			lsChar = Mid(anCardNumber, lnPosition, 1)
			' If the character is a number, append it to our new number
			If IsNumeric(lsChar) Then lsNumber = lsNumber & lsChar
		Next ' lnPosition

		' ====
		' The credit card number must be between 13 and 16 digits.
		' ====
		' If the length of the number is less then 13 digits, then exit the routine
		If Len(lsNumber) < 13 Then Exit Function

		' If the length of the number is more then 16 digits, then exit the routine
		If Len(lsNumber) > 16 Then Exit Function

		' ====
		' The credit card number must start with: 
		'	4 for Visa Cards 
		'	37 for American Express Cards 
		'	5 for MasterCards 
		'	6 for Discover Cards 
		' ====

		' Choose action based on type of card
		Select Case LCase(asCardType)
			' VISA
			Case "visa", "v"
				' If first digit not 4, exit function
				If Not Left(lsNumber, 1) = "4" Then Exit Function
			' American Express
			Case "american express", "americanexpress", "american", "ax", "a"
				' If first 2 digits not 37, exit function
				If Not Left(lsNumber, 2) = "37" Then Exit Function
			' Mastercard
			Case "mastercard", "master card", "master", "m"
				' If first digit not 5, exit function
				If Not Left(lsNumber, 1) = "5" Then Exit Function
			' Discover
			Case "discover", "discovercard", "discover card", "d"
				' If first digit not 6, exit function
				If Not Left(lsNumber, 1) = "6" Then Exit Function
			Case Else
		End Select ' LCase(asCardType)

		' ====
		' If the credit card number is less then 16 digits add zeros
		' to the beginning to make it 16 digits.
		' ====
		' Continue loop while the length of the number is less then 16 digits
		While Not Len(lsNumber) = 16
			' Insert 0 to the beginning of the number
			lsNumber = "0" & lsNumber
		Wend ' Not Len(lsNumber) = 16

		' ====
		' Multiply each digit of the credit card number by the corresponding digit of
		' the mask, and sum the results together.
		' ====

		' Loop through each digit
		For lnPosition = 1 To 16
			' Parse a digit from a specified position in the number
			lnDigit = Mid(lsNumber, lnPosition, 1)

			' Determine if we multiply by:
			'	1 (Even)
			'	2 (Odd)
			' based on the position that we are reading the digit from
			lnMultiplier = 1 + (lnPosition Mod 2)

			' Calculate the sum by multiplying the digit and the Multiplier
			lnSum = lnDigit * lnMultiplier

			' (Single digits roll over to remain single. We manually have to do this.)
			' If the Sum is 10 or more, subtract 9
			If lnSum > 9 Then lnSum = lnSum - 9

			' Add the sum to the total of all sums
			lnTotal = lnTotal + lnSum
		Next ' lnPosition

		' ====
		' Once all the results are summed divide
		' by 10, if there is no remainder then the credit card number is valid.
		' ====
		IsCreditCard = ((lnTotal Mod 10) = 0)
	End Function

	Public Function Text2Url(ByVal sText)
		Dim sReplaceSign : sReplaceSign = "_"
		sText = Replace(sText, " ", sReplaceSign)
		sText = Replace(sText, "\", sReplaceSign)
		sText = Replace(sText, "/", sReplaceSign)
		sText = Replace(sText, ":", sReplaceSign)
		sText = Replace(sText, "*", sReplaceSign)
		sText = Replace(sText, "?", sReplaceSign)
		sText = Replace(sText,"""", sReplaceSign)
		sText = Replace(sText, "<", sReplaceSign)
		sText = Replace(sText, ">", sReplaceSign)
		sText = Replace(sText, "|", sReplaceSign)
		sText = Replace(sText, ".", sReplaceSign)
		sText = Replace(sText, "[", sReplaceSign)
		sText = Replace(sText, "]", sReplaceSign)
		sText = Replace(sText, ";", sReplaceSign)
		sText = Replace(sText, "=", sReplaceSign)
		sText = Replace(sText, ",", sReplaceSign)
		sText = Replace(sText, "(", sReplaceSign)
		sText = Replace(sText, ")", sReplaceSign)
		sText = Replace(sText, "'", sReplaceSign)
		sText = Replace(sText, "~", sReplaceSign)
		sText = Replace(sText, "!", sReplaceSign)
		sText = Replace(sText, "@", sReplaceSign)
		sText = Replace(sText, "#", sReplaceSign)
		sText = Replace(sText, "$", sReplaceSign)
		sText = Replace(sText, "%", sReplaceSign)
		sText = Replace(sText, "^", sReplaceSign)
		sText = Replace(sText, "&", sReplaceSign)
		sText = Replace(sText, "+", sReplaceSign)

		sText = HTMLEncode(sText)
		sText = Replace(sText, "&#174;", sReplaceSign)
		sText = Replace(sText, "&#194;", sReplaceSign)
		sText = Replace(sText, "&#8482;", sReplaceSign)
		sText = Replace(sText, "&#8217;", sReplaceSign)

		sText = ReplaceEx(sText, sReplaceSign & sReplaceSign, sReplaceSign)

		If Right(sText, 1) = sReplaceSign Then
			sText = Left(sText, Len(sText) - 1)
		End If

		Text2Url = sText
	End Function

	Function SqlGetValueOrNull(sValue)
		SqlGetValueOrNull = IIF(IsNull(sValue) Or sValue = "", "NULL", "'" & Quote(sValue) & "'")
	End Function

	Public Function GetInfoPageLink(ByVal ID, ByVal Name)
		GetInfoPageLink = GetLink("InfoPage.asp?ID=" & ID)
	End Function

	Public Function GetCategoryLink(Link)
		GetCategoryLink = GetLink("Category.asp?Link=" & Link)
	End Function

	Public Function GetPageLink(ByVal Link)
		If Link = "Default.asp" Then
			GetPageLink = GetLink("")
			Exit Function
		End If

		GetPageLink = GetLink(Replace(Link, "/", "") & ".asp")
	End Function

	Public Function GetCategoryImage(sCatName, sCatImage)
		Dim sSrc : sSrc = IIF(Request.Servervariables("SERVER_NAME") = C_DOMAIN_NAME_SECURE, C_DOMAIN_PATH_SECURE, C_DOMAIN_PATH) &_
			Replace(C_CATEGORY_IMAGE_PATH, "../", "/") &_
			"/" & sCatImage

		GetCategoryImage = "<img " &_
			"src=""" & sSrc & """ " &_
			"width=""" & C_CATEGORY_IMAGE_WIDTH & """ " &_
			"height=""" & C_CATEGORY_IMAGE_HEIGHT & """ " &_
			"alt=""" & HTMLEncode(sCatName) & """ " &_
		"/>"
	End Function

%>