<%
sQuery= "SELECT " & IIF(iLimit > 0, "TOP " & iLimit, "") & " p.ProductID" &_
		"	  , p.ManufacturerID" &_
		"	  , m.ManufacturerName" &_
		"	  , p.ProductStatusID" &_
		"	  , ps.ProductStatusName" &_
		"	  , p.ProductConditionID" &_
		"	  , pc.ProductConditionName" &_
		"	  , p.ProductName" &_
		"	  , p.ProductModel" &_
		"	  , p.ProductImage" &_
		"	  , p.ProductSKU" &_
		"	  , p.ProductMPN" &_
		"	  , p.ProductMSRP" &_
		"	  , p.ProductPrice" &_
		"	  , p.ProductRating" &_
		"	  , p.ProductKeyFeature" &_
		"	  , p.ProductIncludes" &_
		"  FROM utb_Products AS p" &_
		"		INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID" &_
		"		INNER JOIN utb_ProductStatuses AS ps ON ps.ProductStatusID = p.ProductStatusID" &_
		"		INNER JOIN utb_ProductConditions AS pc ON pc.ProductConditionID = p.ProductConditionID" &_
		"		INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID" &_
 		" 		" & sWhere &_
 		" ORDER BY " & GetColumnByIndex(Request("Order"))

Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount, iForCount
iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

Dim j
Dim sPageQuery : sPageQuery = GetURLWithout("Page")
Dim sOrderQuery : sOrderQuery = GetURLWithout("Order")

If iRecordCount > 0 Then
	%>
	<div class="block-gray pager-wrap">
		<table width="100%" class="pager">
			<tr>
				<td width="60"><strong>Sort By:</strong></td>
				<td>
					<select name="Order" style="width: 140px" onchange="document.location.href='<%= GetURLWithoutRewrite("Order,Page") & "Order=" %>' + $(this).val()">
						<option value="1" <%= IIF(Request("Order") = "1", "selected='selected'", "") %>>By Name</option>
						<option value="2" <%= IIF(Request("Order") = "2", "selected='selected'", "") %>>Best Sellers</option>
						<option value="3" <%= IIF(Request("Order") = "3", "selected='selected'", "") %>>Recently Added</option>
						<option value="4" <%= IIF(Request("Order") = "4", "selected='selected'", "") %>>Prices High to Low</option>
						<option value="5" <%= IIF(Request("Order") = "5", "selected='selected'", "") %>>Prices Low to High</option>
					</select>
				</td>
				<td align="right" class="pager-pages"><!--#include file="PagerFrontend.asp"--></td>
			</tr>
		</table>
	</div>

	<div class="products">
		<ul class="items-list">
		<%
		While Not oQuery.Eof
			%>
			<li id="pr-<%= oQuery("ProductID") %>">
				<a href="/Product/<%= Text2Url(oQuery("ProductName")) %>.htm" class="item-img"><%= GetProductImage(oQuery("ProductName"), oQuery("ProductImage"), "small") %></a>
				<h3 class="item-name"><a href="/Product/<%= Text2Url(oQuery("ProductName")) %>.htm"><%= HTMLEncode(oQuery("ProductName")) %></a></h3>
				<div class="item-retail">
				<% If CCur(oQuery("ProductMSRP")) > 0 Then %>
				Retail price: <span><%= CurrencyFormat(oQuery("ProductMSRP"), 2) %></span>
				<% Else %>
				&nbsp;
				<% End If %>
				</div>
				<div class="item-price">Our Price: <strong class="price"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></strong></div>
				<a class="item-btn-more" href="<%= BuildFriendlyDetailURL(oQuery("ProductName"), oQuery("ProductID")) %>">More info</a>
			</li>
			<%
			oQuery.MoveNext
		Wend 
		oQuery.Close
		Set oQuery = Nothing
		%>
		</ul>
	</div>
	<div class="cleaner"></div>

	<div class="block-gray pager-wrap">
		<table width="100%" class="pager">
			<tr>
				<td width="60"><strong>Sort By:</strong></td>
				<td>
					<select name="Order" style="width: 140px" onchange="document.location.href='<%= GetURLWithoutRewrite("Order,Page") & "Order=" %>' + $(this).val()">
						<option value="1" <%= IIF(Request("Order") = "1", "selected='selected'", "") %>>By Name</option>
						<option value="2" <%= IIF(Request("Order") = "2", "selected='selected'", "") %>>Best Sellers</option>
						<option value="3" <%= IIF(Request("Order") = "3", "selected='selected'", "") %>>Recently Added</option>
						<option value="4" <%= IIF(Request("Order") = "4", "selected='selected'", "") %>>Prices High to Low</option>
						<option value="5" <%= IIF(Request("Order") = "5", "selected='selected'", "") %>>Prices Low to High</option>
					</select>
				</td>
				<td align="right" class="pager-pages"><!--#include file="PagerFrontend.asp"--></td>
			</tr>
		</table>
	</div>
	<%
End If

Function GetColumnByIndex(sIndex)
	Dim sColumn : sColumn = "p.ProductName ASC"

	Select Case sIndex
		Case "1" sColumn = "p.ProductName ASC"
		Case "2" sColumn = "p.ProductIsBestSeller ASC"
		Case "3" sColumn = "p.ProductCreateDate DESC"
		Case "4" sColumn = "p.ProductPrice DESC"
		Case "5" sColumn = "p.ProductPrice ASC"
	End Select

	GetColumnByIndex = sColumn
End Function
%>
