var miniCartTimeOut = null;

$(function(){
	$('textarea.limited').each(function(){
		setCounter(this);
		$(this).bind('keyup', function(){
			$('#limit_' + $(this).attr('name')).html(checkLimit(this));
		});
	});

	$('#mb-close a,.mb-close').click(hideMiniBasket);
});

function redirect(url) {
	document.location.href = url;
}

function checkEmail(email) {
	return email.match(/^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/);
}

function focusBlur(el, val) {
	el.blur(function(){
		if ($.trim($(this).val()) == '') {
			$(this).val(val);
		}
	});
	el.focus(function(){
		if ($.trim($(this).val()) == val) {
			$(this).val('');
		}
	});
	el.parents('form').submit(function(){
		if (el.val() == '' || el.val() == val) {
			el.focus();
			return false;
		}
		return true;
	});
}

function countryTrigger(countryValue, stateValue, stateFieldName, isCode, callback) {
	var argNum = arguments.length;
	$.post(sitePath+'/ajax/GetStates.asp', {CountryID: countryValue, IsCode: isCode}, function(data){
		if (data.length <= 0) {
			result = '<input type="text" name="' + stateFieldName + '" id="' + stateFieldName + '" value="" maxlength="50" class="required" />';
		}
		else {
			result = '<select name="' + stateFieldName + '" id="' + stateFieldName + '" class="required">' + 
				'<option value="">Select One</option>';

			$.each(data, function(i, val){
				result += '<option value="' + val.StateCode + '"' + (val.StateCode == stateValue ? ' selected="selected"' : '') + '>' + val.StateName + '</option>';
			});
			result += '</select>';
		}
		var oldControl = $('#' + stateFieldName);
		oldControl.hide().after(result);
		oldControl.remove();

		if (argNum == 5 && typeof callback == 'function') {
			callback();
		}
	}, 'json');
}

function checkLimit(o) {
	var limit = $(o).attr('class').match(/limit_[\d]+/);
	var total = limit[0].split('_')[1];
	var left = total - $(o).attr('value').length;

	if (left < 0) {
		$(o).val($(o).attr('value').substr(0, total));
		left = 0;
	}
	return left;
}

function setCounter(o) {
	var counterObj = $('#' + $(o).attr('id') + '-counter');
	if (counterObj.length) {
		counterObj.html('<br />Number of characters left: <span id="limit_' + $(o).attr('name') + '">' + checkLimit(o) + '</span>');
	}
	else {
		$(o).parent().append('<br />Number of characters left: <span id="limit_' + $(o).attr('name') + '">' + checkLimit(o) + '</span>');
	}
}

function showMiniBasket(products) {
	if ($('#mb').is(':visible')) {
		hideMiniBasket(function(){
			showMiniBasket(products);
		});
		return false;
	}

	var htm = '';
	$.each(products, function(i, product){
		htm +=''
			+ '<table cellpadding="3" cellspacing="0">'
			+	'<tr valign="top">'
			+		'<td><img src="'+product.imgsrc+'" alt="" width="'+product.imgsrcwidth+'" height="'+product.imgsrcheight+'" /></td>'
			+		'<td><a href="'+product.link+'">'+product.name+'</a>'
			+			'<div style="padding-top: 5px">'
			+				'#<span>'+product.sku+'</span><br />'
			+				'Price: <strong class="price-18">'+product.price+'</strong>'
			+			'</div>'
			+		'</td>'
			+	'</tr>'
			+ '</table>';
	});
	$('#mb-content').html(htm);

	$('#mb').css({
		'top': ($(window).height() - $('#mb').height()) / 2 +$(window).scrollTop() + 'px',
		'left': ($(window).width() - $('#mb').width()) / 2 +$(window).scrollLeft() + 'px'
	}).show('slide', {direction: 'up'}, 300, function(){
		if (miniCartTimeOut) {
			clearTimeout(miniCartTimeOut);
		}
		$('#mb-footer').slideDown();
		miniCartTimeOut = setTimeout(hideMiniBasket, 5000);
	});

	return false;
}
function hideMiniBasket(callback) {
	if ($('#mb').is(':hidden')) {
		return false;
	}
	$('#mb-footer').slideUp(function(){
		if (typeof(callback) == 'function') {
			$('#mb').hide('slide', {direction: 'up'}, 150, callback);
		}
		else {
			$('#mb').hide('slide', {direction: 'up'}, 800);
		}
	});
	return false;
}
