$(function(){
	focusBlur($('input[name="SearchString"]'), typeof(searchDefault) != 'undefined' ? searchDefault : '');
	focusBlur($('.subscribe input[name="NewsletterEmail"]'), typeof(newsDefault) != 'undefined' ? newsDefault : '');

	$('.add2cart').click(add2Cart);
	$('.add2wish').click(add2Wish);

	// Promos
	if ($('.promo ul li').length > 0) {
		$('.promo ul li:first-child').fadeIn();
		if ($('.promo ul li').length > 1) {
			setInterval(scrollPromos, 6000);
		}
	}

	$('form input[autofocus="true"]').focus();
});

var promo_c = 0;
function scrollPromos() {
	var i;
	if (promo_c == $('.promo ul li').length - 1) {
		i = 0;
	}
	else {
		i = promo_c + 1;
	}

	$('.promo li:eq('+promo_c+')').fadeOut(500, function(){
		$('.promo li:eq('+i+')').fadeIn(500);
	});
	promo_c = i;
}

function add2Cart() {
	var btn = $(this),
		pid = btn.attr('id').replace('p-', '');
		qty = parseInt($('#Qty').val())

	if (isNaN(qty)) {
		$('#Qty').focus();
		return false;
	}

	$('.p-loading').remove();
	btn.fadeTo(500, 0.3);

	$.post(sitePath+'/ajax/AddToBasket.asp', {ProductID: pid, Qty: qty}, function(data){
		if (data.success) {
			$('#cart-ticker #count').text(data.count);
			$('#cart-ticker #amount').text(data.amount);

			var basketData = new Array;
			basketData.push(data.product);
			showMiniBasket(basketData);
		}
		else {
			alert(data.message);
		}
		btn.fadeTo(300, 1);
	}, 'json');

	return false;
}

var add2WishCb = function(d){
	if (!d.success) {
		document.location.href = d.goTo;
		return;
	}
	$('.add2wish-load').addClass('add2wish-done').removeClass('add2wish-load');
	setTimeout(function(){
		$('.add2wish-done').fadeOut(function(){
			$(this).remove();
		});
	}, 2000);
};
function add2Wish() {
	var btn = $(this),
		pid = btn.attr('id').replace('w-', '');

	$('.add2wish-load,.add2wish-done').remove();
	btn.before('<div class="add2wish-load"><div></div></div>');

	$.ajax({
		url: sitePathSecure+'/ajax/WishList.asp',
		data: {ProductID: pid},
		type: 'GET',
		dataType: 'jsonp',
		jsonpCallback: 'add2WishCb'
	});
	return false;
}
