<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	If Request("Submit") <> "" Then
		sQuery = "SELECT t.OrderID" &_
				 "	   , t.TrackingNumber" &_
				 "	   , t.TrackingCost" &_
				 "	   , t.CarrierID" &_
				 "	   , t.CarrierMethod" &_
				 "	FROM utb_Tracking AS t" &_
				 "		 INNER JOIN utb_Orders AS o ON CAST(o.OrderID AS VARCHAR(50)) = t.OrderID" &_
				 " WHERE o.OrderStatusID = 9"

		Set oQuery = Server.CreateObject("ADODB.Recordset")
		oQuery.Open sQuery, oConn, 1, 3, 1

		Dim iRecordCount
		iRecordCount = oQuery.RecordCount

		oConn.BeginTrans
		On Error Resume Next

		Dim iIndex, arQuery, arQuery2, sOrderIds, sIdDelim
		sIdDelim = ""
		ReDim arQuery(iRecordCount)
		ReDim arQuery2(iRecordCount)
		While Not oQuery.Eof
			arQuery(iIndex) = "UPDATE utb_Orders" &_
							  "	  SET OrderDeliveryTracking = '" & Quote(oQuery("TrackingNumber")) & "'" &_
							  "		, OrderDeliveryCost = '" & Quote(DecimalPatch(oQuery("TrackingCost"))) & "'" &_
							  "		, OrderDeliveryCarrierID = '" & Quote(oQuery("CarrierID")) & "'" &_
							  "		, OrderDeliveryCarrierMethod = '" & Quote(oQuery("CarrierMethod")) & "'" &_
							  "		, OrderStatusID = 10" &_
							  "	WHERE OrderID = '" & Quote(oQuery("OrderID")) & "'"

			arQuery2(iIndex)= "INSERT INTO utb_OrderStatusChanges(OrderID, UserName, StatusName) " &_
							  "VALUES(" & Quote(oQuery("OrderID")) & ", '" & Session("UserNickName") & "', 'Shipped') "

			sOrderIds = sOrderIds & sIdDelim & oQuery("OrderID")
			sIdDelim = ","

			iIndex = iIndex + 1
			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing

		If UBound(arQuery) >= 0 Then
			oConn.Execute(Join(arQuery, vbNewLine))
		End If

		If UBound(arQuery2) >= 0 Then
			oConn.Execute(Join(arQuery2, vbNewLine))
		End If

		If sOrderIds <> "" Then
			sQuery = "DELETE" &_
					 "	FROM utb_Tracking" &_
					 " WHERE TrackingID IN(SELECT t.TrackingID" &_
					 "						 FROM utb_Tracking AS t" &_
					 "		 					  INNER JOIN utb_Orders AS o ON CAST(o.OrderID AS VARCHAR(50)) = t.OrderID" &_
					 "		 				WHERE o.OrderID IN(" & sOrderIds & "))"

			oConn.Execute(sQuery)
		End If

		If Err.Number = 0 Then
			oConn.CommitTrans
			Call SetAlertMessage("success", "Tracking numbers have been assigned.")
		Else
			oConn.RollbackTrans
			Call SetAlertMessage("error", Err.Description)
		End If

		Redirect("AssignTrackingNumbers.asp")
	End If

	Dim iAvailable : iAvailable = 0
	sQuery = "SELECT COUNT(*) AS RecordsCount" &_
			 "	FROM utb_Tracking AS t" &_
			 "		 INNER JOIN utb_Orders AS o ON CAST(o.OrderID AS VARCHAR(50)) = t.OrderID"
	Set oQuery = oConn.Execute(sQuery)
	iAvailable = oQuery("RecordsCount")
	oQuery.Close
	Set oQuery = Nothing

	Dim iReady : iReady = 0
	sQuery = "SELECT COUNT(*) AS RecordsCount" &_
			 "	FROM utb_Tracking AS t" &_
			 "		 INNER JOIN utb_Orders AS o ON CAST(o.OrderID AS VARCHAR(50)) = t.OrderID" &_
			 " WHERE o.OrderStatusID = 9"
	Set oQuery = oConn.Execute(sQuery)
	iReady = oQuery("RecordsCount")
	oQuery.Close
	Set oQuery = Nothing
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Assign tracking numbers</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2>Assign tracking numbers to orders</h2>
		</div>
		<div class="box">
			<form action="AssignTrackingNumbers.asp" method="post">
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td>Total <strong><%= iAvailable %></strong> tracking numbers available</td>
					</tr>
					<tr>
						<td>Total <strong><%= iReady %></strong> valid tracking numbers ready to assign</td>
					</tr>
				<%
				sQuery = "SELECT OrderID" &_
						 "	   , COUNT(*) AS TotalDup" &_
						 "	FROM utb_Tracking" &_
						 " GROUP BY OrderID " &_
						 "HAVING COUNT(*) > 1"
				Set oQuery = oConn.Execute(sQuery)
				If Not oQuery.Eof Then
					%>
					<tr>
						<td>There is a problems with duplicate orders.</td>
					</tr>
				<% Else %>
					<tr>
						<td><input type="submit" name="Submit" class="form-btn" value="Assign tracking numbers"<%= IIF(iReady = 0, " disabled='disabled'", "") %> /></td>
					</tr>
					<%
				End If
				oQuery.Close
				Set oQuery = Nothing
				%>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
