<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Upload.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	Dim oUploader
	Set oUploader = New FileUploader
	oUploader.Upload()

	iID = IIF(iID <> "", iID, oUploader.Form("ID"))
	sAction = IIF(sAction <> "", sAction, oUploader.Form("Action"))

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle 
	Dim iBannerID, sFileName, oFile, BannerLink, SortOrder
	Dim sImageName : sImageName = ""

	Select Case sAction
		Case "New"
			sTitle = "Add Banner"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Banner Ref #" & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Banners WHERE BannerID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				BannerLink = oQuery("BannerLink")
				SortOrder = oQuery("BannerSortOrder")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Banner"
		
			CommonValidation()

			If oUploader.Files.Count = 0 Then
				AddError("Field <strong>File</strong> is required.")
			End If
		
			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next
				sQuery = "INSERT INTO utb_Banners(BannerType, BannerLink, BannerSortOrder) " &_
						 "VALUES(" &_
						 "  'b' " &_
						 ", " & IIF(BannerLink = "", "NULL", "'" & Quote(BannerLink) & "'") &_
						 ", " & IIF(ValidateInteger(SortOrder), SortOrder, "NULL") &_
						 ")"
				oConn.Execute(sQuery)

				iBannerID = GetLastID(oConn)

				Set oFile = oUploader.Files.Item("File") 
				sFileName = MakeFileName("b", GetFileExtension(oFile.FileName), iBannerID)

				If Err.Number = 0 Then
					Call SaveBinaryData(Server.MapPath("..\" & "Files/Banners/") & "\" & sFileName, oFile.FileData)

					oConn.CommitTrans
					Call SetAlertMessage("success", "Banner has been inserted.")
					Redirect("BannerBigForm.asp?Action=Edit&ID=" & iBannerID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Banner # " & iID

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				iBannerID = iID
				Dim bFileExist : bFileExist = (oUploader.Files.Count > 0)
				
				If bFileExist Then
					Set oFile = oUploader.Files.Item("File") 
					sFileName = MakeFileName("l", GetFileExtension(oFile.FileName), iBannerID)
				End If

				sQuery = " UPDATE utb_Banners " & _
						 "	  SET BannerLink = " & IIF(oUploader.Form("BannerLink") <> "", "'" & Quote(oUploader.Form("BannerLink")) & "' ", "NULL") &_
						 "		, BannerSortOrder = " & IIF(ValidateInteger(SortOrder), SortOrder, "NULL") &_
						 "	WHERE BannerID = " & iBannerID
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					If bFileExist Then
						Call SaveBinaryData(Server.MapPath("..\" & "Files/Banners/") & "\" & sFileName, oFile.FileData)
					End If

					If Err.Number = 0 Then
						oConn.CommitTrans
						Call SetAlertMessage("success", "Banner has been updated.")
						Redirect("BannerBigForm.asp?Action=Edit&ID=" & iBannerID)
					Else
						oConn.RollbackTrans
						AddError(Err.Description)
					End If
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_Banners " & _
					 "  WHERE BannerID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				If iID > 0 Then
					Call DeleteFile(Server.MapPath("..\" & "Files/Banners/") & "/b_" & iID & ".jpg")
				End If

				oConn.CommitTrans
				Call SetAlertMessage("success", "Banner has been deleted.")
				Redirect("BannerBigList.asp")
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect("BannerBigList.asp")
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="BannerBigList.asp"> &laquo; Back</a>
	<h1>Slider Banners</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="BannerBigForm.asp" method="post" enctype="multipart/form-data">
		<input type="hidden" name="Action" id="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> File</td>
				<td><input type="file" name="File" style="width:400px;" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Link</td>
				<td><input type="text" class="form-field" name="BannerLink" value="<%= BannerLink %>" style="width:400px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Sort Order</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
		<% If iID > 0 Then %>
		<br />
		<table cellpadding="5" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td>
					<br />
					<img src="../Files/Banners/b_<%= iID %>.jpg" alt=""/>
				</td>
			</tr>
		</table>
		<% End If %>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		BannerLink = Trim(oUploader.Form("BannerLink"))
		SortOrder = Trim(oUploader.Form("SortOrder"))
	End Sub
%>