﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim iParentID : iParentID = Request("ParentID")
	Dim sBackURL : sBackURL = GetBackURL("CategoryList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, Link, Image, IsVisible, SortOrder, Description, Path, WhyYouNeedIt, MetaTitle, MetaDescription, MetaKey
	Dim Reserved1, Reserved2, Reserved3, Reserved4, Reserved5, Reserved6, Reserved7, Reserved8, Reserved9, Reserved10
	Dim iCategoryID

	Dim sImageName : sImageName = GetValueFromTable(oConn, "CategoryImage", "utb_Categories", "WHERE CategoryID = '" & Quote(iID) & "'")

	Select Case sAction
		Case "New"
			sTitle = "Add Category"
			sAction = "Insert"

			IsVisible = "1"
			SortOrder = "0"

		Case "Edit"
			sTitle = "Edit Category Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Categories WHERE CategoryID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("CategoryName"))
				Link = HTMLEncode(oQuery("CategoryLink"))
				IsVisible = oQuery("CategoryIsVisible")
				SortOrder = oQuery("CategoryIsFeatured")
				Description = oQuery("CategoryDescription")
				WhyYouNeedIt = HTMLEncode(oQuery("CategoryWhyYouNeedIt"))
				MetaTitle = HTMLEncode(oQuery("CategoryMetaTitle"))
				MetaDescription = HTMLEncode(oQuery("CategoryMetaDescription"))
				MetaKey = HTMLEncode(oQuery("CategoryMetaKey"))
				Reserved1 = HTMLEncode(oQuery("CategoryReserved1"))
				Reserved2 = HTMLEncode(oQuery("CategoryReserved2"))
				Reserved3 = HTMLEncode(oQuery("CategoryReserved3"))
				Reserved4 = HTMLEncode(oQuery("CategoryReserved4"))
				Reserved5 = HTMLEncode(oQuery("CategoryReserved5"))
				Reserved6 = HTMLEncode(oQuery("CategoryReserved6"))
				Reserved7 = HTMLEncode(oQuery("CategoryReserved7"))
				Reserved8 = HTMLEncode(oQuery("CategoryReserved8"))
				Reserved9 = HTMLEncode(oQuery("CategoryReserved9"))
				Reserved10 = HTMLEncode(oQuery("CategoryReserved10"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Category"

			CommonValidation()

			If GetValueFromTable(oConn, "CategoryID", "utb_Categories", "WHERE CategoryName = '" & Quote(Name) & "' AND ISNULL(ParentID, '') = '" & iParentID & "'") <> "" Then
				AddError("Category with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				Path = GetValueFromTable(oConn, "CategoryPath", "utb_Categories", "WHERE CategoryID = '" & Quote(iParentID) & "'")
				If Not IsNull(Path) Then
					Path = Path & "," & iParentID
					Link = GetValueFromTable(oConn, "CategoryLink", "utb_Categories", "WHERE CategoryID = '" & Quote(iParentID) & "'") & "/"
				Else
					Path = iParentID
				End If
				Link = Link & Text2Url(Name)

				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Categories(" &_
						 "	CategoryName" &_
						 ",	CategoryLink" &_
						 ", CategoryIsVisible" &_
						 ", CategoryIsFeatured" &_
						 ", CategoryDescription" &_
						 ", CategoryPath" &_
						 ", CategoryWhyYouNeedIt" &_
						 ", CategoryMetaTitle" &_
						 ", CategoryMetaDescription" &_
						 ", CategoryMetaKey" &_
						 ", ParentID" &_
						 ", CategoryReserved1" &_
						 ", CategoryReserved2" &_
						 ", CategoryReserved3" &_
						 ", CategoryReserved4" &_
						 ", CategoryReserved5" &_
						 ", CategoryReserved6" &_
						 ", CategoryReserved7" &_
						 ", CategoryReserved8" &_
						 ", CategoryReserved9" &_
						 ", CategoryReserved10" &_
						 ") " &_
						 "VALUES(" &_
						 "   '" & Quote(Name) & "'" &_
						 " , '" & Quote(Link) & "'" &_
						 " , " & IIF(IsVisible = "1", "1", "0") &_
						 " , '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "'" &_
						 " , " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") &_
						 " , " & IIF(Path <> "", "'" & Quote(Path) & "'", "NULL") &_
						 " , " & IIF(WhyYouNeedIt <> "", "'" & Quote(WhyYouNeedIt) & "'", "NULL") &_
						 " , " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") &_
						 " , " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") &_
						 " , " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") &_
						 " , " & IIF(iParentID <> "", "'" & Quote(iParentID) & "'", "NULL") &_
						 " , " & IIF(Reserved1 <> "", "'" & Quote(Reserved1) & "'", "NULL") &_
						 " , " & IIF(Reserved2 <> "", "'" & Quote(Reserved2) & "'", "NULL") &_
						 " , " & IIF(Reserved3 <> "", "'" & Quote(Reserved3) & "'", "NULL") &_
						 " , " & IIF(Reserved4 <> "", "'" & Quote(Reserved4) & "'", "NULL") &_
						 " , " & IIF(Reserved5 <> "", "'" & Quote(Reserved5) & "'", "NULL") &_
						 " , " & IIF(Reserved6 <> "", "'" & Quote(Reserved6) & "'", "NULL") &_
						 " , " & IIF(Reserved7 <> "", "'" & Quote(Reserved7) & "'", "NULL") &_
						 " , " & IIF(Reserved8 <> "", "'" & Quote(Reserved8) & "'", "NULL") &_
						 " , " & IIF(Reserved9 <> "", "'" & Quote(Reserved9) & "'", "NULL") &_
						 " , " & IIF(Reserved10 <> "", "'" & Quote(Reserved10) & "'", "NULL") &_
						 " ) "
				oConn.Execute(sQuery)

				iCategoryID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Category has been created.")
					Redirect("CategoryForm.asp?Action=Edit&ID=" & iCategoryID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Category Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "CategoryID", "utb_Categories", "WHERE CategoryName = '" & Quote(Name) & "' AND CategoryID <> '" & Quote(iID) & "' AND ISNULL(ParentID, '') = '" & iParentID & "'") <> "" Then
				AddError("Category with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				iParentID = GetValueFromTable(oConn, "ParentID", "utb_Categories", "WHERE CategoryID = " & iID)
				If Not IsNull(iParentID) Then
					Link = GetValueFromTable(oConn, "CategoryLink", "utb_Categories", "WHERE CategoryID = '" & Quote(iParentID) & "'") & "/"
				End If
				Link = Link & Text2Url(Name)

				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_Categories " & _
						 "	SET CategoryName = '" & Quote(Name) & "' " & _
						 "	  , CategoryLink = '" & Quote(Link) & "' " & _
						 "	  , CategoryIsVisible = " & IIF(IsVisible = "1", "1", "0") & " " & _
						 "	  , CategoryIsFeatured = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , CategoryDescription = " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 "	  , CategoryWhyYouNeedIt = " & IIF(WhyYouNeedIt <> "", "'" & Quote(WhyYouNeedIt) & "'", "NULL") & " " & _
						 "	  , CategoryMetaTitle = " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " & _
						 "	  , CategoryMetaDescription = " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " & _
						 "	  , CategoryMetaKey = " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " & _
						 "	  , CategoryReserved1 = " & IIF(Reserved1 <> "", "'" & Quote(Reserved1) & "'", "NULL") & " " & _
						 "	  , CategoryReserved2 = " & IIF(Reserved2 <> "", "'" & Quote(Reserved2) & "'", "NULL") & " " & _
						 "	  , CategoryReserved3 = " & IIF(Reserved3 <> "", "'" & Quote(Reserved3) & "'", "NULL") & " " & _
						 "	  , CategoryReserved4 = " & IIF(Reserved4 <> "", "'" & Quote(Reserved4) & "'", "NULL") & " " & _
						 "	  , CategoryReserved5 = " & IIF(Reserved5 <> "", "'" & Quote(Reserved5) & "'", "NULL") & " " & _
						 "	  , CategoryReserved6 = " & IIF(Reserved6 <> "", "'" & Quote(Reserved6) & "'", "NULL") & " " & _
						 "	  , CategoryReserved7 = " & IIF(Reserved7 <> "", "'" & Quote(Reserved7) & "'", "NULL") & " " & _
						 "	  , CategoryReserved8 = " & IIF(Reserved8 <> "", "'" & Quote(Reserved8) & "'", "NULL") & " " & _
						 "	  , CategoryReserved9 = " & IIF(Reserved9 <> "", "'" & Quote(Reserved9) & "'", "NULL") & " " & _
						 "	  , CategoryReserved10 = " & IIF(Reserved10 <> "", "'" & Quote(Reserved10) & "'", "NULL") & " " & _
						 "  WHERE CategoryID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iCategoryID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Category has been updated.")
					Redirect("CategoryForm.asp?Action=Edit&ID=" & iCategoryID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_Categories " & _
					 "  WHERE CategoryID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				If sImageName <> "" Then
					Call DeleteFile(Server.MapPath(C_CATEGORY_IMAGE_PATH) & "/" & sImageName)
				End If

				oConn.CommitTrans
				Call SetAlertMessage("success", "Category has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
		<script type="text/javascript" src="js/ajaxupload.js"></script>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Categories</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<!--#include file="../ckeditor/ckeditor.asp"-->
			<form action="CategoryForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>">
				<input type="hidden" name="ID" value="<%= iID %>">
				<input type="hidden" name="ParentID" value="<%= iParentID %>">
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width: 300px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsVisible">Visible</label></td>
						<td>
							<input type="checkbox" name="IsVisible" id="IsVisible" value="1"<%= IIF(IsVisible = "1", " checked='checked'", "") %>/>
						</td>
					</tr>
					<tr>
						<td style="text-align: right">Featured</td>
						<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width: 60px" maxlength="10"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Description</td>
						<td><%
							Set oEditor = New CKeditor
							oEditor.basePath = "../ckeditor/"
							oEditor.config("width") = 850
							oEditor.config("height") = 300
							oEditor.editor "Description", Description
						%>
						</td>
					</tr>
					<tr>
						<td style="text-align:right;">Why You Need It</td>
						<td><textarea class="form-field limited limit_2000" name="WhyYouNeedIt" style="width:500px;height:100px;"><%= WhyYouNeedIt %></textarea></td>
					</tr>
					<tr>
						<td style="text-align:right;">Meta Title</td>
						<td><textarea class="form-field limited limit_500" name="MetaTitle" style="width:500px;height:100px;"><%= MetaTitle %></textarea></td>
					</tr>
					<tr>
						<td style="text-align:right;">Meta Description</td>
						<td><textarea class="form-field limited limit_500" name="MetaDescription" style="width:500px;height:100px;"><%= MetaDescription %></textarea></td>
					</tr>
					<tr>
						<td style="text-align:right;">Meta Key</td>
						<td><textarea class="form-field limited limit_500" name="MetaKey" style="width:500px;height:100px;"><%= MetaKey %></textarea></td>
					</tr>
					<% If iID > 0 Then %>
					<tr>
						<td style="text-align:right;">Image</td>
						<td>
							<table>
								<tr>
									<td><img src="<%= IIF(sImageName <> "", C_CATEGORY_IMAGE_PATH & "/" & sImageName, C_NO_IMAGE_SMALL) %>" id="category_img" alt="" class="imgborder" /></td>
									<td style="vertical-align:bottom;" id="buttons_block">
										<div id="delete_button_block" style="padding-bottom:5px;<%= IIF(sImageName <> "", "", "display:none;") %>">
											<button id="delete_button" style="font-size:11px;width:60px;">Delete</button>
										</div>
										<div id="upload_button_block" style="padding-bottom:5px;">
											<button id="upload_button" style="font-size:11px;width:60px;">Browse</button>
										</div>
									</td>
								</tr>
							</table>
							<script type="text/javascript">
							//<![CDATA[
							var uploadingImg = '<div id="uploading_img" style="display:none;"><img src="images/uploading.gif" width="24" height="24" alt="Uploading..." /></div>';
							$(function(){
								$('#delete_button').click(function(){
									if (!areYouSure()) {
										return false;
									}

									$('#delete_button,#upload_button').hide();
									$('#buttons_block').append(uploadingImg);
									$('#uploading_img').fadeIn(function(){
										$.post('ajax/DeleteImage.asp', {Type: 'Category', ID: <%= iID %>}, function(res){
											$('#uploading_img').fadeOut(function(){
												$('#uploading_img').remove();

												if (res.success) {
													$('#delete_button_block').hide();
													$('#category_img').attr('src', res.src);
												}
												else if (typeof(res.redirect) != 'undefined') {
													redirect(res.redirect);
												}
												else if (typeof(res.message) != 'undefined') {
													alert('Error: ' + res.message);
												}
												else {
													alert('Unknown Error. Please contact support.');
												}
												$('#delete_button,#upload_button').show();
											});
										}, 'json');
									});

									return false;
								});
								new AjaxUpload('upload_button',{
									action: 'ajax/UploadImage.asp',
									name: 'File',
									responseType: 'json',
									data: {Type: 'Category', ID: <%= iID %>},
									onSubmit: function(file, ext){
										if (!(ext && /^(jpg|jpeg|gif|png)$/i.test(ext))){
											alert('Error: invalid file extension.');
											return false;
										}

										$('#delete_button,#upload_button').hide();
										$('#buttons_block').append(uploadingImg);
										$('#uploading_img').fadeIn();
									},
									onComplete: function(file, res){
										$('#uploading_img').fadeOut(function(){
											$('#uploading_img').remove();

											if (res.success) {
												$('#delete_button_block').show();
												$('#category_img').attr('src', res.src+'?rnd='+Math.random());
											}
											else if (typeof(res.redirect) != 'undefined') {
												redirect(res.redirect);
											}
											else if (typeof(res.message) != 'undefined') {
												alert('Error: ' + res.message);
											}
											else {
												alert('Unknown Error. Please contact support.');
											}
											$('#delete_button,#upload_button').show();
										});
									}
								});
							});
							//]]>
							</script>
						</td>
					</tr>
					<% End If %>
					<tr>
						<td style="text-align:right;">Reserved 1</td>
						<td><input type="text" class="form-field" name="Reserved1" value="<%= Reserved1 %>" style="width:700px;" maxlength="500" />&nbsp;Googlge</td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 2</td>
						<td><input type="text" class="form-field" name="Reserved2" value="<%= Reserved2 %>" style="width:700px;" maxlength="500" />&nbsp;Shopzilla</td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 3</td>
						<td><input type="text" class="form-field" name="Reserved3" value="<%= Reserved3 %>" style="width:700px;" maxlength="500" />&nbsp;Nex Tag</td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 4</td>
						<td><input type="text" class="form-field" name="Reserved4" value="<%= Reserved4 %>" style="width:700px;" maxlength="500" />&nbsp;Price Grabber</td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 5</td>
						<td><input type="text" class="form-field" name="Reserved5" value="<%= Reserved5 %>" style="width:700px;" maxlength="500" />&nbsp;Bing</td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 6</td>
						<td><input type="text" class="form-field" name="Reserved6" value="<%= Reserved6 %>" style="width: 700px" maxlength="500" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 7</td>
						<td><input type="text" class="form-field" name="Reserved7" value="<%= Reserved7 %>" style="width: 700px" maxlength="500" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 8</td>
						<td><input type="text" class="form-field" name="Reserved8" value="<%= Reserved8 %>" style="width: 700px" maxlength="500" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 9</td>
						<td><input type="text" class="form-field" name="Reserved9" value="<%= Reserved9 %>" style="width: 700px" maxlength="500" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Reserved 10</td>
						<td><input type="text" class="form-field" name="Reserved10" value="<%= Reserved10 %>" style="width: 700px" maxlength="500" /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		IsVisible = Trim(Request("IsVisible"))
		SortOrder = Trim(Request("SortOrder"))
		Description = Trim(Request("Description"))
		WhyYouNeedIt = Trim(Request("WhyYouNeedIt"))
		MetaTitle = Trim(Request("MetaTitle"))
		MetaDescription = Trim(Request("MetaDescription"))
		MetaKey = Trim(Request("MetaKey"))
		Reserved1 = Trim(Request("Reserved1"))
		Reserved2 = Trim(Request("Reserved2"))
		Reserved3 = Trim(Request("Reserved3"))
		Reserved4 = Trim(Request("Reserved4"))
		Reserved5 = Trim(Request("Reserved5"))
		Reserved6 = Trim(Request("Reserved6"))
		Reserved7 = Trim(Request("Reserved7"))
		Reserved8 = Trim(Request("Reserved8"))
		Reserved9 = Trim(Request("Reserved9"))
		Reserved10 = Trim(Request("Reserved10"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Featured</strong> is invalid.")
			End If
		End If

		If Reserved10 <> "" And Not ValidateDecimal(Reserved10) Then
			AddError("Field <strong>Reserved 10</strong> is invalid.")
		End If
	End Sub
%>