<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iParentID, sCatPaths, sBreadCrumbs
	iParentID = IIF(ValidateInteger(Request("ParentID")), Request("ParentID"), 0)
	sCatPaths = GetValueFromTable(oConn, "CategoryPath", "utb_Categories", "WHERE CategoryID = " & iParentID)
	sCatPaths = IIF(iParentID <> 0, IIF(sCatPaths <> "", sCatPaths & "," & iParentID, iParentID), sCatPaths)

	sBreadCrumbs = "<a href='CategoryList.asp'>Categories</a>"
	If sCatPaths <> "" Then
		Set oQuery = oConn.Execute("SELECT * FROM utb_Categories WHERE CategoryID IN(" & sCatPaths & ")")
		While Not oQuery.Eof
			sBreadCrumbs = sBreadCrumbs &_
				" / <a href='CategoryList.asp?ParentID=" & oQuery("CategoryID") & "'>" & oQuery("CategoryName") & "</a>"

			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing
	End If

	Dim sWhere : sWhere = " WHERE ISNULL(ParentID, '0') = '" & iParentID & "' "
	Dim sOrder, sArrow, sOrderBy
	sOrder = "3"
	sArrow = "1"
	If Request("Order") <> "" And Request("Arrow") <> "" Then
		sOrder = Request("Order")
		sArrow = Request("Arrow")
	End If
	sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")
	sQuery = " SELECT * " & _
			 "	  , (CASE WHEN ISNULL(CategoryDescription, '') <> '' THEN 1 ELSE 0 END) AS _CategoryDescription " & _
			 "	  , (CASE WHEN ISNULL(CategoryMetaTitle, '') <> '' THEN 1 ELSE 0 END) AS _CategoryMetaTitle " & _
			 "	  , (CASE WHEN ISNULL(CategoryMetaDescription, '') <> '' THEN 1 ELSE 0 END) AS _CategoryMetaDescription " & _
			 "	  , (CASE WHEN ISNULL(CategoryMetaKey, '') <> '' THEN 1 ELSE 0 END) AS _CategoryMetaKey " & _
			 "	  , (CASE WHEN ISNULL(CategoryImage, '') <> '' THEN 1 ELSE 0 END) AS _CategoryImage " & _
			 "	  , (SELECT COUNT(*) FROM utb_Categories WHERE ParentID = c.CategoryID) AS CategoryChildCount " & _
			 "	  , (SELECT COUNT(*) FROM utb_ProductCategories WHERE CategoryID = c.CategoryID) AS CategoryProductCount " & _
			 "   FROM utb_Categories c " & _
			 sWhere & _
			 sOrderBy

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Categories</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<% If iParentID > 0 Then %>
			<a class="head-link-right icon-add" href="CategoryForm.asp?Action=New&amp;ID=0<%= IIF(iParentID <> "0", "&amp;ParentID=" & iParentID, "") %>">Add Category</a>
			<% End If %>
			<h2><%= sBreadCrumbs %></h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width:50px;"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:90px;"><%= GetURLForOrder("Featured", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:90px;"><%= GetURLForOrder("Description", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:80px;"><%= GetURLForOrder("Meta Title", "5", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:120px;"><%= GetURLForOrder("Meta Description", "6", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:80px;"><%= GetURLForOrder("Meta Key", "7", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:60px;"><%= GetURLForOrder("Image", "8", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:70px;"><%= GetURLForOrder("Products", "9", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:50px;">&nbsp;</td>
			</tr>
			<%  
				Dim iCount : iCount = 0
				While Not oQuery.Eof 
					iCount = iCount + 1
			%>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td><%= oQuery("CategoryID") %></td>
				<td style="text-align:left;"><a href="CategoryList.asp?ParentID=<%= oQuery("CategoryID") %>"><%= oQuery("CategoryName") %></a></td>
				<td><%= oQuery("CategoryIsFeatured") %></td>
				<td><%= IIF(oQuery("_CategoryDescription") = 1, "Yes", "No") %></td>
				<td><%= IIF(oQuery("_CategoryMetaTitle") = 1, "Yes", "No") %></td>
				<td><%= IIF(oQuery("_CategoryMetaDescription") = 1, "Yes", "No") %></td>
				<td><%= IIF(oQuery("_CategoryMetaKey") = 1, "Yes", "No") %></td>
				<td><%= IIF(oQuery("_CategoryImage") = 1, "Yes", "No") %></td>
				<td><a href="CategoryProductList.asp?CategoryID=<%= oQuery("CategoryID") %>"><%= oQuery("CategoryProductCount") %></a></td>
				<td>
					<a href="CategoryForm.asp?Action=Edit&amp;ID=<%= oQuery("CategoryID") %>"><img src="images/grid-act-edit.png" alt="" title="Edit" width="16" height="16" /></a>
					&nbsp;
					<% If oQuery("CategoryChildCount") = 0 And oQuery("CategoryProductCount") = 0 Then %>
					<a href="CategoryForm.asp?Action=Delete&amp;ID=<%= oQuery("CategoryID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16" /></a>
					<% Else %>
					<img src="images/grid-act-delete-gray.png" alt="" title="" width="16" height="16" />
					<% End If %>
				</td>
			</tr>
			<%
					oQuery.MoveNext
				Wend
			%>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "CategoryID"

		Select Case sIndex
			Case "1" sColumn = "CategoryID"
			Case "2" sColumn = "CategoryName"
			Case "3" sColumn = "CategoryIsFeatured"
			Case "4" sColumn = "(CASE WHEN ISNULL(CategoryDescription, '') <> '' THEN 1 ELSE 0 END)"
			Case "5" sColumn = "(CASE WHEN ISNULL(CategoryMetaTitle, '') <> '' THEN 1 ELSE 0 END)"
			Case "6" sColumn = "(CASE WHEN ISNULL(CategoryMetaDescription, '') <> '' THEN 1 ELSE 0 END)"
			Case "7" sColumn = "(CASE WHEN ISNULL(CategoryMetaKey, '') <> '' THEN 1 ELSE 0 END)"
			Case "8" sColumn = "(CASE WHEN ISNULL(CategoryImage, '') <> '' THEN 1 ELSE 0 END)"
			Case "9" sColumn = "(SELECT COUNT(*) FROM utb_ProductCategories WHERE CategoryID = c.CategoryID)"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>