<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sID : sID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("CountryList.asp")

	If Not ValidateCode(sID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Code, Name, SortOrder, IsActiveBilling, IsActiveShipping, Markup
	Dim sCountryID

	Select Case sAction
		Case "Edit"
			sTitle = "Edit Country Ref # " & sID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Countries WHERE CountryCode = '" & Quote(sID) & "' ")
			If Not oQuery.Eof Then
				Code = oQuery("CountryCode")
				Name = oQuery("CountryName")
				SortOrder = oQuery("CountrySortOrder")
				IsActiveBilling = oQuery("CountryIsActiveBilling")
				IsActiveShipping = oQuery("CountryIsActiveShipping")
				Markup = DecimalFormat(oQuery("CountryMarkup"), 2)
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Update"
			sTitle = "Edit Country Ref # " & sID
		
			CommonValidation()
		
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " UPDATE utb_Countries " & _
						 "	SET CountrySortOrder = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , CountryIsActiveBilling = '" & Quote(IsActiveBilling) & "' " & _
						 "	  , CountryIsActiveShipping = '" & Quote(IsActiveShipping) & "' " & _
						 "	  , CountryMarkup = '" & IIF(Markup = "", "0", Quote(DecimalPatch(Markup))) & "' " & _
						 "  WHERE CountryCode = '" & Quote(sID) & "' "
				oConn.Execute(sQuery)
		
				sCountryID = sID
		
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Country has been updated.")
					Redirect("CountryForm.asp?Action=Edit&ID=" & sCountryID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Countries</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="CountryForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>" />
				<input type="hidden" name="ID" value="<%= sID %>" />
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;">Code</td>
						<td><strong><%= Code %></strong><input type="hidden" name="Code" value="<%= Code %>" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Name</td>
						<td><strong><%= Name %></strong><input type="hidden" name="Name" value="<%= Name %>" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Sort Order</td>
						<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><label for="IsActiveBilling">Billing Active</label></td>
						<td>
							<input type="checkbox" name="IsActiveBilling" id="IsActiveBilling" value="1" <%= IIF(IsActiveBilling = "1", "checked='checked'", "") %> />
						</td>
					</tr>
					<tr>
						<td style="text-align:right;"><label for="IsActiveShipping">Shipping Active</label></td>
						<td>
							<input type="checkbox" name="IsActiveShipping" id="IsActiveShipping" value="1" <%= IIF(IsActiveShipping = "1", "checked='checked'", "") %> />
						</td>
					</tr>
					<tr>
						<td style="text-align:right;">Markup</td>
						<td><input type="text" class="form-field" name="Markup" value="<%= Markup %>" style="width:60px;" maxlength="15" /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Code = Trim(Request("Code"))
		Name = Trim(Request("Name"))
		SortOrder = Trim(Request("SortOrder"))
		IsActiveBilling = Trim(Request("IsActiveBilling"))
		IsActiveShipping = Trim(Request("IsActiveShipping"))
		Markup = Trim(Request("Markup"))

		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
		If Markup <> "" Then
			If Not ValidateDecimal(Markup) Then
				AddError("Field <strong>Markup</strong> is invalid.")
			End If
		End If
	End Sub
%>