﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/JSON.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim BasketID : BasketID = Trim(Request("BasketID"))
	Dim showBasket : showBasket = False
	If BasketID <> "" Then
		If Not ValidateInteger(BasketID) Then
			AddError("<strong>Basket ID</strong> is invalid.")
		Else
			If GetValueFromTable(oConn, "COUNT(*)", "utb_Basket", "WHERE BasketCustomerID = " & BasketID) <> 0 Then
				showBasket = True
			Else
				AddError("Shopping cart is empty.")
			End If
		End If
	End If

	Dim fSubTotal, fTaxRate, fTax, fGrandTotal
	Dim PromoDiscount, PromoMessage
	Dim ShippingName, ShippingValue, ShippingDiscount, ShippingDiscountID
	
	ShippingDiscount = 0

	If Request("jAction") <> "" Then
		Dim jsonOut
		Set jsonOut = jsObject()
		jsonOut("success") = False

		Dim totalsSubTotal, totalsShipping, totalsPromo, totalsTax, totalsGrandTotal

		Select Case Request("jAction")
			Case "updateQty"
				Dim iQty, iCounter
				Dim arQtys : arQtys = Split(Request("Qtys"), ",")
				Dim arQtyIds : arQtyIds = Split(Request("Ids"), ",")

				Dim sXML
				For Each iQty In arQtys
					sXML = sXML & "<i p=""" & arQtyIds(iCounter) & """ q=""" & iQty &  """/>"
					iCounter = iCounter + 1
				Next
				sXML = "<r>" & sXML & "</r>"

				On Error Resume Next
				oConn.BeginTrans

				Set oQuery = oConn.Execute("EXEC usp_BasketUpd @BasketCustomerID = '" & Quote(BasketID) & "', @XML = '" & Quote(sXML) & "', @CheckQuantity = '" & GetSetting(oConn, "CompanyIsCheckQuantity") & "'")
				If CInt(oQuery("OverLimit")) > 0 Then
					AddError("You have exceeded the max order quantity, your qty has been adjusting accordingly to the inventory available.")
				End If
				oQuery.Close
				Set oQuery = Nothing

				If Err.Number = 0 Then
					oConn.CommitTrans

					Set jsonOut("items") = jsArray()
					Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = " & BasketID)
					While Not oQuery.Eof
						If CInt(oQuery("DisplayType")) = 0 Or CInt(oQuery("DisplayType")) = 1 Then
							Set jsonOut("items")(Null) = jsObject()

							jsonOut("items")(Null)("id") = oQuery("ProductID")
							jsonOut("items")(Null)("qty") = oQuery("BasketQuantity")
							jsonOut("items")(Null)("price_total") = CurrencyFormat(CCur(oQuery("ProductPrice")) * oQuery("BasketQuantity"), 2)
						End If
						oQuery.MoveNext
					Wend
					oQuery.Close
					Set oQuery = Nothing

					jsonOut("success") = True
					jsonOut("message") = GetMessage("success", "Basket has been updated.")
				Else
					oConn.RollbackTrans
					jsonOut("message") = GetMessage("error", Err.Description)
				End If

			Case "applyPromo"
				If GetPromoDiscount(BasketID, Request("PromoCode"), Request("Country"), Request("State")) Then
					jsonOut("success") = True
				Else
					jsonOut("message") = GetMessage("error", PromoMessage)
				End If

			Case "calcShipping"
				jsonOut("success") = True
				Set jsonOut("items") = jsArray()

				If Request("Country") <> "" And Request("State") <> "" Then
					Call GetPromoDiscount(BasketID, Request("PromoCode"), Request("Country"), Request("State"))

					Dim fValue
					sQuery = "EXEC usp_ShippingRatesGet" &_
							 "	@BasketCustomerID = " & BasketID &_
							 ", @CountryCode = '" & Quote(Request("Country")) & "'" &_
							 ", @StateID = '" & Quote(Request("State")) & "'"

					Set oQuery = oConn.Execute(sQuery)
					While Not oQuery.Eof
						Set jsonOut("items")(Null) = jsObject()

						fValue = CCur(oQuery("ShippingTotal"))
						If CStr(oQuery("ShippingMethodID")) = CStr(ShippingDiscountID) Then
							fValue = fValue - ShippingDiscount
						End If
	
						jsonOut("items")(Null)("id") = oQuery("ShippingMethodID")
						jsonOut("items")(Null)("name") = oQuery("ShippingMethodName") & " - " & IIF(fValue = 0, "free", CurrencyFormat(fValue, 2))
						oQuery.MoveNext
					Wend
					oQuery.Close
					Set oQuery = Nothing
				End If

			Case "recountTotals"
				jsonOut("success") = True

			Case "addToCart"
				Dim pIds : pIds = Trim(Request("ids"))

				If pIds <> "" Then
					Dim pIdsArr : pIdsArr = Split(pIds, ",")
					Dim i
					sQuery = ""

					On Error Resume Next
					oConn.BeginTrans
					For i = 0 To UBound(pIdsArr)
						sQuery = sQuery & "EXEC usp_BasketAdd" &_
								 "				@BasketCustomerID = " & BasketID &_
								 "			  , @ProductID = '" & Quote(Trim(pIdsArr(i))) & "'" &_
								 "			  , @BasketQuantity = 1" & vbNewLine
					Next
					oConn.Execute(sQuery)
				End If

				If Err.Number = 0 Then
					oConn.CommitTrans

					jsonOut("success") = True
					jsonOut("message") = GetMessage("success", "Products have been added to cart.")
				Else
					oConn.RollbackTrans
					jsonOut("message") = GetMessage("error", Err.Description)
				End If

			Case "placeOrder"
				On Error Resume Next
				oConn.BeginTrans

				Call RecountTotals(BasketID, Request("Country"), Request("State"), Request("ShippingID"), Request("PromoCode"))

				Dim orderState : orderState = ""
				If ValidateInteger(Request("State")) Then
					orderState = GetValueFromTable(oConn, "StateCode", "utb_States", "WHERE StateID = " & Request("State"))
				End If
				
				sQuery = "EXEC usp_OrderAdd" &_
						 "	@OrderEmail					= NULL" &_
						 ",	@BasketCustomerID			= " & BasketID &_
						 ", @ItemsXML					= NULL" &_

						 ", @OrderBillingFirstName		= NULL" &_
						 ", @OrderBillingLastName		= NULL" &_
						 ", @OrderBillingCompanyName 	= NULL" &_
						 ", @OrderBillingCountry		= NULL" &_
						 ", @OrderBillingAddress1		= NULL" &_
						 ", @OrderBillingAddress2		= NULL" &_
						 ", @OrderBillingCity			= NULL" &_
						 ", @OrderBillingState			= NULL" &_
						 ", @OrderBillingZip			= NULL" &_
						 ", @OrderBillingHomePhone		= NULL" &_
						 ", @OrderBillingAltPhone		= NULL" &_

						 ", @OrderShippingFirstName		= NULL" &_
						 ", @OrderShippingLastName		= NULL" &_
						 ", @OrderShippingCompanyName	= NULL" &_
						 ", @OrderShippingCountry		=  " & IIF(Request("Country") <> "", "'" & Quote(Request("Country")) & "'", "NULL") &_
						 ", @OrderShippingAddress1		= NULL" &_
						 ", @OrderShippingAddress2		= NULL" &_
						 ", @OrderShippingCity			= NULL" &_
						 ", @OrderShippingState			=  " & IIF(orderState <> "", "'" & Quote(orderState) & "'", "NULL") &_
						 ", @OrderShippingZip			= NULL" &_
						 ", @OrderShippingHomePhone		= NULL" &_
						 ", @OrderShippingAltPhone		= NULL" &_

						 ", @PaymentTypeID 				= NULL" &_
						 ", @OrderAccountName			= NULL" &_
						 ", @OrderAccountNumber1		= NULL" &_
						 ", @OrderAccountNumber2		= NULL" &_
						 ", @OrderAccountNumber3		= NULL" &_
						 ", @OrderAccountNumber4		= NULL" &_
						 ", @OrderCardExpMonth			= NULL" &_
						 ", @OrderCardExpYear			= NULL" &_
						 ", @OrderCard4Digits			= NULL" &_

						 ", @OrderDeliveryMethod		= '" & Quote(ShippingName) & "'" &_
						 ", @OrderDeliveryPrice			= '" & Quote(DecimalPatch(totalsShipping)) & "'" &_
						 ", @OrderPromoCode				=  " & IIF(Request("PromoCode") <> "", "'" & Quote(Request("PromoCode")) & "'", "NULL") &_
						 ", @OrderPromoAmount			= '" & Quote(DecimalPatch(totalsPromo)) & "'" &_
						 ", @OrderTaxAmount				= '" & Quote(DecimalPatch(totalsTax)) & "'" &_
						 ", @OrderTaxExemption			= 0" &_
						 ", @OrderCustomerNotes			= NULL" &_
						 ", @OrderReferral 				= NULL" &_
						 ", @OrderReferralCode 			= NULL" &_
						 ", @OrderIP 					= '" & Quote(Request.ServerVariables("REMOTE_ADDR")) & "'" &_
						 ", @OrderMerchantAltID			= NULL" &_
						 ", @HearFromID					= NULL" &_
						 ", @OrderCreateUser			= NULL" &_
						 ", @SalesmanUserID				= " & Session("UserID")

			Dim iOrderID
			Set oQuery = oConn.Execute(sQuery)
			iOrderID = CLng(oQuery("OrderId"))
			oQuery.Close
			Set oQuery = Nothing
			If Err.Number = 0 Then
				oConn.CommitTrans
				jsonOut("success") = True
				jsonOut("redirect") = "OrderForm.asp?OrderID=" & iOrderID
				Call SetAlertMessage("success", "Order has been created successfully.")
			Else
				oConn.RollbackTrans
				jsonOut("message") = GetMessage("error", Err.Description)
			End If
			jsonOut.Flush
			Response.End
		End Select

		Call RecountTotals(BasketID, Request("Country"), Request("State"), Request("ShippingID"), Request("PromoCode"))
		jsonOut("subtotal")		= CurrencyFormat(totalsSubTotal, 2)
		jsonOut("shipping")		= CurrencyFormat(totalsShipping, 2)
		jsonOut("promo")		= CurrencyFormat(totalsPromo, 2)
		jsonOut("tax")			= CurrencyFormat(totalsTax, 2)
		jsonOut("grand_total")	= CurrencyFormat(totalsGrandTotal, 2)

		jsonOut.Flush
		Response.End
	End If

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Customer Basket Review</h1>
			&nbsp;
		</div>
		<span id="alert"><!--#include file="../inc/Alert.asp"--></span>
		<div class="box-head">
			<div>
				<%
				Dim sDefault : sDefault = "Basket ID"
				Dim sValue : sValue = IIF(BasketID = "", sDefault, BasketID)
				%>
				<form action="CustomerBasket.asp?BasketID=<%= BasketID %>" method="get" onsubmit="if($('#BasketID').val() == '<%= sDefault %>'){$('#BasketID').focus(); return false}">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td><input type="text" class="form-field" name="BasketID" id="BasketID" value="<%= sValue %>" maxlength="10" style="width: 97px" onfocus="if(this.value=='<%= sDefault %>')this.value=''" onblur="if(this.value=='')this.value='<%= sDefault %>'"/></td>
							<td>&nbsp;</td>
							<td><input type="submit" class="inline-btn" value="Search"/></td>
						</tr>
					</table>
				</form>
			</div>
		</div>
		<%
		Dim iDisplayType, iProductID, sSKU, sStatus, sPrice, sQty
		Dim iProductCounter : iProductCounter = 0
		Dim iKitCounter : iKitCounter = 0
		Dim iGiftCounter : iGiftCounter = 0

		If showBasket Then
			Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = " & BasketID)
			If Not oQuery.Eof Then
				%>
				<form action="CustomerBasket.asp?BasketID=<%= BasketID %>" method="post" class="default cbasket">
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
						<thead>
							<tr class="head-line">
								<td style="width: 120px">Sku</td>
								<td>Item</td>
								<td style="width: 70px">Price</td>
								<td style="width: 70px">Stock</td>
								<td style="width: 75px">Qty</td>
								<td style="width: 70px">Total</td>
								<td style="width: 50px">&nbsp;</td>
							</tr>
						</thead>
						<tbody id="basket-items">
							<%
							fSubTotal = 0
							i = 0
							While Not oQuery.Eof
								iDisplayType = CInt(oQuery("DisplayType"))
								If iDisplayType = 0 Or iDisplayType = 1 Then
									If iProductCounter > 0 Then
										If iKitCounter > 0 Or iGiftCounter > 0 Then
											%></ul></div><%
										End If
										%>
										</td>
										<td style="text-align: right" class="price"><%= CurrencyFormat(sPrice, 2) %></td>
										<td><%= sStatus %></td>
										<td><input type="text" name="qty-<%= iProductID %>" class="qty" value="<%= sQty %>" maxlength="4"/></td>
										<td style="text-align: right" class="price_total"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
										<td>
											<a href="#accessories-<%= iProductID %>" class="search-accessories" title="Search Accessories"><img src="images/p_accessories.png" alt="" width="16" height="16"/></a>
											&nbsp;
											<a href="#remove-<%= iProductID %>" class="remove-item" title="Remove Item"><img src="images/grid-act-delete.png" alt="" width="16" height="16"/></a>
										</td>
									</tr>
									<%
									End If

									iProductID = oQuery("ProductID")
									sSKU	= oQuery("ProductSKU")
									sStatus	= oQuery("ProductStatusName")
									sPrice	= oQuery("ProductPrice")
									sQty	= oQuery("BasketQuantity")
									%>
									<tr class="product-<%= oQuery("ProductID") & IIF(i Mod 2 = 0, "", " row-hl") %>">
										<td style="text-align: left"><%= sSKU %></td>
										<td style="text-align: left">
											<%= oQuery("ProductName") %>
											<%
								ElseIf iDisplayType = 2 Then
									If iKitCounter = 0 Then
										%><div class="kits-free"><strong>Kit Items:</strong><ul><%
									End If
									%><li><%= oQuery("ProductName") %></li><%
								ElseIf iDisplayType = 3 Then
									If iGiftCounter = 0 Then
										If iKitCounter > 0 Then
											%></ul></div><%
										End If
										%><div class="kits-free"><strong>Free Items:</strong><ul><%
									End If
									%><li><%= oQuery("ProductName") %></li><%
								End If

								Select Case iDisplayType
									Case 0
										iProductCounter = iProductCounter + 1
										iKitCounter = 0
										iGiftCounter = 0
									Case 1
										iProductCounter = iProductCounter + 1
										iKitCounter = 0
										iGiftCounter = 0
									Case 2
										iKitCounter = iKitCounter + 1
									Case 3
										iGiftCounter = iGiftCounter + 1
								End Select

								fSubTotal = fSubTotal + CCur(oQuery("ProductPrice")) * CCur(oQuery("BasketQuantity"))
								i = i + 1
								oQuery.MoveNext
							Wend

							If iKitCounter > 0 Or iGiftCounter > 0 Then
								%></ul></div><%
							End If
								%>
								</td>
								<td style="text-align: right" class="price"><%= CurrencyFormat(sPrice, 2) %></td>
								<td><%= sStatus %></td>
								<td><input type="text" name="qty-<%= iProductID %>" class="qty" value="<%= sQty %>" maxlength="4"/></td>
								<td style="text-align: right" class="price_total"><%= CurrencyFormat(CCur(sPrice) * CCur(sQty), 2) %></td>
								<td>
									<a href="#accessories-<%= iProductID %>" class="search-accessories" title="Search Accessories"><img src="images/p_accessories.png" alt="" width="16" height="16"/></a>
									&nbsp;
									<a href="#remove-<%= iProductID %>" class="remove-item" title="Remove Item"><img src="images/grid-act-delete.png" alt="" width="16" height="16"/></a>
								</td>
							</tr>
						</tbody>
					</table>
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
						<tfoot id="basket-totals">
							<tr class="cbasket-totals<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
								<td style="width: 120px; text-align: center; border-right-width: 0; border-top: 0; padding: 2px 0.4em"><input type="button" value="Update" class="inline-btn update-btn"/></td>
								<td style="border-left: 0; border-top: 0; border-right: 0">&nbsp;</td>
								<td style="border-left: 0; border-top: 0; width: 75px">Sub Total:</td>
								<td style="width: 70px; border-top: 0" class="subtotal"><%= CurrencyFormat(fSubTotal, 2) %></td>
								<td style="width: 50px; border-top: 0">&nbsp;</td>
							</tr>
							<% i = i + 1 %>
							<tr class="cbasket-totals<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
								<td colspan="2" style="border-right-width: 0; padding: 2px 0.4em">
									<table class="internal_table" align="right">
										<tr>
											<td><span>Country:</span></td>
											<td>&nbsp;</td>
											<td>
												<select id="ShippingCountry" name="ShippingCountry" class="selector" style="width: auto">
													<option value="">Select One</option>
													<%
													Dim oShippingCountry
													Set oShippingCountry = oConn.Execute("SELECT CountryCode, CountryName FROM utb_Countries WHERE CountryIsActiveShipping = 1 ORDER BY CountrySortOrder, CountryName")
													While Not oShippingCountry.Eof
														%><option value="<%= oShippingCountry("CountryCode") %>"<%= IIF(oShippingCountry("CountryCode") = C_DEFAULT_COUNTRY_CODE, " selected=""selected""", "") %>><%= oShippingCountry("CountryName") %></option><%
														oShippingCountry.MoveNext
													Wend
													oShippingCountry.Close
													Set oShippingCountry = Nothing
													%>
												</select>
											</td>
											<td>&nbsp;&nbsp;&nbsp;</td>
											<td><span>State:</span></td>
											<td>&nbsp;</td>
											<td>
												<select id="ShippingState" name="ShippingState" class="selector-nowidth" style="margin-right: 5px">
													<option value="">Select One</option>
													<%
													Dim oShippingState
													Set oShippingState = oConn.Execute("SELECT StateID, StateName FROM utb_States WHERE CountryCode = '" & Quote(C_DEFAULT_COUNTRY_CODE) & "' ORDER BY StateName")
													While Not oShippingState.Eof
														%><option value="<%= oShippingState("StateID") %>"><%= oShippingState("StateName") %></option><%
														oShippingState.MoveNext
													Wend
													oShippingState.Close
													Set oShippingState = Nothing
													%>
												</select>
											</td>
											<td>&nbsp;&nbsp;&nbsp;</td>
											<td><span>Method:</span></td>
											<td>&nbsp;</td>
											<td>
												<select name="Shipping" id="Shipping" class="selector-nowidth" style="margin-right: 5px"></select>
											</td>
										</tr>
									</table>
								</td>
								<td style="border-left-width: 0">Shipping:</td>
								<td class="shipping"><%= CurrencyFormat(0, 2) %></td>
								<td style="text-align: center; padding: 0"><img src="images/ae.gif" alt="" id="load-shipping" style="display: none"/></td>
							</tr>
							<% i = i + 1 %>
							<tr class="cbasket-totals<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
								<td colspan="2" style="border-right-width: 0; padding: 2px 0.4em">
									<table class="internal_table" align="right">
										<tr>
											<td><span>Promo Code:</span></td>
											<td>&nbsp;</td>
											<td><input type="text" name="PromoCode" id="PromoCode" value="" style="width: 67px" maxlength="8" class="form-field"/></td>
											<td>&nbsp;</td>
											<td><input type="button" value="Apply" class="promo-btn inline-btn" style="width: 80px; margin-right: 6px"/></td>
										</tr>
									</table>
								</td>
								<td style="border-left-width: 0">Promo:</td>
								<td class="promo"><%= CurrencyFormat(0, 2) %></td>
								<td style="text-align: center"><img src="images/ae.gif" alt="" id="load-promo" style="display: none"/></td>
							</tr>
							<% i = i + 1 %>
							<tr class="cbasket-totals<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
								<td colspan="2" style="border-right-width: 0">&nbsp;</td>
								<td style="border-left-width: 0; padding-top: 6px; padding-bottom: 6px">Tax:</td>
								<td class="tax"><%= CurrencyFormat(0, 2) %></td>
								<td>&nbsp;</td>
							</tr>
							<% i = i + 1 %>
							<tr class="cbasket-totals<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
								<td colspan="2" style="border-right-width: 0">&nbsp;</td>
								<td style="border-left-width: 0; color: red; padding-top: 6px; padding-bottom: 6px">Grand Total:</td>
								<td class="grand_total"><%= CurrencyFormat(fSubTotal, 2) %></td>
								<td style="text-align: center"><img src="images/ae.gif" alt="" id="load-place" style="display: none"/></td>
							</tr>
						</tfoot>
					</table>

					<div style="float: right; padding-top: 5px" id="place-order">
						<input type="button" class="inline-btn" value="Place Order"/>
					</div>
					<div style="float: left; padding-top: 5px">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td><input type="text" value="Search Products" name="DetailsSearch" id="DetailsSearch" class="form-field" style="width: 230px" onfocus="if(this.value=='Search Products')this.value=''" onblur="if(this.value=='')this.value='Search Products'"/></td>
								<td>&nbsp;</td>
								<td><input type="button" value="Search" class="inline-btn search-products"/></td>
							</tr>
						</table>
					</div>
					<div style="clear: both"></div>
				</form>
				<br/>

				<div id="search-results" style="display: none"></div>
				<div style="height: 30px; padding-top: 5px">
					<input type="button" class="inline-btn addtocart" value="" style="display: none; width: 125px"/>
				</div>
				<script type="text/javascript">var BasketID = <%= BasketID %>, zeroAmount = '<%= CurrencyFormat(0, 2) %>';</script>
				<script type="text/javascript" src="js/customer-basket.js"></script>
				<%
			End If
			oQuery.Close
			Set oQuery = Nothing
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
Public Function GetSubTotal(BasketID)
	Dim fSubTotal : fSubTotal = 0
	Set oQuery = oConn.Execute("EXEC usp_BasketGet @BasketCustomerID = " & BasketID)
	While Not oQuery.Eof
		If CInt(oQuery("DisplayType")) = 0 Or CInt(oQuery("DisplayType")) = 1 Then
			fSubTotal = fSubTotal + CCur(oQuery("ProductPrice")) * CCur(oQuery("BasketQuantity"))
		End If
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

	GetSubTotal = fSubTotal
End Function

Public Function GetShipping(BasketID, Country, State, ShippingID)
	Country = Trim(Country)
	State = Trim(State)
	If Not ValidateInteger(ShippingID) Then
		ShippingID = 0
	End If

	ShippingValue = 0
	sQuery = "EXEC usp_ShippingRateGet" &_
			 "	@BasketCustomerID 	= '" & Quote(BasketID) & "'" &_
			 ", @CountryCode 		= '" & Quote(Country) & "'" &_
			 ", @StateID 			= '" & Quote(State) & "'" &_
			 ", @ShippingMethodID 	= '" & ShippingID & "'"

	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		ShippingName = oQuery("ShippingMethodName")
		ShippingValue = CCur(oQuery("ShippingTotal")) - IIF(CStr(oQuery("ShippingMethodID")) = CStr(ShippingDiscountID), ShippingDiscount, 0)
	End If
	oQuery.Close
	Set oQuery = Nothing
End function

Public Function GetPromoDiscount(BasketID, PromoCode, Country, State)
	PromoCode = Trim(PromoCode)
	Country = Trim(Country)
	State = Trim(State)

	sQuery = "EXEC usp_PromoCodeDiscountCalculate" &_
			 "	   @PromoCodeName = '" & Quote(Trim(PromoCode)) & "'" &_
			 "	 , @BasketCustomerID = " & BasketID &_
			 IIF(Country <> "", "	 , @CountryCode = '" & Quote(Country) & "'", "") &_
			 IIF(State <> "", "	 , @StateID = '" & Quote(State) & "'", "")

	Set oQuery = oConn.Execute(sQuery)
	If oQuery("DisplayMessage") <> "" Then
		PromoMessage = oQuery("DisplayMessage")
		PromoDiscount = 0
		GetPromoDiscount = False
	Else
		PromoDiscount		= 0 - CCur(oQuery("OrderDiscount"))
		ShippingDiscount	= CCur(oQuery("ShippingDiscount"))
		ShippingDiscountID	= oQuery("ShippingMethodID")
		GetPromoDiscount = True
	End If
	oQuery.Close
	Set oQuery = Nothing
End Function

Public Function GetTax(State, SubTotal, PromoDiscount)
	State = Trim(State)

	Dim fTaxRate : fTaxRate = 0
	sQuery = "SELECT se.CompanyTaxRate" &_
			 "	FROM utb_Settings se" &_
			 "		 INNER JOIN utb_States st ON st.StateCode = se.CompanyTaxState" &_
			 " WHERE st.StateID = '" & Quote(State) & "'" &_
			 "	 AND st.CountryCode = '" & Quote(C_DEFAULT_COUNTRY_CODE) & "'"

	Dim oQuery
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		fTaxRate = CCur(oQuery("CompanyTaxRate"))
	End If
	oQuery.Close
	Set oQuery = Nothing
	GetTax = (SubTotal + PromoDiscount) / 100 * fTaxRate
End function

Public Function RecountTotals(BasketID, Country, State, ShippingID, PromoCode)
	Call GetPromoDiscount(BasketID, PromoCode, Country, State)
	Call GetShipping(BasketID, Country, State, ShippingID)

	totalsSubTotal	= GetSubTotal(BasketID)
	totalsShipping	= ShippingValue
	totalsPromo		= PromoDiscount
	totalsTax		= GetTax(State, totalsSubTotal, PromoDiscount)
	totalsGrandTotal= totalsSubTotal + totalsShipping + totalsPromo + totalsTax
End function
%>
