<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("CustomerList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim TypeID, Email, Password, IsTaxable, CreateDate, VisitDate
	Dim BillingFirstName, BillingLastName, BillingCompanyName, BillingCountry, BillingAddress1, BillingAddress2, BillingCity, BillingState, BillingZip, BillingHomePhone, BillingAltPhone
	Dim ShippingFirstName, ShippingLastName, ShippingCompanyName, ShippingCountry, ShippingAddress1, ShippingAddress2, ShippingCity, ShippingState, ShippingZip, ShippingHomePhone, ShippingAltPhone
	Dim ProfName, ProfType, ProfLicense, IssuingAuthority, DEANumber, Website
	Dim iCustomerID

	Select Case sAction
		Case "New"
			sTitle = "Add Customer"
			sAction = "Insert"

			IsTaxable = "0"

		Case "Edit"
			sTitle = "Edit Customer Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Customers WHERE CustomerID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				TypeID = oQuery("CustomerTypeID")
				Email = HTMLEncode(oQuery("CustomerEmail"))
				Password = HTMLEncode(Decode(oQuery("CustomerPassword")))
				BillingFirstName = HTMLEncode(oQuery("CustomerBillingFirstName"))
				BillingLastName = HTMLEncode(oQuery("CustomerBillingLastName"))
				BillingCompanyName = HTMLEncode(oQuery("CustomerBillingCompanyName"))
				BillingCountry = oQuery("CustomerBillingCountry")
				BillingAddress1 = HTMLEncode(oQuery("CustomerBillingAddress1"))
				BillingAddress2 = HTMLEncode(oQuery("CustomerBillingAddress2"))
				BillingCity = HTMLEncode(oQuery("CustomerBillingCity"))
				BillingState = oQuery("CustomerBillingState")
				BillingZip = HTMLEncode(oQuery("CustomerBillingZip"))
				BillingHomePhone = HTMLEncode(oQuery("CustomerBillingHomePhone"))
				BillingAltPhone = HTMLEncode(oQuery("CustomerBillingAltPhone"))
				ShippingFirstName = HTMLEncode(oQuery("CustomerShippingFirstName"))
				ShippingLastName = HTMLEncode(oQuery("CustomerShippingLastName"))
				ShippingCompanyName = HTMLEncode(oQuery("CustomerShippingCompanyName"))
				ShippingCountry = oQuery("CustomerShippingCountry")
				ShippingAddress1 = HTMLEncode(oQuery("CustomerShippingAddress1"))
				ShippingAddress2 = HTMLEncode(oQuery("CustomerShippingAddress2"))
				ShippingCity = HTMLEncode(oQuery("CustomerShippingCity"))
				ShippingState = oQuery("CustomerShippingState")
				ShippingZip = HTMLEncode(oQuery("CustomerShippingZip"))
				ShippingHomePhone = HTMLEncode(oQuery("CustomerShippingHomePhone"))
				ShippingAltPhone = HTMLEncode(oQuery("CustomerShippingAltPhone"))
				IsTaxable = oQuery("CustomerIsTaxable")
				CreateDate = oQuery("CustomerCreateDate")
				VisitDate = oQuery("CustomerVisitDate")

				ProfName			= HTMLEncode(oQuery("CustomerProfName"))
				ProfLicense			= HTMLEncode(oQuery("CustomerProfLicense"))
				IssuingAuthority	= HTMLEncode(oQuery("CustomerIssuingAuthority"))
				ProfType			= HTMLEncode(oQuery("CustomerProfType"))
				DEANumber			= HTMLEncode(oQuery("CustomerDEANumber"))
				Website				= HTMLEncode(oQuery("CustomerWebsite"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Customer"

			CommonValidation()

			If GetValueFromTable(oConn, "CustomerID", "utb_Customers", "WHERE CustomerEmail = '" & Quote(Email) & "'") <> "" Then
				AddError("Customer with email <strong>" & Email & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_Customers (CustomerTypeID, CustomerEmail, CustomerPassword, CustomerBillingFirstName, CustomerBillingLastName, CustomerBillingCompanyName, CustomerBillingCountry, CustomerBillingAddress1, CustomerBillingAddress2, CustomerBillingCity, CustomerBillingState, CustomerBillingZip, CustomerBillingHomePhone, CustomerBillingAltPhone, CustomerShippingFirstName, CustomerShippingLastName, CustomerShippingCompanyName, CustomerShippingCountry, CustomerShippingAddress1, CustomerShippingAddress2, CustomerShippingCity, CustomerShippingState, CustomerShippingZip, CustomerShippingHomePhone, CustomerShippingAltPhone, CustomerIsTaxable, CustomerProfName, CustomerProfLicense, CustomerIssuingAuthority, CustomerDEANumber, CustomerProfType, CustomerWebsite) " & _
						 " VALUES ( " & _
						 "   '" & Quote(TypeID) & "' " & _
						 " , '" & Quote(Email) & "' " & _
						 " , '" & Quote(Encode(Password)) & "' " & _
						 " , '" & Quote(BillingFirstName) & "' " & _
						 " , '" & Quote(BillingLastName) & "' " & _
						 " , '" & Quote(BillingCompanyName) & "' " & _
						 " , '" & Quote(BillingCountry) & "' " & _
						 " , '" & Quote(BillingAddress1) & "' " & _
						 " , " & IIF(BillingAddress2 <> "", "'" & Quote(BillingAddress2) & "'", "NULL") & " " & _
						 " , '" & Quote(BillingCity) & "' " & _
						 " , '" & Quote(BillingState) & "' " & _
						 " , '" & Quote(BillingZip) & "' " & _
						 " , '" & Quote(BillingHomePhone) & "' " & _
						 " , " & IIF(BillingAltPhone <> "", "'" & Quote(BillingAltPhone) & "'", "NULL") & " " & _
						 " , '" & Quote(ShippingFirstName) & "' " & _
						 " , '" & Quote(ShippingLastName) & "' " & _
						 " , '" & Quote(ShippingCompanyName) & "' " & _
						 " , '" & Quote(ShippingCountry) & "' " & _
						 " , '" & Quote(ShippingAddress1) & "' " & _
						 " , " & IIF(ShippingAddress2 <> "", "'" & Quote(ShippingAddress2) & "'", "NULL") & " " & _
						 " , '" & Quote(ShippingCity) & "' " & _
						 " , '" & Quote(ShippingState) & "' " & _
						 " , '" & Quote(ShippingZip) & "' " & _
						 " , '" & Quote(ShippingHomePhone) & "' " & _
						 " , " & IIF(ShippingAltPhone <> "", "'" & Quote(ShippingAltPhone) & "'", "NULL") & " " & _
						 " , '" & Quote(IsTaxable) & "' " & _
						 " , '" & Quote(ProfName) & "' " & _
						 " , '" & Quote(ProfLicense) & "' " & _
						 " , '" & Quote(IssuingAuthority) & "' " & _
						 " , " & IIF(DEANumber <> "", "'" & Quote(DEANumber) & "'", "NULL") & " " & _
						 " , " & IIF(ProfType <> "", "'" & Quote(ProfType) & "'", "NULL") & " " & _
						 " , " & IIF(Website <> "", "'" & Quote(Website) & "'", "NULL") & " " & _
						 " ) "
				oConn.Execute(sQuery)

				iCustomerID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Customer has been inserted.")
					Redirect("CustomerForm.asp?Action=Edit&ID=" & iCustomerID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Customer Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "CustomerID", "utb_Customers", "WHERE CustomerEmail = '" & Quote(Email) & "' AND CustomerID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Customer with email <strong>" & Email & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_Customers " & _
						 "	SET CustomerTypeID = '" & Quote(TypeID) & "' " & _
						 "	  , CustomerEmail = '" & Quote(Email) & "' " & _
						 "	  , CustomerPassword = '" & Quote(Encode(Password)) & "' " & _
						 "	  , CustomerBillingFirstName = '" & Quote(BillingFirstName) & "' " & _
						 "	  , CustomerBillingLastName = '" & Quote(BillingLastName) & "' " & _
						 "	  , CustomerBillingCompanyName = '" & Quote(BillingCompanyName) & "' " & _
						 "	  , CustomerBillingCountry = '" & Quote(BillingCountry) & "' " & _
						 "	  , CustomerBillingAddress1 = '" & Quote(BillingAddress1) & "' " & _
						 "	  , CustomerBillingAddress2 = " & IIF(BillingAddress2 <> "", "'" & Quote(BillingAddress2) & "'", "NULL") & " " & _
						 "	  , CustomerBillingCity = '" & Quote(BillingCity) & "' " & _
						 "	  , CustomerBillingState = '" & Quote(BillingState) & "' " & _
						 "	  , CustomerBillingZip = '" & Quote(BillingZip) & "' " & _
						 "	  , CustomerBillingHomePhone = '" & Quote(BillingHomePhone) & "' " & _
						 "	  , CustomerBillingAltPhone = " & IIF(BillingAltPhone <> "", "'" & Quote(BillingAltPhone) & "'", "NULL") & " " & _
						 "	  , CustomerShippingFirstName = '" & Quote(ShippingFirstName) & "' " & _
						 "	  , CustomerShippingLastName = '" & Quote(ShippingLastName) & "' " & _
						 "	  , CustomerShippingCompanyName = '" & Quote(ShippingCompanyName) & "' " & _
						 "	  , CustomerShippingCountry = '" & Quote(ShippingCountry) & "' " & _
						 "	  , CustomerShippingAddress1 = '" & Quote(ShippingAddress1) & "' " & _
						 "	  , CustomerShippingAddress2 = " & IIF(ShippingAddress2 <> "", "'" & Quote(ShippingAddress2) & "'", "NULL") & " " & _
						 "	  , CustomerShippingCity = '" & Quote(ShippingCity) & "' " & _
						 "	  , CustomerShippingState = '" & Quote(ShippingState) & "' " & _
						 "	  , CustomerShippingZip = '" & Quote(ShippingZip) & "' " & _
						 "	  , CustomerShippingHomePhone = '" & Quote(ShippingHomePhone) & "' " & _
						 "	  , CustomerShippingAltPhone = " & IIF(ShippingAltPhone <> "", "'" & Quote(ShippingAltPhone) & "'", "NULL") & " " & _
						 "	  , CustomerIsTaxable = '" & Quote(IsTaxable) & "' " & _
						 "	  , CustomerProfName = '" & Quote(ProfName) & "' " & _
						 "	  , CustomerProfLicense = '" & Quote(ProfLicense) & "' " & _
						 "	  , CustomerIssuingAuthority = '" & Quote(IssuingAuthority) & "' " & _
						 "	  , CustomerDEANumber = " & IIF(DEANumber <> "", "'" & Quote(DEANumber) & "'", "NULL") & " " & _
						 "	  , CustomerProfType = " & IIF(ProfType <> "", "'" & Quote(ProfType) & "'", "NULL") & " " & _
						 "	  , CustomerWebsite = " & IIF(Website <> "", "'" & Quote(Website) & "'", "NULL") & " " & _
						 "  WHERE CustomerID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iCustomerID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Customer has been updated.")
					Redirect("CustomerForm.asp?Action=Edit&ID=" & iCustomerID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "UPDATE utb_Orders SET CustomerID = NULL WHERE CustomerID = '" & Quote(iID) & "'"
			oConn.Execute(sQuery)

			sQuery = "DELETE FROM utb_Customers WHERE CustomerID = '" & Quote(iID) & "'"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Customer has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>">
		<meta name="Keywords" content="<%= sPageKeywords %>">
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Customers</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="OrderFormCreate.asp?Type=2&amp;CustomerID=<%= iID %>&amp;submit=yes" onclick="return areYouSure()">Create New Order</a>
			<a class="head-link-right" href="OrderList.asp?SearchField=10&SearchString=<%= iID %>">View Orders (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_Orders", "WHERE CustomerID = " & iID) %>)</a>
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="CustomerForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>" />
				<input type="hidden" name="ID" value="<%= iID %>" />
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr valign="bottom">
						<td width="55%">
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Type</td>
									<td>
										<select class="selector" name="TypeID" style="width:120px;">
										<%
											Set oQuery = oConn.Execute(" SELECT * FROM utb_CustomerTypes ORDER BY CustomerTypeID ")
											While Not oQuery.Eof 
										%>
											<option value="<%= oQuery("CustomerTypeID") %>" <%= IIF(CStr(oQuery("CustomerTypeID")) = CStr(TypeID), "selected='selected'", "") %>><%= oQuery("CustomerTypeName") %></option>
										<%
												oQuery.MoveNext
											Wend
											oQuery.Close
											Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> MP Name</td>
									<td><input type="text" class="form-field" name="ProfName" value="<%= ProfName %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> MP License Number</td>
									<td><input type="text" class="form-field" name="ProfLicense" value="<%= ProfLicense %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> License Issuing Authority</td>
									<td><input type="text" class="form-field" name="IssuingAuthority" value="<%= IssuingAuthority %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Type of MP</td>
									<td><input type="text" class="form-field" name="ProfType" value="<%= ProfType %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">DEA Number</td>
									<td><input type="text" class="form-field" name="DEANumber" value="<%= DEANumber %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Website</td>
									<td><input type="text" class="form-field" name="Website" value="<%= Website %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Email</td>
									<td><input type="text" class="form-field" name="Email" value="<%= Email %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Password</td>
									<td><input type="password" class="form-field" name="Password" value="<%= Password %>" style="width:100px;" maxlength="100" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><label for="IsTaxable">Tax Exemption</label></td>
									<td>
										<input type="checkbox" name="IsTaxable" id="IsTaxable" value="1" <%= IIF(IsTaxable = "1", "checked='checked'", "") %> />
									</td>
								</tr>
								<% If iID > 0 Then %>
								<tr>
									<td style="text-align:right;">Date Created</td>
									<td colspan="2"><strong><%= CreateDate %></strong><input type="hidden" name="CreateDate" value="<%= CreateDate %>" /></td>
								</tr>
									<% If VisitDate <> "" Then %>
									<tr>
										<td style="text-align:right;">Visit Date</td>
										<td colspan="2"><strong><%= VisitDate %></strong><input type="hidden" name="VisitDate" value="<%= VisitDate %>" /></td>
									</tr>
									<% End If %>
								<% End If %>
								<tr>
									<td style="text-align:right;" style="padding-top:15px;"><strong>Billing Info</strong></td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> First Name:</td>
									<td><input type="text" class="form-field" name="BillingFirstName" id="BillingFirstName" value="<%= BillingFirstName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Last Name:</td>
									<td><input type="text" class="form-field" name="BillingLastName" id="BillingLastName" value="<%= BillingLastName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Company Name:</td>
									<td><input type="text" class="form-field" name="BillingCompanyName" id="BillingCompanyName" value="<%= BillingCompanyName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Country:</td>
									<td>
										<select class="selector" id="BillingCountry" name="BillingCountry" style="width:214px;" onchange="changeCountry('Billing');" >
											<option value="">Select One</option>
										<%
											Set oQuery = oConn.Execute(" SELECT * FROM utb_Countries WHERE CountryIsActiveBilling = 1 ORDER BY CountrySortOrder, CountryName ")
											While Not oQuery.Eof 
										%>
											<option value="<%= oQuery("CountryCode") %>" <%= IIF(CStr(oQuery("CountryCode")) = CStr(BillingCountry), "selected='selected'", "") %>><%= oQuery("CountryName") %></option>
										<%
												oQuery.MoveNext
											Wend
											oQuery.Close
											Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Address 1:</td>
									<td><input type="text" class="form-field" name="BillingAddress1" id="BillingAddress1" value="<%= BillingAddress1 %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Address 2:</td>
									<td><input type="text" class="form-field" name="BillingAddress2" id="BillingAddress2" value="<%= BillingAddress2 %>" style="width:200px;" maxlength="100" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> City:</td>
									<td><input type="text" class="form-field" name="BillingCity" id="BillingCity" value="<%= BillingCity %>" style="width:200px;" maxlength="100" /></td>
								</tr>
								<tr height="24px">
									<td style="text-align:right;"><span class="asterisk">*</span> State:</td>
									<td><div id="billing_state"></div></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Zip:</td>
									<td><input type="text" class="form-field" name="BillingZip" id="BillingZip" value="<%= BillingZip %>" style="width:100px;" maxlength="50" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Home Phone:</td>
									<td><input type="text" class="form-field" name="BillingHomePhone" id="BillingHomePhone" value="<%= BillingHomePhone %>" style="width:100px;" maxlength="20" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Alt Phone:</td>
									<td><input type="text" class="form-field" name="BillingAltPhone" id="BillingAltPhone" value="<%= BillingAltPhone %>" style="width:100px;" maxlength="20" /></td>
								</tr>
							</table>
						</td>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align:right;"><strong>Shipping Info</strong></td>
									<td>
										<input type="checkbox" name="addrTheSame" id="addrTheSame" value="1"<%= IIF(Request("addrTheSame") = "1", " checked='checked'", "") %> />
										<label for="addrTheSame">Check here if Shipping is the same as Billing</label>
									</td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> First Name:</td>
									<td><input type="text" class="form-field" name="ShippingFirstName" id="ShippingFirstName" value="<%= ShippingFirstName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Last Name:</td>
									<td><input type="text" class="form-field" name="ShippingLastName" id="ShippingLastName" value="<%= ShippingLastName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Company Name:</td>
									<td><input type="text" class="form-field" name="ShippingCompanyName" id="ShippingCompanyName" value="<%= ShippingCompanyName %>" style="width:200px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Country:</td>
									<td>
										<select class="selector" id="ShippingCountry" name="ShippingCountry" id="ShippingCountry" style="width:214px;" onchange="changeCountry('Shipping');" >
											<option value="">Select One</option>
										<%
											Set oQuery = oConn.Execute(" SELECT * FROM utb_Countries WHERE CountryIsActiveShipping = 1 ORDER BY CountrySortOrder, CountryName ")
											While Not oQuery.Eof 
										%>
											<option value="<%= oQuery("CountryCode") %>" <%= IIF(CStr(oQuery("CountryCode")) = CStr(ShippingCountry), "selected='selected'", "") %>><%= oQuery("CountryName") %></option>
										<%
												oQuery.MoveNext
											Wend
											oQuery.Close
											Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Address 1:</td>
									<td><input type="text" class="form-field" name="ShippingAddress1" id="ShippingAddress1" value="<%= ShippingAddress1 %>" style="width:300px;" maxlength="255" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Address 2:</td>
									<td><input type="text" class="form-field" name="ShippingAddress2" id="ShippingAddress2" value="<%= ShippingAddress2 %>" style="width:200px;" maxlength="100" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> City:</td>
									<td><input type="text" class="form-field" name="ShippingCity" id="ShippingCity" value="<%= ShippingCity %>" style="width:200px;" maxlength="100" /></td>
								</tr>
								<tr height="24px">
									<td style="text-align:right;"><span class="asterisk">*</span> State:</td>
									<td><div id="shipping_state"></div></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Zip:</td>
									<td><input type="text" class="form-field" name="ShippingZip" id="ShippingZip" value="<%= ShippingZip %>" style="width:100px;" maxlength="50" /></td>
								</tr>
								<tr>
									<td style="text-align:right;"><span class="asterisk">*</span> Home Phone:</td>
									<td><input type="text" class="form-field" name="ShippingHomePhone" id="ShippingHomePhone" value="<%= ShippingHomePhone %>" style="width:100px;" maxlength="20" /></td>
								</tr>
								<tr>
									<td style="text-align:right;">Alt Phone:</td>
									<td><input type="text" class="form-field" name="ShippingAltPhone" id="ShippingAltPhone" value="<%= ShippingAltPhone %>" style="width:100px;" maxlength="20" /></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="padding-left: 152px">
										<br/>
										<div style="float: left"><input type="submit" class="form-btn" value="Save" /></div>
										<div style="float: left"><input type="reset" class="form-btn" value="Reset" /></div>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		var copyFields = new Array('FirstName', 'LastName', 'CompanyName', 'Country', 'Address1', 'Address2', 'City', 'State', 'Zip', 'HomePhone', 'AltPhone');

		function changeCountry(type, stateType, callback) {
			var argNum = arguments.length;
			var stType = argNum == 3 ? stateType : type;

			$.ajax({
				url: 'ajax/GetStates.asp',
				type: 'POST',
				dataType: 'text',
				async: false,
				data: {CountryID: $('#' + type + 'Country').val()},
				success: function(response) {
					if (response != '') {
						var buffer = '';
						var rows = response.split('\n');

						for (var i = 0; i < rows.length; i++) {
							if (rows[i] != '') {
								var columns = rows[i].split('|');
								buffer += '<option value="' + columns[0] + '" ' + (columns[0] == (stType == 'Billing' ? '<%= BillingState %>' : '<%= ShippingState %>') ? 'selected="selected"' : '') + '>' + columns[1] + '</option>'
							}
						}

						$('#' + stType.toLowerCase() + '_state').html('<select class="selector" name="' + stType + 'State" id="' + stType + 'State" style="width:214px;"><option value="">Select One</option>' + buffer + '</select>');
					}
					else {
						$('#' + stType.toLowerCase() + '_state').html('<input type="text" class="form-field" name="' + stType + 'State" id="' + stType + 'State" value="' + (stType == 'Billing' ? '<%= BillingState %>' : '<%= ShippingState %>') + '" style="width:150px;" maxlength="50">');
					}
					if (argNum == 3 && typeof callback == 'function') {
						callback();
					}
				}
			});
		}

		$(function(){
			changeCountry('Billing');
			changeCountry('Shipping');

			$('#addrTheSame').click(function(){
				if ($(this).attr('checked')) {
					changeCountry('Billing', 'Shipping', function(){
						$.each(copyFields, function(i, field){
							$('#Shipping'+field).val($('#Billing'+field).val());
						});
					});
				}
				else {
					changeCountry('Billing', 'Shipping', function(){
						$.each(copyFields, function(i, field){
							if (field == 'Country') {
								$('#ShippingCountry').val('US');
							}
							else {
								$('#Shipping'+field).val('');
							}
						});
					});
				}
			});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		TypeID = Trim(Request("TypeID"))
		Email = Trim(Request("Email"))
		Password = Trim(Request("Password"))
		BillingFirstName = Trim(Request("BillingFirstName"))
		BillingLastName = Trim(Request("BillingLastName"))
		BillingCompanyName = Trim(Request("BillingCompanyName"))
		BillingCountry = Trim(Request("BillingCountry"))
		BillingAddress1 = Trim(Request("BillingAddress1"))
		BillingAddress2 = Trim(Request("BillingAddress2"))
		BillingCity = Trim(Request("BillingCity"))
		BillingState = Trim(Request("BillingState"))
		BillingZip = Trim(Request("BillingZip"))
		BillingHomePhone = Trim(Request("BillingHomePhone"))
		BillingAltPhone = Trim(Request("BillingAltPhone"))
		ShippingFirstName = Trim(Request("ShippingFirstName"))
		ShippingLastName = Trim(Request("ShippingLastName"))
		ShippingCompanyName = Trim(Request("ShippingCompanyName"))
		ShippingCountry = Trim(Request("ShippingCountry"))
		ShippingAddress1 = Trim(Request("ShippingAddress1"))
		ShippingAddress2 = Trim(Request("ShippingAddress2"))
		ShippingCity = Trim(Request("ShippingCity"))
		ShippingState = Trim(Request("ShippingState"))
		ShippingZip = Trim(Request("ShippingZip"))
		ShippingHomePhone = Trim(Request("ShippingHomePhone"))
		ShippingAltPhone = Trim(Request("ShippingAltPhone"))
		IsTaxable = Trim(Request("IsTaxable"))
		CreateDate = Trim(Request("CreateDate"))
		VisitDate = Trim(Request("VisitDate"))

		ProfName = Trim(Request("ProfName"))
		ProfLicense = Trim(Request("ProfLicense"))
		IssuingAuthority = Trim(Request("IssuingAuthority"))
		ProfType = Trim(Request("ProfType"))
		DEANumber = Trim(Request("DEANumber"))
		Website = Trim(Request("Website"))

		If TypeID = "" Then
			AddError("Field <strong>Type</strong> is required.")
		End If
		If Email = "" Then
			AddError("Field <strong>Email</strong> is required.")
		Else
			If Not ValidateEmail(Email) Then
				AddError("Field <strong>Email</strong> is invalid.")
			End If
		End If

		If ProfName = "" Then
			AddError("Field <strong>Medical Professional Name</strong> is required.")
		End If
		If ProfLicense = "" Then
			AddError("Field <strong>Medical Professional License Number</strong> is required.")
		End If
		If IssuingAuthority = "" Then
			AddError("Field <strong>Medical License Issuing Authority</strong> is required.")
		End If

		If Password = "" Then
			AddError("Field <strong>Password</strong> is required.")
		Else
			If Len(Password) < C_PASSWORD_LENGTH Then
				AddError("<strong>Password</strong> length must be more or equal " & C_PASSWORD_LENGTH & " characters.")
			End If
		End If
		If BillingFirstName = "" Then
			AddError("Field <strong>Billing First Name</strong> is required.")
		End If
		If BillingLastName = "" Then
			AddError("Field <strong>Billing Last Name</strong> is required.")
		End If
		If BillingCountry = "" Then
			AddError("Field <strong>Billing Country</strong> is required.")
		End If
		If BillingAddress1 = "" Then
			AddError("Field <strong>Billing Address 1</strong> is required.")
		End If
		If BillingCity = "" Then
			AddError("Field <strong>Billing City</strong> is required.")
		End If
		If BillingState = "" Then
			AddError("Field <strong>Billing State</strong> is required.")
		End If
		If BillingZip = "" Then
			AddError("Field <strong>Billing Zip</strong> is required.")
		End If
		If BillingHomePhone = "" Then
			AddError("Field <strong>Billing Home Phone</strong> is required.")
		End If
		If ShippingFirstName = "" Then
			AddError("Field <strong>Shipping First Name</strong> is required.")
		End If
		If ShippingLastName = "" Then
			AddError("Field <strong>Shipping Last Name</strong> is required.")
		End If
		If ShippingCountry = "" Then
			AddError("Field <strong>Shipping Country</strong> is required.")
		End If
		If ShippingAddress1 = "" Then
			AddError("Field <strong>Shipping Address 1</strong> is required.")
		End If
		If ShippingCity = "" Then
			AddError("Field <strong>Shipping City</strong> is required.")
		End If
		If ShippingState = "" Then
			AddError("Field <strong>Shipping State</strong> is required.")
		End If
		If ShippingZip = "" Then
			AddError("Field <strong>Shipping Zip</strong> is required.")
		End If
		If ShippingHomePhone = "" Then
			AddError("Field <strong>Shipping Home Phone</strong> is required.")
		End If
	End Sub
%>