<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("DeliveryCarrierList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, SortOrder, IsSystem, IsActive
	Dim iDeliveryCarrierID

	Select Case sAction
		Case "New"
			sTitle = "Add Delivery Carrier"
			sAction = "Insert"

			IsSystem = "0"
			IsActive = "1"

		Case "Edit"
			sTitle = "Edit Delivery Carrier Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_OrderDeliveryCarriers WHERE OrderDeliveryCarrierID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("OrderDeliveryCarrierName"))
				SortOrder = HTMLEncode(oQuery("OrderDeliveryCarrierSortOrder"))
				IsSystem = oQuery("OrderDeliveryCarrierIsSystem")
				IsActive = oQuery("OrderDeliveryCarrierIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Delivery Carrier"
		
			CommonValidation()

			If GetValueFromTable(oConn, "OrderDeliveryCarrierID", "utb_OrderDeliveryCarriers", "WHERE OrderDeliveryCarrierName = '" & Quote(Name) & "'") <> "" Then
				AddError("Delivery Carrier with name <strong>" & Name & "</strong> already exist in database.")
			End If
		
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " INSERT INTO utb_OrderDeliveryCarriers (OrderDeliveryCarrierName, OrderDeliveryCarrierSortOrder, OrderDeliveryCarrierIsSystem, OrderDeliveryCarrierIsActive) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Name) & "' " & _
						 " , '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 " , '" & Quote(IsSystem) & "' " & _
						 " , '" & Quote(IsActive) & "' " & _
						 " ) "
				oConn.Execute(sQuery)
		
				iDeliveryCarrierID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Delivery Carrier has been inserted.")
					Redirect("DeliveryCarrierForm.asp?Action=Edit&ID=" & iDeliveryCarrierID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Update"
			sTitle = "Edit Delivery Carrier Ref # " & iID
		
			CommonValidation()

			If GetValueFromTable(oConn, "OrderDeliveryCarrierID", "utb_OrderDeliveryCarriers", "WHERE OrderDeliveryCarrierName = '" & Quote(Name) & "' AND OrderDeliveryCarrierID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Delivery Carrier with name <strong>" & Name & "</strong> already exist in database.")
			End If
			
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " UPDATE utb_OrderDeliveryCarriers " & _
						 "	SET OrderDeliveryCarrierName = '" & Quote(Name) & "' " & _
						 "	  , OrderDeliveryCarrierSortOrder = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , OrderDeliveryCarrierIsActive = '" & Quote(IsActive) & "' " & _
						 "  WHERE OrderDeliveryCarrierID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)
		
				iDeliveryCarrierID = iID
		
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Delivery Carrier has been updated.")
					Redirect("DeliveryCarrierForm.asp?Action=Edit&ID=" & iDeliveryCarrierID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_OrderDeliveryCarriers " & _
					 "  WHERE OrderDeliveryCarrierID = '" & Quote(iID) & "' " & _
					 "	AND OrderDeliveryCarrierIsSystem = 0 "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Delivery Carrier has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Delivery Carriers</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="DeliveryCarrierForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;">
					<% If IsSystem <> "1" Then %>
					<span class="asterisk">*</span>
					<% End If %>
					Name
				</td>
				<td>
					<% If IsSystem = "1" Then %>
					<strong><%= Name %></strong><input type="hidden" name="Name" value="<%= Name %>" />
					<% Else %>
					<input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" />
					<% End If %>
					<input type="hidden" name="IsSystem" value="<%= IsSystem %>" />
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Sort Order</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActive">Active</label></td>
				<td>
					<input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		SortOrder = Trim(Request("SortOrder"))
		IsSystem = Trim(Request("IsSystem"))
		IsActive = Trim(Request("IsActive"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
	End Sub
%>