<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iOrderStatusID : iOrderStatusID = 10

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	If Request("Submit") <> "" Then
		'On Error Resume Next

		Dim sEmailSubject, sEmailContentDefault, sEmailMsg
		sQuery = "SELECT *" &_
				 "	FROM utb_OrderStatuses" &_
				 " WHERE OrderStatusID = " & iOrderStatusID
		Set oQuery = oConn.Execute(sQuery)
		If Not oQuery.Eof Then
			sEmailSubject = oQuery("OrderStatusEmailSubject")
			sEmailContentDefault = oQuery("OrderStatusEmailBody")
			
			If IsNull(sEmailSubject) Then
				AddError("Order Status #" & iOrderStatusID & " email subject can't be empty.")
			End If
			If IsNull(sEmailContentDefault) Then
				AddError("Order Status #" & iOrderStatusID & " email body can't be empty.")
			End If
		Else
			AddError("Order Status #" & iOrderStatusID & " not found.")
		End If
		oQuery.Close
		Set oQuery = Nothing

		If Not IsError() Then
			Dim sCompanyName, sCompanyEmail, oOrder, iTotalSent
			sCompanyName = GetSetting(oConn, "CompanyName")
			sCompanyEmail = GetSetting(oConn, "CompanyEmailForOrder")
			iTotalSent = 0

			sQuery = "SELECT TOP " & C_END_OF_DAY_LIMIT & " *" &_
					 "	FROM utb_Orders" &_
					 " WHERE OrderStatusID = " & iOrderStatusID &_
					 "	 AND OrderShippedDate IS NULL"

			Set oOrder = oConn.Execute(sQuery)
			If Not oOrder.Eof Then
				While Not oOrder.Eof
					sEmailMsg = sEmailContentDefault
					sEmailMsg = Replace(sEmailMsg, "$CompanyName$",		sCompanyName)
					sEmailMsg = Replace(sEmailMsg, "$CompanyEmail$",	sCompanyEmail)
					sEmailMsg = Replace(sEmailMsg, "$OrderNumber$",		oOrder("OrderID"))
					sEmailMsg = Replace(sEmailMsg, "$DFirstName$",		IIF(IsNull(oOrder("OrderShippingFirstName")), "", oOrder("OrderShippingFirstName")))
					sEmailMsg = Replace(sEmailMsg, "$DLastName$",		IIF(IsNull(oOrder("OrderShippingLastName")), "", oOrder("OrderShippingLastName")))
					sEmailMsg = Replace(sEmailMsg, "$OrderDate$",		oOrder("OrderCreateDate"))
					sEmailMsg = Replace(sEmailMsg, "$DCompanyName$",	IIF(IsNull(oOrder("OrderShippingCompanyName")), "", oOrder("OrderShippingCompanyName")))
					sEmailMsg = Replace(sEmailMsg, "$DAddress$",		IIF(IsNull(oOrder("OrderShippingAddress1")), "", oOrder("OrderShippingAddress1")))
					sEmailMsg = Replace(sEmailMsg, "$DApt$",			"DApt")
					sEmailMsg = Replace(sEmailMsg, "$DCity$",			IIF(IsNull(oOrder("OrderShippingCity")), "", oOrder("OrderShippingCity")))
					sEmailMsg = Replace(sEmailMsg, "$DState$",			IIF(IsNull(oOrder("OrderShippingState")), "", oOrder("OrderShippingState")))
					sEmailMsg = Replace(sEmailMsg, "$DZip$",			IIF(IsNull(oOrder("OrderShippingZip")), "", oOrder("OrderShippingZip")))
					sEmailMsg = Replace(sEmailMsg, "$TrackingNumber$",	IIF(IsNull(oOrder("OrderDeliveryTracking")), "", oOrder("OrderDeliveryTracking")))
					sEmailMsg = Replace(sEmailMsg, "$ShippingCompany$",	IIF(IsNull(oOrder("OrderDeliveryMethod")), "", oOrder("OrderDeliveryMethod")))

					Call SendEmail(oOrder("OrderEmail"), sCompanyEmail, sEmailSubject, sEmailMsg)

					If Err.Number = 0 Then
						oConn.Execute("UPDATE utb_Orders SET OrderShippedDate = GETDATE() WHERE OrderID = " & oOrder("OrderID"))
					Else
						Call SetAlertMessage("error", Err.Description)
						Redirect("EndOfDay.asp")
					End If
					iTotalSent = iTotalSent + 1
					oOrder.MoveNext
				Wend
			End If
			oOrder.Close
			Set oOrder = Nothing

			If Err.Number = 0 Then
				Call SetAlertMessage("success", "<strong>" & iTotalSent & "</strong> confirmation emails have been sent.")
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
			End If

			Redirect("EndOfDay.asp")
		End If
	End If

	Dim iAvailable : iAvailable = 0
	sQuery = "SELECT COUNT(*) AS RecordsCount" &_
			 "	FROM utb_Orders" &_
			 " WHERE OrderStatusID = " & iOrderStatusID &_
			 "	 AND OrderShippedDate IS NULL"
	Set oQuery = oConn.Execute(sQuery)
	iAvailable = oQuery("RecordsCount")
	oQuery.Close
	Set oQuery = Nothing

	Dim sButtonText : sButtonText = "Send" & IIF(iAvailable >= C_END_OF_DAY_LIMIT, " " & C_END_OF_DAY_LIMIT, "")

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>End Of Day</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		
		<div class="box-head">
			<h2>End Of Day</h2>
		</div>

		<% If iAvailable > 0 Then %>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid grid-list">
			<tr class="head-line">
				<td style="width: 50px">#</td>
				<td>Status</td>
				<td>Email</td>
				<td>First Name</td>
				<td>Last Name</td>
				<td>State</td>
				<td>Shipping Method</td>
				<td>Shipping Price</td>
				<td>Tracking</td>
				<td>Cost</td>
				<td>Shipping Carrier</td>
			</tr>
		<%
		Dim iCount : iCount = 0
		sQuery = " SELECT TOP " & C_END_OF_DAY_LIMIT & " o.*" &_
				 "		, os.OrderStatusName" &_
				 "		, os.OrderStatusColor" &_
				 "		, odc.OrderDeliveryCarrierName" &_
				 "	FROM utb_Orders o " &_
				 "		 INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID " &_
				 "		  LEFT JOIN utb_OrderDeliveryCarriers odc ON odc.OrderDeliveryCarrierID = o.OrderDeliveryCarrierID " &_
				 " WHERE o.OrderStatusID = " & iOrderStatusID &_
				 "	 AND OrderShippedDate IS NULL"
		Set oQuery = oConn.Execute(sQuery)
		While Not oQuery.Eof
			iCount = iCount + 1
			%>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td><a href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>" style="color: #<%= oQuery("OrderStatusColor") %>"><%= oQuery("OrderID") %></a></td>
				<td><span style="color: #<%= oQuery("OrderStatusColor") %>"><%= oQuery("OrderStatusName") %></span></td>
				<td style="text-align: left"><%= oQuery("OrderEmail") %></td>
				<td style="text-align: left"><%= oQuery("OrderShippingFirstName") %></td>
				<td style="text-align: left"><%= oQuery("OrderShippingLastName") %></td>
				<td style="text-align: center"><%= oQuery("OrderShippingState") %></td>
				<td style="text-align: left"><%= oQuery("OrderDeliveryMethod") %></td>
				<td style="text-align: right"><%= CurrencyFormat(oQuery("OrderDeliveryPrice"), 2) %></td>
				<td style="text-align: right"><%= oQuery("OrderDeliveryTracking") %></td>
				<td style="text-align: right"><%= CurrencyFormat(oQuery("OrderDeliveryCost"), 2) %></td>
				<td style="text-align: left"><%= oQuery("OrderDeliveryCarrierName") %></td>
			</tr>
			<%
			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing
		%>
		</table>
		<br/>
		<% End If %>

		<div class="box">
		<% If iAvailable > 0 Then %>
			<form action="EndOfDay.asp" method="post" id="end-of-day">
				<div>
					<input type="hidden" name="TotalToCommit" value="<%= iAvailable %>" />
					<input type="hidden" name="Submit" value="Yes" />
				</div>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td>Total <strong><%= iAvailable %></strong> orders need to commit shipped order status and send confirmation emails.</td>
					</tr>
					<tr>
						<td><div><input type="submit" class="form-btn" value="<%= sButtonText %>" /></div></td>
					</tr>
				</table>
			</form>
		<% Else %>
			<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
				<tr>
					<td>No orders need to commit shipped order status and send confirmation emails.</td>
				</tr>
			</table>
		<% End If %>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#end-of-day').submit(function(){
				$('.form-btn').attr('disabled', true)
					.after('<span style="color: #999">Sending email<%= IIF(iAvailable > 1, "s", "") %>..</span>')
					.blur();
			});
		});
		//]]>
		</script>
	</body>
</html>
