<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("FaqList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Question, Answer, SortOrder, IsActive
	Dim iQuestionID

	Select Case sAction
		Case "New"
			sTitle = "Add Question"
			sAction = "Insert"

			SortOrder = "0"
			IsActive = "0"

		Case "Edit"
			sTitle = "Edit Question Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Faqs WHERE FaqID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Question = HTMLEncode(oQuery("FaqQuestion"))
				Answer = oQuery("FaqAnswer")
				SortOrder = oQuery("FaqSortOrder")
				IsActive = oQuery("FaqIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Question"

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_Faqs (FaqQuestion, FaqAnswer, FaqSortOrder, FaqIsActive) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Question) & "' " & _
						 " , '" & Quote(Answer) & "' " & _
						 " , '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 " , '" & Quote(IsActive) & "' " & _
						 " ) "
				oConn.Execute(sQuery)

				iQuestionID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Question has been inserted.")
					Redirect("FaqForm.asp?Action=Edit&ID=" & iQuestionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Question Ref # " & iID

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_Faqs " & _
						 "	SET FaqQuestion = '" & Quote(Question) & "' " & _
						 "	  , FaqAnswer = '" & Quote(Answer) & "' " & _
						 "	  , FaqSortOrder = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , FaqIsActive = '" & Quote(IsActive) & "' " & _
						 "  WHERE FaqID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iQuestionID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Question has been updated.")
					Redirect("FaqForm.asp?Action=Edit&ID=" & iQuestionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_Faqs " & _
					 "  WHERE FaqID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Question has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>FAQ</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<!--#include file="../ckeditor/ckeditor.asp"-->
	<form action="FaqForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Question</td>
				<td><input type="text" class="form-field" name="Question" value="<%= Question %>" style="width:820px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Answer</td>
				<td><%
					Set oEditor = New CKeditor
					oEditor.basePath = "../ckeditor/"
					oEditor.config("width") = 844
					oEditor.config("height") = 400
					oEditor.editor "Answer", Answer
				%>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Sort Order</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActive">Active</label></td>
				<td>
					<input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Question = Trim(Request("Question"))
		Answer = Trim(Request("Answer"))
		SortOrder = Trim(Request("SortOrder"))
		IsActive = Trim(Request("IsActive"))

		If Question = "" Then
			AddError("Field <strong>Question</strong> is required.")
		End If
		If Answer = "" Then
			AddError("Field <strong>Answer</strong> is required.")
		End If
		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
	End Sub
%>