<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sBackURL : sBackURL = GetBackURL("FeedList.asp")

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	' Feed Info
	Dim ID, NetworkName, FileNameTXT, IsAllProducts
	Set oQuery = oConn.Execute("SELECT * FROM utb_Feeds WHERE FeedScriptName = '" & GetFileName() & "'")
	If Not oQuery.Eof Then
		ID			= oQuery("FeedID")
		NetworkName = HTMLEncode(oQuery("FeedNetworkName"))
		FileNameTXT = HTMLEncode(oQuery("FeedFileNameTXT"))
		IsAllProducts = oQuery("FeedIsAllProducts")
	Else
		Call SetAlertMessage("error", "Feed Script Name <strong>" & GetFileName() & "</strong> doesn't exists.")
		Redirect(sBackURL)
	End If
	oQuery.Close
	Set oQuery = Nothing

	' Shipping Prices
	Dim arShippingPrices
	Set arShippingPrices = Server.CreateObject("Scripting.Dictionary")
	Set oQuery = oConn.Execute("SELECT ShippingLevelID, MIN(ShippingFirstItemPrice) AS ShippingFirstItemPrice FROM utb_Shippings GROUP BY ShippingLevelID")
	While Not oQuery.Eof
		arShippingPrices.Add "" & oQuery("ShippingLevelID") & "", "" & oQuery("ShippingFirstItemPrice") & ""
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

	oConn.BeginTrans
	On Error Resume Next

	Dim arVals, oFS, oFSFile
	Dim sQueryCount, RecordsCompiled
	RecordsCompiled = 0

	sQuery = "SELECT p.*" &_
			 "	   , m.ManufacturerName" &_
			 "	   , c.CategoryReserved2" &_
			 "	   , pc.ProductConditionName" &_
			 "	   , ps.ProductStatusName" &_
			 "	FROM utb_Products AS p" &_
			 "		 INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID" &_
			 "		 INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1" &_
			 "		 INNER JOIN utb_Categories AS c ON c.CategoryID = pcat.CategoryID" &_
			 "		 INNER JOIN utb_ProductConditions AS pc ON pc.ProductConditionID = p.ProductConditionID" &_
			 "		 INNER JOIN utb_ProductStatuses AS ps ON ps.ProductStatusID = p.ProductStatusID"

	sQueryCount = "SELECT COUNT(*) AS TotalCount" &_
				  "	 FROM utb_Products AS p" &_
				  "		  INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID"

	If IsAllProducts = "0" Then
		sQuery = sQuery &_
			 "		 INNER JOIN utb_FeedProducts AS fp ON fp.ProductID = p.ProductID" &_
			 " WHERE p.ProductStatusID IN(2, 3, 4)" &_
			 "	 AND LOWER(pc.ProductConditionName) IN('new', 'used', 'refurbished')" &_
			 "	 AND LOWER(ps.ProductStatusName) IN('in stock', 'out of stock', 'limited availability')" &_
			 "	 AND fp.FeedID = '" & Quote(ID) & "'"

		sQueryCount = sQueryCount &_
				  "		  INNER JOIN utb_FeedProducts AS fp ON fp.ProductID = p.ProductID" &_
				  "	WHERE fp.FeedID = '" & Quote(ID) & "'"
	Else
		sQuery = sQuery &_
			 " WHERE p.ProductStatusID IN(2, 3, 4)" &_
			 "	 AND LOWER(pc.ProductConditionName) IN('new', 'used', 'refurbished')" &_
			 "	 AND LOWER(ps.ProductStatusName) IN('in stock', 'out of stock', 'limited availability')"
	End If

	Set oQuery = oConn.Execute(sQuery)
	If Err.Number = 0 Then
		If Not oQuery.Eof Then
			ReDim arVals(11)
			arVals(0)	= "id"
			arVals(1)	= "title"
			arVals(2)	= "link"
			arVals(3)	= "price"
			arVals(4)	= "description"
			arVals(5)	= "condition"
			arVals(6)	= "brand"
			arVals(7)	= "mpn"
			arVals(8)	= "image_link"
			arVals(9)	= "product_type"
			arVals(10)	= "availability"
			arVals(11)	= "shipping"

			Set oFS = CreateObject("Scripting.FileSystemObject")
			Set oFSFile = oFS.OpenTextFile(Server.MapPath(C_COMPILE_FILE_PATH & "/" & FileNameTXT), 2, true)
			oFSFile.Write(BuildTabDelemitedLine(arVals))
			While Not oQuery.Eof
				arVals(0)	= oQuery("ProductID")
				arVals(1)	= Left(oQuery("ProductName"), 70)
				arVals(2)	= BuildFriendlyDetailURL(oQuery("ProductName"), oQuery("ProductID"))
				arVals(3)	= DecimalFormat(oQuery("ProductPrice"), 2) & " USD"
				arVals(4)	= Replace(StripTags(oQuery("ProductDescription")), VbCrlf, " ")
				arVals(5)	= LCase(oQuery("ProductConditionName"))
				arVals(6)	= oQuery("ManufacturerName")
				arVals(7)	= oQuery("ProductMPN")
				arVals(8)	= GetProductImageSrc__(oQuery("ProductImage"), "medium", False)
				arVals(9)	= oQuery("CategoryReserved2")
				arVals(10)	= LCase(oQuery("ProductStatusName"))
				arVals(11)	= ":::" & DecimalFormat(arShippingPrices.Item(CStr(oQuery("ShippingLevelID"))), 2)

				oFSFile.Write(VbCrLf & BuildTabDelemitedLine(arVals))
				RecordsCompiled = RecordsCompiled + 1
				oQuery.MoveNext
			Wend
			oFSFile.Close()
			Set oFSFile = Nothing
		Else
			Call SetAlertMessage("error", "No products found to compile.")
			Redirect(sBackURL)
		End If
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim RecordsCount : RecordsCount = 0
	Set oQuery = oConn.Execute(sQueryCount)
	If Err.Number = 0 Then
		If Not oQuery.Eof Then
			RecordsCount = oQuery("TotalCount")
		End If
	End If
	oQuery.Close
	Set oQuery = Nothing

	If Err.Number = 0 Then
		oConn.Execute("UPDATE utb_Feeds SET FeedCompileDate = GETDATE() WHERE FeedID = '" & Quote(ID) & "'")
	End If

	If Err.Number = 0 Then
		oConn.CommitTrans
	Else
		oConn.RollbackTrans
		Call SetAlertMessage("error", Err.Description)
		Redirect(sBackURL)
	End If

	Dim sFile : sFile = C_DOMAIN_PATH & Replace(C_COMPILE_FILE_PATH, "../", "/") & "/" & FileNameTXT

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Feeds</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= NetworkName %> Data Feed</h2>
		</div>
		<table cellpadding="4" style="margin-left: 7px">
			<tr>
				<td>Products selected:</td>
				<td><%= RecordsCount %></td>
			</tr>
			<tr>
				<td>Products write:</td>
				<td><%= RecordsCompiled %></td>
			</tr>
			<tr>
				<td>File path:</td>
				<td><a href="<%= sFile %>"><%= sFile %></a></td>
			</tr>
		</table>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>