<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sBackURL : sBackURL = GetBackURL("FeedList.asp")
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	' Feed Info
	Dim ID, NetworkName, FileNameTXT, IsAllProducts
	Set oQuery = oConn.Execute("SELECT * FROM utb_Feeds WHERE FeedScriptName = '" & GetFileName() & "'")
	If Not oQuery.Eof Then
		ID			= oQuery("FeedID")
		NetworkName = HTMLEncode(oQuery("FeedNetworkName"))
		FileNameTXT = HTMLEncode(oQuery("FeedFileNameTXT"))
		IsAllProducts = oQuery("FeedIsAllProducts")
	Else
		Call SetAlertMessage("error", "Feed Script Name <strong>" & GetFileName() & "</strong> doesn't exists.")
		Redirect(sBackURL)
	End If
	oQuery.Close
	Set oQuery = Nothing
	' Categories
	Dim arCategories, arCategoriesWithPath, arCategoryPath, sCategory, i
	Set arCategories = Server.CreateObject("Scripting.Dictionary")
	Set arCategoriesWithPath = Server.CreateObject("Scripting.Dictionary")
	Set oQuery = oConn.Execute("SELECT * FROM utb_Categories ORDER BY ParentID, CategoryID")
	While Not oQuery.Eof
		arCategories.Add "" & oQuery("CategoryID") & "", "" & oQuery("CategoryName") & ""
		If IsNull(oQuery("CategoryPath")) Then
			arCategoriesWithPath.Add "" & oQuery("CategoryID") & "", "" & oQuery("CategoryName") & ""
		Else
			sCategory = ""
			arCategoryPath = Split(oQuery("CategoryPath"), ",")
			For i = 0 To Ubound(arCategoryPath)
				sCategory = sCategory & arCategories(arCategoryPath(i)) & " > "
			Next
			arCategoriesWithPath.Add "" & oQuery("CategoryID") & "", "" & sCategory & oQuery("CategoryName") & ""
		End If
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing
	' Shipping Prices
	Dim arShippingPrices
	Set arShippingPrices = Server.CreateObject("Scripting.Dictionary")
	Set oQuery = oConn.Execute("SELECT ShippingLevelID, MIN(ShippingFirstItemPrice) AS ShippingFirstItemPrice FROM utb_Shippings GROUP BY ShippingLevelID")
	While Not oQuery.Eof
		arShippingPrices.Add "" & oQuery("ShippingLevelID") & "", "" & oQuery("ShippingFirstItemPrice") & ""
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing
	oConn.BeginTrans
	On Error Resume Next
	Dim sBuffer, arVals, oFS, oFSFile
	ReDim arVals(10)
	arVals(0)   = "ID"
	arVals(1)   = "Name"
	arVals(2)   = "SKU"
	arVals(3)   = "Price"
	arVals(4)   = "Shipping Price"
	arVals(5)   = "Url"
	arVals(6)   = "Image"
	arVals(7)   = "Category"
	arVals(8)   = "Category Path"
	arVals(9)   = "Manufacturer"
	arVals(10)  = "Description"
	sBuffer = sBuffer & BuildTabDelemitedLine(arVals)
	Dim sQueryCount
	sQuery = "SELECT p.ProductID " &_
			 "	   , p.ProductName " &_
			 "	   , p.ProductSKU " &_
			 "	   , p.ProductPrice " &_
			 "	   , p.ShippingLevelID " &_
			 "	   , p.ProductImage " &_
			 "	   , pcat.CategoryID " &_
			 "	   , m.ManufacturerName " &_
			 "	   , p.ProductDescription " &_
			 "	FROM utb_Products AS p " &_
			 "		 INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID " &_
			 "		 INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1"
	sQueryCount = "SELECT COUNT(*) AS TotalCount " &_
			 "		 FROM utb_Products AS p " &_
			 "			  INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID " &_
			 "		 	  INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1"
	If IsAllProducts = "0" Then
		sQuery = sQuery &_
			 "		INNER JOIN utb_FeedProducts AS fp ON fp.ProductID = p.ProductID " &_
			 "  WHERE p.ProductStatusID IN(2, 3, 4) " &_
			 "	AND fp.FeedID = '" & Quote(ID) & "' "
		
		sQueryCount = sQueryCount &_
				  "		INNER JOIN utb_FeedProducts AS fp ON fp.ProductID = p.ProductID " &_
				  "  WHERE fp.FeedID = '" & Quote(ID) & "' "
	Else
		sQuery = sQuery &_
			 "  WHERE p.ProductStatusID IN(2, 3, 4) "
	End If
	Dim RecordsCompiled : RecordsCompiled = 0
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		Set oFS = CreateObject("Scripting.FileSystemObject")
		Set oFSFile = oFS.OpenTextFile(Server.MapPath(C_COMPILE_FILE_PATH & "/" & FileNameTXT), 2, true)
		oFSFile.Write(sBuffer)
		oFSFile.Close()
		Set oFSFile = Nothing
		Set oFSFile = oFS.OpenTextFile(Server.MapPath(C_COMPILE_FILE_PATH & "/" & FileNameTXT), 8, true)
		While Not oQuery.Eof
			arVals(0)   = oQuery("ProductID")
			arVals(1)   = oQuery("ProductName")
			arVals(2)   = oQuery("ProductSKU")
			arVals(3)   = CurrencyFormat(oQuery("ProductPrice"), 2)
			arVals(4)   = CurrencyFormat(arShippingPrices.Item(CStr(oQuery("ShippingLevelID"))), 2)
			arVals(5)   = C_DOMAIN_PATH & "/ProductView.asp?ID=" & oQuery("ProductID")
			arVals(6)   = oQuery("ProductImage")
			arVals(7)   = arCategories.Item("" & oQuery("CategoryID") & "")
			arVals(8)   = arCategoriesWithPath.Item("" & oQuery("CategoryID") & "")
			arVals(9)   = oQuery("ManufacturerName")
			arVals(10)  = Replace(StripTags(oQuery("ProductDescription")), VbCrlf, " ")
			oFSFile.Write(VbCrLf & BuildTabDelemitedLine(arVals))
			RecordsCompiled = RecordsCompiled + 1
			oQuery.MoveNext
		Wend
		oFSFile.Close()
		Set oFSFile = Nothing
	Else
		Call SetAlertMessage("error", "No products found to compile.")
		Redirect(sBackURL)
	End If
	oQuery.Close
	Set oQuery = Nothing
	Dim RecordsCount : RecordsCount = 0
	Set oQuery = oConn.Execute(sQueryCount)
	If Not oQuery.Eof Then
		RecordsCount = oQuery("TotalCount")
	End If
	oQuery.Close
	Set oQuery = Nothing
	oConn.Execute("UPDATE utb_Feeds SET FeedCompileDate = GETDATE() WHERE FeedID = '" & Quote(ID) & "'")
	If Err.Number = 0 Then
		oConn.CommitTrans
	Else
		oConn.RollbackTrans
		Call SetAlertMessage("error", Err.Description)
		Redirect(sBackURL)
	End If
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Feeds</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= NetworkName %> Data Feed</h2>
</div>
<table cellpadding="4" style="margin-left: 7px">
	<tr>
		<td>Products selected:</td>
		<td><%= RecordsCount %></td>
	</tr>
	<tr>
		<td>Products write:</td>
		<td><%= RecordsCompiled %></td>
	</tr>
	<tr>
		<td>File path:</td>
		<td><a href="<%= C_COMPILE_FILE_PATH & "/" & FileNameTXT %>"><%= C_DOMAIN_PATH & Replace(C_COMPILE_FILE_PATH, "../", "/") & "/" & FileNameTXT %></a></td>
	</tr>
</table>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>