<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("FeedList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim NetworkName, FileNameTXT, IsAllProducts

	Set oQuery = oConn.Execute(" SELECT * FROM utb_Feeds WHERE FeedID = '" & Quote(iID) & "' ")
	If Not oQuery.Eof Then
		NetworkName = HTMLEncode(oQuery("FeedNetworkName"))
		FileNameTXT = HTMLEncode(oQuery("FeedFileNameTXT"))
		IsAllProducts = oQuery("FeedIsAllProducts")
	End If
	oQuery.Close
	Set oQuery = Nothing

	Select Case sAction
		Case "Edit"
			sTitle = "Edit Feed: " & NetworkName
			sAction = "Update"

		Case "Update"
			sTitle = "Edit Feed: " & NetworkName

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_Feeds " & _
						 "	SET FeedFileNameTXT = '" & Quote(FileNameTXT) & "' " & _
						 "	  , FeedIsAllProducts = " & IIF(IsAllProducts = "1", "1", "0") & " " & _
						 "  WHERE FeedID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Feed has been updated.")
					Redirect("FeedForm.asp?Action=Edit&ID=" & iID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_FeedProducts " & _
					 "  WHERE FeedID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Products has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Feeds</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="FeedForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>">
		<input type="hidden" name="ID" value="<%= iID %>">
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> File Name</td>
				<td><input type="text" class="form-field" name="FileNameTXT" value="<%= FileNameTXT %>" style="width:300px;" maxlength="50" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsAllProducts">All Products</label></td>
				<td>
					<input type="checkbox" name="IsAllProducts" id="IsAllProducts" value="1"<%= IIF(IsAllProducts = "1", " checked=""checked""", "") %> />
				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		FileNameTXT = Trim(Request("FileNameTXT"))
		IsAllProducts = Trim(Request("IsAllProducts"))

		If FileNameTXT = "" Then
			AddError("Field <strong>File Name</strong> is required.")
		End If
	End Sub
%>