<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Feeds</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
			Dim sWhere : sWhere = "  "

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "1"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = " SELECT FeedID " & _
					 "		, FeedNetworkName " & _
					 "		, FeedFileNameTXT " & _
					 "		, FeedCompileDate " & _
					 "		, FeedIsAllProducts " & _
					 "		, FeedScriptName " & _
					 "		, (CASE WHEN FeedIsAllProducts = 0 " & _
					 "				THEN (SELECT COUNT(*) FROM utb_FeedProducts WHERE FeedID = f.FeedID) " & _
					 "	 			ELSE 0 " & _
					 "	 	  END) AS FeedProductCount " & _
					 "	 FROM utb_Feeds f " & _
					 sWhere & _
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

			Dim iCount : iCount = 0

			Dim oFS
			Set oFS = CreateObject("Scripting.FileSystemObject")
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<h2>Feeds</h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width:50px;"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Network Name", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("File Name", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:90px;"><%= GetURLForOrder("Products", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:120px;"><%= GetURLForOrder("Compile Date", "5", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:75px;">&nbsp;</td>
			</tr>
			<%
			While Not oQuery.Eof
				iCount = iCount + 1
			%>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td><%= oQuery("FeedID") %></td>
				<td style="text-align:left;"><%= oQuery("FeedNetworkName") %></td>
				<td style="text-align:left;">
					<%= oQuery("FeedFileNameTXT") %>
				</td>
				<td>
					<% If oQuery("FeedIsAllProducts") = "1" Then %>
					All Active
					<% Else %>
					<a href="FeedProductList.asp?FeedID=<%= oQuery("FeedID") %>"><%= oQuery("FeedProductCount") %></a>
					<% End If %>
				</td>
				<td><%= oQuery("FeedCompileDate") %></td>
				<td>
					<% If oQuery("FeedProductCount") > 0 Or oQuery("FeedIsAllProducts") = "1" Then %>
					<a href="<%= oQuery("FeedScriptName") %>"><img src="images/grid-act-compile.png" alt="Compile" title="Compile" width="16" height="16" /></a>
					<% Else %>
					<img src="images/grid-act-compile-off.png" alt="" title="Please add products to feed" width="16" height="16" />
					<% End If %>
					&nbsp;
					<a href="FeedForm.asp?Action=Edit&amp;ID=<%= oQuery("FeedID") %>"><img src="images/grid-act-edit.png" alt="" title="Edit" width="16" height="16" /></a>
					&nbsp;
					<% If oQuery("FeedProductCount") > 0 Then %>
					<a href="FeedForm.asp?Action=Delete&amp;ID=<%= oQuery("FeedID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" alt="" title="Remove all prodcuts from selected network" width="16" height="16" /></a>
					<% Else %>
					<img src="images/grid-act-delete-gray.png" alt="" title="" width="16" height="16" />
					<% End If %>
				</td>
			</tr>
			<%
			oQuery.MoveNext
			Wend
			%>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "FeedID"

		Select Case sIndex
			Case "1" sColumn = "FeedID"
			Case "2" sColumn = "FeedNetworkName"
			Case "3" sColumn = "FeedFileNameTXT"
			Case "4" sColumn = "(CASE WHEN FeedIsAllProducts = 0 THEN (SELECT COUNT(*) FROM utb_FeedProducts WHERE FeedID = f.FeedID) ELSE 0 END)"
			Case "5" sColumn = "FeedCompileDate"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>