<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("InfoPageList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, Title, Content, MetaTitle, MetaDescription, MetaKey
	Dim iInfoPageID

	Dim ValidatePage : ValidatePage = False ' True
	
	Select Case sAction
		Case "New"
			sTitle = "Add Info Page"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Info Page Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_InfoPages WHERE InfoPageID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("InfoPageName"))
				Title = HTMLEncode(oQuery("InfoPageTitle"))
				Content = oQuery("InfoPageContent")
				MetaTitle = HTMLEncode(oQuery("InfoPageMetaTitle"))
				MetaDescription = HTMLEncode(oQuery("InfoPageMetaDescription"))
				MetaKey = HTMLEncode(oQuery("InfoPageMetaKey"))
			End If
			oQuery.Close
			Set oQuery = Nothing

			If iID = 1 Then
				ValidatePage = False
			End If

		Case "Insert"
			sTitle = "Add Info Page"

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_InfoPages (InfoPageName, InfoPageTitle, InfoPageContent, InfoPageMetaTitle, InfoPageMetaDescription, InfoPageMetaKey) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Name) & "' " & _
						 " , '" & Quote(Title) & "' " & _
						 " , '" & Quote(Content) & "' " & _
						 " , " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " & _
						 " , " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " & _
						 " , " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " & _
						 " ) "
				oConn.Execute(sQuery)

				iInfoPageID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Info Page has been inserted.")
					Redirect("InfoPageForm.asp?Action=Edit&ID=" & iInfoPageID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Info Page Ref # " & iID

			If iID = 1 Then
				ValidatePage = False
			End If

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_InfoPages " & _
						 "	SET InfoPageName = '" & Quote(Name) & "' " & _
						 "	  , InfoPageTitle = '" & Quote(Title) & "' " & _
						 "	  , InfoPageContent = '" & Quote(Content) & "' " & _
						 "	  , InfoPageMetaTitle = " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " & _
						 "	  , InfoPageMetaDescription = " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " & _
						 "	  , InfoPageMetaKey = " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " & _
						 "  WHERE InfoPageID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iInfoPageID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Info Page has been updated.")
					Redirect("InfoPageForm.asp?Action=Edit&ID=" & iInfoPageID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_InfoPages " & _
					 "  WHERE InfoPageID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Info Page has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Info Pages</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<!--#include file="../ckeditor/ckeditor.asp"-->
	<form action="InfoPageForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><% If ValidatePage = True Then %><span class="asterisk">*</span> <% End If %>Title</td>
				<td><input type="text" class="form-field" name="Title" value="<%= Title %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><% If ValidatePage = True Then %><span class="asterisk">*</span> <% End If %>Content</td>
				<td>
				<%
					Set oEditor = New CKeditor
					oEditor.basePath = "../ckeditor/"
					oEditor.config("width") = 850
					oEditor.config("height") = 500
					oEditor.editor "Content", Content
				%>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Title</td>
				<td><textarea class="form-field limited limit_500" name="MetaTitle" style="width:500px;height:100px;"><%= MetaTitle %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Description</td>
				<td><textarea class="form-field limited limit_500" name="MetaDescription" style="width:500px;height:100px;"><%= MetaDescription %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Key</td>
				<td><textarea class="form-field limited limit_500" name="MetaKey" style="width:500px;height:100px;"><%= MetaKey %></textarea></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Title = Trim(Request("Title"))
		Content = Trim(Request("Content"))
		MetaTitle = Trim(Request("MetaTitle"))
		MetaDescription = Trim(Request("MetaDescription"))
		MetaKey = Trim(Request("MetaKey"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Title = "" And ValidatePage = True Then
			AddError("Field <strong>Title</strong> is required.")
		End If
		If Content = "" And ValidatePage = True Then
			AddError("Field <strong>Content</strong> is required.")
		End If
	End Sub
%>