<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("InfoSectionList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, Content, IsActive
	Dim iInfoSectionID

	Select Case sAction
		Case "New"
			sTitle = "Add Info Section"
			sAction = "Insert"

			IsActive = "0"

		Case "Edit"
			sTitle = "Edit Info Section Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_InfoSections WHERE InfoSectionID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("InfoSectionName"))
				Content = oQuery("InfoSectionContent")
				IsActive = oQuery("InfoSectionIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Info Section"

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_InfoSections (InfoSectionName, InfoSectionContent, InfoSectionIsActive) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Name) & "' " & _
						 " , '" & Quote(Content) & "' " & _
						 " , '" & Quote(IsActive) & "' " & _
						 " ) "
				oConn.Execute(sQuery)

				iInfoSectionID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Info Section has been inserted.")
					Redirect("InfoSectionForm.asp?Action=Edit&ID=" & iInfoSectionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Info Section Ref # " & iID

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_InfoSections " & _
						 "	SET InfoSectionName = '" & Quote(Name) & "' " & _
						 "	  , InfoSectionContent = '" & Quote(Content) & "' " & _
						 "	  , InfoSectionIsActive = '" & Quote(IsActive) & "' " & _
						 "  WHERE InfoSectionID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iInfoSectionID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Info Section has been updated.")
					Redirect("InfoSectionForm.asp?Action=Edit&ID=" & iInfoSectionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_InfoSections " & _
					 "  WHERE InfoSectionID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Info Section has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Info Sections</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<!--#include file="../ckeditor/ckeditor.asp"-->
	<form action="InfoSectionForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Content</td>
				<td><%
					Set oEditor = New CKeditor
					oEditor.basePath = "../ckeditor/"
					oEditor.config("width") = 850
					oEditor.config("height") = 400
					oEditor.editor "Content", Content
				%>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActive">Active</label></td>
				<td>
					<input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Content = Trim(Request("Content"))
		IsActive = Trim(Request("IsActive"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Content = "" Then
			AddError("Field <strong>Content</strong> is required.")
		End If
	End Sub
%>