<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ManufacturerList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, IsVisible, SortOrder, Description, MetaTitle, MetaDescription, MetaKey
	Dim Reserved1, Reserved2, Reserved3, Reserved4, Reserved5
	Dim iManufacturerID

	Dim sImageName : sImageName = GetValueFromTable(oConn, "ManufacturerImage", "utb_Manufacturers", "WHERE ManufacturerID = '" & Quote(iID) & "'")

	Select Case sAction
		Case "New"
			sTitle = "Add Manufacturer"
			sAction = "Insert"

			IsVisible = "1"
			SortOrder = "0"

		Case "Edit"
			sTitle = "Edit Manufacturer Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Manufacturers WHERE ManufacturerID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("ManufacturerName"))
				IsVisible = oQuery("ManufacturerIsVisible")
				SortOrder = oQuery("ManufacturerIsFeatured")
				Description = oQuery("ManufacturerDescription")
				MetaTitle = HTMLEncode(oQuery("ManufacturerMetaTitle"))
				MetaDescription = HTMLEncode(oQuery("ManufacturerMetaDescription"))
				MetaKey = HTMLEncode(oQuery("ManufacturerMetaKey"))
				Reserved1 = HTMLEncode(oQuery("ManufacturerReserved1"))
				Reserved2 = HTMLEncode(oQuery("ManufacturerReserved2"))
				Reserved3 = HTMLEncode(oQuery("ManufacturerReserved3"))
				Reserved4 = HTMLEncode(oQuery("ManufacturerReserved4"))
				Reserved5 = HTMLEncode(oQuery("ManufacturerReserved5"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Manufacturer"

			CommonValidation()

			If GetValueFromTable(oConn, "ManufacturerID", "utb_Manufacturers", "WHERE ManufacturerName = '" & Quote(Name) & "'") <> "" Then
				AddError("Manufacturer with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_Manufacturers (ManufacturerName, ManufacturerIsVisible, ManufacturerIsFeatured, ManufacturerDescription, ManufacturerMetaTitle, ManufacturerMetaDescription, ManufacturerMetaKey, ManufacturerReserved1, ManufacturerReserved2, ManufacturerReserved3, ManufacturerReserved4, ManufacturerReserved5) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Name) & "' " & _
						 " , " & IIF(IsVisible = "1", "1", "0") & " " & _
						 " , '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 " , " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 " , " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " & _
						 " , " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " & _
						 " , " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " & _
						 " , " & IIF(Reserved1 <> "", "'" & Quote(Reserved1) & "'", "NULL") & " " & _
						 " , " & IIF(Reserved2 <> "", "'" & Quote(Reserved2) & "'", "NULL") & " " & _
						 " , " & IIF(Reserved3 <> "", "'" & Quote(Reserved3) & "'", "NULL") & " " & _
						 " , " & IIF(Reserved4 <> "", "'" & Quote(Reserved4) & "'", "NULL") & " " & _
						 " , " & IIF(Reserved5 <> "", "'" & Quote(Reserved5) & "'", "NULL") & " " & _
						 " ) "
				oConn.Execute(sQuery)

				iManufacturerID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Manufacturer has been inserted.")
					Redirect("ManufacturerForm.asp?Action=Edit&ID=" & iManufacturerID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Manufacturer Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "ManufacturerID", "utb_Manufacturers", "WHERE ManufacturerName = '" & Quote(Name) & "' AND ManufacturerID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Manufacturer with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_Manufacturers " & _
						 "	SET ManufacturerName = '" & Quote(Name) & "' " & _
						 "	  , ManufacturerIsVisible = " & IIF(IsVisible = "1", "1", "0") & " " & _
						 "	  , ManufacturerIsFeatured = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , ManufacturerDescription = " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 "	  , ManufacturerMetaTitle = " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " & _
						 "	  , ManufacturerMetaDescription = " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " & _
						 "	  , ManufacturerMetaKey = " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " & _
						 "	  , ManufacturerReserved1 = " & IIF(Reserved1 <> "", "'" & Quote(Reserved1) & "'", "NULL") & " " & _
						 "	  , ManufacturerReserved2 = " & IIF(Reserved2 <> "", "'" & Quote(Reserved2) & "'", "NULL") & " " & _
						 "	  , ManufacturerReserved3 = " & IIF(Reserved3 <> "", "'" & Quote(Reserved3) & "'", "NULL") & " " & _
						 "	  , ManufacturerReserved4 = " & IIF(Reserved4 <> "", "'" & Quote(Reserved4) & "'", "NULL") & " " & _
						 "	  , ManufacturerReserved5 = " & IIF(Reserved5 <> "", "'" & Quote(Reserved5) & "'", "NULL") & " " & _
						 "  WHERE ManufacturerID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iManufacturerID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Manufacturer has been updated.")
					Redirect("ManufacturerForm.asp?Action=Edit&ID=" & iManufacturerID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_Manufacturers " & _
					 "  WHERE ManufacturerID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				If sImageName <> "" Then
					Call DeleteFile(Server.MapPath(C_MANUFACTURER_IMAGE_PATH) & "/" & sImageName)
				End If

				oConn.CommitTrans
				Call SetAlertMessage("success", "Manufacturer has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
	<script type="text/javascript" src="js/ajaxupload.js"></script>
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Manufacturers</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<!--#include file="../ckeditor/ckeditor.asp"-->
	<form action="ManufacturerForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsVisible">Visible</label></td>
				<td>
					<input type="checkbox" name="IsVisible" id="IsVisible" value="1" <%= IIF(IsVisible = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Featured</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Description</td>
				<td><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 850
						oEditor.config("height") = 300
						oEditor.editor "Description", Description
					%>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Title</td>
				<td><textarea class="form-field limited limit_500" name="MetaTitle" style="width:500px;height:100px;"><%= MetaTitle %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Description</td>
				<td><textarea class="form-field limited limit_500" name="MetaDescription" style="width:500px;height:100px;"><%= MetaDescription %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;">Meta Key</td>
				<td><textarea class="form-field limited limit_500" name="MetaKey" style="width:500px;height:100px;"><%= MetaKey %></textarea></td>
			</tr>
			<% If iID > 0 Then %>
			<tr>
				<td style="text-align:right;">Image</td>
				<td>
					<table>
						<tr>
							<td><img src="<%= IIF(sImageName <> "", C_MANUFACTURER_IMAGE_PATH & "/" & sImageName, C_NO_IMAGE_SMALL) %>" id="manufacturer_img" alt="" class="imgborder" /></td>
							<td style="vertical-align:bottom;" id="buttons_block">
								<div id="delete_button_block" style="padding-bottom:5px;<%= IIF(sImageName <> "", "", "display:none;") %>">
									<button id="delete_button" style="font-size:11px;width:60px;">Delete</button>
								</div>
								<div id="upload_button_block" style="padding-bottom:5px;">
									<button id="upload_button" style="font-size:11px;width:60px;">Browse</button>
								</div>
							</td>
						</tr>
					</table>
					<script type="text/javascript">
					//<![CDATA[
					var uploadingImg = '<div id="uploading_img" style="display:none;"><img src="images/uploading.gif" width="24" height="24" alt="Uploading..." /></div>';
					$(function(){
						$('#delete_button').click(function(){
							if (!areYouSure()) {
								return false;
							}

							$('#delete_button,#upload_button').hide();
							$('#buttons_block').append(uploadingImg);
							$('#uploading_img').fadeIn(function(){
								$.post('ajax/DeleteImage.asp', {Type: 'Manufacturer', ID: <%= iID %>}, function(res){
									$('#uploading_img').fadeOut(function(){
										$('#uploading_img').remove();

										if (res.success) {
											$('#delete_button_block').hide();
											$('#manufacturer_img').attr('src', res.src);
										}
										else if (typeof(res.redirect) != 'undefined') {
											redirect(res.redirect);
										}
										else if (typeof(res.message) != 'undefined') {
											alert('Error: ' + res.message);
										}
										else {
											alert('Unknown Error. Please contact support.');
										}
										$('#delete_button,#upload_button').show();
									});
								}, 'json');
							});

							return false;
						});
						new AjaxUpload('upload_button',{
							action: 'ajax/UploadImage.asp',
							name: 'File',
							responseType: 'json',
							data: {Type: 'Manufacturer', ID: <%= iID %>},
							onSubmit: function(file, ext){
								if (!(ext && /^(jpg|jpeg|gif|png)$/i.test(ext))){
									alert('Error: invalid file extension.');
									return false;
								}

								$('#delete_button,#upload_button').hide();
								$('#buttons_block').append(uploadingImg);
								$('#uploading_img').fadeIn();
							},
							onComplete: function(file, res){
								$('#uploading_img').fadeOut(function(){
									$('#uploading_img').remove();

									if (res.success) {
										$('#delete_button_block').show();
										$('#manufacturer_img').attr('src', res.src+'?rnd='+Math.random());
									}
									else if (typeof(res.redirect) != 'undefined') {
										redirect(res.redirect);
									}
									else if (typeof(res.message) != 'undefined') {
										alert('Error: ' + res.message);
									}
									else {
										alert('Unknown Error. Please contact support.');
									}
									$('#delete_button,#upload_button').show();
								});
							}
						});
					});
					//]]>
					</script>
				</td>
			</tr>
			<% End If %>
			<tr>
				<td style="text-align:right;">Reserved 1</td>
				<td><input type="text" class="form-field" name="Reserved1" value="<%= Reserved1 %>" style="width:820px;" maxlength="500" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Reserved 2</td>
				<td><input type="text" class="form-field" name="Reserved2" value="<%= Reserved2 %>" style="width:820px;" maxlength="500" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Reserved 3</td>
				<td><input type="text" class="form-field" name="Reserved3" value="<%= Reserved3 %>" style="width:820px;" maxlength="500" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Reserved 4</td>
				<td><input type="text" class="form-field" name="Reserved4" value="<%= Reserved4 %>" style="width:820px;" maxlength="500" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Reserved 5</td>
				<td><input type="text" class="form-field" name="Reserved5" value="<%= Reserved5 %>" style="width:820px;" maxlength="500" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		IsVisible = Trim(Request("IsVisible"))
		SortOrder = Trim(Request("SortOrder"))
		Description = Trim(Request("Description"))
		MetaTitle = Trim(Request("MetaTitle"))
		MetaDescription = Trim(Request("MetaDescription"))
		MetaKey = Trim(Request("MetaKey"))
		Reserved1 = Trim(Request("Reserved1"))
		Reserved2 = Trim(Request("Reserved2"))
		Reserved3 = Trim(Request("Reserved3"))
		Reserved4 = Trim(Request("Reserved4"))
		Reserved5 = Trim(Request("Reserved5"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Featured</strong> is invalid.")
			End If
		End If
	End Sub
%>