<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Upload.asp"-->
<%
	Dim iID : iID = IIF(Request("ID") = "", 0, Request("ID"))
	Dim sAction : sAction = Request("Action")

	Dim sBackURL : sBackURL = "NewsletterBlastList.asp"

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Subject, Header, Footer, ProductIDs, ProductCount, SortOrder
	Select Case sAction
		Case "Edit"
			sTitle = "Edit Newsletter Blast Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_NewsletterBlast WHERE NewsletterBlastID = " & iID)
			If Not oQuery.Eof Then
				Subject		= oQuery("NewsletterBlastSubject")
				Header		= oQuery("NewsletterBlastHeader")
				Footer		= oQuery("NewsletterBlastFooter")
				ProductIDs	= oQuery("NewsletterBlastProductIDs")
				ProductCount= oQuery("NewsletterBlastProductCount")
				SortOrder	= oQuery("NewsletterBlastSortOrder")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Update"
			sTitle = "Edit Newsletter Blast Ref # " & iID
			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_NewsletterBlast " &_
						 "	 SET NewsletterBlastSubject = '" & Quote(Subject) & "'" &_
						 "	   , NewsletterBlastHeader = '" & Quote(Header) & "'" &_
						 "	   , NewsletterBlastFooter = '" & Quote(Footer) & "'" &_
						 "	   , NewsletterBlastSortOrder = '" & Quote(SortOrder) & "'" &_
						 " WHERE NewsletterBlastID = " & iID
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Newsletter Blast has been updated.")
					Redirect("NewsletterBlastForm.asp?Action=Edit&ID=" & iID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="NewsletterBlastList.asp"> &laquo; Back</a>
			<h1>Newsletter Blast</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="NewsletterBlastAssignProducts.asp?ID=<%= iID %>">Assign Products (<%= FormatNumber(ProductCount, 0) %>)</a>
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<!--#include file="../ckeditor/ckeditor.asp"-->
			<form action="NewsletterBlastForm.asp" method="post">
				<input type="hidden" name="Action" id="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Subject</td>
						<td><input type="text" class="form-field" name="Subject" value="<%= Subject %>" style="width: 805px" maxlength="255"/></td>
					</tr>
					<tr>
						<td>Sort Order</td>
						<td>
							<select name="SortOrder" class="selector" style="width: 175px">
								<option value="">Select Products Sort Order</option>
								<option value="ProductName"<%= IIF(SortOrder = "ProductName", " selected=""selected""", "") %>>Product Name</option>
								<option value="ProductPrice DESC"<%= IIF(SortOrder = "ProductPrice DESC", " selected=""selected""", "") %>>Product Price Descending</option>
								<option value="ProductPrice ASC"<%= IIF(SortOrder = "ProductPrice ASC", " selected=""selected""", "") %>>Product Price Ascending</option>
								<option value="ProductID DESC"<%= IIF(SortOrder = "ProductID DESC", " selected=""selected""", "") %>>Product ID Descending</option>
								<option value="ProductID ASC"<%= IIF(SortOrder = "ProductID ASC", " selected=""selected""", "") %>>Product ID Ascending</option>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align:right;">Header</td>
						<td><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 850
						oEditor.config("height") = 300
						oEditor.editor "Header", Header
						Set oEditor = Nothing
					%>
						</td>
					</tr>
					<tr>
						<td style="text-align:right;">Footer</td>
						<td><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 850
						oEditor.config("height") = 300
						oEditor.editor "Footer", Footer
						Set oEditor = Nothing
					%>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Subject		= Trim(Request("Subject"))
		Header		= Trim(Request("Header"))
		Footer		= Trim(Request("Footer"))
		SortOrder	= Trim(Request("SortOrder"))

		If Subject = "" Then
			AddError("Field <strong>Subject</strong> is required.")
		End If
	End Sub

	Sub SetBackURL()
		Session("NewsletterBlastFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>