<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Select Case Request("Action")
		Case "AddRecord"
			Dim Subject : Subject = Trim(Request("Subject"))

			If Subject = "" Then
				AddError("Field <strong>Subject</strong> is required.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				oConn.Execute("INSERT INTO utb_NewsletterBlast(NewsletterBlastSubject, NewsletterBlastCreateDate) VALUES('" & Quote(Subject) & "', GETDATE())")

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Newsletter Blast has been added.")
					Redirect("NewsletterBlastForm.asp?Action=Edit&ID=" & GetLastID(oConn))
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "Delete"
			Dim iID : iID = Request("ID")
			If Not ValidateInteger(iID) Then
				Call SetAlertMessage("error", "Invalid ID")
			Else
				oConn.BeginTrans
				On Error Resume Next

				oConn.Execute("DELETE FROM utb_NewsletterBlast WHERE NewsletterBlastID = " & iID)
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Newsletter Blast has been deleted.")
					Redirect("NewsletterBlastList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Newsletter Blast</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		Dim sOrder, sArrow, sOrderBy
		sOrder = "1"
		sArrow = "2"
		If Request("Order") <> "" And Request("Arrow") <> "" Then
			sOrder = Request("Order")
			sArrow = Request("Arrow")
		End If
		sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

		sQuery = "SELECT NewsletterBlastID" &_
				 "	   , NewsletterBlastSubject" & _
				 "	   , NewsletterBlastProductCount" &_
				 "	   , NewsletterBlastCreateDate" &_
				 "	FROM utb_NewsletterBlast" &_
				 sOrderBy

		Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount, iCount
		iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
		iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
		Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
		iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		iCount = 0

		Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right icon-add" href="#" onclick="$(this).hide(); $('#add-record').fadeIn(function(){$('#Subject').focus()}); return false;"<%= IIF(Request("Action") = "AddRecord", " style='display: none'", "") %>>Add Newsletter Blast</a>
			<div id="add-record" style="float: right<%= IIF(Request("Action") <> "AddRecord", "; display: none", "") %>">
				<form action="NewsletterBlastList.asp?Action=AddRecord" method="post">
					<table class="no-border" style="border: 0">
						<tr>
							<td>Subject:</td>
							<td><input type="text" name="Subject" id="Subject" value="<%= Request("Subject") %>" maxlength="255" style="width: 400px" class="form-field" /></td>
							<td style="width: 10">&nbsp;</td>
							<td><input type="submit" value="Add" class="inline-btn" /></td>
						</tr>
					</table>
				</form>
			</div>
			<h2>Newsletter Blast</h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<tr class="head-line">
				<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Subject", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 80px"><%= GetURLForOrder("Products", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 120px"><%= GetURLForOrder("Created", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 50px">&nbsp;</td>
			</tr>
			<% While Not oQuery.Eof %>
				<% iCount = iCount + 1 %>
				<tr<%= IIF(iCount Mod 2 = 0, " class='row-hl'", "") %>>
					<td><%= oQuery("NewsletterBlastID") %></td>
					<td style="text-align:left;"><%= oQuery("NewsletterBlastSubject") %></td>
					<td style="text-align:right;"><a style="display: block" title="Click here to assign products" href="NewsletterBlastAssignProducts.asp?ID=<%= oQuery("NewsletterBlastID") %>"><%= FormatNumber(oQuery("NewsletterBlastProductCount"), 0) %></a></td>
					<td>&nbsp;<%= oQuery("NewsletterBlastCreateDate") %></td>
					<td>
						<a href="NewsletterBlastForm.asp?Action=Edit&amp;ID=<%= oQuery("NewsletterBlastID") %>"><img src="images/grid-act-edit.png" border="0" alt="" title="Edit" width="16" height="16" /></a>
						&nbsp;
						<a href="NewsletterBlastList.asp?Action=Delete&amp;ID=<%= oQuery("NewsletterBlastID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" border="0" alt="" title="Delete" width="16" height="16" /></a>
					</td>
				</tr>
				<% oQuery.MoveNext %>
			<% Wend %>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
		oQuery.Close
		Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "NewsletterBlastID"

		Select Case sIndex
			Case "1" sColumn = "NewsletterBlastID"
			Case "2" sColumn = "NewsletterBlastSubject"
			Case "3" sColumn = "NewsletterBlastProductCount"
			Case "4" sColumn = "NewsletterBlastCreateDate"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>