<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sTypeID : sTypeID = Trim(Request("TypeID"))
	Dim sBackURL : sBackURL = GetBackURL("NewsletterTypeList.asp")

	If sTypeID = "" Then
		Call SetAlertMessage("error", "Please select newsletter type(s) to compile")
		Redirect(sBackURL)
	End If

	Dim sFileName : sFileName = "site_emails.txt"
	Dim sFilePath : sFilePath = Server.MapPath(C_COMPILE_FILE_PATH & "/" & sFileName)

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	' Newsletter Info
	Set oQuery = oConn.Execute("SELECT * FROM utb_NewsletterTypes WHERE NewsletterTypeID IN(" & Quote(sTypeID) & ")")
	If oQuery.Eof Then
		Call SetAlertMessage("error", "Newsletter type(s) not found.")
		Redirect(sBackURL)
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim sQueryCount
	sQuery = " SELECT DISTINCT(NewsletterEmail) " &_
			 "   FROM utb_Newsletters " &_
			 "  WHERE NewsletterTypeID IN(" & Quote(sTypeID) & ") " &_
			 "  ORDER BY NewsletterEmail"

	sQueryCount = " SELECT COUNT(*) AS TotalCount " &_
				  "   FROM utb_Newsletters " &_
				  "  WHERE NewsletterTypeID IN(" & Quote(sTypeID) & ")"

	Dim RecordsCompiled : RecordsCompiled = 0
	
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		Dim oFS, oFSFile
		Set oFS = CreateObject("Scripting.FileSystemObject")
		Set oFSFile = oFS.OpenTextFile(sFilePath, 2, true)
		oFSFile.Close()
		Set oFSFile = Nothing

		Set oFSFile = oFS.OpenTextFile(sFilePath, 8, true)
		While Not oQuery.Eof
			oFSFile.Write(IIF(RecordsCompiled > 0, VbCrLf, "") & LCase(oQuery("NewsletterEmail")))
			RecordsCompiled = RecordsCompiled + 1
			oQuery.MoveNext
		Wend
		oFSFile.Close()
		Set oFSFile = Nothing
	Else
		Call SetAlertMessage("error", "No email found to compile.")
		Redirect(sBackURL)
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim RecordsCount : RecordsCount = 0
	Set oQuery = oConn.Execute(sQueryCount)
	If Not oQuery.Eof Then
		RecordsCount = oQuery("TotalCount")
	End If
	oQuery.Close
	Set oQuery = Nothing

	If Err.Number <> 0 Then
		Call SetAlertMessage("error", Err.Description)
		Redirect(sBackURL)
	End If
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Newsletter</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2>Newsletter file information</h2>
</div>
<table cellpadding="4" style="margin-left: 7px">
	<tr>
		<td>Emails selected:</td>
		<td><%= RecordsCount %></td>
	</tr>
	<tr>
		<td>Emails write:</td>
		<td><%= RecordsCompiled %></td>
	</tr>
	<tr>
		<td>File path:</td>
		<td><a href="<%= C_COMPILE_FILE_PATH & "/" & sFileName %>"><%= C_DOMAIN_PATH & Replace(C_COMPILE_FILE_PATH, "../", "/") & "/" & sFileName %></a></td>
	</tr>
</table>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>