<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("NesletterList.asp")

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	
	Select Case sAction
		Case "AddEmail"
			Dim TypeID : TypeID = Trim(Request("TypeID"))
			Dim Email : Email = Trim(Request("Email"))

			If TypeID = "" Then
				AddError("Field <strong>Type</strong> is required.")
			End If

			If Email = "" Then
				AddError("Field <strong>Email</strong> is required.")
			ElseIf Not ValidateEmail(Email) Then
				AddError("Field <strong>Email</strong> is invalid.")
			ElseIf GetValueFromTable(oConn, "NewsletterID", "utb_Newsletters", "WHERE NewsletterEmail = '" & Quote(Email) & "' AND NewsletterTypeID = '" & Quote(TypeID) & "'") <> "" Then
				AddError("Email <strong>" & Email & "</strong> already exist in newsletter type <strong>" & GetValueFromTable(oConn, "NewsletterTypeName", "utb_NewsletterTypes", "WHERE NewsletterTypeID = " & TypeID) & "</strong>.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " INSERT INTO utb_Newsletters " &_
						 " (NewsletterEmail, NewsletterTypeID) " &_
						 " VALUES " &_
						 " ('" & Quote(Email) & "', '" & Quote(TypeID) & "') "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Email has been added.")
					Redirect("NewsletterList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "Delete"
			If Not ValidateInteger(iID) Then
				Call SetAlertMessage("success", "Invalid ID.")
				Redirect("NewsletterList.asp")
			Else
				oConn.BeginTrans
				On Error Resume Next

				oConn.Execute("DELETE FROM utb_Newsletters WHERE NewsletterID = " & iID)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Email has been deleted.")
					Redirect("NewsletterList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
	End Select

	Dim sTypesHtml, sTypeSel
	Set oQuery = oConn.Execute("SELECT NewsletterTypeID, NewsletterTypeName FROM utb_NewsletterTypes ORDER BY NewsletterTypeName")
	While Not oQuery.Eof
		sTypeSel = IIF(CStr(Request("TypeID")) = CStr(oQuery("NewsletterTypeID")), " selected='selected'", "")
		sTypesHtml = sTypesHtml &_
			"<option value='" & oQuery("NewsletterTypeID") & "'" & sTypeSel & ">" & oQuery("NewsletterTypeName") & "</option>"

		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Newsletter</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
			Dim SearchEmail : SearchEmail = Quote(Trim(Request("SearchEmail")))

			Dim sWhere : sWhere = IIF(SearchEmail <> "", " WHERE n.NewsletterEmail LIKE '%" & SearchEmail & "%' ", "")
			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")
			sQuery = " SELECT n.NewsletterID " & _
					 "	  , n.NewsletterEmail" & _
					 "	  , nt.NewsletterTypeName " & _
					 "	  , n.NewsletterCreateDate " & _
					 "   FROM utb_Newsletters AS n " & _
					 "		INNER JOIN utb_NewsletterTypes AS nt ON nt.NewsletterTypeID = n.NewsletterTypeID " & _
					 sWhere & _
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

			Dim iCount : iCount = 0
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right icon-add" href="#" onclick="$(this).hide(); $('#add-email').fadeIn(); return false"<%= IIF(Request("Action") = "AddEmail", " style='display: none'", "") %>>Add Email</a>
			<div id="add-email" style="float: right<%= IIF(Request("Action") <> "AddEmail", "; display: none", "") %>">
				<form action="NewsletterList.asp?Action=AddEmail" method="post">
					<table class="no-border" style="border: 0">
						<tr>
							<td>Type:</td>
							<td>
								<select class="selector" name="TypeID" style="width: 175px">
									<option value="">Select One</option>
									<%= sTypesHtml %>
								</select>
							</td>
							<td style="width: 10">&nbsp;</td>
							<td>Email:</td>
							<td><input type="text" name="Email" value="<%= Request("Email") %>" maxlength="255" style="width: 200px" class="form-field" /></td>
							<td style="width: 10">&nbsp;</td>
							<td><input type="submit" value="Add" class="inline-btn" /></td>
						</tr>
					</table>
				</form>
			</div>
			<div>
				<% Dim sEmptyText : sEmptyText = "Enter email here" %>
				<form action="" method="get" onsubmit="if($('#SearchEmail').val()=='<%= sEmptyText %>'){$('#SearchEmail').focus();return false;}">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td><input type="text" name="SearchEmail" id="SearchEmail" class="form-field" style="width: 150px" maxlength="255" value="<%= IIF(SearchEmail <> "", SearchEmail, sEmptyText) %>" onfocus="if($(this).val()=='<%= sEmptyText %>')$(this).val('')" onblur="if($(this).val()=='')$(this).val('<%= sEmptyText %>')" /></td>
							<td><input type="submit" class="inline-btn" value="Search" /></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('NewsletterList.asp')" /></td>
						</tr>
					</table>
				</form>
			</div>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Email", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Type", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 125px"><%= GetURLForOrder("Created", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 25px">&nbsp;</td>
			</tr>
			<% While Not oQuery.Eof %>
				<% iCount = iCount + 1 %>
				<tr<%= IIF(iCount Mod 2 = 0, " class='row-hl'", "") %>>
					<td><%= oQuery("NewsletterID") %></td>
					<td style="text-align: left"><%= oQuery("NewsletterEmail") %></td>
					<td style="text-align: left"><%= oQuery("NewsletterTypeName") %></td>
					<td>&nbsp;<%= oQuery("NewsletterCreateDate") %></td>
					<td><a href="NewsletterList.asp?Action=Delete&amp;ID=<%= oQuery("NewsletterID") %>" onclick="return areYouSure()"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16"/></a></td>
				</tr>
				<% oQuery.MoveNext %>
			<% Wend %>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "NewsletterID"

		Select Case sIndex
			Case "1" sColumn = "NewsletterID"
			Case "2" sColumn = "NewsletterEmail"
			Case "3" sColumn = "NewsletterTypeName"
			Case "4" sColumn = "NewsletterCreateDate"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>