<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("NesletterTypeList.asp")

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Select Case sAction
		Case "AddType"
			Dim Name : Name = Trim(Request("Name"))

			If Name = "" Then
				AddError("Field <strong>Name</strong> is required.")
			ElseIf GetValueFromTable(oConn, "NewsletterTypeID", "utb_NewsletterTypes", "WHERE NewsletterTypeName = '" & Quote(Name) & "'") <> "" Then
				AddError("Name <strong>" & Name & "</strong> already exists in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " INSERT INTO utb_NewsletterTypes (NewsletterTypeName) " &_
						 " VALUES ('" & Quote(Name) & "') "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Newsletter type has been added.")
					Redirect("NewsletterTypeList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "Delete"
			If Not ValidateInteger(iID) Then
				Call SetAlertMessage("success", "Invalid ID.")
				Redirect("NewsletterTypeList.asp")
			Else
				oConn.BeginTrans
				On Error Resume Next

				oConn.Execute("DELETE FROM utb_NewsletterTypes WHERE NewsletterTypeID = " & iID & " AND NewsletterTypeIsSystem = 0")

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Newsletter type has been deleted.")
					Redirect("NewsletterTypeList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
	<h1>Newsletter</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<%
	' Order By
	Dim sOrder, sArrow, sOrderBy
	sOrder = "1"
	sArrow = "2"
	If Request("Order") <> "" And Request("Arrow") <> "" Then
		sOrder = Request("Order")
		sArrow = Request("Arrow")
	End If
	sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

	' Query
	sQuery = " SELECT nt.NewsletterTypeID " & _
			 "   	, nt.NewsletterTypeName " & _
			 "   	, nt.NewsletterTypeIsSystem " & _
			 "   	, nt.NewsletterTypeCreateDate " & _
			 "   	, (SELECT COUNT(*) FROM utb_Newsletters WHERE NewsletterTypeID = nt.NewsletterTypeID) AS EmailsCount " & _
			 "   FROM utb_NewsletterTypes AS nt " & _
			 sOrderBy

	' Pager
	Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
	iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
	iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
	Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
	iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

	Dim iCount : iCount = 0
%>
<div class="box-head">
	<!--#include file="inc/PagerBackend.asp"-->
	<a class="head-link-right icon-add" href="#" onclick="$(this).hide(); $('#add-type').fadeIn(); return false;"<%= IIF(Request("Action") = "AddType", " style='display: none'", "") %>>Add New Type</a>
	<div id="add-type" style="float: right<%= IIF(Request("Action") <> "AddType", "; display: none", "") %>">
		<form action="NewsletterTypeList.asp?Action=AddType	" method="post">
			<table class="no-border" style="border: 0">
				<tr>
					<td>Name:</td>
					<td><input type="text" name="Name" value="<%= Request("Name") %>" maxlength="255" style="width: 200px" class="form-field" /></td>
					<td style="width: 10">&nbsp;</td>
					<td><input type="submit" value="Add" class="inline-btn" /></td>
				</tr>
			</table>
		</form>
	</div>
	<h2>Newsletter Types</h2>
</div>
<form action="NewsletterCompile.asp" method="post">
	<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
		<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
		<tr class="head-line">
			<td style="width: 20px"><input type="checkbox" id="check-all" onclick="$('.type-checkbox').attr('checked', $(this).attr('checked'));" /></td>
			<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
			<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
			<td><%= GetURLForOrder("Type", "3", sOrderQuery, sOrder, sArrow) %></td>
			<td><%= GetURLForOrder("Emails", "4", sOrderQuery, sOrder, sArrow) %></td>
			<td style="width: 120px"><%= GetURLForOrder("Created", "5", sOrderQuery, sOrder, sArrow) %></td>
			<td style="width: 25px">&nbsp;</td>
		</tr>
		<% While Not oQuery.Eof %>
			<% iCount = iCount + 1 %>
			<tr<%= IIF(iCount Mod 2 = 0, " class='row-hl'", "") %>>
				<td>
					<% If oQuery("EmailsCount") > 0 Then %>
					<input type="checkbox" name="TypeID" class="type-checkbox" value="<%= oQuery("NewsletterTypeID") %>" />
					<% End If %>
				</td>
				<td><%= oQuery("NewsletterTypeID") %></td>
				<td style="text-align:left;"><%= oQuery("NewsletterTypeName") %></td>
				<td><%= IIF(oQuery("NewsletterTypeIsSystem") = 1, "<span style='color:#e20000;'>System</span>", "<span style='color:#159600;'>User</span>") %></td>
				<td><%= oQuery("EmailsCount") %></td>
				<td><%= oQuery("NewsletterTypeCreateDate") %></td>
				<td>
					<% If oQuery("NewsletterTypeIsSystem") = 0 Then %>
					<a href="NewsletterTypeList.asp?Action=Delete&amp;ID=<%= oQuery("NewsletterTypeID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" border="0" alt="" title="Delete" width="16" height="16" /></a>
					<% Else %>
					<img src="images/grid-act-delete-gray.png" alt="" title="" width="16" height="16" />
					<% End If %>
				</td>
			</tr>
			<% oQuery.MoveNext %>
		<% Wend %>
	</table>
	<div style="padding-top: 5px">
		<input type="submit" value="Compile" id="add-btn" disabled="disabled" class="form-btn" />
		<input type="reset" value="Reset" id="reset-btn" disabled="disabled" class="form-btn" onclick="$('#add-btn').val('Compile').attr('disabled',true); this.disabled='disabled'" />
	</div>
</form>
<script type="text/javascript">
function checkBoxes() {
	var checkedCnt = 0;
	var allChecked = true;
	$('.type-checkbox').each(function(){
		if (!$(this).attr('checked')) {
			if (allChecked == true) {
				allChecked = false;
			}
		}
		else {
			checkedCnt++;
		}
	});
	$('#check-all').attr('checked', allChecked);
	if (checkedCnt > 0) {
		$('#add-btn').val('Compile (' + checkedCnt + ')').attr('disabled', false);
		$('#reset-btn').attr('disabled', false);
	}
	else {
		$('#add-btn').val('Compile').attr('disabled', true);
		$('#reset-btn').attr('disabled', true);
	}
}
$(function(){
	$('.type-checkbox,#check-all').click(checkBoxes);
});
</script>
<% If iRecordCount = 0 Then %>
	<!--#include file="inc/NoRecords.asp"-->
<% End If %>
<%
	oQuery.Close
	Set oQuery = Nothing
%>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "NewsletterTypeID"

		Select Case sIndex
			Case "1" sColumn = "NewsletterTypeID"
			Case "2" sColumn = "NewsletterTypeName"
			Case "3" sColumn = "NewsletterTypeIsSystem"
			Case "4" sColumn = "(SELECT COUNT(*) FROM utb_Newsletters WHERE NewsletterTypeID = nt.NewsletterTypeID)"
			Case "5" sColumn = "NewsletterTypeCreateDate"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>