<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	SetBackURL()

	Dim iOrderID : iOrderID = Request("OrderID")
	Dim sBackURL : sBackURL = GetBackURL("OrderForm.asp?OrderID=" & iOrderID)

	If Not ValidateInteger(iOrderID) Then
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order Charge History</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
			Dim sWhere : sWhere = "WHERE p.OrderID = " & iOrderID

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = "SELECT p.*" & _
					 "	   , pt.PaymentTypeName" & _
					 "	   , pg.PaymentGatewayName" & _
					 "	FROM utb_Payments AS p" & _
					 "		 LEFT JOIN utb_PaymentTypes AS pt ON pt.PaymentTypeID = p.PaymentTypeID" & _
					 "		 LEFT JOIN utb_PaymentGateways AS pg ON pg.PaymentGatewayID = p.PaymentGatewayID" & _
					 " " & sWhere & _
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

			Dim iCount : iCount = 0
			Dim sCCNumber
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<h2>Order # <%= iOrderID %></h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width: 25px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Gateway", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Type", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td>Billing Information</td>
				<td>Account Information</td>
				<td>Transaction<br />
					<% Response.Write GetURLForOrder("Type", "4", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("ID", "5", sOrderQuery, sOrder, sArrow) %>
				</td>
				<td>Status<br />
					<% Response.Write GetURLForOrder("ID", "6", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("Text", "7", sOrderQuery, sOrder, sArrow) %>
				</td>
				<td>Error<br />
					<% Response.Write GetURLForOrder("Code", "8", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("Text", "9", sOrderQuery, sOrder, sArrow) %>
				</td>
				<td><% Response.Write GetURLForOrder("Approval", "10", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("AVS", "11", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("CVV2", "12", sOrderQuery, sOrder, sArrow)
					%><br />
					Code
				</td>
				<td><%= GetURLForOrder("Total", "13", sOrderQuery, sOrder, sArrow) %></td>
				<td>Create<br />
					<% Response.Write GetURLForOrder("Date", "14", sOrderQuery, sOrder, sArrow) &_
					"&nbsp;/&nbsp;" & GetURLForOrder("User", "15", sOrderQuery, sOrder, sArrow) %>
				</td>
			</tr>
			<%
			While Not oQuery.Eof
				iCount = iCount + 1
				If Not IsNullOrEmpty(oQuery("PaymentAccountNumber1")) Then
					sCCNumber = Decode(oQuery("PaymentAccountNumber1"))
					sCCNumber = PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X")
				Else
					sCCNumber = ""
				End If
			%>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td rowspan="2"><%= oQuery("PaymentID") %></td>
				<td rowspan="2"><%= oQuery("PaymentGatewayName") %></td>
				<td rowspan="2"><%= oQuery("PaymentTypeName") %></td>
				<td style="text-align: left" valign="top" rowspan="2">
					<ul style="margin: 0; padding: 0; list-style: none">
						<li><strong>Name:</strong> <%= oQuery("PaymentBillingFirstName") & " " & oQuery("PaymentBillingLastName") %></li>
						<li><strong>Company:</strong> <%= oQuery("PaymentBillingCompanyName") %></li>
						<li><strong>Address:</strong> <%
						Response.Write oQuery("PaymentBillingAddress1") &_
							IIF(Not IsNull(oQuery("PaymentBillingAddress2")) And oQuery("PaymentBillingAddress2") <> "", " (" & oQuery("PaymentBillingAddress2") & ")", "") &_
							", " & oQuery("PaymentBillingCity") &_
							", " & oQuery("PaymentBillingState") &_
							", " & oQuery("PaymentBillingZip") %></li>
						<li><strong>Country:</strong> <%= oQuery("PaymentBillingCountry") %></li>
						<li><strong>Home&nbsp;Phone:</strong>&nbsp;<%= oQuery("PaymentBillingHomePhone") %></li>
					<% If Not IsNull(oQuery("PaymentBillingAltPhone")) And oQuery("PaymentBillingAltPhone") <> "" Then %>
						<li><strong>Alt&nbsp;Phone:</strong> <%= oQuery("PaymentBillingAltPhone") %></li>
					<% End If %>
					</ul>
				</td>
				<td style="text-align: left" valign="top" nowrap="nowrap" rowspan="2">
					<ul style="margin: 0; padding: 0; list-style: none">
						<li><strong>Name:</strong> <%= oQuery("PaymentAccountName") %></li>
						<li><strong>Number1:</strong> <%= sCCNumber %></li>
						<li><strong>Number2:</strong> <%= oQuery("PaymentAccountNumber2") %></li>
					<% If Not IsNull(oQuery("PaymentAccountNumber3")) Then %>
						<li><strong>Number3:</strong> <%= oQuery("PaymentAccountNumber3") %></li>
					<% End If %>
					<% If Not IsNull(oQuery("PaymentAccountNumber4")) Then %>
						<li><strong>Number4:</strong> <%= oQuery("PaymentAccountNumber4") %></li>
					<% End If %>
						<li><strong>Exp. Date:</strong> <%= PrependChar(oQuery("PaymentCardExpMonth"), 2, "0") & "/" & oQuery("PaymentCardExpYear") %></li>
					</ul>
				</td>
				<td><%= oQuery("PaymentTransType") & "&nbsp;/&nbsp;" & oQuery("PaymentTransID") %></td>
				<td><%= oQuery("PaymentStatusID") & "&nbsp;/&nbsp;" & oQuery("PaymentStatusText") %></td>
				<td><%= oQuery("PaymentErrorCode") %> / <%= oQuery("PaymentErrorText") %></td>
				<td><%= oQuery("PaymentApprovalCode") %> / <%= oQuery("PaymentAVSCode") %> / <%= oQuery("PaymentCVV2Code") %></td>
				<td rowspan="2"><%= CurrencyFormat(oQuery("PaymentTotal"), 2) %></td>
				<td rowspan="2"><%= oQuery("CreateDate") %><br /><br />By <%= oQuery("CreateUser") %></td>
			</tr>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td colspan="4"><%= oQuery("PaymentStatusReason") %></td>
			</tr>
			<%
			oQuery.MoveNext
			Wend
			%>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "PaymentID"

		Select Case sIndex
			Case "1" sColumn = "PaymentID"
			Case "2" sColumn = "PaymentGatewayName"
			Case "3" sColumn = "PaymentTypeName"
			Case "4" sColumn = "PaymentTransType"
			Case "5" sColumn = "PaymentTransID"
			Case "6" sColumn = "PaymentStatusID"
			Case "7" sColumn = "PaymentStatusText"
			Case "8" sColumn = "PaymentErrorCode"
			Case "9" sColumn = "PaymentErrorText"
			Case "10" sColumn = "PaymentApprovalCode"
			Case "11" sColumn = "PaymentAVSCode"
			Case "12" sColumn = "PaymentCVV2Code"
			Case "13" sColumn = "PaymentTotal"
			Case "14" sColumn = "CreateDate"
			Case "15" sColumn = "CreateUser"
		End Select

		GetColumnByIndex = sColumn
	End Function

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderFormBackURL") = "", sDefaultURL, Session("OrderFormBackURL"))
	End Function

	Sub SetBackURL()
		Session("OrderChargeHistoryBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>