﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("OrderForm.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update", "Delete", "ChangeTax", "InsertItem", "AddProducts")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery, k
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	sQuery = " SELECT o.* " & _
			 "	  , (CASE WHEN OrderTaxExemption = 0 THEN o.OrderTaxAmount ELSE 0 END) AS OrderTaxAmount " & _
			 "	  , os.OrderStatusName " & _
			 "	  , os.OrderStatusColor " & _
			 "	  , (CAST(o.OrderCreateDate AS DATE)) AS _OrderCreateDate" & _
			 "   FROM utb_Orders o " & _
			 "		INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID " & _
			 "		LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID " & _
			 "  WHERE o.OrderID = " & iID

	Dim oOrder
	Set oOrder = oConn.Execute(sQuery)

	If oOrder.Eof Then
		AddError("Order #" & iID & " not found.")
		Redirect(sBackURL)
	End If

	Dim arProductStatus
	Set arProductStatus = Server.CreateObject("Scripting.Dictionary")
	Set oQuery = oConn.Execute("SELECT * FROM utb_ProductStatuses ORDER BY ProductStatusID")
	While Not oQuery.Eof
		arProductStatus.Add CStr(oQuery("ProductStatusID")), CStr(oQuery("ProductStatusName"))
		oQuery.MoveNext
	Wend
	oQuery.Close

	Dim arProductStatusKeys : arProductStatusKeys = arProductStatus.Keys

	Select Case sAction
		Case "Update"
			If Request("DeliveryPrice") <> "" Then
				If Not ValidateDecimal(Request("DeliveryPrice")) Then
					AddError("Field <strong>Shipping Price</strong> is invalid.")
				End If
			End If

			If Request("PromoPrice") <> "" Then
				If Not ValidateDecimal(Request("PromoPrice")) Then
					AddError("Field <strong>Promo Price</strong> is invalid.")
				ElseIf Request("PromoPrice") > 0 Then
					AddError("Field <strong>Promo Price</strong> is invalid, it should be negative.")
				End If
			End If

			If Request("HandlingInsurance") <> "" Then
				If Not ValidateDecimal(Request("HandlingInsurance")) Then
					AddError("Field <strong>Handling Insurance</strong> is invalid.")
				End If
			End If

			If Not IsError() Then
				Dim iDetailCount
				Dim DetailID : DetailID = Split(Request("_DetailID"), ", ")
				Dim ProductSKU : ProductSKU = Split(Request("_ProductSKU"), ", ")
				Dim ProductPrice : ProductPrice = Split(Request("_ProductPrice"), ", ")
				Dim ProductStatusID : ProductStatusID = Split(Request("_ProductStatusID"), ", ")
				Dim ProductQuantity : ProductQuantity = Split(Request("_ProductQuantity"), ", ")

				Dim arQuery
				ReDim arQuery(UBound(DetailID))

				Dim ID, SKU, Price, StatusID, Quantity
				For iDetailCount = 0 To UBound(DetailID)
					ID = Trim(DetailID(iDetailCount))
					SKU = Trim(ProductSKU(iDetailCount))
					Price = Trim(ProductPrice(iDetailCount))
					StatusID = Trim(ProductStatusID(iDetailCount))
					Quantity = Trim(ProductQuantity(iDetailCount))

					If Not ValidateDecimal(Price) Then
						AddError("Field <strong>Price</strong> for item '" & SKU & "' is invalid.")
					End If

					If Not ValidateInteger(Quantity) Then
						AddError("Field <strong>Quantity</strong> for item '" & SKU & "' is invalid.")
					End If

					If Not IsError() Then
						If Quantity <= 0 Then
							sQuery = " DELETE" &_
									 "	 FROM utb_OrderDetails" &_
									 "	WHERE OrderDetailID = " & ID
						Else
							sQuery = " UPDATE utb_OrderDetails" &_
									 "	  SET ProductPrice = '" & IIF(Price = "", "0", Quote(DecimalPatch(Price))) & "'" &_
									 "		, ProductStatusID = '" & Quote(StatusID) & "'" &_
									 "		, OrderDetailProductQuantity = '" & IIF(Quantity = "", "0", Quote(Quantity)) & "'" &_
									 "	WHERE OrderDetailID = " & ID
						End If
						arQuery(iDetailCount) = sQuery
					End If
				Next
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next
			
				' Update Details
				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If
			
				' Update Order
				sQuery = " UPDATE utb_Orders " &_
						 "	SET OrderDeliveryMethod = '" & Quote(Request("DeliveryMethod")) & "' " &_
						 "	  , OrderDeliveryPrice = '" & IIF(Request("DeliveryPrice") = "", "0", Quote(DecimalPatch(Request("DeliveryPrice")))) & "' " &_
						 "	  , OrderPromoCode = '" & Quote(Request("PromoCode")) & "' " &_
						 "	  , OrderPromoAmount = '" & IIF(Request("PromoPrice") = "", "0", Quote(DecimalPatch(Request("PromoPrice")))) & "' " &_
						 "	  , OrderHandlingInsurance = '" & IIF(Request("HandlingInsurance") = "", "0", Quote(DecimalPatch(Request("HandlingInsurance")))) & "' " &_
						 "  WHERE OrderID = " & iID
				oConn.Execute(sQuery)
			
				Call OrderAddNote(oConn, iID, "Updated Order Details Information", 0, 1)
				Call OrderUpdateTax(oConn, iID)
			
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Details has been updated.")
					Redirect("OrderDetailsForm.asp?Action=Edit&ID=" & iID)
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "Delete"
			If Not ValidateInteger(Request("OrderDetailID")) Then
				Call SetAlertMessage("error", "Invalid OrderDetailID")
			Else
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " DELETE " &_
						 "   FROM utb_OrderDetails " &_
						 "  WHERE OrderDetailID = " & Request("OrderDetailID")
				oConn.Execute(sQuery)

				Call OrderAddNote(oConn, iID, "Updated Order Details Information", 0, 1)
				Call OrderUpdateTax(oConn, iID)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Item has been deleted.")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
				Redirect("OrderDetailsForm.asp?Action=Edit&ID=" & iID)
			End If

		Case "ChangeTax"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " UPDATE utb_Orders " &_
					 "	SET OrderTaxExemption = (CASE WHEN OrderTaxExemption = 1 THEN 0 ELSE 1 END) " &_
					 "  WHERE OrderID = " & iID
			oConn.Execute(sQuery)
			
			Call OrderAddNote(oConn, iID, "Updated Order Details Information", 0, 1)
			Call OrderUpdateTax(oConn, iID)

			If Err.Number = 0 Then
				oConn.CommitTrans

				Dim OrderTaxExemption : OrderTaxExemption = GetValueFromTable(oConn, "OrderTaxExemption", "utb_Orders", "WHERE OrderID = " & iID)
				
				Call SetAlertMessage("success", "Tax has been " & IIF(OrderTaxExemption = "1", "deleted", "added") & ".")
				Redirect("OrderDetailsForm.asp?Action=Edit&ID=" & iID)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
			End If

		Case "InsertItem"
			Dim NonInventoryName : NonInventoryName = Trim(Request("NonInventoryName"))
			Dim NonInventoryPrice : NonInventoryPrice = Trim(Request("NonInventoryPrice"))
			Dim NonInventoryCost : NonInventoryCost = Trim(Request("NonInventoryCost"))
			Dim NonInventorySKU : NonInventorySKU = Trim(Request("NonInventorySKU"))

			If NonInventoryName = "" Then
				AddError("Field <strong>Name</strong> is required.")
			End If

			If NonInventoryPrice = "" Then
				AddError("Field <strong>Price</strong> is required.")
			Else
				If Not ValidateDecimal(NonInventoryPrice) Then
					AddError("Field <strong>Price</strong> is invalid.")
				End If
			End If

			If NonInventoryCost <> "" Then
				If Not ValidateDecimal(NonInventoryCost) Then
					AddError("Field <strong>Cost</strong> is invalid.")
				End If
			End If

			If NonInventorySKU = "" Then
				AddError("Field <strong>SKU</strong> is required.")
			ElseIf GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductSKU = '" & Quote(NonInventorySKU) & "'") <> "" Then
				AddError("Product with SKU <strong>" & NonInventorySKU & "</strong> already exist in database.")
			End If

			If C_CHECK_DUPLICATE_PRODUCT_NAME Then
				If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductName = '" & Quote(NonInventoryName) & "'") <> "" Then
					AddError("Product with name <strong>" & NonInventoryName & "</strong> already exist in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				NonInventoryPrice = IIF(NonInventoryPrice = "", "0", Quote(DecimalPatch(NonInventoryPrice)))
				NonInventoryCost = IIF(NonInventoryCost = "", "0", Quote(DecimalPatch(NonInventoryCost)))

				sQuery = "INSERT INTO utb_OrderDetails(" &_
						 "	OrderID" &_
						 ", ProductID" &_
						 ", ProductSKU" &_
						 ", ProductName" &_
						 ", ProductPrice" &_
						 ", ProductCost" &_
						 ", ProductStatusID" &_
						 ", OrderDetailCreateDate" &_
						 ") " &_
						 "VALUES(" &_
						 "	 " & iID &_
						 ", NULL" &_
						 ", '" & Quote(NonInventorySKU) & "'" &_
						 ", '" & Quote(NonInventoryName) & "'" &_
						 ", '" & NonInventoryPrice & "'" &_
						 ", '" & NonInventoryCost & "'" &_
						 ", 2" &_
						 ", GETDATE()" &_
						 ")"
				oConn.Execute(sQuery)

				Call OrderAddNote(oConn, iID, "Updated Order Details Information", 0, 1)
				Call OrderUpdateTax(oConn, iID)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Non inventory item has been added.")
					Redirect("OrderDetailsForm.asp?Action=Edit&ID=" & iID)
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "AddProducts"
			If Request("CheckedID") <> "" Then
				Dim ProductsCount
				ProductsCount = GetValueFromTable(oConn, "COUNT(*) AS ProductsCount", "utb_Products", "WHERE ProductID IN(" & Quote(Request("CheckedID")) & ")")

				If ProductsCount > 0 Then
					oConn.BeginTrans
					On Error Resume Next

					sQuery = " INSERT INTO utb_OrderDetails (OrderID, ProductID, ProductSKU, ProductName, ProductPrice, ProductCost, ProductStatusID) " &_
							 " SELECT " & iID & " " &_
							 "	  , ProductID " &_
							 "	  , ProductSKU " &_
							 "	  , ProductName " &_
							 "	  , ProductPrice " &_
							 "	  , ProductCost " &_
							 "	  , ProductStatusID " &_
							 "   FROM utb_Products " &_
							 "  WHERE ProductID IN(" & Quote(Request("CheckedID")) & ") "
					oConn.Execute(sQuery)

					Call OrderAddNote(oConn, iID, "Updated Order Details Information", 0, 1)
					Call OrderUpdateTax(oConn, iID)

					If Err.Number = 0 Then
						oConn.CommitTrans
						Call SetAlertMessage("success", "Products has been added.")
						Redirect("OrderDetailsForm.asp?Action=Edit&ID=" & iID)
					Else
						oConn.RollbackTrans
						Call SetAlertMessage("error", Err.Description)
					End If
				Else
					Call SetAlertMessage("error", "Products not found.")
				End If
			Else
				Call SetAlertMessage("error", "Please select products.")
			End If		  
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order # <%= iID %></h1>&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<a class="head-link-right icon-add" href="#" onclick="$(this).hide(); $('#add-non-inv').fadeIn(); return false;"<%= IIF(Request("Form") = "NonInventory", " style='display: none'", "") %>>Add non inventory item</a>
			<div id="add-non-inv" style="float: right<%= IIF(Request("Form") <> "NonInventory", "; display: none", "") %>">
				<form action="OrderDetailsForm.asp?Form=NonInventory" method="post">
					<div style="display: none">
						<input type="hidden" name="ID" value="<%= iID %>"/>
						<input type="hidden" name="Action" value="InsertItem"/>
					</div>
					<table class="no-border" style="border: 0">
						<tr>
							<td>Name:</td>
							<td><input type="text" name="NonInventoryName" value="<%= Request("NonInventoryName") %>" maxlength="255" style="width: 300px" /></td>
							<td style="width: 10">&nbsp;</td>
							<td>Price:</td>
							<td><input type="text" name="NonInventoryPrice" value="<%= Request("NonInventoryPrice") %>" maxlength="15" style="width: 70px" /></td>
							<td style="width: 10">&nbsp;</td>
							<td>Cost:</td>
							<td><input type="text" name="NonInventoryCost" value="<%= Request("NonInventoryCost") %>" maxlength="15" style="width: 70px" /></td>
							<td style="width: 10">&nbsp;</td>
							<td>SKU:</td>
							<td><input type="text" name="NonInventorySKU" value="<%= Request("NonInventorySKU") %>" maxlength="50" style="width: 70px" /></td>
							<td style="width: 10">&nbsp;</td>
							<td><input type="submit" value="Add" /></td>
						</tr>
					</table>
				</form>
			</div>
			<h2>Update Order Details &amp; Totals</h2>
		</div>
		<form action="OrderDetailsForm.asp" method="post">
			<div style="display: none">
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<input type="hidden" name="Action" value="Update"/>
			</div>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<tr class="head-line">
					<td>Sku</td>
					<td>Item</td>
					<td style="width: 85px">Price</td>
					<td style="width: 65px">Cost</td>
					<td style="width: 95px">Stock</td>
					<td style="width: 65px">Qty</td>
					<td style="width: 85px">Total</td>
					<td style="width: 50px">&nbsp;</td>
				</tr>
				<%
				Dim fSubTotal, fSubTotalCost, fShipping, fShippingCost, fInsurance, fPromo, sPromoCode, fTax

				fSubTotal = CCur(oOrder("OrderTotalAmount"))
				fSubTotalCost = CCur(oOrder("OrderCostAmount"))
				fShipping = CCur(oOrder("OrderDeliveryPrice"))
				fShippingCost = CCur(oOrder("OrderDeliveryCost"))
				fInsurance = CCur(oOrder("OrderHandlingInsurance"))
				fPromo = CCur(oOrder("OrderPromoAmount"))
				sPromoCode = IIF(IsNull(oOrder("OrderPromoCode")), "", oOrder("OrderPromoCode"))
				fTax = CCur(oOrder("OrderTaxAmount"))

				Dim i : i = 0
				Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = " & iID)
				While Not oQuery.Eof
					%>
					<tr valign="top"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
						<td style="text-align: left"><%= oQuery("ProductSKU") %></td>
						<td style="text-align: left"><%= oQuery("ProductName") %> &nbsp; <span style="color: #999999"><%= oQuery("OrderDetailType") %></span></td>
						<td style="text-align: center">
							<input type="hidden" name="_DetailID" value="<%= oQuery("OrderDetailID") %>"/>
							<input type="hidden" name="_ProductSKU" value="<%= oQuery("ProductSKU") %>"/>
							<input name="_ProductPrice" value="<%= DecimalFormat(oQuery("ProductPrice"), 2) %>" maxlength="15" type="text" style="width: 70px; text-align: right"/>
						</td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductCost"), 2) %></td>
						<td style="text-align: center">
							<select name="_ProductStatusID">
							<%
								Dim sProductStatusKey
								For Each sProductStatusKey In arProductStatusKeys
							%>
								<option value="<%= sProductStatusKey %>" <%= IIF(sProductStatusKey = CStr(oQuery("ProductStatusID")), "selected='selected'", "") %>><%= arProductStatus.Item(sProductStatusKey) %></option>
							<%
								Next
							%>	
							</select>
						</td>
						<td style="text-align: center"><input name="_ProductQuantity" value="<%= oQuery("OrderDetailProductQuantity") %>" maxlength="3" type="text" style="width: 50px; text-align: center"/></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("Total"), 2) %></td>
						<td style="text-align: center">
							<a href="OrderDetailsForm.asp?ID=<%= iID %>&amp;Action=Edit&amp;AccessoriesSearch=<%= oQuery("ProductID") %>#assignlist"><img src="images/p_accessories.png" alt="" title="Accessories" width="16" height="16"/></a>
							&nbsp;
							<a href="OrderDetailsForm.asp?Action=Delete&amp;ID=<%= iID %>&amp;OrderDetailID=<%= oQuery("OrderDetailID") %>" onclick="return areYouSure()"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16"/></a>
						</td>
					</tr>
					<% 
					i = i + 1
					oQuery.MoveNext
				Wend
				oQuery.Close
				Set oQuery = Nothing

				Dim fTotalOrder, fTotalCost, fPNL, fGrandTotal

				fTotalOrder = fSubTotal + fShipping + fPromo + fInsurance
				fTotalCost	= fSubTotalCost + fShippingCost
				fPNL = fTotalOrder - fTotalCost
				fGrandTotal = fSubTotal + fShipping + fPromo + fInsurance + fTax
				%>
				<tr style="font-weight: bold; height: 29px"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right" colspan="6">Sub Total:</td>
					<td style="text-align: right"><%= CurrencyFormat(fSubTotal, 2) %></td>
					<td>&nbsp;</td>
				</tr>
				<% i = i + 1 %>
				<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right" colspan="6">Shipping: <input name="DeliveryMethod" value="<%= oOrder("OrderDeliveryMethod") %>" maxlength="255" type="text" style="width: 120px"/></td>
					<td style="text-align: right"><input name="DeliveryPrice" value="<%= DecimalFormat(fShipping, 2) %>" maxlength="15" type="text" style="width: 70px; text-align: right"/></td>
					<td>&nbsp;</td>
				</tr>
				<% i = i + 1 %>
				<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right" colspan="6">Handling and Insurance:</td>
					<td style="text-align: right"><input name="HandlingInsurance" value="<%= DecimalFormat(fInsurance, 2) %>" maxlength="15" type="text" style="width: 70px; text-align: right"/></td>
					<td>&nbsp;</td>
				</tr>
				<% i = i + 1 %>
				<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right" colspan="6">Promo: <input name="PromoCode" value="<%= sPromoCode %>" maxlength="20" type="text" style="width: 120px"/></td>
					<td style="text-align: right"><input name="PromoPrice" value="<%= DecimalFormat(fPromo, 2) %>" maxlength="15" type="text" style="width: 70px; text-align: right"/></td>
					<td>&nbsp;</td>
				</tr>
				<% i = i + 1 %>
				<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right" colspan="6">Tax<%= IIF(oOrder("OrderTaxExemption") = "1", " (Exemption)", "") %>:</td>
					<td style="text-align: right"><%= IIF(oOrder("OrderTaxExemption") = "0", CurrencyFormat(fTax, 2), "0") %></td>
					<td>
						<% If GetSetting(oConn, "CompanyTaxState") = oOrder("OrderShippingState") Then %>
						<a href="OrderDetailsForm.asp?Action=ChangeTax&amp;ID=<%= iID %>" onclick="return areYouSure();"><img src="images/grid-act-<%= IIF(oOrder("OrderTaxExemption") = "0", "delete", "add") %>.png" alt="" title="<%= IIF(oOrder("OrderTaxExemption") = "0", "Delete", "Add") %>" width="16" height="16" /></a>
						<% End If %>
					</td>
				</tr>
				<% i = i + 1 %>
				<tr style="font-weight: bold; height: 29px"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
					<td style="text-align: right; color: red" colspan="6">Grand Total:</td>
					<td style="text-align: right; color: red"><%= CurrencyFormat(fGrandTotal, 2) %></td>
					<td>&nbsp;</td>
				</tr>
			</table>
			<div style="float: right; padding-top: 5px">
				<input type="submit" value="Update" class="form-btn" style="margin-right: 62px" />
			</div>
		</form>
		<%
		Dim DetailsSearch : DetailsSearch = Trim(Request("DetailsSearch"))
		Dim AccessoriesSearch : AccessoriesSearch = Trim(Request("AccessoriesSearch"))
		Dim sEmptyText : sEmptyText = "Search Products"
		%>
		<div style="float: left; padding-top: 5px">
			<form action="OrderDetailsForm.asp" method="get" onsubmit="if($('#DetailsSearch').val()=='' || $('#DetailsSearch').val()=='<%= sEmptyText %>'){$('#DetailsSearch').focus(); return false;}">
				<div style="display: none">
					<input type="hidden" name="ID" value="<%= iID %>"/>
					<input type="hidden" name="Action" value="Edit"/>
				</div>
				<table cellpadding="2" cellspacing="0" border="0">
					<tr>
						<td><input type="text" value="<%= IIF(DetailsSearch <> "", DetailsSearch, sEmptyText) %>" name="DetailsSearch" id="DetailsSearch" class="form-field" style="width: 200px" onfocus="if(this.value=='<%= sEmptyText %>')this.value=''" onblur="if(this.value=='')this.value='<%= sEmptyText %>'" /></td>
						<td><input type="submit" value="Search" class="inline-btn"/></td>
					</tr>
				</table>
			</form>
		</div>
		<div style="clear: both"></div><br />
		<%
		If DetailsSearch <> "" Or ValidateInteger(AccessoriesSearch) Then
			Dim sWhere, sProductListTitle, iGridMode
			If DetailsSearch <> "" Then
				sWhere = " WHERE " & GetProductSearchSQL(DetailsSearch)
				sProductListTitle = "Search Results for: " & DetailsSearch
			Else
				sWhere = " WHERE ProductID IN(SELECT CompatibilityChildID FROM utb_Compatibilities WHERE CompatibilityParentID = " & AccessoriesSearch & ") "
				sProductListTitle = "Accessories for: " & GetValueFromTable(oConn, "ProductName", "utb_Products", "WHERE ProductID = " & AccessoriesSearch)
			End If
			iGridMode = 1
			%>
			<a name="assignlist"></a>
			<form action="OrderDetailsForm.asp" method="post" id="add-products">
				<div style="display: none">
					<input type="hidden" name="ID" value="<%= iID %>"/>
					<input type="hidden" name="Action" value="AddProducts"/>
				</div>
				<!--#include file="inc/ProductGrid.asp"-->
				<div style="padding-top: 5px">
					<input type="submit" value="Assign" id="add-btn" disabled="disabled" class="form-btn" />
					<input type="reset" value="Reset" id="reset-btn" disabled="disabled" class="form-btn" onclick="$('#add-btn').val('Assign').attr('disabled',true); this.disabled='disabled'" />
				</div>
			</form>
			<script type="text/javascript">
			$(function(){
				$('#add-products input[type=checkbox]').click(countSelected);
			});
			function countSelected(){
				var checkedCnt = 0;
				$('#add-products input[type=checkbox]').each(function(){
					if ($(this).attr('checked') && $(this).attr('id') != 'check_all') {
						checkedCnt++;
					}
				});
				if (checkedCnt > 0) {
					$('#add-btn').val('Assign (' + checkedCnt + ')').attr('disabled', false);
					$('#reset-btn').attr('disabled', false);
				}
				else {
					$('#add-btn').val('Assign').attr('disabled', true);
					$('#reset-btn').attr('disabled', true);
				}
			}
			</script>
		<% End If %>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderFormBackURL") = "", sDefaultURL, Session("OrderFormBackURL"))
	End Function
%>