<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<!--#include file="../inc/JSON.asp"-->
<%
	SetBackURL()

	Dim iOrderID : iOrderID = Request("OrderID")
	Dim sHistoryBy : sHistoryBy = Request("HistoryBy")
	Dim sBackURL : sBackURL = GetBackURL("OrderList.asp")

	If Not ValidateInteger(iOrderID) Then
		Redirect(sBackURL)
	End If

	Dim sSelfUrl : sSelfUrl = "OrderForm.asp?OrderID=" & iOrderID

	Dim oConn, sQuery, oQuery, i
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	sQuery = " SELECT o.*" &_
			 "		, (CASE WHEN OrderTaxExemption = 0 THEN o.OrderTaxAmount ELSE 0 END) AS OrderTaxAmount" &_
			 "		, os.OrderStatusName" &_
			 "		, os.OrderStatusColor" &_
			 "		, osr.OrderStatusReasonID" &_
			 "		, osr.OrderStatusReasonName" &_
			 "		, 	CONVERT(VARCHAR(10), o.OrderCreateDate, 101) + '&nbsp;'" &_
			 "		  + RIGHT(CONVERT(VARCHAR(20), o.OrderCreateDate, 109), 8) + '&nbsp;'" &_
			 "		  + RIGHT(CONVERT(VARCHAR(26), o.OrderCreateDate, 100), 2) AS _OrderCreateDate" &_
			 "		, 	CONVERT(VARCHAR(10), o.OrderShippedDate, 101) + '&nbsp;'" &_
			 "		  + RIGHT(CONVERT(VARCHAR(20), o.OrderShippedDate, 109), 8) + '&nbsp;'" &_
			 "		  + RIGHT(CONVERT(VARCHAR(26), o.OrderShippedDate, 100), 2) AS _OrderShippedDate" &_
			 "		, pt.PaymentTypeName" &_
			 "		, pt.PaymentTypeCategory" &_
			 "		, c.OrderDeliveryCarrierName" &_
			 "		, u.UserNickName AS OrderSalesman" &_
			 "	 FROM utb_Orders o" &_
			 "		  INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
			 "		   LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
			 "		   LEFT JOIN utb_OrderStatusReasons osr ON osr.OrderStatusReasonID = o.OrderStatusReasonID" &_
			 "		   LEFT JOIN utb_OrderDeliveryCarriers c ON c.OrderDeliveryCarrierID = o.OrderDeliveryCarrierID" &_
			 "		   LEFT JOIN utb_Users u ON u.UserID = o.SalesmanUserID" &_
			 "	WHERE o.OrderID = " & iOrderID

	Dim oOrder
	Set oOrder = oConn.Execute(sQuery)

	If oOrder.Eof Then
		AddError("Order #" & iOrderID & " not found.")
		Redirect(sBackURL)
	End If

	Dim sOrderReferral : sOrderReferral = URLDecode(oOrder("OrderReferral"))
	If Len(sOrderReferral) > 40 Then
		sOrderReferral = "" &_
			"<span style=""cursor: default"" onclick=""$(this).hide(); $('.ref-hidden').show()"" title=""Click to see full text"">" & Left(sOrderReferral, 40) & "...</span>" &_
			"<span style=""display: none"" class=""ref-hidden"">" & HTMLEncode(sOrderReferral) & "</span>"
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Orders</h1>&nbsp;
		</div>
		<span id="alert"><!--#include file="../inc/Alert.asp"--></span>
		<div class="box-head">
			<a class="head-link-right" href="OrderFormCreate.asp?Type=3&amp;OrderID=<%= iOrderID %>&amp;submit=yes" onclick="return areYouSure()">Create an Order</a>
			<%
				sQuery = "SELECT (SELECT COUNT(*) FROM utb_OrderDetails WHERE OrderID = " & iOrderID & " AND ProductStatusID IN(3,4)) AS PreBack" &_
						 "	   , (SELECT COUNT(*) FROM utb_OrderDetails WHERE OrderID = " & iOrderID & " AND ProductStatusID NOT IN(3,4)) AS Other"

				Set oQuery = oConn.Execute(sQuery)
				If oQuery("PreBack") <> 0 And oQuery("Other") <> 0 Then
					%>
					<a class="head-link-right" href="OrderFormSplit.asp?OrderID=<%= iOrderID %>&amp;submit=yes" onclick="return areYouSure()">Split Order</a>
					<%
				End If
				oQuery.Close()
				Set oQuery = Nothing
			%>
			<a class="head-link-right" href="OrderPrintInvoice.asp?CheckedID=<%= iOrderID %>" target="_blank">Print Packing Slip</a>
			<a class="head-link-right" href="OrderPrintProffOfPurchase.asp?OrderID=<%= iOrderID %>" target="_blank">Print Proof of Purchase</a>
			<a class="head-link-right" href="#" onclick="return emailProffOfPurchase()">E-mail Proof of Purchase</a>
			<h2>Order # <%= iOrderID %></h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 49%" valign="top">
					<!-- Order Information -->
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left order-info">
						<tr class="head-line">
							<td colspan="2">Order Information</td>
						</tr>
						<tr>
							<td style="width: 95px">Date Created:</td>
							<td style="padding: 0 2px 0 2px">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="internal_table">
									<tr>
										<td><%= oOrder("_OrderCreateDate") %></td>
										<td style="text-align: right">IP:</td>
										<td style="width: 90px; text-align: right"><%= oOrder("OrderIP") %></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr class="row-hl">
							<td>Date Shipped:</td>
							<td><%= oOrder("_OrderShippedDate") %></td>
						</tr>
						<tr>
							<td>Referral:</td>
							<td><%= sOrderReferral %></td>
						</tr>
						<tr class="row-hl">
							<td>Referral Code:</td>
							<td class="cell-editable" id="cell-refferal_code"><%= oOrder("OrderReferralCode") %></td>
						</tr>
						<tr>
							<td>Status:</td>
							<td id="cur-st" style="font-weight: bold; color:#<%= oOrder("OrderStatusColor") %>"><%= oOrder("OrderStatusName") %></td>
						</tr>
						<tr class="row-hl">
							<td>Status Reason:</td>
							<td id="cur-st-reason"><%= oOrder("OrderStatusReasonName") %></td>
						</tr>
						<tr>
							<td>Shipping Carrier:</td>
							<td class="cell-editable" id="cell-shipping_carrier"><%= oOrder("OrderDeliveryCarrierName") %></td>
						</tr>
						<tr class="row-hl">
							<td>Carrier Method:</td>
							<td class="cell-editable no-icon" id="cell-carrier_method"><%= oOrder("OrderDeliveryCarrierMethod") %></td>
						</tr>
						<tr>
							<td>Tracking Number:</td>
							<td style="padding: 0 2px 0 2px">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="internal_table">
									<tr>
										<td style="width: 100px" class="cell-editable no-icon" id="cell-tracking_number"><%= oOrder("OrderDeliveryTracking") %></td>
										<td style="text-align: right" class="especiallyforie8">Cost:</td>
										<td style="width: 90px; text-align: right" class="cell-editable no-icon" id="cell-shipping_cost"><%= CurrencyFormat(oOrder("OrderDeliveryCost"), 2) %></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr class="row-hl">
							<td>Salesman:</td>
							<td<% If CheckUserPermission(4) Then %> class="cell-editable" id="cell-salesman"<% End If %>><%= oOrder("OrderSalesman") %></td>
						</tr>
					</table>
					<!-- End Order Information -->
					<br />
					<%
						Dim sForWhat
						Dim sWhere : sWhere = " o.OrderID <> " & iOrderID & " AND "
						Dim sLinkToAll : sLinkToAll = "OrderList.asp?SearchField="
						Select Case sHistoryBy
							Case "IP"
								sForWhat = "IP: " & oOrder("OrderIP")
								sWhere = sWhere & " ISNULL(o.OrderIP, '') = '" & Quote(oOrder("OrderIP")) & "'"
								sLinkToAll = sLinkToAll & "4&amp;SearchString=" & oOrder("OrderIP")

							Case "LastName"
								sForWhat = "Last Name: " & oOrder("OrderShippingLastName")
								sWhere = sWhere & " ISNULL(o.OrderShippingLastName, '') = '" & Quote(oOrder("OrderShippingLastName")) & "'"
								sLinkToAll = sLinkToAll & "1&amp;SearchString=" & oOrder("OrderShippingLastName")

							Case "Phone"
								sForWhat = "Phone: " & oOrder("OrderShippingHomePhone")
								sWhere = sWhere & " ISNULL(o.OrderShippingHomePhone, '') = '" & Quote(oOrder("OrderShippingHomePhone")) & "'"
								sLinkToAll = sLinkToAll & "7&amp;SearchString=" & oOrder("OrderShippingHomePhone")

							Case Else
								sForWhat = "E-mail: " & oOrder("OrderEmail")
								sWhere = sWhere & " ISNULL(o.OrderEmail, '') = '" & Quote(oOrder("OrderEmail")) & "'"
								sLinkToAll = sLinkToAll & "5&amp;SearchString=" & oOrder("OrderEmail")
						End Select

						sQuery = " SELECT COUNT(*) AS RecordsCount" &_
								 "   FROM utb_Orders AS o " &_
								 "  WHERE " & sWhere

						Set oQuery = oConn.Execute(sQuery)
						Dim HistoryCount : HistoryCount = oQuery("RecordsCount")
					%>
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
						<tr class="head-line">
							<td style="text-align: center">History By</td>
							<td colspan="2">
								<%= IIF(sHistoryBy = "Email" Or sHistoryBy = "", "<strong>E-mail</strong>", "<a href=""" & sSelfUrl & "&amp;HistoryBy=Email"">E-mail</a>") %>
								&nbsp;&bull;&nbsp;
								<%= IIF(sHistoryBy = "IP", "<strong>IP</strong>", "<a href=""" & sSelfUrl & "&amp;HistoryBy=IP"">IP</a>") %>
								&nbsp;&bull;&nbsp;
								<%= IIF(sHistoryBy = "LastName", "<strong>Last Name</strong>", "<a href=""" & sSelfUrl & "&amp;HistoryBy=LastName"">Last Name</a>") %>
								&nbsp;&bull;&nbsp;
								<%= IIF(sHistoryBy = "Phone", "<strong>Phone</strong>", "<a href=""" & sSelfUrl & "&amp;HistoryBy=Phone"">Phone</a>") %>
							</td>
						</tr>
						<%
						i = 0
						If HistoryCount > 0 Then
							%>
							<tr class="row-hl">
								<td style="width: 95px"><strong>Order #</strong></td>
								<td><strong>Date Created</strong></td>
								<td><strong>Status</strong></td>
							</tr>
							<%
							sQuery = " SELECT TOP " & C_ORDER_FORM_HISTORY_COUNT & " o.OrderID " &_
									 "	  , CONVERT(VARCHAR(10), o.OrderCreateDate, 101) AS OrderDate " &_
									 "	  , os.OrderStatusName " &_
									 "	  , os.OrderStatusColor " &_
									 "   FROM utb_Orders AS o " &_
									 "		INNER JOIN utb_OrderStatuses AS os ON os.OrderStatusID = o.OrderStatusID " &_
									 "  WHERE " & sWhere

							Set oQuery = oConn.Execute(sQuery)
							While Not oQuery.Eof
								%>
								<tr<%= IIF(i Mod 2 = 0, "", " class=""row-hl""") %>>
									<td><a style="display: block" href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>&amp;HistoryBy=<%= sHistoryBy %>"><%= oQuery("OrderID") %></a></td>
									<td><%= oQuery("OrderDate") %></td>
									<td><%= oQuery("OrderStatusName") %></td>
								</tr><%
								i = i + 1
								oQuery.MoveNext
							Wend
						End If
						%>
						<tr<%= IIF(i Mod 2 = 0, "", " class=""row-hl""") %>>
							<td colspan="3" class="last">
								<% If HistoryCount > C_ORDER_FORM_HISTORY_COUNT Then %>
								<div style="float: right"><a href="<%= sLinkToAll %>">View All</a></div>
								<% End If %>
								<%= IIF(HistoryCount > 0, "<strong>" & HistoryCount & "</strong>", "No") %> orders for <%= sForWhat %>
							</td>
						</tr>
					</table>
					<br />
				</td>
				<td>&nbsp;</td>
				<td style="width: 49%" valign="top">
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
						<tr class="head-line">
							<td id="change-status-header">
								Change Order Status
								<div style="position: relative">
									<div style="position: absolute; right: 0; top: -15px"><img src="images/ae.gif" alt="" id="st-changing" style="display: none" /></div>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="top">
								<label for="OrderStatusID">Status:</label>
								<select class="selector" name="OrderStatusID" id="OrderStatusID" style="width: 150px; margin: 0 10px 0 2px">
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatuses WHERE OrderStatusIsActive = 1 ORDER BY OrderStatusName")
								While Not oQuery.Eof
									%><option value="<%= oQuery("OrderStatusID") %>"<%= IIF(CStr(oQuery("OrderStatusID")) = CStr(oOrder("OrderStatusID")), " selected='selected'", "") %>><%= oQuery("OrderStatusName") %></option><%
									oQuery.MoveNext
								Wend
								%>
								</select>

								<label for="OrderStatusReasonID">Reason:</label>
								<select class="selector" name="OrderStatusReasonID" id="OrderStatusReasonID" style="width: 150px; margin-left: 2px">
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatusReasons WHERE OrderStatusReasonIsActive = 1 AND OrderStatusID = '" & oOrder("OrderStatusID") & "' ORDER BY OrderStatusReasonName")
								If Not oQuery.Eof Then
									%><option value="">Select One</option><%
									While Not oQuery.Eof
										%><option value="<%= oQuery("OrderStatusReasonID") %>"<%= IIF(CStr(oQuery("OrderStatusReasonID")) = CStr(IIF(IsNull(oOrder("OrderStatusReasonID")), "0", oOrder("OrderStatusReasonID"))), " selected='selected'", "") %>><%= oQuery("OrderStatusReasonName") %></option><%
										oQuery.MoveNext
									Wend
								Else
									%><option value="">None</option><%
								End If
								%>
								</select>

								<div id="st-change-controls" style="padding-top: 5px; display: none">
									<table cellpadding="0" cellspacing="0">
										<tr>
											<td style="padding: 0; border: 0"><input type="checkbox" id="send-email-status"/></td>
											<td style="padding: 0 0 0 3px; border: 0"><label for="send-email-status">Send E-mail</label></td>
											<td style="padding: 0 0 0 24px; border: 0"><input type="button" value="Submit" class="inline-btn" /></td>
										</tr>
									</table>
								</div>
							</td>
						</tr>
					</table>

					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left" style="margin-top: 12px">
						<tr class="head-line">
							<td>Status Changes History</td>
						</tr>
						<tr>
							<td style="padding: 0; border-top: 0">
								<div style="overflow: auto" class="st-history">
									<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left" id="block-status_changes">
										<tr class="row-hl" id="grid-status-titles">
											<td style="border-top: 0; border-bottom: 0; border-left: 0; width: 125px"><strong>Date</strong></td>
											<td style="border-top: 0; border-bottom: 0; border-left: 0"><strong>Status</strong></td>
											<td style="border-top: 0; border-bottom: 0"><strong>Reason</strong></td>
											<td style="border-top: 0; border-bottom: 0; border-right: 0"><strong>User</strong></td>
										</tr>
										<%
										sQuery = " SELECT StatusName" &_
												 "		, StatusReasonName" &_
												 "		, UserName" &_
												 "		, CONVERT(VARCHAR(10), OrderStatusChangeCreateDate, 101) + '&nbsp;'" &_
												 "		  + RIGHT(CONVERT(VARCHAR(20), OrderStatusChangeCreateDate, 109), 8) + '&nbsp;'" &_
												 "		  + RIGHT(CONVERT(VARCHAR(26), OrderStatusChangeCreateDate, 100), 2) AS _OrderStatusChangeCreateDate" &_
												 "	 FROM utb_OrderStatusChanges" &_
												 "	WHERE OrderID = " & iOrderID &_
												 "	ORDER BY OrderStatusChangeID DESC"
										i = 0
										Set oQuery = oConn.Execute(sQuery)
										If Not oQuery.Eof Then
											While Not oQuery.Eof
												%>
												<tr<%= IIF(i Mod 2 = 0, "", " class=""row-hl""") %>>
													<td style="border-bottom: 0; border-left: 0; text-align: center"><%= oQuery("_OrderStatusChangeCreateDate") %></td>
													<td style="border-bottom: 0"><%= oQuery("StatusName") %></td>
													<td style="border-bottom: 0"><%= oQuery("StatusReasonName") %></td>
													<td style="border-bottom: 0; border-right: 0"><%= oQuery("UserName") %></td>
												</tr>
												<%
												i = i + 1
												oQuery.MoveNext
											Wend
										End If
										oQuery.Close
										Set oQuery = Nothing
										%>
									</table>
								</div>
							</td>
						</tr>
					</table>
					<br />

					<%
					Dim isShipper, isOtherUser
					isShipper = 0
					isOtherUser = 0
					sQuery = "SELECT * from utb_UserRoles where UserID=" & Session("UserID")
					Set oQuery = oConn.Execute(sQuery)
					while not oQuery.Eof
					  If oQuery("RoleID") = 4 Then
					    isShipper = isShipper + 1
					  Else
					    isOtherUser = isOtherUser + 1
					  End If
					  oQuery.MoveNext
					Wend
					oQuery.Close
					Set oQuery = Nothing

					Dim sNotesContent, sKeepMe
					sQuery = " SELECT *" &_
							 "		, CONVERT(VARCHAR(10), OrderNoteCreateDate, 101) + '&nbsp;'" &_
							 "		  + RIGHT(CONVERT(VARCHAR(20), OrderNoteCreateDate, 109), 8) + '&nbsp;'" &_
							 "		  + RIGHT(CONVERT(VARCHAR(26), OrderNoteCreateDate, 100), 2) AS _OrderNoteCreateDate" &_
							 "	 FROM utb_OrderNotes" &_
							 "	WHERE OrderID = " & iOrderID &_
							 "	  AND OrderNoteIsHidden = 0" &_
							 "	ORDER BY OrderNoteID ASC"
					%>
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
						<tr class="head-line">
							<td>
								<div style="float: right"><a href="OrderFormNotes.asp?OrderID=<%= iOrderID %>" style="font-weight: normal">View All</a></div>
								Order Notes
							</td>
						</tr>
						<tr>
							<td style="padding: 0">
								<div id="order-notes-content">
								<%
								i = 0
								Set oQuery = oConn.Execute(sQuery)
								If Not oQuery.Eof Then
									While Not oQuery.Eof
										sNotesContent = oQuery("OrderNoteContent")
										If InStr(sNotesContent, "Child order created") Then
											sKeepMe = Replace(sNotesContent, "Child order created #", "")
											sNotesContent = "Child order created <a href='OrderForm.asp?OrderID=" & sKeepMe & "'>#" & sKeepMe & "</a>"
										ElseIf InStr(sNotesContent, "Order splitted from order") Then
											sKeepMe = Replace(sNotesContent, "Order splitted from order #", "")
											sNotesContent = "Order splitted from order <a href='OrderForm.asp?OrderID=" & sKeepMe & "'>#" & sKeepMe & "</a>"
										ElseIf InStr(sNotesContent, "Order created based on order") Then
											sKeepMe = Replace(sNotesContent, "Order created based on order #", "")
											sNotesContent = "Order created based on order <a href='OrderForm.asp?OrderID=" & sKeepMe & "'>#" & sKeepMe & "</a>"
										ElseIf InStr(sNotesContent, "Order created based on customer") Then
											sKeepMe = Replace(sNotesContent, "Order created based on customer #", "")
											sNotesContent = "Order created based on customer <a href='CustomerForm.asp?Action=Edit&ID=" & sKeepMe & "'>#" & sKeepMe & "</a>"
										Else
											sNotesContent = Replace(sNotesContent, "<br/>", "®")
											sNotesContent = WordWrap(sNotesContent, 50, vbCrLf)
											sNotesContent = Replace(sNotesContent, "®", "<br/>")
										End If
										%>
										<div id="note-<%= oQuery("OrderNoteID") %>" style="padding: 3px;<%= IIF(i > 0, " border-top: 1px solid #ccc;", "") %>" class="note-item<%= IIF(i Mod 2 = 0, "", " row-hl") %>">
											<div style="float: right"><%= oQuery("_OrderNoteCreateDate") %></div>
											<strong><%= oQuery("UserName") %></strong>
											<div style="clear: both"></div>
											<%= sNotesContent %>
										</div>
										<%
										oQuery.MoveNext
										i = i + 1
									Wend
								Else
									%><div style="padding: 3px" id="note-0">No notes.</div><%
								End If
								%>
								</div>
							</td>
						</tr>
						<tr>
							<td id="order-notes-form">
								<textarea cols="1" rows="1" style="width: 470px; height: 50px" id="notes-textarea" class="form-field limited limit_500"></textarea><br />
								<div style="padding-top: 4px; float: left">
									<input type="checkbox" id="send-email" />
									<label for="send-email">Send E-mail</label>
									&nbsp;&nbsp;
									<input type="button" value="Submit" class="inline-btn" /> <span style="color: #999">(Ctrl + Enter)</span>
								</div>
								<div style="float: right" id="notes-textarea-counter"></div>
							</td>
						</tr>
					</table>
					<br />
				</td>
			</tr>
			<tr>
				<td valign="top">
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr valign="top">
							<td style="width: 99px">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr class="head-line"><td style="text-align: center"><a href="OrderAddressForm.asp?ID=<%= iOrderID %>&amp;Action=Edit">Edit</a></td></tr>
									<tr><td>Name:</td></tr>
									<tr class="row-hl"><td>Company:</td></tr>
									<tr><td>Address 1:</td></tr>
									<tr class="row-hl"><td>Address 2:</td></tr>
									<tr><td>City, St. Zip:</td></tr>
									<tr class="row-hl"><td>Phone:</td></tr>
									<tr><td>Alt Phone:</td></tr>
								</table>
							</td>
							<%
							if isOtherUser > 0 Then
							%>
							<td style="width: 193px">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr class="head-line"><td style="border-left: 0">Billing Information</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderBillingFirstName") & " " & oOrder("OrderBillingLastName") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderBillingCompanyName") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderBillingAddress1") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderBillingAddress2") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= FullAddress(oOrder, "Billing") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderBillingHomePhone") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderBillingAltPhone") %> &nbsp;</td></tr>
								</table>
							</td>
							<%
							End If
							%>
							<td style="width: 193px">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr class="head-line"><td style="border-left: 0">Shipping Information</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderShippingFirstName") & " " & oOrder("OrderShippingLastName") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderShippingCompanyName") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderShippingAddress1") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderShippingAddress2") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= FullAddress(oOrder, "Shipping") %> &nbsp;</td></tr>
									<tr class="row-hl"><td style="border-left: 0"><%= oOrder("OrderShippingHomePhone") %> &nbsp;</td></tr>
									<tr><td style="border-left: 0"><%= oOrder("OrderShippingAltPhone") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr class="row-hl">
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">E-mail:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderEmail") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">MP Name:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderProfName") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr class="row-hl">
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">MP License #:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderProfLicense") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">Issuing Authority:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderIssuingAuthority") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr class="row-hl">
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">DEA Number:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderDEANumber") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0">Website:</td></tr>
								</table>
							</td>
							<td colspan="2">
								<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
									<tr><td style="border-top: 0; border-left: 0"><%= oOrder("OrderWebsite") %> &nbsp;</td></tr>
								</table>
							</td>
						</tr>
					</table>
					<br />
				</td>
				<td>&nbsp;</td>
				<td valign="top">
					<% if isOtherUser > 0 Then %>
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
						<tr class="head-line">
							<td colspan="2">
								<% Dim iHistoryCount : iHistoryCount = GetValueFromTable(oConn, "COUNT(*)", "utb_Payments", "WHERE OrderID = " & iOrderID) %>
								<div style="float: right">
									<a href="OrderPaymentForm.asp?OrderID=<%= iOrderID %>&amp;Action=Edit">Edit</a>
									&nbsp;&bull;&nbsp;
									<a href="OrderFormCharge.asp?OrderID=<%= iOrderID %>">Charge</a>
									&nbsp;&bull;&nbsp;
									<a href="OrderFormPayment.asp?OrderID=<%= iOrderID %>">Add Payment</a>
									<% If iHistoryCount > 0 Then %>
									&nbsp;&bull;&nbsp;
									<a href="OrderChargeHistory.asp?OrderID=<%= iOrderID %>">History <span style="font-weight: normal">(<%= iHistoryCount %>)</span></a>
									<% End If %>
								</div>
								Payment Type: <%= oOrder("PaymentTypeName") %>
							</td>
						</tr>
						<%
							Select Case oOrder("PaymentTypeCategory")
								Case "1"
									%>
									<tr>
										<td style="width: 90px">Card Type:</td>
										<td><%= oOrder("PaymentTypeName") %></td>
									</tr>
									<tr class="row-hl">
										<td>Card Number:</td>
										<td><%
											Dim sCCNumber
											If Len(oOrder("OrderAccountNumber1")) > 0 Then
												sCCNumber = Decode(oOrder("OrderAccountNumber1"))
											End If
											Response.Write PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X")
											%></td>
									</tr>
									<tr>
										<td>Name on Card:</td>
										<td><%= oOrder("OrderAccountName") %></td>
									</tr>
									<tr class="row-hl">
										<td>Expiration Date:</td>
										<td><%= PrependChar(oOrder("OrderCardExpMonth"), 2, "0") %>/<%= oOrder("OrderCardExpYear") %></td>
									</tr>
									<tr>
										<td>CVV/CVV2:</td>
										<td><%= oOrder("OrderAccountNumber2") %></td>
									</tr>
									<%
								Case Else
									%>
									<tr>
										<td>Coming soon..</td>
									</tr><%
							End Select
						%>
					</table>
					<% End If %>
					<br/>

					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
						<tr class="head-line">
							<td>Customer Notes</td>
						</tr>
						<tr>
							<td>
								<% If IsNull(oOrder("OrderCustomerNotes")) Or oOrder("OrderCustomerNotes") = "" Then %>
									No notes.
								<% Else %>
									<span style="color: red"><%= oOrder("OrderCustomerNotes") %></span>
								<% End If %>
							</td>
						</tr>
					</table>
					<br/>
				</td>
			</tr>
			<tr>
				<td colspan="3">
					<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
						<tr class="head-line align-left">
							<td colspan="7">
								<div style="float: right">
									<% If Not IsNull(oOrder("OrderFirstOrderedItems")) Then %>
									<a href="OrderFormFirstOrderedItems.asp?ID=<%= iOrderID %>">First Ordered Items</a>
									&nbsp;&bull;&nbsp;
									<% End If %>
									<a href="OrderDetailsForm.asp?ID=<%= iOrderID %>&amp;Action=Edit">Edit</a>
								</div>
								Order Details &amp; Totals
							</td>
						</tr>
						<tr class="row-hl" style="font-weight: bold">
							<td>Sku</td>
							<td>Item</td>
							<td style="width: 60px">Price</td>
							<td style="width: 60px">Cost</td>
							<td style="width: 70px">Stock</td>
							<td style="width: 60px">Qty</td>
							<td style="width: 80px">Total</td>
						</tr>
						<%
						Dim fSubTotal, fSubTotalCost, fShipping, fShippingCost, fInsurance, fPromo, sPromoCode, fTax

						fSubTotal = CCur(oOrder("OrderTotalAmount"))
						fSubTotalCost = CCur(oOrder("OrderCostAmount"))
						fShipping = CCur(oOrder("OrderDeliveryPrice"))
						fShippingCost = CCur(oOrder("OrderDeliveryCost"))
						fInsurance = CCur(oOrder("OrderHandlingInsurance"))
						fPromo = CCur(oOrder("OrderPromoAmount"))
						sPromoCode = IIF(IsNull(oOrder("OrderPromoCode")), "", oOrder("OrderPromoCode"))
						fTax = CCur(oOrder("OrderTaxAmount"))

						i = 0
						Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = " & iOrderID)
						While Not oQuery.Eof
							%>
							<tr valign="top"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
								<td style="text-align: left"><%= oQuery("ProductSKU") %></td>
								<td style="text-align: left"><%= oQuery("ProductName") %> &nbsp; <span style="color: #999999"><%= oQuery("OrderDetailType") %></span></td>
								<td style="text-align: right"><% if isOtherUser > 0 Then %><%= CurrencyFormat(oQuery("ProductPrice"), 2) %><% End IF %></td>
								<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductCost"), 2) %></td>
								<td><%= oQuery("ProductStatusName") %></td>
								<td style="text-align: center"><%= oQuery("OrderDetailProductQuantity") %></td>
								<td style="text-align: right"><% if isOtherUser > 0 Then %><%= CurrencyFormat(oQuery("Total"), 2) %><% End IF %></td>
							</tr>
							<%
							i = i + 1
							oQuery.MoveNext
						Wend
						oQuery.Close
						Set oQuery = Nothing

						Dim fTotalOrder, fTotalCost, fPNL, fGrandTotal

						fTotalOrder = fSubTotal + fShipping + fPromo + fInsurance
						fTotalCost	= fSubTotalCost + fShippingCost
						fPNL = fTotalOrder - fTotalCost
						fGrandTotal = fSubTotal + fShipping + fPromo + fInsurance + fTax
						%>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right" colspan="6">Sub Total:</td>
							<td style="text-align: right"><% if isOtherUser > 0 Then %>
								<%= CurrencyFormat(fSubTotal, 2) %>
								<% End If %></td>
						</tr>
						<% i = i + 1 %>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right" colspan="6">
								<% If fShippingCost > 0 Then %>
								<span style="font-weight: normal">Shipping Cost: <%= CurrencyFormat(fShippingCost, 2) %></span>
								&nbsp;&nbsp;&nbsp;
								<% End If %>
								Shipping (<%= oOrder("OrderDeliveryMethod") %>):
							</td>
							<td style="text-align: right"><%= CurrencyFormat(fShipping, 2) %></td>
						</tr>
						<% i = i + 1 %>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right" colspan="6">Handling and Insurance:</td>
							<td style="text-align: right"><%= CurrencyFormat(fInsurance, 2) %></td>
						</tr>
						<% i = i + 1 %>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right" colspan="6">Promo<%= IIF(sPromoCode <> "", " (" & sPromoCode & ")", "") %>:</td>
							<td style="text-align: right"><%= CurrencyFormat(fPromo, 2) %></td>
						</tr>
						<% i = i + 1 %>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right" colspan="6">Tax<%= IIF(oOrder("OrderTaxExemption") = "1", " (Exemption)", "") %>:</td>
							<td style="text-align: right"><%= CurrencyFormat(fTax, 2) %></td>
						</tr>
						<% i = i + 1 %>
						<tr style="font-weight: bold"<%= IIF(i Mod 2 = 0, "", "  class=""row-hl""") %>>
							<td style="text-align: right; color: red" colspan="6">
								<div style="float: left">
									<% if isOtherUser > 0 Then %>
									<span style="color: #000">Total Order:</span> <%= CurrencyFormat(fTotalOrder, 2) %>
									&nbsp;&nbsp;&nbsp;
									<span style="color: #000">Total Cost:</span> <%= CurrencyFormat(fTotalCost, 2) %>
									&nbsp;&nbsp;&nbsp;
									<span style="color: #000">PNL:</span> <%= CurrencyFormat(fPNL, 2) %>
									<% End If %>
								</div>
								Grand Total:
								<div style="clear: both"></div>
							</td>
							<td style="text-align: right; color: red"><% if isOtherUser > 0 Then %>
								<%= CurrencyFormat(fGrandTotal, 2) %>
								<% End If %></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<!--#include file="inc/BottomBackend.asp"-->
		<%
		Dim sQuery1, sQuery2
		sQuery1= " SELECT OrderDeliveryCarrierID AS id" &_
				 "		, OrderDeliveryCarrierName AS name" &_
				 "	 FROM utb_OrderDeliveryCarriers" &_
				 "	WHERE OrderDeliveryCarrierIsActive = 1" &_
				 "	ORDER BY OrderDeliveryCarrierSortOrder"

		sQuery2= " SELECT u.UserID AS id" &_
				 "		, u.UserNickName AS name" &_
				 "	 FROM utb_Users AS u" &_
				 "		  INNER JOIN utb_UserRoles AS ur ON ur.UserID = u.UserID" &_
				 "	WHERE u.UserIsActive = 1" &_
				 "	  AND ur.RoleID = " & SALESMAN_ROLE_ID &_
				 "	ORDER BY 2"
		%>
		<script type="text/javascript">
		var OrderStatusReasonID = '<%= oOrder("OrderStatusReasonID") %>',
			OrderID = <%= iOrderID %>,
			DeliveryCarriers = <% Call QueryToJSON(oConn, sQuery1).Flush %>,
			Salesmen = <% Call QueryToJSON(oConn, sQuery2).Flush %>;
		</script>
		<script type="text/javascript" src="js/order-form.js"></script>

		<div id="EmailProffOfPurchase-form" title="Email Proof of Purchase" style="padding-right: 0">
			<div style="height: 20px; padding-left: 33px"><div id="proff-err" style="display: none">E-mail is invalid.</div></div>
			<label for="email-proff">E-mail:</label>
			<input type="text" name="email-proff" id="email-proff" value="<%= oOrder("OrderEmail") %>" class="form-field" style="width: 263px"/>
		</div>
	</body>
</html>
<%
	oOrder.Close
	Set oOrder = Nothing

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderBackURL") = "", sDefaultURL, Session("OrderBackURL"))
	End Function

	Sub SetBackURL()
		Session("OrderFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub

	Function FullAddress(oOrder, sType)
		Dim arCityState, arZipCountry
		ReDim arCityState(-1)
		ReDim arZipCountry(-1)

		If Not IsNull(oOrder("Order" & sType & "City")) And oOrder("Order" & sType & "City") <> "" Then
			ReDim Preserve arCityState(UBound(arCityState) + 1)
			arCityState(UBound(arCityState)) = oOrder("Order" & sType & "City")
		End If
		If Not IsNull(oOrder("Order" & sType & "State")) And oOrder("Order" & sType & "State") <> "" Then
			ReDim Preserve arCityState(UBound(arCityState) + 1)
			arCityState(UBound(arCityState)) = oOrder("Order" & sType & "State")
		End If

		If Not IsNull(oOrder("Order" & sType & "Zip")) And oOrder("Order" & sType & "Zip") <> "" Then
			ReDim Preserve arZipCountry(UBound(arZipCountry) + 1)
			arZipCountry(UBound(arZipCountry)) = oOrder("Order" & sType & "Zip")
		End If
		If Not IsNull(oOrder("Order" & sType & "Country")) And oOrder("Order" & sType & "Country") <> "" Then
			ReDim Preserve arZipCountry(UBound(arZipCountry) + 1)
			arZipCountry(UBound(arZipCountry)) = oOrder("Order" & sType & "Country")
		End If

		FullAddress = Join(arCityState, ", ") & " " & Join(arZipCountry, ", ")
	End Function
%>