<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	SetBackURL()
	Dim iOrderID : iOrderID = Request("OrderID")
	Dim sBackURL : sBackURL = GetBackURL("OrderForm.asp?OrderID=" & iOrderID)
	If Not ValidateInteger(iOrderID) Then
		Redirect(sBackURL)
	End If
	Dim oConn, sQuery, oQuery, i
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	Dim sOrderEmail, ShowPayInfo
	Dim AccountName, AccountNumber1, AccountNumber2, AccountNumber3, AccountNumber4
	Dim CardExpMonth, CardExpYear, DeliveryPrice, PromoAmount, TaxAmount, Insurance, PaymentTypeID, PaymentTypeName
	Dim BFirstName, BLastName, BCompanyName, BAddress1, BAddress2, BCity, BState, BZip, BCountry, BHomePhone, BAltPhone
	ShowPayInfo = False
	sQuery = "SELECT o.*" &_
			 "	   , ISNULL(o.OrderAccountName, 'US') AS OrderAccountName" &_
			 "	   , ISNULL(o.OrderCardExpMonth, '') AS OrderCardExpMonth" &_
			 "	   , (CASE WHEN OrderTaxExemption = 0 THEN o.OrderTaxAmount ELSE 0 END) AS OrderTaxAmount" &_
			 "	   , os.OrderStatusName" &_
			 "	   , os.OrderStatusColor" &_
			 "	   , osr.OrderStatusReasonID" &_
			 "	   , osr.OrderStatusReasonName" &_
			 "	   , (CAST(o.OrderCreateDate AS DATE)) AS _OrderCreateDate" &_
			 "	   , pt.PaymentTypeName" &_
			 "	   , pt.PaymentTypeCategory" &_
			 "	FROM utb_Orders o" &_
			 "		 INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
			 "		  LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
			 "		  LEFT JOIN utb_OrderStatusReasons osr ON osr.OrderStatusReasonID = o.OrderStatusReasonID" &_
			 " WHERE o.OrderID = " & iOrderID
	Set oQuery = oConn.Execute(sQuery)
	If oQuery.Eof Then
		AddError("Order #" & iOrderID & " not found.")
		Redirect(sBackURL)
	Else
		AccountName		= oQuery("OrderAccountName")
		AccountNumber1	= oQuery("OrderAccountNumber1")
		AccountNumber2	= oQuery("OrderAccountNumber2")
		AccountNumber3	= oQuery("OrderAccountNumber3")
		AccountNumber4	= oQuery("OrderAccountNumber4")
		CardExpMonth	= oQuery("OrderCardExpMonth")
		CardExpYear		= oQuery("OrderCardExpYear")
		DeliveryPrice	= oQuery("OrderDeliveryPrice")
		PromoAmount		= oQuery("OrderPromoAmount")
		TaxAmount		= oQuery("OrderTaxAmount")
		Insurance		= oQuery("OrderHandlingInsurance")
		PaymentTypeID	= oQuery("PaymentTypeID")
		PaymentTypeName	= oQuery("PaymentTypeName")
		BFirstName		= oQuery("OrderBillingFirstName")
		BLastName		= oQuery("OrderBillingLastName")
		BCompanyName	= oQuery("OrderBillingCompanyName")
		BAddress1		= oQuery("OrderBillingAddress1")
		BAddress2		= oQuery("OrderBillingAddress2")
		BCity			= oQuery("OrderBillingCity")
		BState			= oQuery("OrderBillingState")
		BZip			= oQuery("OrderBillingZip")
		BCountry		= oQuery("OrderBillingCountry")
		BHomePhone		= oQuery("OrderBillingHomePhone")
		BAltPhone		= oQuery("OrderBillingAltPhone")
		sOrderEmail		= oQuery("OrderEmail")
	End If
	oQuery.Close
	Set oQuery = Nothing
	Dim sCCFirstName, sCCLastName
	Dim sCCNameSplited : sCCNameSplited = Split(AccountName, " ")
	If Ubound(sCCNameSplited) >= 0 Then
		sCCFirstName = sCCNameSplited(0)
		If Ubound(sCCNameSplited) > 0 Then
			sCCLastName = sCCNameSplited(1)
		End If
	End If
	Dim sCCNumber
	If Len(AccountNumber1) > 0 Then
		sCCNumber = Decode(AccountNumber1)
	End If
	Dim sCCExpDate : sCCExpDate = PrependChar(CardExpMonth, 2, "0") & "/" & CardExpYear
	Dim fSubTotal
	fSubTotal = getValueFromTable(oConn, "SUM(ProductPrice * OrderDetailProductQuantity)", "utb_OrderDetails", "WHERE OrderID = " & iOrderID)
	If IsNull(fSubTotal) Then
		fSubTotal = 0
	End If
	fSubTotal = CCur(fSubTotal)
	Dim fShipping : fShipping = CCur(IIF(IsNull(DeliveryPrice), 0, DeliveryPrice))
	Dim fPromo : fPromo = CCur(IIF(IsNull(PromoAmount), 0, PromoAmount))
	Dim fTax : fTax = CCur(IIF(IsNull(TaxAmount), 0, TaxAmount))
	Dim fInsurance : fInsurance = CCur(Insurance)
	Dim fGrandTotal : fGrandTotal = fSubTotal + fShipping + fPromo + fInsurance + fTax
	Dim PGID, PGName, PGAccount1, PGAccount2
	PGID = Request("PaymentGateway")
	If Request("Submit") <> "" Then
		If IsNullOrEmpty(BFirstName) Then
			AddError("Field <strong>First Name</strong> is required.")
		End If
		If IsNullOrEmpty(BLastName) Then
			AddError("Field <strong>Last Name</strong> is required.")
		End If
		If IsNullOrEmpty(BCountry) Then
			AddError("Field <strong>Country</strong> is required.")
		End If
		If IsNullOrEmpty(BAddress1) Then
			AddError("Field <strong>Address 1</strong> is required.")
		End If
		If IsNullOrEmpty(BCity) Then
			AddError("Field <strong>City</strong> is required.")
		End If
		If IsNullOrEmpty(BState) Then
			AddError("Field <strong>State</strong> is required.")
		End If
		If IsNullOrEmpty(BZip) Then
			AddError("Field <strong>Zip</strong> is required.")
		End If
		If IsNullOrEmpty(BHomePhone) Then
			AddError("Field <strong>Home Phone</strong> is required.")
		End If
		If IsNullOrEmpty(AccountNumber1) Then
			AddError("Field <strong>Card Number</strong> is required.")
		End If
		If IsNullOrEmpty(AccountName) Then
			AddError("Field <strong>Name on Card</strong> is required.")
		End If
		If IsNullOrEmpty(CardExpMonth) Then
			AddError("Field <strong>Expiration Date (Month)</strong> is required.")
		End If
		If IsNullOrEmpty(CardExpYear) Then
			AddError("Field <strong>Expiration Date (Year)</strong> is required.")
		End If
		If IsNullOrEmpty(AccountNumber2) Then
			AddError("Field <strong>CVV/CVV2</strong> is required.")
		End If
		If PGID = "" Then
			AddError("Please select an Account.")
		Else
			Set oQuery = oConn.Execute("SELECT * FROM utb_PaymentGateways WHERE PaymentGatewayID = '" & Quote(PGID) & "'")
			If oQuery.Eof Then
				AddError("Account #" & PGID & " not found.")
			ElseIf oQuery("PaymentGatewayIsActive") <> "1" Then
				AddError("Account #" & PGID & " not active.")
			Else
				PGName		= oQuery("PaymentGatewayName")
				PGAccount1	= oQuery("PaymentGatewayAccountNumber1")
				PGAccount2	= oQuery("PaymentGatewayAccountNumber2")
			End If
			oQuery.Close
			Set oQuery = Nothing
		End If
		If Not IsError() Then
			On Error Resume Next
			Dim oAuthorize
			Set oAuthorize = Server.CreateObject("xPayment.Charge")
			oAuthorize.Initialize
			oAuthorize.Gateway		= "AUTHORIZENET"
			oAuthorize.TestMode		= True
			oAuthorize.Login		= PGAccount1
			'oAuthorize.Login2		= ""
			oAuthorize.Password		= PGAccount2
			oAuthorize.CardNumber	= sCCNumber
			oAuthorize.ExpDate		= sCCExpDate
			oAuthorize.FirstName	= sCCFirstName
			oAuthorize.LastName		= sCCLastName
			oAuthorize.Company		= BCompanyName
			oAuthorize.Address		= BAddress1
			oAuthorize.City 		= BCity
			oAuthorize.State 		= BState
			oAuthorize.Zip			= BZip
			oAuthorize.Country		= BCountry
			oAuthorize.Phone		= BHomePhone
			oAuthorize.Amount		= fGrandTotal
			oAuthorize.Process
			Dim AuthAmount 			: AuthAmount 		= oAuthorize.Amount
			Dim AuthTransType		: AuthTransType 	= oAuthorize.TransType
			Dim AuthTransID			: AuthTransID		= oAuthorize.TransID
			Dim AuthErrorCode		: AuthErrorCode		= oAuthorize.ErrorCode
			Dim AuthErrorText		: AuthErrorText		= oAuthorize.ErrorText
			Dim AuthApprovalCode	: AuthApprovalCode	= oAuthorize.ApprovalCode
			Dim AuthAVSCode			: AuthAVSCode		= oAuthorize.AVSCode
			Dim AuthCVV2Code		: AuthCVV2Code		= oAuthorize.CVV2Code
			Dim AuthResponseCode	: AuthResponseCode	= oAuthorize.ResponseCode
			Dim AuthResponseText	: AuthResponseText	= oAuthorize.ResponseText
			Dim AuthResponseReason	: AuthResponseReason= oAuthorize.ResponseReason
			Set oAuthorize = Nothing
			sQuery = "INSERT INTO utb_Payments(" &_
					 "	OrderID" &_
					 ", PaymentTypeID" &_
					 ", PaymentGatewayID" &_
					 ", PaymentStatusID" &_
					 ", PaymentStatusText" &_
					 ", PaymentStatusReason" &_
					 ", PaymentTotal" &_
					 ", PaymentBillingFirstName" &_
					 ", PaymentBillingLastName" &_
					 ", PaymentBillingCompanyName" &_
					 ", PaymentBillingCountry" &_
					 ", PaymentBillingAddress1" &_
					 ", PaymentBillingAddress2" &_
					 ", PaymentBillingCity" &_
					 ", PaymentBillingState" &_
					 ", PaymentBillingZip" &_
					 ", PaymentBillingHomePhone" &_
					 ", PaymentBillingAltPhone" &_
					 ", PaymentAccountName" &_
					 ", PaymentAccountNumber1" &_
					 ", PaymentAccountNumber2" &_
					 ", PaymentAccountNumber3" &_
					 ", PaymentAccountNumber4" &_
					 ", PaymentCardExpMonth" &_
					 ", PaymentCardExpYear" &_
					 ", PaymentCard4Digits" &_
					 ", PaymentTransType" &_
					 ", PaymentTransID" &_
					 ", PaymentErrorCode" &_
					 ", PaymentErrorText" &_
					 ", PaymentApprovalCode" &_
					 ", PaymentAVSCode" &_
					 ", PaymentCVV2Code" &_
					 ", CreateDate" &_
					 ", CreateUser" &_
					 ") " &_
					 "VALUES(" &_
					 "	'" & Quote(iOrderID) & "'" &_
					 ", '" & Quote(PaymentTypeID) & "'" &_
					 ", '" & Quote(PGID) & "'" &_
					 ", '" & Quote(AuthResponseCode) & "'" &_
					 ", '" & Quote(AuthResponseText) & "'" &_
					 ", '" & Quote(AuthResponseReason) & "'" &_
					 ", '" & Quote(DecimalPatch(AuthAmount)) & "'" &_
					 ", '" & Quote(BFirstName) & "'" &_
					 ", '" & Quote(BLastName) & "'" &_
					 ", '" & Quote(BCompanyName) & "'" &_
					 ", '" & Quote(BCountry) & "'" &_
					 ", '" & Quote(BAddress1) & "'" &_
					 ",  " & SqlGetValueOrNull(BAddress2) &_
					 ", '" & Quote(BCity) & "'" &_
					 ", '" & Quote(BState) & "'" &_
					 ", '" & Quote(BZip) & "'" &_
					 ", '" & Quote(BHomePhone) & "'" &_
					 ",  " & SqlGetValueOrNull(BAltPhone) &_
					 ", '" & Quote(AccountName) & "'" &_
					 ", '" & Quote(AccountNumber1) & "'" &_
					 ",  " & SqlGetValueOrNull(AccountNumber2) &_
					 ",  " & SqlGetValueOrNull(AccountNumber3) &_
					 ",  " & SqlGetValueOrNull(AccountNumber4) &_
					 ", '" & Quote(CardExpMonth) & "'" &_
					 ", '" & Quote(CardExpYear) & "'" &_
					 ", '" & Quote(Right(sCCNumber, 4)) & "'" &_
					 ", '" & Quote(AuthTransType) & "'" &_
					 ",  " & SqlGetValueOrNull(AuthTransID) &_
					 ", '" & Quote(AuthErrorCode) & "'" &_
					 ",  " & SqlGetValueOrNull(AuthErrorText) &_
					 ",  " & SqlGetValueOrNull(AuthApprovalCode) &_
					 ",  " & SqlGetValueOrNull(AuthAVSCode) &_
					 ",  " & SqlGetValueOrNull(AuthCVV2Code) &_
					 ",  " & "GETDATE()" &_
					 ", '" & Quote(Session("UserNickName")) & "'" &_
					 ")"
			oConn.Execute(sQuery)
			Dim iStatusID
			If AuthResponseCode = 1 Then
				iStatusID = 6
				ShowPayInfo = True
				Dim ssMsg : ssMsg = "Transaction ID: " & AuthTransID & "<br/>" &_
					"Transaction Type: " & AuthTransType & "<br/>" &_
					"Status ID: " & AuthResponseCode & "<br/>" &_
					"Status Text: " & AuthResponseText & "<br/>" &_
					"Approval Code: " & AuthApprovalCode & "<br/>" &_
					"AVS Code: " & AuthAVSCode & "<br/>" &_
					"CVV2 Code: " & AuthCVV2Code
				Call SetAlertMessage("success", AuthResponseReason & "<br/><br/>" & ssMsg)
			Else
				If AuthErrorCode <> 0 Then
					iStatusID = 7
					AddError(AuthErrorText)
				Else
					iStatusID = 5
					AddError(AuthResponseReason)
				End If
			End If
			oConn.Execute("UPDATE utb_Orders SET OrderStatusID = " & iStatusID & " WHERE OrderID = " & iOrderID)
			Dim sStatusName : sStatusName = ""
			Dim iStatusIsEmail : iStatusIsEmail = "0"
			Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatuses WHERE OrderStatusID = " & iStatusID)
			If Not oQuery.Eof Then
				sStatusName = oQuery("OrderStatusName")
				iStatusIsEmail = CStr(oQuery("OrderStatusIsSendEmail"))
			End If
			Set oQuery = Nothing
			sQuery = "INSERT INTO utb_OrderStatusChanges(OrderID, UserName, StatusName, StatusReasonName) " &_
					 "VALUES(" & iOrderID & ", '" & Session("UserNickName") & "', '" & Quote(sStatusName) & "', '')"
			oConn.Execute(sQuery)
			If iStatusIsEmail = "1" And ValidateEmail(sOrderEmail) Then
				Dim arOrderSt : arOrderSt = GetOrderStatusMessage(iOrderID)
				Call SendEmail(sOrderEmail, GetSetting(oConn, "CompanyEmailForOrder"), "Order status changed", arOrderSt(1))
			End If
		End If
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order # <%= iOrderID %></h1>&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2>Charge</h2></div>
		<div class="box">
			<form action="OrderFormCharge.asp?OrderID=<%= iOrderID %>" method="post">
				<table cellpadding="0" cellspacing="0" border="0">
					<tr valign="top">
						<td>
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align:right"><strong>Billing Info</strong></td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td style="text-align:right">First Name:</td>
									<td><%= BFirstName %></td>
								</tr>
								<tr>
									<td style="text-align:right">Last Name:</td>
									<td><%= BLastName %></td>
								</tr>
								<tr>
									<td style="text-align:right">Company Name:</td>
									<td><%= BCompanyName %></td>
								</tr>
								<tr>
									<td style="text-align:right">Country:</td>
									<td><%= BCountry %></td>
								</tr>
								<tr>
									<td style="text-align:right">Address 1:</td>
									<td><%= BAddress1 %></td>
								</tr>
								<tr>
									<td style="text-align:right">Address 2:</td>
									<td><%= BAddress2 %></td>
								</tr>
								<tr>
									<td style="text-align:right">City:</td>
									<td><%= BCity %></td>
								</tr>
								<tr>
									<td style="text-align:right">State:</td>
									<td><%= BState %></td>
								</tr>
								<tr>
									<td style="text-align:right">Zip:</td>
									<td><%= BZip %></td>
								</tr>
								<tr>
									<td style="text-align:right">Home Phone:</td>
									<td><%= BHomePhone %></td>
								</tr>
								<tr>
									<td style="text-align:right">Alt Phone:</td>
									<td><%= BAltPhone %></td>
								</tr>
							</table>
						</td>
						<td style="width: 40px">&nbsp;</td>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align:right"><strong>Credit Card Info</strong></td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td style="text-align:right;">Card Type:</td>
									<td><%= PaymentTypeName %></td>
								</tr>
								<tr>
									<td style="text-align:right;">Card Number:</td>
									<td><%= PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X") %></td>
								</tr>
								<tr>
									<td style="text-align:right;">Name on Card:</td>
									<td><%= AccountName %></td>
								</tr>
								<tr>
									<td style="text-align:right;">Expiration Date:</td>
									<td><%= sCCExpDate %></td>
								</tr>
								<tr>
									<td style="text-align:right;">CVV/CVV2:</td>
									<td><%= AccountNumber2 %></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<div>&nbsp;</div>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><strong>Total Amount To Charge:</strong></td>
						<td><%= CurrencyFormat(fGrandTotal, 2) %></td>
					</tr>
					<tr>
						<td style="text-align: right">Select Account:</td>
						<td>
							<select class="selector" name="PaymentGateway" id="PaymentGateway" style="width:200px;">
								<option value="">Select One</option>
							<%
							Dim sSelected
							sQuery = "SELECT *" &_
									 "	FROM utb_PaymentGateways" &_
									 " WHERE PaymentGatewayIsActive = 1" &_
									 "	 AND PaymentGatewayType = 'authorize'" &_
									 " ORDER BY PaymentGatewayName"
							Set oQuery = oConn.Execute(sQuery)
							While Not oQuery.Eof
								sSelected = IIF(CStr(oQuery("PaymentGatewayID")) = CStr(PGID), " selected='selected'", "")
								%>
								<option value="<%= oQuery("PaymentGatewayID") %>"<%= sSelected %>><%= oQuery("PaymentGatewayName") %></option>
								<%
								oQuery.MoveNext
							Wend
							oQuery.Close
							Set oQuery = Nothing
							%>
							</select>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td><input type="submit" name="Submit" class="form-btn" value="Charge" /></td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			<% If ShowPayInfo Then %>
			$('.alert').removeAttr('onclick').css('cursor', 'auto');
			<% End If %>
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderFormBackURL") = "", sDefaultURL, Session("OrderFormBackURL"))
	End Function
	Sub SetBackURL()
		Session("OrderFormChargeBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>