<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	Dim sOrderIDs : sOrderIDs = Trim(Request("CheckedID"))
	Dim sDelimiter : sDelimiter = Trim(Request("del"))
	sDelimiter = IIF(sDelimiter = "tab", vbTab, ",")

	If sOrderIDs = "" Then
		Response.Write "Select order(s).."
		Response.End
	End If

	Dim oConn, sQuery, oQuery, oOrder
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	sQuery = " SELECT o.OrderID" &_
			 "		, o.CustomerID" &_
			 "		, os.OrderStatusName					AS Status" &_
			 "		, ISNULL(osr.OrderStatusReasonName, '')	AS StatusReason" &_
			 "		, o.OrderEmail							AS Email" &_

			 "		, o.OrderBillingFirstName				AS BillingFirstName" &_
			 "		, o.OrderBillingLastName				AS BillingLastName" &_
			 "		, o.OrderBillingCompanyName				AS BillingCompanyName" &_
			 "		, o.OrderBillingCountry					AS BillingCountry" &_
			 "		, o.OrderBillingAddress1				AS BillingAddress1" &_
			 "		, o.OrderBillingAddress2				AS BillingAddress2" &_
			 "		, o.OrderBillingCity					AS BillingCity" &_
			 "		, o.OrderBillingState					AS BillingState" &_
			 "		, o.OrderBillingZip						AS BillingZip" &_
			 "		, o.OrderBillingHomePhone				AS BillingHomePhone" &_
			 "		, o.OrderBillingAltPhone				AS BillingAltPhone" &_

			 "		, o.OrderShippingFirstName				AS ShippingFirstName" &_
			 "		, o.OrderShippingLastName				AS ShippingLastName" &_
			 "		, o.OrderShippingCompanyName			AS ShippingCompanyName" &_
			 "		, o.OrderShippingCountry				AS ShippingCountry" &_
			 "		, o.OrderShippingAddress1				AS ShippingAddress1" &_
			 "		, o.OrderShippingAddress2				AS ShippingAddress2" &_
			 "		, o.OrderShippingCity					AS ShippingCity" &_
			 "		, o.OrderShippingState					AS ShippingState" &_
			 "		, o.OrderShippingZip					AS ShippingZip" &_
			 "		, o.OrderShippingHomePhone				AS ShippingHomePhone" &_
			 "		, o.OrderShippingAltPhone				AS ShippingAltPhone" &_

			 "		, pt.PaymentTypeName					AS PaymentType" &_
			 "		, o.OrderAccountName					AS AccountName" &_
			 "		, o.OrderAccountNumber1					AS AccountNumber1" &_
			 "		, o.OrderAccountNumber2					AS AccountNumber2" &_
			 "		, ISNULL(o.OrderAccountNumber3, '')		AS AccountNumber3" &_
			 "		, ISNULL(o.OrderAccountNumber4, '')		AS AccountNumber4" &_
			 "		, o.OrderCardExpMonth					AS CardExpMonth" &_
			 "		, o.OrderCardExpYear					AS CardExpYear" &_

			 "		, o.OrderDeliveryMethod					AS DeliveryMethod" &_
			 "		, o.OrderDeliveryPrice					AS DeliveryPrice" &_
			 "		, o.OrderDeliveryCost					AS DeliveryCost" &_
			 "		, o.OrderDeliveryTracking				AS DeliveryTracking" &_
			 "		, odc.OrderDeliveryCarrierName			AS DeliveryCarrier" &_
			 "		, o.OrderDeliveryCarrierMethod			AS DeliveryCarrierMethod" &_

			 "		, o.OrderPromoCode						AS PromoCode" &_
			 "		, o.OrderPromoAmount					AS PromoAmount" &_
			 "		, (CASE WHEN o.OrderTaxExemption = 0" &_
			 "				THEN o.OrderTaxAmount" &_
			 "				ELSE 0" &_
			 "		  END)									AS TaxAmount" &_
			 "		, o.OrderTotalAmount					AS TotalAmount" &_
			 "		, o.OrderCostAmount						AS CostAmount" &_
			 "		, o.OrderPaymentAmount					AS PaymentAmount" &_
			 "		, ISNULL(o.OrderCustomerNotes, '')		AS CustomerNotes" &_
			 "		, o.OrderReferral						AS Referral" &_
			 "		, o.OrderReferralCode					AS ReferralCode" &_
			 "		, o.OrderIP								AS IP" &_
			 "		, hf.HearFromName						AS HearFrom" &_
			 "		, o.OrderCreateUser						AS CreateUser" &_
			 "		, o.OrderStatusUser						AS StatusUser" &_
			 "		, o.OrderHandlingInsurance				AS HandlingInsurance" &_
			 "		, CONVERT(VARCHAR(10), o.OrderCreateDate, 101) + ' ' + RIGHT(CONVERT(VARCHAR(20), o.OrderCreateDate, 109), 8) + ' ' + RIGHT(CONVERT(VARCHAR(26), o.OrderCreateDate, 100), 2) AS CreateDate" &_
			 "		, CONVERT(VARCHAR(10), o.OrderStatusDate, 101) + ' ' + RIGHT(CONVERT(VARCHAR(20), o.OrderStatusDate, 109), 8) + ' ' + RIGHT(CONVERT(VARCHAR(26), o.OrderStatusDate, 100), 2) AS StatusDate" &_
			 "		, CONVERT(VARCHAR(10), o.OrderShippedDate,101) + ' ' + RIGHT(CONVERT(VARCHAR(20), o.OrderShippedDate,109), 8) + ' ' + RIGHT(CONVERT(VARCHAR(26), o.OrderShippedDate,100), 2) AS ShippedDate" &_

			 "		, od.ProductSKU" &_
			 "		, od.OrderDetailProductQuantity AS ProductQty" &_
			 "		, od.ProductPrice" &_
			 "	 FROM utb_Orders o" &_
			 "		  INNER JOIN utb_OrderDetails AS od ON od.OrderID = o.OrderID" &_
			 "		  INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
			 "		   LEFT JOIN utb_OrderStatusReasons osr ON osr.OrderStatusReasonID = o.OrderStatusReasonID" &_
			 "		   LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
			 "		   LEFT JOIN utb_HearFroms hf ON hf.HearFromID = o.HearFromID" &_
			 "		   LEFT JOIN utb_OrderDeliveryCarriers odc ON odc.OrderDeliveryCarrierID = o.OrderDeliveryCarrierID" &_
			 "	WHERE o.OrderID IN(" & Quote(sOrderIDs) & ")" &_
			 "	ORDER BY o.OrderID DESC" &_
			 "		, od.OrderDetailID"

	Set oOrder = oConn.Execute(sQuery)
	If oOrder.Eof Then
		Response.Write "Order(s) not found."
		Response.End
	End If

	Dim iMaxDetails
	sQuery = " SELECT TOP 1 COUNT(*) AS MaxDetails" &_
			 "	 FROM utb_OrderDetails" &_
			 "	WHERE OrderID IN(" & Quote(sOrderIDs) & ")" &_
			 "	GROUP BY OrderID" &_
			 "	ORDER BY 1 DESC"
	Set oQuery = oConn.Execute(sQuery)
	iMaxDetails = oQuery("MaxDetails")
	oQuery.Close
	Set oQuery = Nothing

	Dim sFieldName, sFieldValue, sCCNumber
	Dim sFields : sFields = "CustomerID,Status,StatusReason,Email," &_
		"BillingFirstName,BillingLastName,BillingCompanyName,BillingCountry,BillingAddress1,BillingAddress2,BillingCity," &_
		"BillingState,BillingZip,BillingHomePhone,BillingAltPhone," &_
		"ShippingFirstName,ShippingLastName,ShippingCompanyName,ShippingCountry,ShippingAddress1,ShippingAddress2,ShippingCity," &_
		"ShippingState,ShippingZip,ShippingHomePhone,ShippingAltPhone," &_
		"PaymentType,AccountName,AccountNumber1,AccountNumber2,AccountNumber3,AccountNumber4,CardExpMonth,CardExpYear," &_
		"DeliveryMethod,DeliveryPrice,DeliveryCost,DeliveryTracking,DeliveryCarrier,DeliveryCarrierMethod," &_
		"PromoCode,PromoAmount,TaxAmount,TotalAmount,CostAmount,PaymentAmount,CustomerNotes,Referral,ReferralCode,IP," &_
		"HearFrom,CreateDate,CreateUser,StatusDate,StatusUser,ShippedDate,HandlingInsurance"
	Dim arFields : arFields = Split(sFields, ",")
	Dim sFileName : sFileName = "export_" & Year(Date) & "_" & Append0(Month(Date), 2) & "_" & Append0(Day(Date), 2) & ".txt"

	Dim iCounter
	Dim sContent : sContent = "OrderID," & sFields
	For iCounter = 1 To iMaxDetails
		sContent = sContent & ",SKU" & iCounter & ",Quantity" & iCounter & ",Price" & iCounter
	Next
	sContent = Replace(sContent, ",", sDelimiter)

	Dim iCurrentID : iCurrentID = 0
	While Not oOrder.Eof
		If iCurrentID <> oOrder("OrderID") Then
			sContent = sContent & vbNewLine &_
				Chr(34) & oOrder("OrderID") & Chr(34)

			For Each sFieldName In arFields
				sFieldValue = oOrder(sFieldName)

				If Not IsNull(sFieldValue) Then
					sFieldValue = Replace(sFieldValue, """", Chr(34) & Chr(34))
					sFieldValue = Replace(sFieldValue, "&quot;", Chr(34) & Chr(34))
				End If

				If	sFieldName = "DeliveryPrice" Or _
					sFieldName = "DeliveryCost" Or  _
					sFieldName = "PromoAmount" Or  _
					sFieldName = "TaxAmount" Or  _
					sFieldName = "TotalAmount" Or  _
					sFieldName = "CostAmount" Or  _
					sFieldName = "PaymentAmount" Or  _
					sFieldName = "HandlingInsurance" _
				Then
					sFieldValue = CurrencyFormat(sFieldValue, 2)
				ElseIf sFieldName = "CustomerNotes" Then
					sFieldValue = Replace(sFieldValue, vbNewLine, " ")
				ElseIf sFieldName = "AccountNumber1" Then
					If Len(sFieldValue) > 0 Then
						sCCNumber = Decode(sFieldValue)
					End If
					sFieldValue = PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X")
				End If

				sContent = sContent &_
					sDelimiter & Chr(34) & sFieldValue & Chr(34)
			Next

			'oConn.Execute("UPDATE utb_Orders SET OrderStatusID = 9 WHERE OrderID = " & oOrder("OrderID"))
			'oConn.Execute("INSERT INTO utb_OrderStatusChanges(OrderID, UserName, StatusName) VALUES(" & oOrder("OrderID") & ", '" & Session("UserNickName") & "', 'Ready to Ship')")
			iCurrentID = oOrder("OrderID")
		End If

		sContent = sContent &_
			sDelimiter & Chr(34) & oOrder("ProductSKU") & Chr(34) &_
			sDelimiter & Chr(34) & oOrder("ProductQty") & Chr(34) &_
			sDelimiter & Chr(34) & CurrencyFormat(oOrder("ProductPrice"), 2) & Chr(34)

		oOrder.MoveNext
	Wend
	oOrder.Close
	Set oOrder = Nothing

	Response.ContentType = "application/octet-stream"
	Response.AddHeader "Content-Disposition", "attachment; filename=" & sFileName
	Response.AddHeader "Content-Description", sFileName
	Response.AddHeader "Content-Length", Len(sContent)
	'Response.Write "<pre>"
	Response.Write sContent
%>
