<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	SetBackURL()
	Dim iOrderID : iOrderID = Request("OrderID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("OrderForm.asp")
	If Not ValidateInteger(iOrderID) Then
		Redirect(sBackURL)
	End If
	If GetIndex(sAction, Array("Edit", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	Dim sTitle : sTitle = "Update Payment Information"
	Dim PaymentTypeID, AccountName, AccountNumber1, AccountNumber2, AccountNumber3, AccountNumber4, CardExpMonth, CardExpYear
	Select Case sAction
		Case "Edit"
			sAction = "Update"
			sQuery = "SELECT *" &_
					 "	   , ISNULL(OrderBillingCountry, 'US') AS OrderBillingCountry" &_
					 "	   , ISNULL(PaymentTypeID, '') AS PaymentTypeID" &_
					 "	   , ISNULL(OrderCardExpMonth, '') AS OrderCardExpMonth" &_
					 "	   , ISNULL(OrderCardExpYear, '') AS OrderCardExpYear" &_
					 "	FROM utb_Orders" &_
					 " WHERE OrderID = " & iOrderID
			Set oQuery = oConn.Execute(sQuery)
			If Not oQuery.Eof Then
				PaymentTypeID 	= oQuery("PaymentTypeID")
				AccountName 	= HTMLEncode(oQuery("OrderAccountName"))
				If Not IsNull(oQuery("OrderAccountNumber1")) Then
					AccountNumber1	= Decode(oQuery("OrderAccountNumber1"))
				End If
				AccountNumber2	= HTMLEncode(oQuery("OrderAccountNumber2"))
				AccountNumber3	= HTMLEncode(oQuery("OrderAccountNumber3"))
				AccountNumber4	= HTMLEncode(oQuery("OrderAccountNumber4"))
				CardExpMonth	= HTMLEncode(oQuery("OrderCardExpMonth"))
				CardExpYear		= HTMLEncode(oQuery("OrderCardExpYear"))
			End If
			oQuery.Close
			Set oQuery = Nothing
		Case "Update"
			CommonValidation()
			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next
				sQuery = "UPDATE utb_Orders" & _
						 "	 SET PaymentTypeID = '" & Quote(PaymentTypeID) & "'" &_
						 "	   , OrderAccountName = '" & Quote(AccountName) & "'" &_
						 "	   , OrderAccountNumber1 = '" & Quote(Encode(AccountNumber1)) & "'" &_
						 "	   , OrderAccountNumber2 = '" & Quote(AccountNumber2) & "'" &_
						 "	   , OrderAccountNumber3 = '" & Quote(AccountNumber3) & "'" &_
						 "	   , OrderAccountNumber4 = '" & Quote(AccountNumber4) & "'" &_
						 "	   , OrderCardExpMonth = '" & Quote(CardExpMonth) & "'" &_
						 "	   , OrderCardExpYear = '" & Quote(CardExpYear) & "'" &_
						 "	   , OrderCard4Digits = '" & Quote(Right(AccountNumber1, 4)) & "'" &_
						 " WHERE OrderID = '" & Quote(iOrderID) & "'"
				oConn.Execute(sQuery)
				Call OrderAddNote(oConn, iOrderID, "Updated Payment Information", 0, 1)
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Payment Information has been updated.")
					Redirect("OrderPaymentForm.asp?OrderID=" & iOrderID & "&Action=Edit")
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order # <%= iOrderID %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="OrderPaymentForm.asp" method="post">
				<div style="display: none"><input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="OrderID" value="<%= iOrderID %>"/></div>
				<table width="100%" cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right; width: 100px"><label for="PaymentTypeID"><span class="asterisk">*</span> Payment Type:</label></td>
						<td>
							<select class="selector" id="PaymentTypeID" name="PaymentTypeID" style="width: 214px">
							<% Set oQuery = oConn.Execute("SELECT * FROM utb_PaymentTypes WHERE PaymentTypeIsActiveOnFront = 1 AND PaymentTypeIsUpdatable = 1 AND PaymentTypeID IN(1,2,3,4) ORDER BY PaymentTypeID")
							While Not oQuery.Eof %>
								<option value="<%= oQuery("PaymentTypeID") %>" <%= IIF(CStr(oQuery("PaymentTypeID")) = CStr(PaymentTypeID), "selected='selected'", "") %>> <%= oQuery("PaymentTypeName") %></option>
								<% oQuery.MoveNext
							Wend
							oQuery.Close
							Set oQuery = Nothing
							%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right; width: 100px"><label for="AccountNumber1"><span class="asterisk">*</span> Card Number:</label></td>
						<td><input type="text" id="AccountNumber1" name="AccountNumber1" value="<%= AccountNumber1 %>" class="form-field" style="width: 200px" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="AccountName"><span class="asterisk">*</span> Name on Card:</label></td>
						<td><input type="text" id="AccountName" name="AccountName" value="<%= AccountName %>" class="form-field" style="width: 200px" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="CardExpMonth"><span class="asterisk">*</span> Expiration Date:</label></td>
						<td><% Dim iMonth, iYear %>
							<select class="selector" id="CardExpMonth" name="CardExpMonth" style="width: 60px">
								<option value="">Month</option>
							<% For iMonth = 1 To 12 %>
								<option value="<%= iMonth %>"<%= IIF(CStr(iMonth) = CStr(CardExpMonth), " selected='selected'", "") %>><%= Append0(iMonth, 2) %></option>
							<% Next %>
							</select>
							&nbsp;&nbsp;&nbsp;
							<select class="selector" id="CardExpYear" name="CardExpYear" style="width:60px">
								<option value="">Year</option>
							<% For iYear = Year(Now) To Year(Now) + 10 %>
								<option value="<%= iYear %>"<%= IIF(CStr(iYear) = CStr(CardExpYear), " selected='selected'", "") %>><%= iYear %></option>
							<% Next %>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align:right;"><label for="AccountNumber2"><span class="asterisk">*</span> CVV/CVV2:</label></td>
						<td><input type="text" id="AccountNumber2" name="AccountNumber2" value="<%= AccountNumber2 %>" class="form-field" style="width: 46px" maxlength="4" /></td>
					</tr>
					<tr>
						<td colspan="2" style="padding-left: 13px">
							<br/>
							<div style="float: left"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		PaymentTypeID	= Trim(Request("PaymentTypeID"))
		AccountName		= Trim(Request("AccountName"))
		AccountNumber1	= Trim(Request("AccountNumber1"))
		AccountNumber2	= Trim(Request("AccountNumber2"))
		AccountNumber3	= Trim(Request("AccountNumber3"))
		AccountNumber4	= Trim(Request("AccountNumber4"))
		CardExpMonth	= Trim(Request("CardExpMonth"))
		CardExpYear		= Trim(Request("CardExpYear"))
		If AccountNumber1 = "" Then
			AddError("Field <strong>Card Number</strong> is required.")
		End If
		If AccountName = "" Then
			AddError("Field <strong>Name on Card</strong> is required.")
		End If
		If CardExpMonth = "" Then
			AddError("Field <strong>Expiration Date (Month)</strong> is required.")
		ElseIf CLng(CardExpYear) = CLng(Year(Date)) And CLng(CardExpMonth) < CLng(Month(Date)) Then
			AddError("Field <strong>Expiration Date</strong> is invalid.")
		End If
		If CardExpYear = "" Then
			AddError("Field <strong>Expiration Date (Year)</strong> is required.")
		End If
		If AccountNumber2 = "" Then
			AddError("Field <strong>CVV/CVV2</strong> is required.")
		End If
	End Sub
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderFormBackURL") = "", sDefaultURL, Session("OrderFormBackURL"))
	End Function
%>