<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<!--#include file="../inc/JSON.asp"-->
<%
	On Error Resume Next
	Dim sOrderIDs : sOrderIDs = Trim(Request("OrderID"))
	Dim sEmail : sEmail = Trim(Request("Email"))
	If sOrderIDs = "" Then
		Response.Write "Select order(s).."
		Response.End
	End If
	Dim oConn, sQuery, oQuery, oOrder
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	sQuery = "SELECT o.*" &_
			 "	   , (CASE WHEN OrderTaxExemption = 0 THEN o.OrderTaxAmount ELSE 0 END) AS OrderTaxAmount" &_
			 "	   , os.OrderStatusName" &_
			 "	   , (CAST(o.OrderCreateDate AS DATE)) AS _OrderCreateDate" &_
			 "	   , pt.PaymentTypeName" &_
			 "	FROM utb_Orders o" &_
			 "		 INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
			 "		 LEFT JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = o.PaymentTypeID" &_
			 " WHERE OrderID IN(" & Quote(sOrderIDs) & ")"
	Set oOrder = oConn.Execute(sQuery)
	If oOrder.Eof Then
		Response.Write "Order(s) not found."
		Response.End
	End If
	Dim sPrintTpl : sPrintTpl = GetPrintTemplate(2)
	Dim sPrintTplCur, sResults
	Dim sBreak : sBreak = ""
	While Not oOrder.Eof
		Dim OrderAccountNumber1 : OrderAccountNumber1 = IIF(IsNull(oOrder("OrderAccountNumber1")), "", oOrder("OrderAccountNumber1"))
		Dim sCCNumber : sCCNumber = ""
		If Len(OrderAccountNumber1) > 0 Then
			sCCNumber = Decode(OrderAccountNumber1)
		End If
		Dim fSubTotal, fSubTotalCost, fShipping, fShippingCost, fInsurance, fPromo, sPromoCode, fTax
		fSubTotal = CCur(oOrder("OrderTotalAmount"))
		fSubTotalCost = CCur(oOrder("OrderCostAmount"))
		fShipping = CCur(oOrder("OrderDeliveryPrice"))
		fShippingCost = CCur(oOrder("OrderDeliveryCost"))
		fInsurance = CCur(oOrder("OrderHandlingInsurance"))
		fPromo = CCur(oOrder("OrderPromoAmount"))
		sPromoCode = IIF(IsNull(oOrder("OrderPromoCode")), "", oOrder("OrderPromoCode"))
		fTax = CCur(oOrder("OrderTaxAmount"))
		Dim sOrderSegment : sOrderSegment = "" &_
			"<table width=""100%"" cellpadding=""5"" cellspacing=""1"" border=""0"" bgcolor=""#dedede"" style=""border: 1px solid #999"">" &_
				"<tr align=""center"">" &_
				"	<td><strong>Qty.</strong></td>" &_
				"	<td><strong>Sku</strong></td>" &_
				"	<td align=""left""><strong>Description</strong></td>" &_
				"	<td><strong>Price</strong></td>" &_
				"	<td><strong>Total</strong></td>" &_
				"</tr>"
		Set oQuery = oConn.Execute("EXEC usp_OrderDetailsGet @OrderID = " & oOrder("OrderID"))
		While Not oQuery.Eof
			sOrderSegment = sOrderSegment &_
				"<tr valign=""top"" bgcolor=""#ffffff"">" &_
					"<td align=""center"">" & oQuery("OrderDetailProductQuantity") & "</td>" &_
					"<td>" & oQuery("ProductSKU") & "</td>" &_
					"<td>" & oQuery("ProductName") & "</td>" &_
					"<td align=""right"">" & CurrencyFormat(oQuery("ProductPrice"), 2) & "</td>" &_
					"<td align=""right"">" & CurrencyFormat(oQuery("Total"), 2) & "</td>" &_
				"</tr>"
			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing
		Dim fTotalOrder, fTotalCost, fPNL, fGrandTotal
		fTotalOrder = fSubTotal + fShipping + fPromo + fInsurance
		fTotalCost	= fSubTotalCost + fShippingCost
		fPNL = fTotalOrder - fTotalCost
		fGrandTotal = fSubTotal + fShipping + fPromo + fInsurance + fTax
		sOrderSegment = sOrderSegment &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4"">Sub Total:</td>" &_
					"<td>" & CurrencyFormat(fSubTotal, 2) & "</td>" &_
				"</tr>" &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4"">Promo" & IIF(sPromoCode <> "", " (" & sPromoCode & ")", "") & ":</td>" &_
					"<td>" & CurrencyFormat(fPromo, 2) & "</td>" &_
				"</tr>" &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4"">Shipping:</td>" &_
					"<td>" & CurrencyFormat(fShipping, 2) & "</td>" &_
				"</tr>"
		If fInsurance > 0 Then
			sOrderSegment = sOrderSegment &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4"">Handling and Insurance:</td>" &_
					"<td>" & CurrencyFormat(fInsurance, 2) & "</td>" &_
				"</tr>"
		End if
		sOrderSegment = sOrderSegment &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4"">Tax:</td>" &_
					"<td>" & CurrencyFormat(fTax, 2) & "</td>" &_
				"</tr>" &_
				"<tr valign=""top"" align=""right"" bgcolor=""#ffffff"">" &_
					"<td colspan=""4""><strong>Grand Total:</strong></td>" &_
					"<td><strong>" & CurrencyFormat(fGrandTotal, 2) & "</strong></td>" &_
				"</tr>" &_
			"</table>"
		sPrintTplCur = sPrintTpl
		sPrintTplCur = Replace(sPrintTplCur, "$CompanyName$",	GetSetting(oConn, "CompanyName"))
		sPrintTplCur = Replace(sPrintTplCur, "$CompanyEmail$",	GetSetting(oConn, "CompanyEmailForOrder"))
		sPrintTplCur = Replace(sPrintTplCur, "$OrderDate$",		oOrder("OrderCreateDate"))
		sPrintTplCur = Replace(sPrintTplCur, "$OrderID$",		oOrder("OrderID"))
		sPrintTplCur = Replace(sPrintTplCur, "$OrderNumber$",	oOrder("OrderID"))
		sPrintTplCur = Replace(sPrintTplCur, "$CFirstName$",	IIF(IsNull(oOrder("OrderBillingFirstName")), "", oOrder("OrderBillingFirstName")))
		sPrintTplCur = Replace(sPrintTplCur, "$CLastName$",		IIF(IsNull(oOrder("OrderBillingLastName")), "", oOrder("OrderBillingLastName")))
		sPrintTplCur = Replace(sPrintTplCur, "$CCompanyName$",	IIF(IsNull(oOrder("OrderBillingCompanyName")), "", oOrder("OrderBillingCompanyName")))
		sPrintTplCur = Replace(sPrintTplCur, "$CAddress$",		IIF(IsNull(oOrder("OrderBillingAddress1")), "", oOrder("OrderBillingAddress1")))
		sPrintTplCur = Replace(sPrintTplCur, "$CApt$",			IIF(IsNull(oOrder("OrderBillingCountry")), "", oOrder("OrderBillingCountry")))
		sPrintTplCur = Replace(sPrintTplCur, "$CCity$",			IIF(IsNull(oOrder("OrderBillingCity")), "", oOrder("OrderBillingCity")))
		sPrintTplCur = Replace(sPrintTplCur, "$CState$",		IIF(IsNull(oOrder("OrderBillingState")), "", oOrder("OrderBillingState")))
		sPrintTplCur = Replace(sPrintTplCur, "$CZip$",			IIF(IsNull(oOrder("OrderBillingZip")), "", oOrder("OrderBillingZip")))
		sPrintTplCur = Replace(sPrintTplCur, "$CHomePhone$",	IIF(IsNull(oOrder("OrderBillingHomePhone")), "", oOrder("OrderBillingHomePhone")))
		sPrintTplCur = Replace(sPrintTplCur, "$CWorkPhone$",	IIF(IsNull(oOrder("OrderBillingAltPhone")), "", oOrder("OrderBillingAltPhone")))
		sPrintTplCur = Replace(sPrintTplCur, "$DFirstName$",	IIF(IsNull(oOrder("OrderShippingFirstName")), "", oOrder("OrderShippingFirstName")))
		sPrintTplCur = Replace(sPrintTplCur, "$DLastName$",		IIF(IsNull(oOrder("OrderShippingLastName")), "", oOrder("OrderShippingLastName")))
		sPrintTplCur = Replace(sPrintTplCur, "$DCompanyName$",	IIF(IsNull(oOrder("OrderShippingCompanyName")), "", oOrder("OrderShippingCompanyName")))
		sPrintTplCur = Replace(sPrintTplCur, "$DAddress$",		IIF(IsNull(oOrder("OrderShippingAddress1")), "", oOrder("OrderShippingAddress1")))
		sPrintTplCur = Replace(sPrintTplCur, "$DApt$",			IIF(IsNull(oOrder("OrderShippingCountry")), "", oOrder("OrderShippingCountry")))
		sPrintTplCur = Replace(sPrintTplCur, "$DCity$",			IIF(IsNull(oOrder("OrderShippingCity")), "", oOrder("OrderShippingCity")))
		sPrintTplCur = Replace(sPrintTplCur, "$DState$",		IIF(IsNull(oOrder("OrderShippingState")), "", oOrder("OrderShippingState")))
		sPrintTplCur = Replace(sPrintTplCur, "$DZip$",			IIF(IsNull(oOrder("OrderShippingZip")), "", oOrder("OrderShippingZip")))
		sPrintTplCur = Replace(sPrintTplCur, "$DHomePhone$",	IIF(IsNull(oOrder("OrderShippingHomePhone")), "", oOrder("OrderShippingHomePhone")))
		sPrintTplCur = Replace(sPrintTplCur, "$DWorkPhone$",	IIF(IsNull(oOrder("OrderShippingAltPhone")), "", oOrder("OrderShippingAltPhone")))
		sPrintTplCur = Replace(sPrintTplCur, "$Shipping$",		IIF(IsNull(oOrder("OrderDeliveryMethod")), "", oOrder("OrderDeliveryMethod")))
		sPrintTplCur = Replace(sPrintTplCur, "$PaymentType$",	IIF(IsNull(oOrder("PaymentTypeName")), "", oOrder("PaymentTypeName")))
		sPrintTplCur = Replace(sPrintTplCur, "$CreditCard$",	PrependChar(Right(sCCNumber, 4), Len(sCCNumber), "X"))
		sPrintTplCur = Replace(sPrintTplCur, "$OrderSegment$",	sOrderSegment)
		sPrintTplCur = Replace(sPrintTplCur, "$CurrentYear$",	Year(Date))
		sResults = sResults & sBreak & sPrintTplCur
		sBreak = "<div style=""page-break-after: always""></div>"
		oOrder.MoveNext
	Wend
	oOrder.Close
	Set oOrder = Nothing
	If sEmail <> "" Then
		Dim jsonOut
		Set jsonOut = jsObject()
		Call SendEmail(sEmail, GetSetting(oConn, "CompanyEmailForOrder"), "Proof of Purchase", sResults)
		If Err.Number = 0 Then
			jsonOut("success") = True
			jsonOut("message") = GetMessage("success", "Email has been sent.")
		Else
			jsonOut("success") = False
			jsonOut("message") = Err.Description
		End If
		jsonOut.Flush
		Response.End
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<style type="text/css">td {font-size: 11px; font-family: Verdana,Helvetica,Arial}</style>
	</head>
	<body>
		<%= sResults %>
	</body>
</html>
