<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("OrderStatusList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, EmailSubject, EmailBody, Color, IsSystem, IsActive, IsCommited, IsSendEmail
	Dim iOrderStatusID

	Select Case sAction
		Case "New"
			sTitle = "Add Order Status"
			sAction = "Insert"

			Color = "000000"
			IsSystem = "0"
			IsActive = "1"
			IsCommited = "0"
			IsSendEmail = "0"

		Case "Edit"
			sTitle = "Edit Order Status Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatuses WHERE OrderStatusID = " & iID)
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("OrderStatusName"))
				EmailSubject = HTMLEncode(oQuery("OrderStatusEmailSubject"))
				EmailBody = oQuery("OrderStatusEmailBody")
				Color = HTMLEncode(oQuery("OrderStatusColor"))
				IsSystem = oQuery("OrderStatusIsSystem")
				IsActive = oQuery("OrderStatusIsActive")
				IsCommited = oQuery("OrderStatusIsCommitted")
				IsSendEmail = oQuery("OrderStatusIsSendEmail")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Order Status"

			CommonValidation()
			If GetValueFromTable(oConn, "OrderStatusID", "utb_OrderStatuses", "WHERE OrderStatusName = '" & Quote(Name) & "'") <> "" Then
				AddError("Order Status with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_OrderStatuses(" &_
						 "	OrderStatusName" &_
						 ", OrderStatusEmailSubject" &_
						 ", OrderStatusEmailBody" &_
						 ", OrderStatusColor" &_
						 ", OrderStatusIsSystem" &_
						 ", OrderStatusIsActive" &_
						 ", OrderStatusIsCommitted" &_
						 ", OrderStatusIsSendEmail" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(Name) & "'" &_
						 ", '" & Quote(EmailSubject) & "'" &_
						 ",  " & IIF(EmailBody <> "", "'" & Quote(EmailBody) & "'", "NULL") &_
						 ", '" & Quote(Color) & "'" &_
						 ", '" & Quote(IsSystem) & "'" &_
						 ", '" & Quote(IsActive) & "'" &_
						 ", '" & Quote(IsCommited) & "'" &_
						 ", '" & Quote(IsSendEmail) & "'" &_
						 ")"
				oConn.Execute(sQuery)

				iOrderStatusID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Status has been created.")
					Redirect("OrderStatusForm.asp?Action=Edit&ID=" & iOrderStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Order Status Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "OrderStatusID", "utb_OrderStatuses", "WHERE OrderStatusName = '" & Quote(Name) & "' AND OrderStatusID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Order Status with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_OrderStatuses" &_
						 "	  SET OrderStatusName = '" & Quote(Name) & "'" &_
						 "		, OrderStatusEmailSubject = '" & Quote(EmailSubject) & "'" &_
						 "		, OrderStatusEmailBody = " & IIF(EmailBody <> "", "'" & Quote(EmailBody) & "'", "NULL") &_
						 "		, OrderStatusColor = '" & Quote(Color) & "'" &_
						 "		, OrderStatusIsActive = '" & Quote(IsActive) & "'" &_
						 "		, OrderStatusIsCommitted = '" & Quote(IsCommited) & "'" &_
						 "		, OrderStatusIsSendEmail = '" & Quote(IsSendEmail) & "'" &_
						 "	WHERE OrderStatusID = " & iID
				oConn.Execute(sQuery)

				iOrderStatusID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Status has been updated.")
					Redirect("OrderStatusForm.asp?Action=Edit&ID=" & iOrderStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " DELETE " &_
					 "	 FROM utb_OrderStatuses" &_
					 "	WHERE OrderStatusID = '" & Quote(iID) & "'" &_
					 "	  AND OrderStatusIsSystem = 0"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Order Status has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
		<link rel="stylesheet" type="text/css" href="styles/colorpicker.css"/>
		<script type="text/javascript" src="js/colorpicker.js"></script>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order Statuses</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<% If iID > 0 Then %>
				<% Dim ReasonsCount : ReasonsCount = GetValueFromTable(oConn, "COUNT(*)", "utb_OrderStatusReasons", "WHERE OrderStatusID = '" & Quote(iID) & "'") %>
				<a class="head-link-right" href="OrderStatusReason<%= IIF(ReasonsCount > 0, "List.asp?", "Form.asp?Action=New&amp;") %>OrderStatusID=<%= iID %>">Reasons (<%= ReasonsCount %>)</a>
			<% End If %>
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<!--#include file="../ckeditor/ckeditor.asp"-->
			<form action="OrderStatusForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><% If IsSystem <> "1" Then %><span class="asterisk">*</span><% End If %> Name</td>
						<td>
							<% If IsSystem = "1" Then %>
							<strong><%= Name %></strong><input type="hidden" name="Name" value="<%= Name %>"/>
							<% Else %>
							<input type="text" class="form-field" name="Name" value="<%= Name %>" style="width: 300px" maxlength="255"/>
							<% End If %>
							<input type="hidden" name="IsSystem" value="<%= IsSystem %>"/>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> E-mail Subject</td>
						<td><input type="text" class="form-field" name="EmailSubject" value="<%= EmailSubject %>" style="width: 806px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right">E-mail Body</td>
						<td><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 850
						oEditor.config("height") = 400
						oEditor.editor "EmailBody", EmailBody
					%>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> Color</td>
						<td><input type="text" class="form-field" id="Color" name="Color" value="<%= Color %>" style="width:60px;" maxlength="6" readonly="readonly" /></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsActive">Active</label></td>
						<td><input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %>/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsCommited">Commited</label></td>
						<td><input type="checkbox" name="IsCommited" id="IsCommited" value="1" <%= IIF(IsCommited = "1", "checked='checked'", "") %>/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsSendEmail">Send E-mail</label></td>
						<td><input type="checkbox" name="IsSendEmail" id="IsSendEmail" value="1" <%= IIF(IsSendEmail = "1", "checked='checked'", "") %>/></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(document).ready(function(){
			$('#Color').ColorPicker({
				color: '#00ff00',
				onBeforeShow: function(){
					$(this).ColorPickerSetColor(this.value);
				},
				onShow: function (colpkr){
					$(colpkr).slideDown(300);
					return false;
				},
				onSubmit: function(hsb, hex, rgb, el){
					$(el).val(hex.toUpperCase());
					$(el).ColorPickerHide();
				}
			});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		EmailSubject = Trim(Request("EmailSubject"))
		EmailBody = Trim(Request("EmailBody"))
		Color = Trim(Request("Color"))
		IsSystem = Trim(Request("IsSystem"))
		IsActive = Trim(Request("IsActive"))
		IsCommited = Trim(Request("IsCommited"))
		IsSendEmail = Trim(Request("IsSendEmail"))

		If EmailSubject = "" Then
			AddError("Field <strong>E-mail Subject</strong> is required.")
		End If
		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Color = "" Then
			AddError("Field <strong>Color</strong> is required.")
		End If
		If Color <> "" Then
			If Not ValidateColor(Color) Then
				AddError("Field <strong>Color</strong> is invalid.")
			End If
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderStatusBackURL") = "", sDefaultURL, Session("OrderStatusBackURL"))
	End Function

	Sub SetBackURL()
		Session("OrderStatusFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>