<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Order Statuses</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		Dim sWhere : sWhere = ""

		Dim sOrder, sArrow, sOrderBy
		sOrder = "1"
		sArrow = "1"
		If Request("Order") <> "" And Request("Arrow") <> "" Then
			sOrder = Request("Order")
			sArrow = Request("Arrow")
		End If
		sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

		sQuery = " SELECT * " & _
				 "	  , (SELECT COUNT(*) FROM utb_Orders WHERE OrderStatusID = os.OrderStatusID) AS OrderStatusOrderCount " & _
				 "	  , (SELECT COUNT(*) FROM utb_OrderStatusReasons WHERE OrderStatusID = os.OrderStatusID) AS OrderStatusReasonCount " & _
				 "   FROM utb_OrderStatuses os " & _
				 sWhere & _
				 sOrderBy

		Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
		iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
		iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
		Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
		iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

		Dim iCount : iCount = 0
		Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right icon-add" href="OrderStatusForm.asp?Action=New&amp;ID=0">Add Order Status</a>
			<h2>Order Statuses</h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<tr class="head-line">
				<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Email Subject", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 60px"><%= GetURLForOrder("Color", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 60px"><%= GetURLForOrder("Type", "5", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 60px"><%= GetURLForOrder("Active", "6", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 75px"><%= GetURLForOrder("Commited", "7", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 80px"><%= GetURLForOrder("Send Email", "8", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 65px"><%= GetURLForOrder("Reasons", "9", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 50px">&nbsp;</td>
			</tr>
			<%
			While Not oQuery.Eof
				iCount = iCount + 1
				%>
				<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
					<td><%= oQuery("OrderStatusID") %></td>
					<td style="text-align: left"><%= oQuery("OrderStatusName") %></td>
					<td style="text-align: left"><%= oQuery("OrderStatusEmailSubject") %></td>
					<td style="background: #<%= oQuery("OrderStatusColor") %>">&nbsp;</td>
					<td><%= IIF(oQuery("OrderStatusIsSystem") = 1, "<span style='color:#e20000;'>System</span>", "<span style='color:#159600;'>User</span>") %></td>
					<td><%= IIF(oQuery("OrderStatusIsActive") = 1, "Yes", "No") %></td>
					<td><%= IIF(oQuery("OrderStatusIsCommitted") = 1, "Yes", "No") %></td>
					<td><%= IIF(oQuery("OrderStatusIsSendEmail") = 1, "Yes", "No") %></td>
					<td><a href="OrderStatusReason<%= IIF(oQuery("OrderStatusReasonCount") > 0, "List.asp?", "Form.asp?Action=New&amp;") %>OrderStatusID=<%= oQuery("OrderStatusID") %>"><%= oQuery("OrderStatusReasonCount") %></a></td>
					<td>
						<a href="OrderStatusForm.asp?Action=Edit&amp;ID=<%= oQuery("OrderStatusID") %>"><img src="images/grid-act-edit.png" alt="" title="Edit" width="16" height="16"/></a>
						&nbsp;
						<% If oQuery("OrderStatusOrderCount") = 0 _
						  And oQuery("OrderStatusIsSystem") = 0 Then %>
						<a href="OrderStatusForm.asp?Action=Delete&amp;ID=<%= oQuery("OrderStatusID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16"/></a>
						<% Else %>
						<img src="images/grid-act-delete-gray.png" alt="" width="16" height="16"/>
						<% End If %>
					</td>
				</tr>
				<%
				oQuery.MoveNext
			Wend
			%>
		</table>
		<%
		If iRecordCount = 0 Then
			%><!--#include file="inc/NoRecords.asp"--><%
		End If
		oQuery.Close
		Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "OrderStatusID"

		Select Case sIndex
			Case "1" sColumn = "OrderStatusID"
			Case "2" sColumn = "OrderStatusName"
			Case "3" sColumn = "OrderStatusEmailSubject"
			Case "4" sColumn = "OrderStatusColor"
			Case "5" sColumn = "OrderStatusIsSystem"
			Case "6" sColumn = "OrderStatusIsActive"
			Case "7" sColumn = "OrderStatusIsCommitted"
			Case "8" sColumn = "OrderStatusIsSendEmail"
			Case "9" sColumn = "(SELECT COUNT(*) FROM utb_OrderStatusReasons WHERE OrderStatusID = os.OrderStatusID)"
		End Select

		GetColumnByIndex = sColumn
	End Function

	Sub SetBackURL()
		Session("OrderStatusBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>
