<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iOrderStatusID : iOrderStatusID = Request("OrderStatusID")
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("OrderStatusReasonList.asp?OrderStatusID=" & iOrderStatusID)

	If Not ValidateInteger(iOrderStatusID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, IsActive, iOrderStatusReasonID

	Select Case sAction
		Case "New"
			sTitle = "Add Order Status Reason"
			sAction = "Insert"

			IsActive = "1"

		Case "Edit"
			sTitle = "Edit Order Status Reason Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatusReasons WHERE OrderStatusReasonID = '" & Quote(iID) & "'")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("OrderStatusReasonName"))
				IsActive = oQuery("OrderStatusReasonIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Order Status Reason"

			CommonValidation()

			If GetValueFromTable(oConn, "OrderStatusReasonID", "utb_OrderStatusReasons", "WHERE OrderStatusReasonName = '" & Quote(Name) & "'") <> "" Then
				AddError("Order Status Reason with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " INSERT INTO utb_OrderStatusReasons (OrderStatusID, OrderStatusReasonName, OrderStatusReasonIsSystem, OrderStatusReasonIsActive, CreateDate) " & _
						 " VALUES ( " &_
						 "   '" & Quote(iOrderStatusID) & "' " & _
						 " , '" & Quote(Name) & "' " & _
						 " , 0 " & _
						 " , '" & IIF(IsActive = "", "0", "1") & "' " &_
						 " , GETDATE() " &_
						 " ) "
				oConn.Execute(sQuery)

				iOrderStatusReasonID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Status Reason has been inserted.")
					Redirect("OrderStatusReasonForm.asp?Action=Edit&ID=" & iOrderStatusReasonID & "&OrderStatusID=" & iOrderStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Order Status Reason Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "OrderStatusReasonID", "utb_OrderStatusReasons", "WHERE OrderStatusReasonName = '" & Quote(Name) & "' AND OrderStatusReasonID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Order Status Reason with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_OrderStatusReasons " & _
						 "	SET OrderStatusReasonName = '" & Quote(Name) & "' " & _
						 "	  , OrderStatusReasonIsActive = '" & IIF(IsActive = "", "0", "1") & "' " & _
						 "  WHERE OrderStatusReasonID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iOrderStatusReasonID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Status Reason has been updated.")
					Redirect("OrderStatusReasonForm.asp?Action=Edit&ID=" & iOrderStatusReasonID & "&OrderStatusID=" & iOrderStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			If GetValueFromTable(oConn, "COUNT(*)", "utb_Orders", "WHERE OrderStatusReasonID = '" & Quote(iID) & "'") = 0 Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " DELETE " & _
						 "   FROM utb_OrderStatusReasons " & _
						 "  WHERE OrderStatusReasonID = '" & Quote(iID) & "' " & _
						 "	AND OrderStatusReasonIsSystem = 0 "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Order Status Reason has been deleted.")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
			Redirect(sBackURL)

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Order Status <%= GetValueFromTable(oConn, "OrderStatusName", "utb_OrderStatuses", "WHERE OrderStatusID = '" & Quote(iOrderStatusID) & "'") %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="OrderStatusReasonForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>" />
				<input type="hidden" name="OrderStatusID" value="<%= iOrderStatusID %>" />
				<input type="hidden" name="ID" value="<%= iID %>" />
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><label for="IsActive">Active</label></td>
						<td>
							<input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %> />
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		IsActive = Trim(Request("IsActive"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("OrderStatusReasonBackURL") = "", sDefaultURL, Session("OrderStatusReasonBackURL"))
	End Function
%>