<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("PaymentGatewayList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, Type_, AccountNumber1, AccountNumber2, AccountNumber3, AccountNumber4, IsActive
	Dim iPaymentGatewayID

	Select Case sAction
		Case "New"
			sTitle = "Add Payment Gateway"
			sAction = "Insert"

			IsActive = "1"

		Case "Edit"
			sTitle = "Edit Payment Gateway Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_PaymentGateways WHERE PaymentGatewayID = '" & Quote(iID) & "'")
			If Not oQuery.Eof Then
				Name			= HTMLEncode(oQuery("PaymentGatewayName"))
				Type_			= HTMLEncode(oQuery("PaymentGatewayType"))
				AccountNumber1	= HTMLEncode(oQuery("PaymentGatewayAccountNumber1"))
				AccountNumber2	= HTMLEncode(oQuery("PaymentGatewayAccountNumber2"))
				AccountNumber3	= HTMLEncode(oQuery("PaymentGatewayAccountNumber3"))
				AccountNumber4	= HTMLEncode(oQuery("PaymentGatewayAccountNumber4"))
				IsActive 		= oQuery("PaymentGatewayIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Payment Gateway"

			CommonValidation()
			If GetValueFromTable(oConn, "PaymentGatewayID", "utb_PaymentGateways", "WHERE PaymentGatewayName = '" & Quote(Name) & "'") <> "" Then
				AddError("Payment Gateway with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_PaymentGateways(" &_
						 "	PaymentGatewayName" &_
						 ", PaymentGatewayType" &_
						 ", PaymentGatewayAccountNumber1" &_
						 ", PaymentGatewayAccountNumber2" &_
						 ", PaymentGatewayAccountNumber3" &_
						 ", PaymentGatewayAccountNumber4" &_
						 ", PaymentGatewayIsActive" &_
						 ") " & _
						 "VALUES(" & _
						 "	'" & Quote(Name) & "'" &_
						 ", '" & Quote(Type_) & "'" &_
						 ", '" & Quote(AccountNumber1) & "'" &_
						 ",  " & IIF(AccountNumber2 <> "", "'" & Quote(AccountNumber2) & "'", "NULL") &_
						 ",  " & IIF(AccountNumber3 <> "", "'" & Quote(AccountNumber3) & "'", "NULL") &_
						 ",  " & IIF(AccountNumber4 <> "", "'" & Quote(AccountNumber4) & "'", "NULL") &_
						 ", '" & Quote(IsActive) & "'" &_
						 ")"

				oConn.Execute(sQuery)
				iPaymentGatewayID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Payment Gateway has been inserted.")
					Redirect("PaymentGatewayForm.asp?Action=Edit&ID=" & iPaymentGatewayID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Payment Gateway Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "PaymentGatewayID", "utb_PaymentGateways", "WHERE PaymentGatewayName = '" & Quote(Name) & "' AND PaymentGatewayID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Payment Gateway with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_PaymentGateways" &_
						 "	 SET PaymentGatewayName = '" & Quote(Name) & "'" &_
						 "	   , PaymentGatewayType = '" & Quote(Type_) & "'" &_
						 "	   , PaymentGatewayAccountNumber1 = '" & Quote(AccountNumber1) & "'" &_
						 "	   , PaymentGatewayAccountNumber2 = " & IIF(AccountNumber2 <> "", "'" & Quote(AccountNumber2) & "'", "NULL") & " " & _
						 "	   , PaymentGatewayAccountNumber3 = " & IIF(AccountNumber3 <> "", "'" & Quote(AccountNumber3) & "'", "NULL") & " " & _
						 "	   , PaymentGatewayAccountNumber4 = " & IIF(AccountNumber4 <> "", "'" & Quote(AccountNumber4) & "'", "NULL") & " " & _
						 "	   , PaymentGatewayIsActive = '" & Quote(IsActive) & "' " & _
						 " WHERE PaymentGatewayID = '" & Quote(iID) & "'"

				oConn.Execute(sQuery)
				iPaymentGatewayID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Payment Gateway has been updated.")
					Redirect("PaymentGatewayForm.asp?Action=Edit&ID=" & iPaymentGatewayID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "DELETE" &_
					 "	FROM utb_PaymentGateways" &_
					 " WHERE PaymentGatewayID = '" & Quote(iID) & "'"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Payment Gateway has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Payment Gateways</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="PaymentGatewayForm.asp" method="post">
				<div>
					<input type="hidden" name="Action" value="<%= sAction %>" />
					<input type="hidden" name="ID" value="<%= iID %>" />
				</div>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:400px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Type</td>
						<td><input type="text" class="form-field" name="Type_" value="<%= Type_ %>" style="width:400px;" maxlength="50" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Account Number 1</td>
						<td><input type="text" class="form-field" name="AccountNumber1" value="<%= AccountNumber1 %>" style="width:400px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Account Number 2</td>
						<td><input type="text" class="form-field" name="AccountNumber2" value="<%= AccountNumber2 %>" style="width:400px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Account Number 3</td>
						<td><input type="text" class="form-field" name="AccountNumber3" value="<%= AccountNumber3 %>" style="width:400px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Account Number 4</td>
						<td><input type="text" class="form-field" name="AccountNumber4" value="<%= AccountNumber4 %>" style="width:400px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><label for="IsActive">Active</label></td>
						<td><input type="checkbox" name="IsActive" id="IsActive" value="1"<%= IIF(IsActive = "1", " checked='checked'", "") %> /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name			= Trim(Request("Name"))
		Type_			= Trim(Request("Type_"))
		AccountNumber1	= Trim(Request("AccountNumber1"))
		AccountNumber2	= Trim(Request("AccountNumber2"))
		AccountNumber3	= Trim(Request("AccountNumber3"))
		AccountNumber4	= Trim(Request("AccountNumber4"))
		IsActive		= Trim(Request("IsActive"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Type_ = "" Then
			AddError("Field <strong>Type</strong> is required.")
		End If
		If AccountNumber1 = "" Then
			AddError("Field <strong>Account Number 1</strong> is required.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("PaymentGatewayBackURL") = "", sDefaultURL, Session("PaymentGatewayBackURL"))
	End Function

	Sub SetBackURL()
		Session("PaymentGatewayFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>