<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("PaymentTypeList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, IsUpdatable, IsActiveOnFront, IsActiveOnBack, Category
	Dim iPaymentTypeID

	Select Case sAction
		Case "Edit"
			sTitle = "Edit Payment Type Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_PaymentTypes WHERE PaymentTypeID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = oQuery("PaymentTypeName")
				IsUpdatable = oQuery("PaymentTypeIsUpdatable")
				IsActiveOnFront = oQuery("PaymentTypeIsActiveOnFront")
				IsActiveOnBack = oQuery("PaymentTypeIsActiveOnBack")
				Category = oQuery("PaymentTypeCategory")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Update"
			sTitle = "Edit Payment Type Ref # " & iID
		
			CommonValidation()
		
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " UPDATE utb_PaymentTypes " & _
						 "	SET PaymentTypeIsActiveOnFront = '" & Quote(IsActiveOnFront) & "' " & _
						 "	  , PaymentTypeIsActiveOnBack = '" & Quote(IsActiveOnBack) & "' " & _
						 "  WHERE PaymentTypeID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)
		
				iPaymentTypeID = iID
		
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Payment Type has been updated.")
					Redirect("PaymentTypeForm.asp?Action=Edit&ID=" & iPaymentTypeID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Payment Types</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="PaymentTypeForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;">Name</td>
				<td><strong><%= Name %></strong><input type="hidden" name="Name" value="<%= Name %>" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Updatable</td>
				<td><strong><%= IIF(IsUpdatable = 1, "Yes", "No") %></strong><input type="hidden" name="IsUpdatable" value="<%= IsUpdatable %>" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActiveOnFront">Active On Front</label></td>
				<td>
					<input type="checkbox" name="IsActiveOnFront" id="IsActiveOnFront" value="1" <%= IIF(IsActiveOnFront = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActiveOnBack">Active On Back</label></td>
				<td>
					<input type="checkbox" name="IsActiveOnBack" id="IsActiveOnBack" value="1" <%= IIF(IsActiveOnBack = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Category</td>
				<td><strong><%= Category %></strong><input type="hidden" name="Category" value="<%= Category %>" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		IsUpdatable = Trim(Request("IsUpdatable"))
		IsActiveOnFront = Trim(Request("IsActiveOnFront"))
		IsActiveOnBack = Trim(Request("IsActiveOnBack"))
		Category = Trim(Request("Category"))
	End Sub
%>