<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("PolicyList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, Description, Days, IsVisible
	Dim iPolicyID

	Select Case sAction
		Case "New"
			sTitle = "Add Return Policy"
			sAction = "Insert"
			IsVisible = "1"

		Case "Edit"
			sTitle = "Edit Return Policy Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_Policies WHERE PolicyID = '" & Quote(iID) & "'")
			If Not oQuery.Eof Then
				Name 		= HTMLEncode(oQuery("PolicyName"))
				Description = oQuery("PolicyDescription")
				Days 		= oQuery("PolicyDays")
				IsVisible 	= oQuery("PolicyIsVisible")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Return Policy"

			CommonValidation()

			If GetValueFromTable(oConn, "PolicyID", "utb_Policies", "WHERE PolicyName = '" & Quote(Name) & "'") <> "" Then
				AddError("Return Policy with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Policies(PolicyName, PolicyDescription, PolicyDays, PolicyIsVisible) " &_
						 "VALUES(" & _
						 "	'" & Quote(Name) & "'" &_
						 ", '" & Quote(Description) & "'" &_
						 ", '" & Quote(Days) & "'" &_
						 ", '" & IIF(IsVisible <> "", "1", "0") & "'" &_
						 ") "
				oConn.Execute(sQuery)
		
				iPolicyID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Return Policy has been inserted.")
					Redirect("PolicyForm.asp?Action=Edit&ID=" & iPolicyID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Return Policy Ref # " & iID
		
			CommonValidation()

			If GetValueFromTable(oConn, "PolicyID", "utb_Policies", "WHERE PolicyName = '" & Quote(Name) & "' AND PolicyID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Return Policy with name <strong>" & Name & "</strong> already exist in database.")
			End If
			
			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_Policies" &_
						 "	 SET PolicyName = '" & Quote(Name) & "'" &_
						 "	   , PolicyDescription = '" & Quote(Description) & "'" &_
						 "	   , PolicyDays = '" & Quote(Days) & "'" &_
						 "	   , PolicyIsVisible = '" & IIF(IsVisible <> "", "1", "0") & "'" &_
						 " WHERE PolicyID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iPolicyID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Return Policy has been updated.")
					Redirect("PolicyForm.asp?Action=Edit&ID=" & iPolicyID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			If GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE PolicyID = '" & Quote(iID) & "'") = 0 Then
				oConn.BeginTrans
				On Error Resume Next
				
				oConn.Execute("DELETE FROM utb_Policies WHERE PolicyID = '" & Quote(iID) & "'")
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Return Policy has been deleted.")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
			Redirect(sBackURL)
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Return Policies</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<!--#include file="../ckeditor/ckeditor.asp"-->
	<form action="PolicyForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:500px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Description</td>
				<td><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 850
						oEditor.config("height") = 400
						oEditor.editor "Description", Description
					%></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Days</td>
				<td><input type="text" class="form-field" id="Days" name="Days" value="<%= Days %>" style="width:50px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsVisible">Visible</label></td>
				<td><input type="checkbox" name="IsVisible" id="IsVisible" value="1"<%= IIF(IsVisible = "1", " checked='checked'", "") %> /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Description = Trim(Request("Description"))
		Days = Trim(Request("Days"))
		IsVisible = Trim(Request("IsVisible"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If

		If Description = "" Then
			AddError("Field <strong>Description</strong> is required.")
		End If

		If Days = "" Then
			AddError("Field <strong>Days</strong> is required.")
		ElseIf Not ValidateInteger(Days) Then
			AddError("Field <strong>Days</strong> is invalid.")
		End If
	End Sub

	Sub SetBackURL()
		Session("PolicyFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>